/*
 * Decompiled with CFR 0.152.
 */
package com.treemap.swing.legend;

import com.macrofocus.common.properties.PropertiesListener;
import com.macrofocus.common.properties.PropertyEvent;
import com.treemap.TreeMapField;
import com.treemap.TreeMapModel;
import com.treemap.swing.legend.WrapLayout;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;

public class TextualLegend
extends JPanel {
    private TreeMapModel treeMapModel;

    public TextualLegend(boolean updateOnResize) {
        this.setLayout(new WrapLayout(0, 2, 0));
        if (updateOnResize) {
            this.addComponentListener(new ComponentListener(){

                @Override
                public void componentResized(ComponentEvent e) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            TextualLegend.this.updateTextualLegend(TextualLegend.this.treeMapModel);
                        }
                    });
                }

                @Override
                public void componentMoved(ComponentEvent e) {
                }

                @Override
                public void componentShown(ComponentEvent e) {
                }

                @Override
                public void componentHidden(ComponentEvent e) {
                }
            });
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    TextualLegend.this.updateTextualLegend(TextualLegend.this.treeMapModel);
                }
            });
        }
    }

    public void setModel(TreeMapModel model) {
        this.treeMapModel = model;
        PropertiesListener treeMapListener = new PropertiesListener(){

            public void propertyChanged(Object name, PropertyEvent event) {
                if ("groupByField".equals(name) || "sizeField".equals(name) || "colorField".equals(name)) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            TextualLegend.this.updateTextualLegend(TextualLegend.this.treeMapModel);
                        }
                    });
                }
            }
        };
        this.treeMapModel.getSettings().getProperties().addPropertiesListener(treeMapListener);
        this.treeMapModel.getSettings().getProperties().addPropertiesListener(treeMapListener);
        this.treeMapModel.getSettings().getProperties().addPropertiesListener(treeMapListener);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                TextualLegend.this.updateTextualLegend(TextualLegend.this.treeMapModel);
            }
        });
    }

    public void updateTextualLegend(TreeMapModel treeMapModel) {
        this.removeAll();
        if (treeMapModel != null) {
            String sizeLabel;
            TreeMapField[] groupByTreeMapFields = treeMapModel.getSettings().getGroupByTreeMapFields();
            if (groupByTreeMapFields != null && groupByTreeMapFields.length > 0 && groupByTreeMapFields[0] != null && groupByTreeMapFields[0].isValid()) {
                this.add(new JLabel("Items"));
                this.add(new JLabel("are"));
                this.add(new JLabel("grouped"));
                this.add(new JLabel("by"));
                int count = 0;
                for (int i = 0; i < groupByTreeMapFields.length; ++i) {
                    boolean hasNext;
                    TreeMapField field = groupByTreeMapFields[i];
                    if (!field.isValid()) continue;
                    ++count;
                    String name = field.getName();
                    boolean bl = hasNext = i + 1 < groupByTreeMapFields.length && groupByTreeMapFields[i + 1] != null && groupByTreeMapFields[i + 1].isValid();
                    if (hasNext) {
                        boolean nextHasNext;
                        boolean bl2 = nextHasNext = i + 2 < groupByTreeMapFields.length && groupByTreeMapFields[i + 2] != null && groupByTreeMapFields[i + 2].isValid();
                        if (nextHasNext || count > 1) {
                            name = name + ",";
                        }
                    } else {
                        if (count > 1) {
                            this.add(new JLabel("and"));
                        }
                        name = name + ".";
                    }
                    this.add(new JLabel(name));
                }
            }
            TreeMapField sizeTreeMapField = treeMapModel.getSettings().getSizeTreeMapField();
            TreeMapField colorTreeMapField = treeMapModel.getSettings().getColorTreeMapField();
            if (sizeTreeMapField != null && sizeTreeMapField.isValid()) {
                this.add(new JLabel("Their"));
                this.add(new JLabel("size"));
                this.add(new JLabel("is"));
                this.add(new JLabel("proportional"));
                this.add(new JLabel("to"));
                sizeLabel = sizeTreeMapField.getName();
                sizeLabel = colorTreeMapField != null && colorTreeMapField.isValid() ? sizeLabel + "," : sizeLabel + ".";
                this.add(new JLabel(sizeLabel));
            } else {
                this.add(new JLabel("Their"));
                this.add(new JLabel("size"));
                this.add(new JLabel("are"));
                sizeLabel = "all equal";
                sizeLabel = colorTreeMapField != null && colorTreeMapField.isValid() ? sizeLabel + "," : sizeLabel + ".";
                this.add(new JLabel(sizeLabel));
            }
            if (colorTreeMapField != null && colorTreeMapField.isValid()) {
                this.add(new JLabel("and"));
                this.add(new JLabel("they"));
                this.add(new JLabel("are"));
                this.add(new JLabel("colored"));
                this.add(new JLabel("by"));
                String colorLabel = colorTreeMapField.getName() + ".";
                this.add(new JLabel(colorLabel));
            }
        }
        this.validate();
    }
}

