/*
 * Decompiled with CFR 0.152.
 */
package com.treemap.swing.originalfastvoronoi.datastructure;

import com.treemap.swing.originalfastvoronoi.j2d.Site;
import java.util.Arrays;
import java.util.Random;

public class OpenList {
    public Site[] array;
    public int size = 0;
    private static Random rand = new Random(1985L);

    public OpenList() {
        this(10);
    }

    public OpenList(int capacity) {
        this.array = new Site[capacity];
    }

    private void increaseCapacity() {
        int newCapacity = this.array.length * 3 / 2 + 1;
        this.array = Arrays.copyOf(this.array, newCapacity);
    }

    public boolean add(Site e) {
        if (this.size > this.array.length - 1) {
            this.increaseCapacity();
        }
        this.array[this.size] = e;
        ++this.size;
        return true;
    }

    public void clear() {
        this.size = 0;
    }

    public Site get(int index) {
        if (index < this.size) {
            return this.array[index];
        }
        return null;
    }

    public boolean isEmpty() {
        return this.size == 0;
    }

    public Site set(int index, Site element) {
        if (index < this.size) {
            this.array[index] = element;
        }
        return element;
    }

    public OpenList cloneWithZeroWeights() {
        OpenList neu = new OpenList(this.size + 1);
        neu.size = this.size;
        for (int i = 0; i < this.size; ++i) {
            Site s = this.array[i];
            neu.array[i] = s.cloneZeroWeight();
        }
        return neu;
    }

    public void permutate() {
        for (int i = 0; i < this.size; ++i) {
            int ra = rand.nextInt(this.size);
            Site temp = this.array[ra];
            this.array[ra] = this.array[i];
            this.array[i] = temp;
        }
    }
}

