/*
 * Decompiled with CFR 0.152.
 */
package com.treemap.swing.treeplot;

import com.macrofocus.common.interval.MutableBoundedInterval;
import com.macrofocus.geom.Point;
import com.treemap.swing.treeplot.SwingTreePlotView;
import com.treemap.treeplot.TreePlotModel;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.KeyStroke;

class DrillDownAction<N, Row, Column>
extends AbstractAction {
    private final SwingTreePlotView<N, Row, Column> _view;

    public DrillDownAction(SwingTreePlotView<N, Row, Column> view) {
        super("Drill Down");
        this._view = view;
        this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(40, 0));
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object node;
        TreePlotModel model = this._view.getModel();
        model.getProbing().clearSelection();
        java.awt.Point location = this._view.getNativeComponent().getMousePosition();
        if (location != null && (node = this._view.getNode(new Point(location.x, location.y))) != null) {
            if (this._view.getModel().isLeaf(node)) {
                MutableBoundedInterval xRangeModel = this._view.getXRangeModel();
                MutableBoundedInterval yRangeModel = this._view.getYRangeModel();
                this._view.zoom(xRangeModel.getMinimum(), xRangeModel.getMaximum(), yRangeModel.getMinimum(), yRangeModel.getMaximum());
                model.setCurrentRoot(model.getRoot());
            } else {
                MutableBoundedInterval xRangeModel = this._view.getXRangeModel();
                MutableBoundedInterval yRangeModel = this._view.getYRangeModel();
                this._view.zoom(xRangeModel.getMinimum(), xRangeModel.getMaximum(), yRangeModel.getMinimum(), yRangeModel.getMaximum());
                model.setCurrentRoot(node);
            }
        }
    }
}

