/*
 * Decompiled with CFR 0.152.
 */
package com.treemap.swing.voronoi.smoothing;

import com.treemap.swing.voronoi.Point2d;
import com.treemap.swing.voronoi.Vector2d;
import com.treemap.swing.voronoi.smoothing.SegmentDirection;
import com.treemap.swing.voronoi.smoothing.Vertex;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class LineSegment {
    private final List<Point2d> points = new ArrayList<Point2d>();
    private Vertex startVertex = null;
    private Vertex endVertex = null;
    private boolean straight = false;
    private final Vector2d startToEnd = new Vector2d();
    private final Vector2d startToVertex = new Vector2d();
    private final Vector2d endToVertex = new Vector2d();

    public void addPoint(int x, int y) {
        this.points.add(new Point2d(x, y));
    }

    public List<Point2d> getPoints() {
        return Collections.unmodifiableList(this.points);
    }

    public void insertPointsAtStart(List<Point2d> pointsToAdd) {
        this.points.addAll(0, pointsToAdd);
    }

    public String toString() {
        return "LineSegment{ start: " + this.startVertex + " end: " + this.endVertex + ", N points=" + this.points.size() + '}';
    }

    public void setStartVertex(Vertex startPoint) {
        this.startVertex = startPoint;
    }

    public Vertex getStartVertex() {
        return this.startVertex;
    }

    public void setEndVertex(Vertex endPoint) {
        this.endVertex = endPoint;
    }

    public Vertex getEndVertex() {
        return this.endVertex;
    }

    public Vertex getStartVertex(SegmentDirection direction) {
        return direction == SegmentDirection.Forward ? this.startVertex : this.endVertex;
    }

    public Vertex getEndVertex(SegmentDirection direction) {
        return direction == SegmentDirection.Forward ? this.endVertex : this.startVertex;
    }

    public void setStraight(boolean straight) {
        this.straight = straight;
    }

    public boolean isStraight() {
        return this.straight;
    }
}

