/*
 * Decompiled with CFR 0.152.
 */
package com.treemap.swing.voronoi.smoothing;

import com.treemap.swing.voronoi.smoothing.LineSegment;
import com.treemap.swing.voronoi.smoothing.SegmentDirection;
import com.treemap.swing.voronoi.smoothing.Vertex;
import java.util.ArrayList;
import java.util.List;

public class LineSegmentContainer {
    private final List<LineSegment> lineSegments = new ArrayList<LineSegment>();

    public SegmentDirection addIfNotContained(LineSegment lineSegmentToAdd) {
        Vertex currentStartVertex = lineSegmentToAdd.getStartVertex();
        Vertex currentEndVertex = lineSegmentToAdd.getEndVertex();
        for (LineSegment lineSegment : this.lineSegments) {
            if (lineSegment.getStartVertex() == currentStartVertex && lineSegment.getEndVertex() == currentEndVertex) {
                return SegmentDirection.Forward;
            }
            if (lineSegment.getStartVertex() != currentEndVertex || lineSegment.getEndVertex() != currentStartVertex) continue;
            return SegmentDirection.Reverse;
        }
        this.lineSegments.add(lineSegmentToAdd);
        return SegmentDirection.Forward;
    }

    public LineSegment getReference(LineSegment currentSegment) {
        if (this.lineSegments.contains(currentSegment)) {
            return currentSegment;
        }
        Vertex currentStartVertex = currentSegment.getStartVertex();
        Vertex currentEndVertex = currentSegment.getEndVertex();
        for (LineSegment lineSegment : this.lineSegments) {
            if ((lineSegment.getStartVertex() != currentStartVertex || lineSegment.getEndVertex() != currentEndVertex) && (lineSegment.getStartVertex() != currentEndVertex || lineSegment.getEndVertex() != currentStartVertex)) continue;
            return lineSegment;
        }
        return null;
    }
}

