/*
 * Decompiled with CFR 0.152.
 */
package edu.uic.ncdm.venn;

import edu.uic.ncdm.venn.Eigen;
import edu.uic.ncdm.venn.VennDiagram;
import edu.uic.ncdm.venn.data.VennData;
import java.util.HashMap;
import java.util.Set;

public class VennAnalytic {
    private int nCircles;
    private int nPolygons;
    private int nTot;
    private double stress;
    private double minStress;
    private double[] polyData;
    private double[] polyAreas;
    private double[] polyHats;
    private double[] circleData;
    private String[] circleLabels;
    private double[][] centers;
    private double[] diameters;
    private double stepsize;
    private final int iterations;
    private int totalCount;
    private boolean isEqualArea;
    private int gridSize;

    public VennAnalytic() {
        this.stepsize = 0.01;
        this.minStress = 1.0E-6;
        this.isEqualArea = false;
        this.iterations = 50;
        this.gridSize = 200;
    }

    public VennAnalytic(double stepsize, double minStress, boolean isEqualArea, int iterations, int gridSize) {
        this.stepsize = stepsize;
        this.minStress = minStress;
        this.isEqualArea = isEqualArea;
        this.iterations = iterations;
        this.gridSize = gridSize;
    }

    public VennDiagram compute(VennData vd) {
        String[][] data = vd.data;
        double[] areas = vd.areas;
        boolean isAreas = vd.isAreas;
        if (isAreas) {
            this.processAreaData(data, areas);
        } else {
            this.processElementData(data);
        }
        this.computeInitialConfiguration();
        this.scaleDiameters();
        this.scaleConfiguration();
        this.minimizeGlobal();
        this.minimizeLocal();
        return this.collectResults();
    }

    private VennDiagram collectResults() {
        double[] colors = new double[this.nCircles];
        for (int j = 0; j < this.nCircles; ++j) {
            colors[j] = (double)(j + 1) / (double)(this.nCircles + 1);
        }
        double stress01 = 0.0;
        double stress05 = 0.0;
        if (this.nCircles > 2) {
            stress01 = Math.exp(0.909 * ((double)this.nCircles - 6.105)) / (1.0 + Math.exp(0.909 * ((double)this.nCircles - 6.105)));
            stress05 = Math.exp(0.9 * ((double)this.nCircles - 5.129)) / (1.0 + Math.exp(0.9 * ((double)this.nCircles - 5.129)));
        }
        double[] residuals = new double[this.nPolygons - 1];
        String[] residualLabels = new String[this.nPolygons - 1];
        double area = 0.0;
        int nonZero = 0;
        for (int i = 1; i < this.nPolygons; ++i) {
            residuals[i - 1] = this.polyAreas[i] - this.polyHats[i];
            char[] c = this.encode(i);
            String s = "";
            for (int j = 0; j < c.length; ++j) {
                if (c[j] != '1') continue;
                s = s + this.circleLabels[j] + "&";
            }
            area += this.polyAreas[i];
            if (residuals[i - 1] != 0.0) {
                ++nonZero;
            }
            residualLabels[i - 1] = s = s.substring(0, s.length() - 1);
        }
        return new VennDiagram(this.centers, this.diameters, this.polyAreas, residuals, this.circleLabels, residualLabels, colors, this.stress, stress01, stress05);
    }

    private void processAreaData(String[][] data, double[] areas) {
        int i;
        HashMap<String, Double> sets = new HashMap<String, Double>();
        for (int i2 = 0; i2 < data.length; ++i2) {
            String[] s = data[i2][0].split("&");
            for (int j = 0; j < s.length; ++j) {
                if (sets.containsKey(s[j])) continue;
                Double cat = sets.size();
                sets.put(s[j], cat);
            }
        }
        this.circleLabels = new String[sets.size()];
        Set keys = sets.keySet();
        for (String key : keys) {
            int j = ((Double)sets.get(key)).intValue();
            this.circleLabels[j] = key;
        }
        int nRows = data.length;
        this.nCircles = sets.size();
        this.nPolygons = (int)Math.pow(2.0, this.nCircles);
        System.out.println(this.nPolygons);
        this.polyData = new double[this.nPolygons];
        this.polyAreas = new double[this.nPolygons];
        this.polyHats = new double[this.nPolygons];
        this.circleData = new double[this.nCircles];
        this.centers = new double[this.nCircles][2];
        double totalArea = 0.0;
        for (i = 0; i < nRows; ++i) {
            totalArea += areas[i];
        }
        for (i = 0; i < nRows; ++i) {
            int[] subsets = new int[this.nCircles];
            String[] s = data[i][0].split("&");
            for (int j = 0; j < s.length; ++j) {
                int jj = ((Double)sets.get(s[j])).intValue();
                subsets[jj] = 1;
            }
            int k = this.decode(subsets);
            this.polyData[k] = areas[i];
            for (int j = 0; j < this.nCircles; ++j) {
                if (subsets[j] <= 0) continue;
                int n = j;
                this.circleData[n] = this.circleData[n] + areas[i];
            }
        }
        for (i = 0; i < this.polyData.length; ++i) {
            this.polyData[i] = this.polyData[i] / totalArea;
        }
        for (int j = 0; j < this.nCircles; ++j) {
            this.circleData[j] = this.circleData[j] / totalArea;
            if (!this.isEqualArea) continue;
            this.circleData[j] = 1.0;
        }
    }

    private void processElementData(String[][] data) {
        int i;
        HashMap[] categories = new HashMap[]{new HashMap(), new HashMap()};
        for (int i2 = 0; i2 < data.length; ++i2) {
            for (int j = 0; j < 2; ++j) {
                if (categories[j].containsKey(data[i2][j])) continue;
                Double cat = categories[j].size();
                categories[j].put(data[i2][j], cat);
            }
        }
        this.circleLabels = new String[categories[1].size()];
        Set keys = categories[1].keySet();
        for (String key : keys) {
            int j = ((Double)categories[1].get(key)).intValue();
            this.circleLabels[j] = key;
        }
        int nRows = data.length;
        this.nCircles = categories[1].size();
        this.nPolygons = (int)Math.pow(2.0, this.nCircles);
        this.polyData = new double[this.nPolygons];
        this.polyAreas = new double[this.nPolygons];
        this.polyHats = new double[this.nPolygons];
        this.circleData = new double[this.nCircles];
        this.centers = new double[this.nCircles][2];
        int[][] subsets = new int[categories[0].size()][this.nCircles];
        for (i = 0; i < nRows; ++i) {
            int i1 = ((Double)categories[0].get(data[i][0])).intValue();
            int j1 = ((Double)categories[1].get(data[i][1])).intValue();
            int[] nArray = subsets[i1];
            int n = j1;
            nArray[n] = nArray[n] + 1;
        }
        for (i = 0; i < subsets.length; ++i) {
            this.updateCounts(subsets[i]);
        }
        for (i = 0; i < this.polyData.length; ++i) {
            this.polyData[i] = this.polyData[i] / (double)this.nTot;
        }
        for (int j = 0; j < this.nCircles; ++j) {
            this.circleData[j] = this.circleData[j] / (double)this.nTot;
            if (!this.isEqualArea) continue;
            this.circleData[j] = 1.0;
        }
    }

    protected void updateCounts(int[] counts) {
        int index;
        int n = index = this.decode(counts);
        this.polyData[n] = this.polyData[n] + 1.0;
        for (int j = 0; j < counts.length; ++j) {
            if (counts[j] <= 0) continue;
            int n2 = j;
            this.circleData[n2] = this.circleData[n2] + 1.0;
        }
        ++this.nTot;
    }

    private char[] encode(int index) {
        String s = Integer.toBinaryString(index);
        char[] c = s.toCharArray();
        int offset = this.nCircles - c.length;
        char[] result = new char[this.nCircles];
        for (int i = 0; i < offset; ++i) {
            result[i] = 48;
        }
        System.arraycopy(c, 0, result, offset, c.length);
        return result;
    }

    private int decode(int[] subsets) {
        String b = "";
        for (int j = 0; j < subsets.length; ++j) {
            b = subsets[j] > 0 ? b + '1' : b + '0';
        }
        return Integer.parseInt(b, 2);
    }

    private void calculateAreas() {
        int i;
        this.totalCount = 0;
        byte[][][] bis = new byte[this.nCircles][this.gridSize][this.gridSize];
        double mins = Double.POSITIVE_INFINITY;
        double maxs = Double.NEGATIVE_INFINITY;
        for (i = 0; i < this.nCircles; ++i) {
            double radius = this.diameters[i] / 2.0;
            mins = Math.min(this.centers[i][0] - radius, mins);
            mins = Math.min(this.centers[i][1] - radius, mins);
            maxs = Math.max(this.centers[i][0] + radius, maxs);
            maxs = Math.max(this.centers[i][1] + radius, maxs);
        }
        for (i = 0; i < this.nCircles; ++i) {
            double xi = (this.centers[i][0] - mins) / (maxs - mins);
            double yi = (this.centers[i][1] - mins) / (maxs - mins);
            double di = this.diameters[i] / (maxs - mins);
            int r = (int)(di * (double)this.gridSize / 2.0);
            int r2 = r * r;
            int cx = (int)(xi * (double)this.gridSize);
            int cy = (int)((double)this.gridSize - yi * (double)this.gridSize);
            for (int x = 0; x < this.gridSize; ++x) {
                for (int y = 0; y < this.gridSize; ++y) {
                    if ((x - cx) * (x - cx) + (y - cy) * (y - cy) >= r2) continue;
                    bis[i][x][y] = 1;
                }
            }
        }
        for (int x = 0; x < this.gridSize; ++x) {
            for (int y = 0; y < this.gridSize; ++y) {
                int[] counts = new int[this.nCircles];
                int count = 0;
                for (int j = 0; j < this.nCircles; ++j) {
                    if (bis[j][x][y] != 1) continue;
                    int n = j;
                    counts[n] = counts[n] + 1;
                    ++count;
                }
                if (count <= 0) continue;
                this.updatePixels(counts);
            }
        }
        if (this.totalCount == 0) {
            return;
        }
        for (i = 0; i < this.nPolygons; ++i) {
            this.polyAreas[i] = 100.0 * this.polyAreas[i] / (double)this.totalCount;
        }
    }

    private void updatePixels(int[] counts) {
        int index;
        int n = index = this.decode(counts);
        this.polyAreas[n] = this.polyAreas[n] + 1.0;
        ++this.totalCount;
    }

    public void computeInitialConfiguration() {
        double[][] s = this.computeDistanceMatrix();
        if (s == null) {
            this.fixedStart();
            return;
        }
        double[] q = new double[this.nCircles];
        this.computeScalarProducts(this.nCircles, s, q);
        Eigen.eigenSymmetric(s, s, q);
        double rms = Math.sqrt(q[0]) + Math.sqrt(q[1]);
        if (Double.isNaN(rms) || rms < 0.1) {
            this.fixedStart();
            return;
        }
        for (int i = 0; i < this.nCircles; ++i) {
            this.centers[i][0] = 0.5 + 0.25 * s[i][0] * Math.sqrt(q[0]);
            this.centers[i][1] = 0.5 + 0.25 * s[i][1] * Math.sqrt(q[1]);
        }
    }

    private void fixedStart() {
        double theta = 1.5707963267948966;
        double delta = Math.PI * 2 / (double)this.nCircles;
        for (int i = 0; i < this.nCircles; ++i) {
            this.centers[i][0] = 0.5 + Math.cos(theta);
            this.centers[i][1] = 0.5 + Math.sin(theta);
            theta -= delta;
        }
    }

    private double[][] computeDistanceMatrix() {
        int nIntersections = 0;
        double[][] s = new double[this.nCircles][this.nCircles];
        for (int i = 0; i < this.nPolygons; ++i) {
            char[] c = this.encode(i);
            for (int j = 0; j < c.length; ++j) {
                if (c[j] == '0') continue;
                for (int k = j + 1; k < c.length; ++k) {
                    if (c[k] == '0') continue;
                    double[] dArray = s[j];
                    int n = k;
                    dArray[n] = dArray[n] + this.polyData[i];
                    s[k][j] = s[j][k];
                    ++nIntersections;
                }
            }
        }
        for (int j = 0; j < this.nCircles; ++j) {
            s[j][j] = 0.0;
            for (int k = 0; k < j; ++k) {
                s[j][k] = 1.0 - s[j][k] / (this.circleData[j] + this.circleData[k]);
                s[k][j] = s[j][k];
            }
        }
        if (nIntersections < 1) {
            return null;
        }
        return s;
    }

    private void computeScalarProducts(int nPoints, double[][] s, double[] q) {
        double rms = 0.0;
        for (int i = 1; i < nPoints; ++i) {
            int j = 0;
            while (j < i) {
                double dij = s[i][j] * s[i][j];
                rms += dij + dij;
                int n = i;
                q[n] = q[n] + dij;
                int n2 = j++;
                q[n2] = q[n2] + dij;
            }
        }
        rms /= (double)(nPoints * nPoints);
        for (int i = 0; i < nPoints; ++i) {
            for (int j = 0; j <= i; ++j) {
                double dsm = i == j ? 0.0 : s[i][j] * s[i][j];
                s[i][j] = ((q[i] + q[j]) / (double)nPoints - rms - dsm) / 2.0;
                s[j][i] = s[i][j];
            }
        }
    }

    private void scaleDiameters() {
        this.diameters = new double[this.nCircles];
        for (int j = 0; j < this.nCircles; ++j) {
            this.diameters[j] = 2.0 * Math.sqrt(this.circleData[j] / Math.PI / (double)this.nCircles);
        }
    }

    private void rescaleDiameters(double[] realDiameters, int iteration) {
        if (iteration > 5) {
            return;
        }
        if (iteration == 0) {
            int j;
            double averageDiameter = 0.0;
            for (j = 0; j < this.nCircles; ++j) {
                averageDiameter += realDiameters[j];
            }
            averageDiameter /= (double)this.nCircles;
            for (j = 0; j < this.nCircles; ++j) {
                this.diameters[j] = averageDiameter;
            }
        } else if (iteration < 5) {
            for (int j = 0; j < this.nCircles; ++j) {
                this.diameters[j] = this.diameters[j] - (double)iteration / 5.0 * (this.diameters[j] - realDiameters[j]);
            }
        } else {
            for (int j = 0; j < this.nCircles; ++j) {
                this.diameters[j] = realDiameters[j];
            }
        }
    }

    private void scaleConfiguration() {
        int j;
        double vc = 0.0;
        for (j = 0; j < 2; ++j) {
            int k;
            double mc = 0.0;
            for (k = 0; k < this.nCircles; ++k) {
                mc += this.centers[k][j];
            }
            mc /= (double)this.nCircles;
            for (k = 0; k < this.nCircles; ++k) {
                double[] dArray = this.centers[k];
                int n = j;
                dArray[n] = dArray[n] - mc;
                vc += this.centers[k][j] * this.centers[k][j];
            }
        }
        if ((vc = 10.0 * Math.sqrt(vc / (double)(2 * this.nCircles))) > 0.0) {
            for (j = 0; j < 2; ++j) {
                for (int k = 0; k < this.nCircles; ++k) {
                    double[] dArray = this.centers[k];
                    int n = j;
                    dArray[n] = dArray[n] / vc;
                }
            }
        }
    }

    private double computeStress() {
        this.calculateAreas();
        if (this.totalCount == 0) {
            this.scaleConfiguration();
            this.calculateAreas();
        }
        double xx = 0.0;
        double xy = 0.0;
        int n = this.polyData.length;
        double sst = 0.0;
        for (int i = 1; i < n; ++i) {
            double x = this.polyData[i];
            double y = this.polyAreas[i];
            xy += x * y;
            xx += x * x;
            sst += y * y;
        }
        double slope = xy / xx;
        double sse = 0.0;
        for (int i = 1; i < n; ++i) {
            double yhat;
            double x = this.polyData[i];
            double y = this.polyAreas[i];
            this.polyHats[i] = yhat = x * slope;
            sse += (y - yhat) * (y - yhat);
        }
        return sse / sst;
    }

    private void minimizeGlobal() {
        double[] initialDiameters = new double[this.nCircles];
        System.arraycopy(this.diameters, 0, initialDiameters, 0, this.nCircles);
        double[][] previousCenters = new double[this.nCircles][2];
        this.copyCircles(this.centers, previousCenters);
        double lastStress = 1.0;
        for (int iter = 0; iter < this.iterations; ++iter) {
            this.rescaleDiameters(initialDiameters, iter);
            this.recenter();
            this.stress = this.computeStress();
            if (this.stress > lastStress) {
                this.copyCircles(previousCenters, this.centers);
            } else {
                this.copyCircles(this.centers, previousCenters);
            }
            if (iter > 10 && (this.stress < this.minStress || lastStress - this.stress < this.minStress)) break;
            this.moveGlobal();
            lastStress = this.stress;
        }
        this.rescaleDiameters(initialDiameters, this.iterations);
        this.recenter();
        this.stress = this.computeStress();
    }

    private void minimizeLocal() {
        double[] initialDiameters = new double[this.nCircles];
        System.arraycopy(this.diameters, 0, initialDiameters, 0, this.nCircles);
        double[][] initialCenters = new double[this.nCircles][2];
        this.copyCircles(this.centers, initialCenters);
        double[][] previousCenters = new double[this.nCircles][2];
        this.copyCircles(this.centers, previousCenters);
        double previousStress = this.stress;
        double lastStress = 1.0;
        for (int iter = 0; iter < this.iterations; ++iter) {
            this.rescaleDiameters(initialDiameters, iter);
            this.recenter();
            this.stress = this.computeStress();
            if (this.stress > lastStress) {
                this.copyCircles(previousCenters, this.centers);
            } else {
                this.copyCircles(this.centers, previousCenters);
            }
            if (iter > 10 && (this.stress < this.minStress || lastStress - this.stress < this.minStress)) break;
            this.moveLocal();
            lastStress = this.stress;
        }
        this.rescaleDiameters(initialDiameters, this.iterations);
        if (previousStress < this.stress) {
            this.copyCircles(initialCenters, this.centers);
        }
        this.recenter();
        this.stress = this.computeStress();
    }

    private void moveGlobal() {
        int i;
        double[][] gradients = new double[this.nCircles][2];
        for (i = 0; i < this.nPolygons; ++i) {
            String s = Integer.toBinaryString(i);
            char[] c = s.toCharArray();
            int offset = this.nCircles - c.length;
            for (int j = 0; j < c.length; ++j) {
                if (c[j] == '0') continue;
                int jo = j + offset;
                for (int k = j + 1; k < c.length; ++k) {
                    if (c[k] == '0') continue;
                    int ko = k + offset;
                    double resid = this.polyAreas[i] - this.polyHats[i];
                    double dx = resid * this.stepsize * (this.centers[jo][0] - this.centers[ko][0]);
                    double dy = resid * this.stepsize * (this.centers[jo][1] - this.centers[ko][1]);
                    double[] dArray = gradients[jo];
                    dArray[0] = dArray[0] + dx;
                    double[] dArray2 = gradients[jo];
                    dArray2[1] = dArray2[1] + dy;
                    double[] dArray3 = gradients[ko];
                    dArray3[0] = dArray3[0] - dx;
                    double[] dArray4 = gradients[ko];
                    dArray4[1] = dArray4[1] - dy;
                }
            }
        }
        for (i = 0; i < this.nCircles; ++i) {
            double[] dArray = this.centers[i];
            dArray[0] = dArray[0] + gradients[i][0];
            double[] dArray5 = this.centers[i];
            dArray5[1] = dArray5[1] + gradients[i][1];
        }
    }

    private void moveLocal() {
        int i;
        double[][] gradients = new double[this.nCircles][2];
        for (i = 0; i < this.nCircles; ++i) {
            double[] dArray = this.centers[i];
            dArray[0] = dArray[0] + this.stepsize;
            double xPlus = this.computeStress();
            double[] dArray2 = this.centers[i];
            dArray2[0] = dArray2[0] - 2.0 * this.stepsize;
            double xMinus = this.computeStress();
            double[] dArray3 = this.centers[i];
            dArray3[0] = dArray3[0] + this.stepsize;
            gradients[i][0] = xPlus < xMinus ? this.stepsize : -this.stepsize;
            double[] dArray4 = this.centers[i];
            dArray4[1] = dArray4[1] + this.stepsize;
            double yPlus = this.computeStress();
            double[] dArray5 = this.centers[i];
            dArray5[1] = dArray5[1] - 2.0 * this.stepsize;
            double yMinus = this.computeStress();
            double[] dArray6 = this.centers[i];
            dArray6[1] = dArray6[1] + this.stepsize;
            gradients[i][1] = yPlus < yMinus ? this.stepsize : -this.stepsize;
        }
        for (i = 0; i < this.nCircles; ++i) {
            double[] dArray = this.centers[i];
            dArray[0] = dArray[0] + gradients[i][0];
            double[] dArray7 = this.centers[i];
            dArray7[1] = dArray7[1] + gradients[i][1];
        }
    }

    private void recenter() {
        int i;
        double cx = 0.0;
        double cy = 0.0;
        for (i = 0; i < this.nCircles; ++i) {
            cx += this.centers[i][0];
            cy += this.centers[i][1];
        }
        cx /= (double)this.nCircles;
        cy /= (double)this.nCircles;
        for (i = 0; i < this.nCircles; ++i) {
            this.centers[i][0] = 0.5 + this.centers[i][0] - cx;
            this.centers[i][1] = 0.5 + this.centers[i][1] - cy;
        }
    }

    private void copyCircles(double[][] a, double[][] b) {
        for (int i = 0; i < this.nCircles; ++i) {
            System.arraycopy(a[i], 0, b[i], 0, 2);
        }
    }
}

