/*
 * Decompiled with CFR 0.152.
 */
package de.javasoft.docking;

import de.javasoft.docking.JYDockingView;
import de.javasoft.docking.controls.BorderManager;
import de.javasoft.docking.controls.DockingManager;
import de.javasoft.docking.controls.DockingPort;
import de.javasoft.docking.controls.IDockable;
import de.javasoft.docking.controls.IDockingConstants;
import java.awt.Component;
import java.util.HashSet;
import java.util.Set;
import java.util.UUID;

public class JYDockingPort
extends DockingPort
implements IDockingConstants {
    private static final long serialVersionUID = -4694207726734641902L;
    protected HashSet<String> blockedRegions = new HashSet(5);

    static {
        if (DockingManager.getDockingStrategy(JYDockingPort.class) == null) {
            DockingManager.setDockingStrategy(JYDockingPort.class, JYDockingView.VIEW_DOCKING_STRATEGY);
        }
    }

    public JYDockingPort() {
        this(UUID.randomUUID().toString());
    }

    public JYDockingPort(String portId) {
        super(portId);
        this.setBorderManager(new BorderManager());
    }

    public void setRegionBlocked(String region, boolean blocked) {
        if (blocked) {
            this.blockedRegions.add(region);
        } else {
            this.blockedRegions.remove(region);
        }
    }

    public boolean isRegionBlocked(String region) {
        return this.blockedRegions.contains(region);
    }

    public Set<IDockable> getViewset(int depth) {
        return this.getDockables(depth, 0, JYDockingView.class);
    }

    @Override
    public boolean isDockingAllowed(Component comp, String region) {
        if (!super.isDockingAllowed(comp, region)) {
            return false;
        }
        if (!"CENTER".equals(region)) {
            return true;
        }
        IDockable dockable = this.getCenterDockable();
        if (dockable == null) {
            return true;
        }
        return true;
    }
}

