/*
 * Decompiled with CFR 0.152.
 */
package de.javasoft.docking.controls;

import de.javasoft.docking.controls.DockingEvent;
import de.javasoft.docking.controls.DockingManager;
import de.javasoft.docking.controls.DockingPort;
import de.javasoft.docking.controls.DockingSplitPane;
import de.javasoft.docking.controls.DockingUtility;
import de.javasoft.docking.controls.DragManager;
import de.javasoft.docking.controls.DragOperation;
import de.javasoft.docking.controls.FloatingDialog;
import de.javasoft.docking.controls.FloatingFrame;
import de.javasoft.docking.controls.IDockable;
import de.javasoft.docking.controls.IDockingConstants;
import de.javasoft.docking.controls.IDockingPort;
import de.javasoft.docking.controls.IDockingStrategy;
import de.javasoft.docking.controls.IFloatingDockingPort;
import de.javasoft.docking.controls.IRegionChecker;
import de.javasoft.docking.controls.Perspective;
import de.javasoft.docking.controls.RootWindow;
import de.javasoft.plaf.synthetica.SyntheticaLookAndFeel;
import de.javasoft.tabpane.JYTabbedPane;
import java.awt.Component;
import java.awt.Container;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.JSplitPane;
import javax.swing.plaf.basic.BasicSplitPaneUI;

public class DockingStrategy
implements IDockingStrategy,
IDockingConstants {
    static final String PREFERRED_PROPORTION = "DefaultDockingStrategy.PREFERRED_PROPORTION";
    static final String REGION = "region";

    @Override
    public boolean dock(IDockable dockable, IDockingPort port, Perspective perspective, String region) {
        if (!this.isDockingPossible(dockable, port, region)) {
            return false;
        }
        DragOperation dragOp = DragManager.getCurrentDragOperation();
        if (!this.dragThresholdElapsed(dragOp)) {
            return false;
        }
        IDockingPort oldPort = dockable.getDockingPort();
        DockingResults results = this.dropComponent(dockable, port, perspective, region, dragOp);
        IDockingPort newPort = results.dropTarget;
        if (!results.success) {
            DockingEvent evt = new DockingEvent(dockable, oldPort, newPort, results.success ? 4 : 5, DragManager.getDragContext(dockable));
            evt.setRegion(region);
            DockingManager.dispatchEvent(evt, true, true);
        }
        return results.success;
    }

    @Override
    public boolean undock(IDockable dockable) {
        if (dockable == null) {
            return false;
        }
        JComponent dragSrc = dockable.getComponent();
        Container parent = dragSrc.getParent();
        if (parent == null) {
            return false;
        }
        RootWindow rootWindow = RootWindow.getRootWindow(parent);
        if (parent.getParent() instanceof JYTabbedPane) {
            parent = parent.getParent();
        }
        boolean success = false;
        IDockingPort dockingPort = DockingUtility.getParentDockingPort(dragSrc);
        Map<Object, Object> dragContext = DragManager.getDragContext(dockable);
        DockingEvent evt = new DockingEvent(dockable, dockingPort, dockingPort, 7, dragContext);
        DockingManager.dispatchEvent(evt);
        if (dockingPort != null) {
            success = dockingPort.undockComponent(dragSrc);
        } else {
            parent.remove(dragSrc);
            success = true;
        }
        if (rootWindow != null) {
            ((JComponent)rootWindow.getContentPane()).revalidate();
            ((JComponent)rootWindow.getContentPane()).repaint();
        }
        if (success) {
            evt = new DockingEvent(dockable, dockingPort, dockingPort, 6, dragContext);
            DockingManager.dispatchEvent(evt, false, true);
        }
        return success;
    }

    @Override
    public IDockingPort createDockingPort(IDockingPort basePort) {
        IDockingPort port = this.createDockingPortImpl(basePort);
        if (port instanceof DockingPort && basePort instanceof DockingPort) {
            DockingPort newPort = (DockingPort)port;
            DockingPort ddp = (DockingPort)basePort;
            newPort.setBorderManager(ddp.getBorderManager());
            newPort.setTabsAsDragSourceEnabled(ddp.isTabsAsDragSourceEnabled());
            newPort.setRoot(false);
        }
        return port;
    }

    @Override
    public JSplitPane createSplitPane(IDockingPort basePort, String region) {
        JSplitPane split = this.createSplitPaneImpl(basePort, region);
        split.putClientProperty(REGION, region);
        boolean elderInTopLeft = !DockingUtility.isRegionTopLeft(region);
        boolean resizeWeight = elderInTopLeft;
        split.setResizeWeight((double)resizeWeight);
        int orientation = 1;
        if ("NORTH".equals(region) || "SOUTH".equals(region)) {
            orientation = 0;
        }
        split.setOrientation(orientation);
        split.setBorder(null);
        split.setDividerSize(SyntheticaLookAndFeel.getInt((String)"JYDocking.splitPane.divider.size", (Component)split, (int)3));
        split.setOneTouchExpandable(false);
        if (!(split.getUI() instanceof BasicSplitPaneUI)) {
            return split;
        }
        return split;
    }

    @Override
    public int getInitialDividerLocation(IDockingPort port, JSplitPane splitPane) {
        if (port == null || splitPane == null) {
            return 0;
        }
        Container dockingPort = (Container)((Object)port);
        Insets in = dockingPort.getInsets();
        boolean vert = splitPane.getOrientation() == 0;
        int inset = vert ? in.top + in.bottom : in.left + in.right;
        int portSize = vert ? dockingPort.getHeight() : dockingPort.getWidth();
        portSize -= inset;
        double proportion = this.getDividerProportion(port, splitPane);
        if (proportion < 0.0 || proportion > 1.0) {
            proportion = 0.5;
        }
        return (int)((double)portSize * proportion);
    }

    @Override
    public double getDividerProportion(IDockingPort port, JSplitPane splitPane) {
        IDockable dockable;
        if (port == null || splitPane == null) {
            return DockingManager.getDefaultSiblingSize();
        }
        Component elder = this.getElderComponent(splitPane);
        if (elder == null) {
            return DockingManager.getDefaultSiblingSize();
        }
        Float prefProp = this.getPreferredProportion(splitPane, elder);
        if (prefProp != null) {
            return prefProp.doubleValue();
        }
        if (elder instanceof DockingSplitPane) {
            elder = ((DockingSplitPane)elder).getElderComponent();
        }
        if ((dockable = DockingManager.getDockable(elder)) != null) {
            IRegionChecker rc = port.getRegionChecker();
            float prefSize = rc.getSiblingSize(dockable.getComponent(), this.getCreationRegion(splitPane));
            return this.isElderTopLeft(splitPane) ? 1.0f - prefSize : prefSize;
        }
        return DockingManager.getDefaultSiblingSize();
    }

    public static IDockable getSibling(IDockable dockable) {
        IDockingPort port = dockable.getDockingPort();
        String startRegion = DockingStrategy.findRegion(dockable.getComponent());
        String region = DockingUtility.flipRegion(startRegion);
        return DockingStrategy.findDockable(port, dockable.getComponent(), region, startRegion);
    }

    public static IDockable getSibling(IDockable dockable, String region) {
        if (dockable == null || !DockingManager.isValidDockingRegion(region) || "CENTER".equals(region)) {
            return null;
        }
        IDockingPort port = dockable.getDockingPort();
        String startRegion = DockingStrategy.findRegion(dockable.getComponent());
        return DockingStrategy.findDockable(port, dockable.getComponent(), region, startRegion);
    }

    public static String findRegion(JComponent c) {
        if (c == null) {
            return null;
        }
        IDockingPort port = DockingManager.getDockingPort(c);
        JComponent docked = port.getDockedComponent();
        if (!(docked instanceof JSplitPane)) {
            IDockingPort superPort = DockingManager.getDockingPort(port.getComponent());
            JComponent jComponent = docked = superPort == null ? docked : superPort.getDockedComponent();
        }
        if (!(docked instanceof JSplitPane)) {
            return "CENTER";
        }
        JSplitPane split = (JSplitPane)docked;
        boolean horiz = split.getOrientation() == 1;
        Component left = split.getLeftComponent();
        if (left == port) {
            return horiz ? "WEST" : "NORTH";
        }
        return horiz ? "EAST" : "SOUTH";
    }

    private static IDockable findDockable(IDockingPort port, Component self, String region, String startRegion) {
        if (port == null) {
            return null;
        }
        JComponent docked = port.getDockedComponent();
        if (!(docked instanceof JSplitPane)) {
            IDockingPort superPort = DockingManager.getDockingPort(port.getComponent());
            return DockingStrategy.findDockable(superPort, self, region, startRegion);
        }
        JComponent sibling = port.getDockedComponent(region);
        if (sibling == self) {
            if (!(self instanceof JSplitPane)) {
                IDockingPort superPort = DockingManager.getDockingPort(port.getComponent());
                return DockingStrategy.findDockable(superPort, self, region, startRegion);
            }
            return null;
        }
        if (sibling instanceof JSplitPane) {
            IDockingPort subPort = DockingManager.getDockingPort(sibling);
            JComponent other = port.getDockedComponent(DockingUtility.flipRegion(region));
            String subRegion = DockingStrategy.findSubRegion((JSplitPane)sibling, other, region, startRegion);
            return DockingStrategy.findDockable(subPort, self, subRegion, startRegion);
        }
        if (sibling == null) {
            IDockingPort superPort = DockingManager.getDockingPort(port.getComponent());
            self = port.getDockedComponent();
            return DockingStrategy.findDockable(superPort, self, region, startRegion);
        }
        return DockingManager.getDockable(sibling);
    }

    private static String findSubRegion(JSplitPane split, Component other, String targetRegion, String baseRegion) {
        boolean translated;
        String region = DockingUtility.translateRegionAxis(split, targetRegion);
        if (!(other instanceof JSplitPane)) {
            return region;
        }
        boolean bl = translated = !targetRegion.equals(region);
        if (translated && !DockingUtility.isAxisEquivalent(region, baseRegion)) {
            region = DockingUtility.flipRegion(region);
        }
        return region;
    }

    protected boolean dragThresholdElapsed(DragOperation dragOp) {
        if (dragOp == null || dragOp.isPseudoDrag() || dragOp.getStartTime() == -1L) {
            return true;
        }
        long elapsed = System.currentTimeMillis() - dragOp.getStartTime();
        return elapsed > 200L;
    }

    protected boolean isDockingPossible(IDockable dockable, IDockingPort port, String region) {
        IFloatingDockingPort floatingDockingPort;
        if (this.isFloatable(dockable, DragManager.getCurrentDragOperation())) {
            return true;
        }
        IDockingPort oldPort = DockingManager.getDockingPort(dockable);
        if (oldPort instanceof IFloatingDockingPort && oldPort == port && (floatingDockingPort = (IFloatingDockingPort)oldPort).getDockableCount() == 1) {
            return false;
        }
        if (dockable == null || dockable.getComponent() == null || port == null) {
            return false;
        }
        if (!DockingManager.isValidDockingRegion(region)) {
            return false;
        }
        IDockable docked = DockingManager.getDockable(port.getDockedComponent());
        if (docked == null) {
            return true;
        }
        Container container = docked.getComponent().getParent();
        IDockingPort grandparent = DockingManager.getDockingPort(container);
        if (grandparent == null) {
            return true;
        }
        JComponent currentlyInRegion = grandparent.getDockedComponent(region);
        return currentlyInRegion != dockable.getComponent();
    }

    protected boolean isFloatable(IDockable dockable, DragOperation dragOp) {
        if (dockable == null || dockable.getComponent() == null || dragOp == null || dragOp.getCurrentMouse(true) == null) {
            return false;
        }
        if (dragOp.isPseudoDrag()) {
            return false;
        }
        return !dragOp.isOverWindow();
    }

    DockingResults dropComponent(IDockable dockable, IDockingPort target, Perspective perspective, String region, DragOperation dragOp) {
        if (this.isFloatable(dockable, dragOp)) {
            return this.floatComponent(dockable, target, perspective, dragOp);
        }
        DockingResults results = new DockingResults(target, false);
        if ("UNKNOWN".equals(region) || target == null) {
            return results;
        }
        JComponent docked = target.getDockedComponent();
        JComponent dockableCmp = dockable.getComponent();
        if (dockableCmp != null && dockableCmp == docked) {
            return results;
        }
        Container contentPane = DockingUtility.getContentPane(target.getComponent());
        Point contentPaneLocation = dragOp == null ? null : dragOp.getCurrentMouse(contentPane);
        IDockingPort newPort = DockingUtility.findDockingPort(contentPane, contentPaneLocation);
        JComponent newPortComponent = newPort == null ? null : newPort.getDockedComponent();
        this.undock(dockable);
        if (contentPaneLocation != null && contentPane != null) {
            newPort = DockingManager.getDockingPort(newPortComponent);
            if (newPort == null) {
                newPort = DockingUtility.findDockingPort(contentPane, contentPaneLocation);
            }
            if (newPort != null) {
                results.dropTarget = newPort;
                target = results.dropTarget;
            }
        }
        results.success = target.dockComponent(dockableCmp, perspective, region);
        target.getComponent().revalidate();
        return results;
    }

    DockingResults floatComponent(IDockable dockable, IDockingPort target, Perspective perspective, DragOperation dragOp) {
        DockingResults results = new DockingResults(target, false);
        Point screenLoc = dragOp.getCurrentMouse(true);
        this.add(screenLoc, dragOp.getMouseOffset());
        Rectangle screenBounds = dockable.getComponent().getBounds();
        screenBounds.setLocation(screenLoc);
        RootWindow rw = RootWindow.getRootWindow(dockable.getComponent());
        Window owner = rw != null ? rw.getWindow() : RootWindow.getMainWindow();
        Window w = DockingManager.floatDockable(dockable, owner, perspective, screenBounds);
        if (w instanceof FloatingDialog) {
            results.dropTarget = ((FloatingDialog)w).getDockingPort();
        } else if (w instanceof FloatingFrame) {
            results.dropTarget = ((FloatingFrame)w).getDockingPort();
        }
        results.success = true;
        return results;
    }

    private void add(Point p1, Point p2) {
        if (p1 != null && p2 != null) {
            p1.x += p2.x;
            p1.y += p2.y;
        }
    }

    protected IDockingPort createDockingPortImpl(IDockingPort base) {
        return new DockingPort();
    }

    protected JSplitPane createSplitPaneImpl(IDockingPort base, String region) {
        return new DockingSplitPane(base, region);
    }

    protected String getCreationRegion(JSplitPane splitPane) {
        if (splitPane instanceof DockingSplitPane) {
            return ((DockingSplitPane)splitPane).getRegion();
        }
        return (String)splitPane.getClientProperty(REGION);
    }

    protected boolean isElderTopLeft(JSplitPane splitPane) {
        if (splitPane instanceof DockingSplitPane) {
            return ((DockingSplitPane)splitPane).isElderTopLeft();
        }
        String region = this.getCreationRegion(splitPane);
        return !DockingUtility.isRegionTopLeft(region);
    }

    protected Float getPreferredProportion(JSplitPane splitPane, Component controller) {
        Container controllerPort = controller.getParent();
        return DockingStrategy.getPreferredProportion(controllerPort);
    }

    protected Component getElderComponent(JSplitPane splitPane) {
        Component comp;
        if (splitPane instanceof DockingSplitPane) {
            return ((DockingSplitPane)splitPane).getElderComponent();
        }
        boolean inTopLeft = this.isElderTopLeft(splitPane);
        Component component = comp = inTopLeft ? splitPane.getLeftComponent() : splitPane.getRightComponent();
        if (comp instanceof IDockingPort) {
            comp = ((IDockingPort)((Object)comp)).getDockedComponent();
        }
        return comp;
    }

    protected static Float getPreferredProportion(Component c) {
        return c == null ? null : (Float)((JComponent)c).getClientProperty(PREFERRED_PROPORTION);
    }

    private static class DockingResults {
        private IDockingPort dropTarget;
        private boolean success;

        public DockingResults(IDockingPort port, boolean status) {
            this.dropTarget = port;
            this.success = status;
        }
    }
}

