/*
 * Decompiled with CFR 0.152.
 */
package de.javasoft.docking.controls;

import de.javasoft.docking.controls.DockingEvent;
import de.javasoft.docking.controls.DragManager;
import de.javasoft.docking.controls.FloatPolicy;
import de.javasoft.docking.controls.IDockable;
import de.javasoft.docking.controls.IDockingEventListener;
import de.javasoft.docking.controls.IFloatPolicy;
import java.util.ArrayList;
import java.util.Map;

class FloatPolicyManager
implements IDockingEventListener {
    private static final FloatPolicyManager INSTANCE = new FloatPolicyManager();
    private static final String FLOATING_ALLOWED = "FloatPolicyManager.FLOATING_ALLOWED";
    private ArrayList<IFloatPolicy> policies = new ArrayList();
    private boolean globalFloatingEnabled;

    public static FloatPolicyManager getInstance() {
        return INSTANCE;
    }

    private FloatPolicyManager() {
        this.addPolicy(FloatPolicy.getInstance());
        this.globalFloatingEnabled = false;
    }

    public boolean isFloatingAllowed(IDockable dockable) {
        Map<Object, Object> context = DragManager.getDragContext(dockable);
        if (context == null) {
            return this.isPolicyFloatingSupported(dockable);
        }
        Boolean floatAllowed = (Boolean)context.get(FLOATING_ALLOWED);
        return floatAllowed == null ? true : floatAllowed;
    }

    public boolean isPolicyFloatingSupported(IDockable dockable) {
        if (dockable == null) {
            return false;
        }
        for (IFloatPolicy policy : this.policies) {
            if (policy.isFloatingAllowed(dockable)) continue;
            return false;
        }
        return true;
    }

    public void addPolicy(IFloatPolicy policy) {
        this.policies.add(policy);
    }

    public void removePolicy(IFloatPolicy policy) {
        this.policies.remove(policy);
    }

    public void setGlobalFloatingEnabled(boolean globalFloatingEnabled) {
        this.globalFloatingEnabled = globalFloatingEnabled;
    }

    public boolean isGlobalFloatingEnabled() {
        return this.globalFloatingEnabled;
    }

    @Override
    public void dockableRegistered(DockingEvent evt) {
    }

    @Override
    public void dockableUnregistered(DockingEvent evt) {
    }

    @Override
    public void dockingCanceled(DockingEvent evt) {
    }

    @Override
    public void dockingCompleted(DockingEvent evt) {
    }

    @Override
    public void undockingStarted(DockingEvent evt) {
    }

    @Override
    public void undockingCompleted(DockingEvent evt) {
    }

    @Override
    public void dragStarted(DockingEvent evt) {
        Map<Object, Object> context = evt.getDragContext();
        IDockable d = evt.getDockable();
        context.put(FLOATING_ALLOWED, this.isPolicyFloatingSupported(d));
    }

    @Override
    public void dropStarted(DockingEvent evt) {
        if (evt.isOverWindow()) {
            return;
        }
        if (!this.isFloatingAllowed(evt.getDockable())) {
            evt.consume();
            return;
        }
        for (IFloatPolicy policy : this.policies) {
            if (policy.isFloatDropAllowed(evt)) continue;
            evt.consume();
            return;
        }
    }
}

