/*
 * Decompiled with CFR 0.152.
 */
package de.javasoft.docking.controls;

import de.javasoft.docking.controls.DockingManager;
import de.javasoft.docking.controls.FloatingDockingPort;
import de.javasoft.docking.controls.FloatingGroup;
import de.javasoft.docking.controls.IDockable;
import de.javasoft.docking.controls.IDockingPort;
import de.javasoft.docking.controls.IFloatingDockingPort;
import de.javasoft.docking.controls.Perspective;
import de.javasoft.plaf.synthetica.SyntheticaLookAndFeel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.UIManager;

class FloatingDialog
extends JDialog {
    private static final long serialVersionUID = 456081945923738818L;
    private static final BoundsMonitor BOUNDS_MONITOR = new BoundsMonitor();
    private IFloatingDockingPort dockingPort;
    private String groupID;

    FloatingDialog(Frame owner, String groupName) {
        super(owner);
        this.initialize(groupName);
    }

    FloatingDialog(Dialog owner, String groupName) {
        super(owner);
        this.initialize(groupName);
    }

    private void initialize(String groupName) {
        IDockingPort port;
        this.groupID = groupName;
        this.setName("JYDocking.FloatingDialog");
        if (UIManager.getLookAndFeel() instanceof SyntheticaLookAndFeel && SyntheticaLookAndFeel.getBoolean((String)"Synthetica.window.decoration", (Component)this)) {
            JComponent titlePane = (JComponent)SyntheticaLookAndFeel.findComponent((String)"RootPane.titlePane", (Container)this);
            titlePane.setPreferredSize(SyntheticaLookAndFeel.getInstance().scaleDimension(12, 12));
            boolean closeButtonVisible = SyntheticaLookAndFeel.getBoolean((String)"JYDocking.floatingWindow.closeButton.visible", (Component)this, (boolean)false);
            SyntheticaLookAndFeel.findComponent((String)"RootPane.titlePane.closeButton", (Container)titlePane).setVisible(closeButtonVisible);
            boolean menuButtonVisible = SyntheticaLookAndFeel.getBoolean((String)"JYDocking.floatingWindow.menuButton.visible", (Component)this, (boolean)true);
            Component b = SyntheticaLookAndFeel.findComponent((String)"RootPane.titlePane.menuButton", (Container)titlePane);
            if (b != null) {
                b.setVisible(menuButtonVisible);
            }
        }
        this.dockingPort = (port = DockingManager.getDockingStrategy(IFloatingDockingPort.class).createDockingPort(null)) instanceof IFloatingDockingPort ? (IFloatingDockingPort)port : new FloatingDockingPort();
        this.dockingPort.setFloatingWindow(this);
        JPanel p = new JPanel(new BorderLayout());
        p.setBorder(SyntheticaLookAndFeel.getInstance().createEmptyBorder(SyntheticaLookAndFeel.getInsets((String)"JYDocking.floatingWindow.insets", (Component)this, (Insets)new Insets(2, 2, 2, 2), (boolean)true), false));
        p.add(this.dockingPort.getComponent());
        this.setContentPane(p);
        this.addComponentListener(BOUNDS_MONITOR);
    }

    public IDockingPort getDockingPort() {
        return this.dockingPort;
    }

    public void addDockable(IDockable dockable, Perspective perspective) {
        if (dockable == null) {
            return;
        }
        this.dockingPort.dock(dockable, perspective, "CENTER");
    }

    public void destroy() {
        this.setVisible(false);
        this.dockingPort = null;
        FloatingGroup group = this.getGroup();
        if (group != null) {
            group.setFloatingWindow(null);
        }
        this.dispose();
    }

    public String getGroupID() {
        return this.groupID;
    }

    public FloatingGroup getGroup() {
        return DockingManager.getFloatingGroup(this.getGroupID());
    }

    @Override
    public Window getOwner() {
        return super.getOwner();
    }

    private static class BoundsMonitor
    implements ComponentListener {
        private BoundsMonitor() {
        }

        @Override
        public void componentHidden(ComponentEvent e) {
        }

        @Override
        public void componentMoved(ComponentEvent e) {
            this.updateBounds(e);
        }

        @Override
        public void componentResized(ComponentEvent e) {
            this.updateBounds(e);
        }

        @Override
        public void componentShown(ComponentEvent e) {
            this.updateBounds(e);
        }

        private void updateBounds(ComponentEvent evt) {
            Component c = evt.getComponent();
            if (!(c instanceof FloatingDialog)) {
                return;
            }
            FloatingDialog frame = (FloatingDialog)c;
            FloatingGroup group = frame.getGroup();
            if (group != null) {
                group.setBounds(frame.getBounds());
            }
        }
    }
}

