/*
 * Decompiled with CFR 0.152.
 */
package de.javasoft.docking.controls;

import de.javasoft.docking.controls.DockingManager;
import de.javasoft.docking.controls.FloatingDockingPort;
import de.javasoft.docking.controls.FloatingGroup;
import de.javasoft.docking.controls.IDockable;
import de.javasoft.docking.controls.IDockingPort;
import de.javasoft.docking.controls.IFloatingDockingPort;
import de.javasoft.docking.controls.Perspective;
import de.javasoft.plaf.synthetica.SyntheticaLookAndFeel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Frame;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.UIManager;

class FloatingFrame
extends JFrame {
    private static final long serialVersionUID = -621877995815416031L;
    private static final BoundsMonitor BOUNDS_MONITOR = new BoundsMonitor();
    private IFloatingDockingPort dockingPort;
    private String groupID;
    private Frame owner;

    FloatingFrame(Frame owner, String groupName) {
        this.owner = owner;
        this.initialize(groupName, owner == null ? null : owner.getIconImage());
    }

    FloatingFrame(String groupName) {
        this(null, groupName);
    }

    private void initialize(String groupName, Image icon) {
        IDockingPort port;
        this.groupID = groupName;
        this.setName("JYDocking.FloatingFrame");
        this.setIconImage(icon);
        if (UIManager.getLookAndFeel() instanceof SyntheticaLookAndFeel && SyntheticaLookAndFeel.getBoolean((String)"Synthetica.window.decoration", (Component)this)) {
            JComponent titlePane = (JComponent)SyntheticaLookAndFeel.findComponent((String)"RootPane.titlePane", (Container)this);
            titlePane.setPreferredSize(SyntheticaLookAndFeel.getInstance().scaleDimension(16, 16));
            boolean closeButtonVisible = SyntheticaLookAndFeel.getBoolean((String)"JYDocking.floatingWindow.closeButton.visible", (Component)this, (boolean)false);
            SyntheticaLookAndFeel.findComponent((String)"RootPane.titlePane.closeButton", (Container)titlePane).setVisible(closeButtonVisible);
            boolean menuButtonVisible = SyntheticaLookAndFeel.getBoolean((String)"JYDocking.floatingWindow.menuButton.visible", (Component)this, (boolean)true);
            SyntheticaLookAndFeel.findComponent((String)"RootPane.titlePane.menuButton", (Container)titlePane).setVisible(menuButtonVisible);
        }
        this.dockingPort = (port = DockingManager.getDockingStrategy(IFloatingDockingPort.class).createDockingPort(null)) instanceof IFloatingDockingPort ? (IFloatingDockingPort)port : new FloatingDockingPort();
        this.dockingPort.setFloatingWindow(this);
        JPanel p = new JPanel(new BorderLayout());
        p.setBorder(SyntheticaLookAndFeel.getInstance().createEmptyBorder(SyntheticaLookAndFeel.getInsets((String)"JYDocking.floatingWindow.insets", (Component)this, (Insets)new Insets(2, 2, 2, 2), (boolean)true), false));
        p.add(this.dockingPort.getComponent());
        this.setContentPane(p);
        this.addComponentListener(BOUNDS_MONITOR);
    }

    public IDockingPort getDockingPort() {
        return this.dockingPort;
    }

    public void addDockable(IDockable dockable, Perspective perspective) {
        if (dockable == null) {
            return;
        }
        this.dockingPort.dock(dockable, perspective, "CENTER");
    }

    public void destroy() {
        this.setVisible(false);
        this.dockingPort = null;
        FloatingGroup group = this.getGroup();
        if (group != null) {
            group.setFloatingWindow(null);
        }
        this.dispose();
    }

    public String getGroupID() {
        return this.groupID;
    }

    public FloatingGroup getGroup() {
        return DockingManager.getFloatingGroup(this.getGroupID());
    }

    @Override
    public Window getOwner() {
        return SyntheticaLookAndFeel.getBoolean((String)"JYDocking.floatingFrame.forceNullOwner", (Component)this, (boolean)false) ? null : this.owner;
    }

    private static class BoundsMonitor
    implements ComponentListener {
        private BoundsMonitor() {
        }

        @Override
        public void componentHidden(ComponentEvent e) {
        }

        @Override
        public void componentMoved(ComponentEvent e) {
            this.updateBounds(e);
        }

        @Override
        public void componentResized(ComponentEvent e) {
            this.updateBounds(e);
        }

        @Override
        public void componentShown(ComponentEvent e) {
            this.updateBounds(e);
        }

        private void updateBounds(ComponentEvent evt) {
            Component c = evt.getComponent();
            if (!(c instanceof FloatingFrame)) {
                return;
            }
            FloatingFrame frame = (FloatingFrame)c;
            FloatingGroup group = frame.getGroup();
            if (group != null) {
                group.setBounds(frame.getBounds());
            }
        }
    }
}

