/*
 * Decompiled with CFR 0.152.
 */
package de.javasoft.docking.controls;

import de.javasoft.docking.controls.CompoundEmptyBorder;
import java.awt.Insets;
import javax.swing.border.Border;

class InsetBorder
extends CompoundEmptyBorder {
    private static final long serialVersionUID = 1883131101601701921L;
    private boolean leftPlacement;
    private boolean rightPlacement;
    private boolean bottomPlacement;

    protected InsetBorder(Border outer, Border inner, boolean emptyInner) {
        super(outer, inner, emptyInner);
    }

    public static InsetBorder createBorder(Border border, boolean inner) {
        return InsetBorder.createBorder(border, inner, null);
    }

    public static InsetBorder createBorder(Border border, boolean inner, Insets base) {
        if (base == null) {
            base = new Insets(0, 0, 0, 0);
        }
        CompoundEmptyBorder.MutableEmptyBorder empty = new CompoundEmptyBorder.MutableEmptyBorder(base.top, base.left, base.bottom, base.right);
        if (inner) {
            return new InsetBorder(border, empty, inner);
        }
        return new InsetBorder(empty, border, inner);
    }

    public void togglePlacement(int placement, boolean on) {
        switch (placement) {
            case 2: {
                this.leftPlacement = on;
                break;
            }
            case 4: {
                this.rightPlacement = on;
                break;
            }
            case 3: {
                this.bottomPlacement = on;
            }
        }
    }

    public boolean isBottomPlacement() {
        return this.bottomPlacement;
    }

    public void setBottomPlacement(boolean bottomPlacement) {
        this.bottomPlacement = bottomPlacement;
    }

    public boolean isLeftPlacement() {
        return this.leftPlacement;
    }

    public void setLeftPlacement(boolean leftPlacement) {
        this.leftPlacement = leftPlacement;
    }

    public boolean isRightPlacement() {
        return this.rightPlacement;
    }

    public void setRightPlacement(boolean rightPlacement) {
        this.rightPlacement = rightPlacement;
    }

    void clearPlacements() {
        this.setLeftPlacement(false);
        this.setRightPlacement(false);
        this.setBottomPlacement(false);
    }

    @Override
    public boolean setEmptyInsets(int top, int left, int bottom, int right) {
        left = this.isLeftPlacement() ? left : 0;
        right = this.isRightPlacement() ? right : 0;
        bottom = this.isBottomPlacement() ? bottom : 0;
        return super.setEmptyInsets(top, left, bottom, right);
    }
}

