/*
 * Decompiled with CFR 0.152.
 */
package de.javasoft.docking.controls;

import de.javasoft.docking.controls.ActiveDockableTracker;
import de.javasoft.docking.controls.DockingManager;
import de.javasoft.docking.controls.DockingPath;
import de.javasoft.docking.controls.DockingPortTracker;
import de.javasoft.docking.controls.DockingState;
import de.javasoft.docking.controls.DockingUtility;
import de.javasoft.docking.controls.IDockable;
import de.javasoft.docking.controls.IDockingPort;
import de.javasoft.docking.controls.NestedComponents;
import de.javasoft.docking.controls.Perspective;
import de.javasoft.docking.controls.RootWindow;
import de.javasoft.tabpane.JYTabbedPane;
import java.awt.Component;
import java.awt.Container;
import java.awt.EventQueue;
import java.awt.Point;
import java.awt.Window;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.SwingUtilities;

class RestorationManager {
    private static final String[] REGIONS = new String[]{"CENTER", "WEST", "EAST", "SOUTH", "NORTH"};
    private static final RestorationManager INSTANCE = new RestorationManager();

    private RestorationManager() {
    }

    public static RestorationManager getInstance() {
        return INSTANCE;
    }

    public boolean restore(IDockable dockable, Perspective perspective) {
        DockingState state = perspective.getDockingState(dockable, true);
        if (this.restoreMaximized(dockable, perspective, state)) {
            return true;
        }
        if (this.restoreAlreadyRestored(dockable, perspective, state)) {
            return true;
        }
        if (this.restoreMinimized(dockable, perspective, state)) {
            return true;
        }
        if (this.restoreFloating(dockable, perspective, state)) {
            return true;
        }
        if (this.restoreRelative(dockable, perspective, state)) {
            return true;
        }
        if (this.restoreDockingPath(dockable, perspective, state)) {
            return true;
        }
        if (this.restorePoint(dockable, perspective, state)) {
            return true;
        }
        return this.restoreUnknownState(dockable, perspective, state);
    }

    private boolean restoreAlreadyRestored(IDockable dockable, Perspective perspective, DockingState dockingState) {
        if (!DockingManager.isDocked(dockable)) {
            return false;
        }
        ActiveDockableTracker.requestDockableActivation(dockable.getComponent(), false);
        this.focus(dockable.getComponent());
        return true;
    }

    private void focus(final Component c) {
        RootWindow rootWindow = RootWindow.getRootWindow(c);
        if (rootWindow == null) {
            return;
        }
        Window window = rootWindow.getWindow();
        Component comp = c;
        Container parent = comp.getParent();
        while (parent != window) {
            if (parent instanceof JTabbedPane && ((JTabbedPane)parent).indexOfComponent(comp) > 0) {
                ((JTabbedPane)parent).setSelectedComponent(comp);
            } else if (parent.getParent() instanceof JYTabbedPane && ((JTabbedPane)parent.getParent()).indexOfComponent(comp) > 0) {
                ((JTabbedPane)parent.getParent()).setSelectedComponent(comp);
            }
            comp = parent;
            parent = comp.getParent();
        }
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                c.requestFocus();
            }
        });
    }

    private boolean restoreDockingPath(IDockable dockable, Perspective perspective, DockingState dockingState) {
        DockingPath dockingPath = dockingState.getPath();
        return dockingPath == null ? false : dockingPath.restore(dockable, perspective);
    }

    private boolean restoreFloating(IDockable dockable, Perspective perspective, DockingState dockingState) {
        if (dockingState == null || !dockingState.isFloating()) {
            return false;
        }
        Window owner = this.getRestoreWindow(dockable);
        if (owner == null) {
            return false;
        }
        Window w = DockingManager.floatDockable(dockable, owner, perspective);
        return w != null;
    }

    private boolean restoreMaximized(IDockable dockable, Perspective perspective, DockingState dockingState) {
        if (dockingState == null || !dockingState.isMaximized()) {
            return false;
        }
        IDockingPort rootPort = DockingManager.getRootDockingPort(dockable.getComponent());
        if (rootPort == null) {
            return false;
        }
        rootPort.uninstallMaximizedDockable();
        DockingManager.returnFromMaximization(rootPort);
        DockingManager.removeMaximizedState(rootPort);
        return DockingManager.isMaximized(dockable);
    }

    private boolean restoreMinimized(IDockable dockable, Perspective perspective, DockingState dockingState) {
        if (dockingState == null || !dockingState.isMinimized()) {
            return false;
        }
        DockingPath dockingPath = dockingState.getPath();
        return dockingPath == null ? false : dockingPath.restore(dockable, perspective);
    }

    private boolean restorePoint(IDockable dockable, Perspective perspective, DockingState dockingState) {
        if (DockingManager.isDocked(dockable) || !dockingState.hasCenterPoint()) {
            return false;
        }
        RootWindow rw = RootWindow.getRootWindow(this.getRestoreWindow(dockable));
        Container contentPane = rw.getContentPane();
        float percentX = (float)dockingState.getCenterX() / 100.0f;
        float percentY = (float)dockingState.getCenterY() / 100.0f;
        Point dropPoint = new Point();
        dropPoint.x = Math.round((float)contentPane.getWidth() * percentX);
        dropPoint.y = Math.round((float)contentPane.getHeight() * percentY);
        Component deep = SwingUtilities.getDeepestComponentAt(contentPane, dropPoint.x, dropPoint.y);
        NestedComponents dropTargets = NestedComponents.find(deep, IDockable.class, IDockingPort.class);
        IDockingPort port = dropTargets == null ? null : (IDockingPort)((Object)dropTargets.parent);
        Point mousePoint = port == null ? null : SwingUtilities.convertPoint(contentPane, dropPoint, port.getComponent());
        String region = port == null ? "UNKNOWN" : port.getRegion(mousePoint);
        return DockingManager.dock(dockable, port, perspective, region);
    }

    private boolean restoreRelative(IDockable dockable, Perspective perspective, DockingState dockingState) {
        IDockable parent;
        IDockable iDockable = parent = dockingState == null ? null : DockingManager.getDockable(dockingState.getRelativeParentID());
        if (!DockingManager.isDocked(parent)) {
            return false;
        }
        DockingState parentDockingState = DockingManager.getPerspectiveManager().getCurrentPerspective().getDockingState(parent, false);
        if (parentDockingState == null || parentDockingState.isFloating() || parentDockingState.isMinimized()) {
            return false;
        }
        float splitRatio = dockingState.getSplitRatio();
        String dockingRegion = dockingState.getRegion();
        boolean dockingOperationResult = DockingManager.dockRelative(dockable, parent, perspective, dockingRegion, splitRatio);
        if (dockingOperationResult) {
            DockingUtility.setSplitProportion(dockable, splitRatio);
        }
        return dockingOperationResult;
    }

    private boolean restoreUnknownState(IDockable dockable, Perspective perspective, DockingState dockingState) {
        IDockingPort port = DockingPortTracker.getRootDockingPort(null, false);
        if (port == null) {
            return false;
        }
        if (port.getDockedComponent() == null) {
            return this.dock(dockable, null, port, perspective);
        }
        DockingInfo dockingInfo = this.getDeepestWest(port);
        if (dockingInfo.dockable == null) {
            return this.dock(dockable, null, dockingInfo.port, perspective);
        }
        return this.dock(dockable, dockingInfo.dockable, null, perspective);
    }

    private DockingInfo getDeepestWest(IDockingPort port) {
        Component comp = port.getDockedComponent();
        if (comp instanceof JTabbedPane) {
            IDockable d = port.getDockable("CENTER");
            return new DockingInfo(d, port);
        }
        if (comp instanceof JSplitPane && (comp = ((JSplitPane)comp).getLeftComponent()) instanceof IDockingPort) {
            return this.getDeepestWest((IDockingPort)((Object)comp));
        }
        return new DockingInfo(DockingManager.getDockable(comp), port);
    }

    private boolean dock(IDockable dockable, IDockable parent, IDockingPort port, Perspective perspective) {
        boolean ret = false;
        int i = 0;
        while (i < REGIONS.length) {
            ret = parent == null ? DockingManager.dock(dockable, port, perspective, REGIONS[i]) : DockingManager.dock(dockable, parent, perspective, REGIONS[i], -1.0f);
            if (ret) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private Window getRestoreWindow(IDockable dockable) {
        RootWindow rw = RootWindow.getRootWindow(dockable.getComponent());
        return rw != null ? rw.getWindow() : RootWindow.getMainWindow();
    }

    private static class DockingInfo {
        private IDockable dockable;
        private IDockingPort port;

        private DockingInfo(IDockable d, IDockingPort p) {
            this.dockable = d;
            this.port = p;
        }
    }
}

