/*
 * Decompiled with CFR 0.152.
 */
package de.javasoft.docking.controls;

import de.javasoft.docking.controls.Dockbar;
import de.javasoft.docking.controls.DockbarLabel;
import de.javasoft.docking.controls.DockbarManager;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import javax.swing.BoxLayout;
import javax.swing.JComponent;
import javax.swing.JPanel;

class StatusDockbar
extends Dockbar {
    private static final long serialVersionUID = -2752314768495082584L;
    private JPanel labelPanel = new JPanel();
    private JComponent statusBarComponent;

    public StatusDockbar(DockbarManager manager, int placement) {
        super(manager, placement);
        this.setLayout(new BorderLayout());
        this.setPlacement(placement);
        super.add(this.labelPanel);
    }

    public void setStatusBarComponent(JComponent c) {
        this.statusBarComponent = c;
        this.add((Component)this.statusBarComponent, "South");
    }

    public JComponent getStatusBarComponent() {
        return this.statusBarComponent;
    }

    @Override
    public Component add(Component c) {
        return this.labelPanel.add(c);
    }

    @Override
    public void remove(Component comp) {
        this.labelPanel.remove(comp);
    }

    private void setPlacement(int placement) {
        int oldValue = this.placement;
        this.placement = placement;
        int boxConstraint = placement == 1 || placement == 3 ? 2 : 3;
        this.labelPanel.setLayout(new BoxLayout(this.labelPanel, boxConstraint));
        this.firePropertyChange("placement", oldValue, placement);
    }

    @Override
    public Dimension getPreferredSize() {
        if (this.statusBarComponent == null || this.statusBarComponent.getComponentCount() == 0) {
            Dimension dim = new Dimension();
            if (this.dockbarLabels.size() > 0) {
                dim = super.getPreferredSize();
            }
            return dim;
        }
        if (this.labelPanel.getComponentCount() == 0) {
            return this.statusBarComponent.getPreferredSize();
        }
        DockbarLabel label = (DockbarLabel)((Object)this.labelPanel.getComponent(0));
        return new Dimension(label.getPreferredSize().width + this.statusBarComponent.getPreferredSize().width, label.getPreferredSize().height + this.statusBarComponent.getPreferredSize().height);
    }

    @Override
    public void updateUI() {
        super.updateUI();
        if (DockbarManager.getCurrent() != null) {
            DockbarManager.getCurrent().revalidate();
            this.repaint();
        }
    }
}

