/*
 * Decompiled with CFR 0.152.
 */
package de.javasoft.docking.controls;

import de.javasoft.docking.controls.DockingManager;
import de.javasoft.docking.controls.DockingPath;
import de.javasoft.docking.controls.DockingState;
import de.javasoft.docking.controls.FloatingGroup;
import de.javasoft.docking.controls.IDockable;
import de.javasoft.docking.controls.ILayoutNode;
import de.javasoft.docking.controls.IPerspectiveManager;
import de.javasoft.docking.controls.Perspective;
import de.javasoft.docking.controls.PerspectiveManager;
import de.javasoft.docking.controls.PerspectiveModel;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.tree.MutableTreeNode;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

class XMLPersister {
    private static final String PERSPECTIVES_ELEMENT_NAME = "Perspectives";
    private static final String PERSPECTIVES_ATTRIBUTE_CURRENT_PERSPECTIVE_ID = "currentPerspectiveId";
    private static final String PERSPECTIVES_ATTRIBUTE_DEFAULT_PERSPECTIVE_ID = "defaultPerspectiveId";
    private static final String PERSPECTIVE_ELEMENT_NAME = "Perspective";
    private static final String PERSPECTIVE_ATTRIBUTE_ID = "id";
    private static final String PERSPECTIVE_ATTRIBUTE_NAME = "name";
    private static final String MODEL_ELEMENT_NAME = "Model";
    private static final String FLOATING_GROUP_ELEMENT_NAME = "FloatingGroup";
    private static final String FLOATING_GROUP_ATTRIBUTE_ID = "id";
    private static final String RECTANGLE_ELEMENT_NAME = "Rectangle";
    private static final String POINT_ELEMENT_NAME = "Point";
    private static final String POINT_ATTRIBUTE_X = "x";
    private static final String POINT_ATTRIBUTE_Y = "y";
    private static final String DIMENSION_ELEMENT_NAME = "Dimension";
    private static final String DIMENSION_ATTRIBUTE_WIDTH = "width";
    private static final String DIMENSION_ATTRIBUTE_HEIGHT = "height";
    private static final String DOCKING_STATE_ELEMENT_NAME = "DockingState";
    private static final String DOCKING_STATE_ATTRIBUTE_STATE = "state";
    private static final String DOCKING_STATE_ATTRIBUTE_SPLIT_RATIO = "splitRatio";
    private static final String DOCKING_STATE_ATTRIBUTE_PLACEMENT = "placement";
    private static final String DOCKING_STATE_ATTRIBUTE_DOCKABLE_ID = "dockableId";
    private static final String DOCKING_STATE_ATTRIBUTE_RELATIVE_PARENT_ID = "relativeParentId";
    private static final String DOCKING_STATE_ATTRIBUTE_REGION = "dockingRegion";
    private static final String DOCKING_STATE_ATTRIBUTE_FLOATING_GROUP_ID = "floatingGroupId";
    private static final String DOCKING_STATE_ATTRIBUTE_ACTIVE = "active";
    private static final String DOCKING_STATE_ATTRIBUTE_SELECTED = "selected";
    private static final String DOCKING_PATH_ELEMENT_NAME = "DockingPath";
    private static final String DOCKING_PATH_ATTRIBUTE_ROOT_PORT_ID = "rootPortId";
    private static final String DOCKING_PATH_ATTRIBUTE_SIBLING_ID = "siblingId";
    private static final String FLOATING_RESTORE_PATH_ELEMENT_NAME = "FloatingRestorePath";
    private static final String SPLIT_NODE_ELEMENT_NAME = "SplitNode";
    private static final String SPLIT_NODE_ATTRIBUTE_ORIENTATION = "orientation";
    private static final String SPLIT_NODE_ATTRIBUTE_REGION = "region";
    private static final String SPLIT_NODE_ATTRIBUTE_PERCENTAGE = "percentage";
    private static final String SPLIT_NODE_ATTRIBUTE_SIBLING_ID = "siblingId";
    private static final String SPLIT_NODE_ATTRIBUTE_DOCKING_REGION = "dockingRegion";
    private static final String DOCKABLE_SEQUENCE_ELEMENT_NAME = "DockableSequence";
    private static final String DOCKABLE_NODE_ELEMENT_NAME = "DockableNode";
    private static final String DOCKABLE_NODE_ATTRIBUTE_DOCKABLE_ID = "dockableId";
    private static final String DOCKING_PORT_NODE_ELEMENT_NAME = "DockingPortNode";
    private static final String DOCKABLE_ELEMENT_NAME = "Dockable";
    private static final String DOCKABLE_ATTRIBUTE_ID = "id";
    private static final String OPENED_STATE = "opened";
    private static final String MINIMIZED_STATE = "minimized";
    private static final String MAXIMIZED_STATE = "maximized";
    private static final String FLOATING_STATE = "floating";
    private IPerspectiveManager pm;
    private InputStream inputStream;
    private OutputStream outputStream;

    public XMLPersister(IPerspectiveManager pm) {
        this.pm = pm;
    }

    public void setInputStream(InputStream inputStream) {
        this.inputStream = inputStream;
    }

    public InputStream getInputStream() {
        return this.inputStream;
    }

    public void setOutputStream(OutputStream outputStream) {
        this.outputStream = outputStream;
    }

    public OutputStream getOutputStream() {
        return this.outputStream;
    }

    public void store() throws IOException {
        this.store(this.getOutputStream());
    }

    private void store(OutputStream os) throws IOException {
        if (os == null) {
            throw new IllegalArgumentException("OutputStream cannot be null!");
        }
        DocumentBuilder documentBuilder = this.createDocumentBuilder();
        Document document = documentBuilder.newDocument();
        Element perspectivesElement = this.serializePerspectives(document, this.pm);
        document.appendChild(perspectivesElement);
        TransformerFactory transformerFactory = TransformerFactory.newInstance();
        try {
            transformerFactory.setAttribute("indent-number", 4);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            try {
                Transformer transformer = transformerFactory.newTransformer();
                transformer.setOutputProperty("indent", "yes");
                DOMSource source = new DOMSource(document);
                StreamResult result = new StreamResult(new OutputStreamWriter(os));
                transformer.transform(source, result);
            }
            catch (TransformerConfigurationException e) {
                throw new IOException("Unable to serialize perspectives to XML", e);
            }
            catch (TransformerException e) {
                throw new IOException("Unable to serialize perspectives to XML", e);
            }
        }
        finally {
            os.close();
        }
    }

    public void store(Window mainWindow, Window floatingWindow, OutputStream os) throws IOException {
        DocumentBuilder documentBuilder = this.createDocumentBuilder();
        Document document = documentBuilder.newDocument();
        Element perspectivesElement = this.serializeCurrentPerspective(document, mainWindow, floatingWindow);
        document.appendChild(perspectivesElement);
        TransformerFactory transformerFactory = TransformerFactory.newInstance();
        try {
            transformerFactory.setAttribute("indent-number", 4);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            Transformer transformer = transformerFactory.newTransformer();
            transformer.setOutputProperty("indent", "yes");
            DOMSource source = new DOMSource(document);
            StreamResult result = new StreamResult(new OutputStreamWriter(os));
            transformer.transform(source, result);
        }
        catch (TransformerConfigurationException e) {
            throw new IOException("Unable to serialize perspectives to XML", e);
        }
        catch (TransformerException e) {
            throw new IOException("Unable to serialize perspectives to XML", e);
        }
    }

    public void load() throws IOException {
        this.load(this.getInputStream(), false);
    }

    void load(InputStream is, boolean importModel) throws IOException {
        if (is == null) {
            throw new IllegalArgumentException("InputStream cannot be null!");
        }
        try {
            try {
                InputSource inputSource = new InputSource(is);
                DocumentBuilder documentBuilder = this.createDocumentBuilder();
                Document document = documentBuilder.parse(inputSource);
                NodeList perspectivesNodeList = document.getElementsByTagName(PERSPECTIVES_ELEMENT_NAME);
                if (perspectivesNodeList.getLength() > 0 && perspectivesNodeList.item(0) instanceof Element) {
                    Element perspectivesElement = (Element)perspectivesNodeList.item(0);
                    this.deserializePerspectives(perspectivesElement, importModel);
                }
            }
            catch (SAXException e) {
                throw new IOException("Unable to deserialize perspectives from XML", e);
            }
        }
        finally {
            is.close();
        }
    }

    private DocumentBuilder createDocumentBuilder() throws IOException {
        try {
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            return documentBuilder;
        }
        catch (ParserConfigurationException e) {
            throw new IOException("Unable to create document builder", e);
        }
    }

    private Element serializePerspectives(Document document, Object object) {
        Element perspectivesElement = document.createElement(PERSPECTIVES_ELEMENT_NAME);
        perspectivesElement.setAttribute(PERSPECTIVES_ATTRIBUTE_CURRENT_PERSPECTIVE_ID, PerspectiveManager.getCurrentPerspectiveID());
        perspectivesElement.setAttribute(PERSPECTIVES_ATTRIBUTE_DEFAULT_PERSPECTIVE_ID, PerspectiveManager.getDefaultPerspectiveID());
        ArrayList<Perspective> perspectives = new ArrayList<Perspective>();
        for (Perspective perspective : this.pm.getPerspectives()) {
            perspectives.add((Perspective)perspective.clone());
        }
        for (Perspective perspective : perspectives) {
            Element perspectiveElement = this.serializePerspective(document, perspective, null, null);
            perspectivesElement.appendChild(perspectiveElement);
        }
        return perspectivesElement;
    }

    private Element serializeCurrentPerspective(Document document, Window mainWindow, Window floatingWindow) {
        Element perspectivesElement = document.createElement(PERSPECTIVES_ELEMENT_NAME);
        perspectivesElement.setAttribute(PERSPECTIVES_ATTRIBUTE_CURRENT_PERSPECTIVE_ID, PerspectiveManager.getCurrentPerspectiveID());
        perspectivesElement.setAttribute(PERSPECTIVES_ATTRIBUTE_DEFAULT_PERSPECTIVE_ID, PerspectiveManager.getDefaultPerspectiveID());
        Element perspectiveElement = this.serializePerspective(document, this.pm.getCurrentPerspective(), mainWindow, floatingWindow);
        perspectivesElement.appendChild(perspectiveElement);
        return perspectivesElement;
    }

    private Object deserializePerspectives(Element element, boolean importModel) {
        String currentPerspectiveId = element.getAttribute(PERSPECTIVES_ATTRIBUTE_CURRENT_PERSPECTIVE_ID);
        String defaultPerspectiveId = element.getAttribute(PERSPECTIVES_ATTRIBUTE_DEFAULT_PERSPECTIVE_ID);
        NodeList perspectiveList = element.getElementsByTagName(PERSPECTIVE_ELEMENT_NAME);
        ArrayList<Perspective> perspectives = new ArrayList<Perspective>();
        int i = 0;
        while (i < perspectiveList.getLength()) {
            Node node = perspectiveList.item(i);
            if (node instanceof Element) {
                Element perspectiveElement = (Element)node;
                Perspective perspective = (Perspective)this.deserializePerspective(perspectiveElement, importModel);
                perspectives.add(perspective);
            }
            ++i;
        }
        PerspectiveManager.setDefaultPerspectiveID(defaultPerspectiveId);
        PerspectiveManager.setCurrentPerspectiveID(currentPerspectiveId);
        PerspectiveManager.setPerspectives(perspectives.toArray(new Perspective[perspectives.size()]));
        return this.pm;
    }

    private Element serializePerspective(Document document, Object object, Window mainWindow, Window floatingWindow) {
        Perspective perspective = (Perspective)object;
        Element perspectiveElement = document.createElement(PERSPECTIVE_ELEMENT_NAME);
        perspectiveElement.setAttribute("id", perspective.getID());
        perspectiveElement.setAttribute(PERSPECTIVE_ATTRIBUTE_NAME, perspective.getName());
        Element modelElement = this.serializeModel(document, perspective.getModel(), mainWindow, floatingWindow);
        perspectiveElement.appendChild(modelElement);
        return perspectiveElement;
    }

    private Object deserializePerspective(Element element, boolean importModel) {
        String perspectiveId = element.getAttribute("id");
        String perspectiveName = element.getAttribute(PERSPECTIVE_ATTRIBUTE_NAME);
        Perspective perspective = importModel ? DockingManager.getPerspectiveManager().getCurrentPerspective() : new Perspective(perspectiveId, perspectiveName);
        NodeList modelNodeList = element.getElementsByTagName(MODEL_ELEMENT_NAME);
        if (modelNodeList.getLength() > 0 && modelNodeList.item(0) instanceof Element) {
            Element layoutElement = (Element)modelNodeList.item(0);
            PerspectiveModel m_ = (PerspectiveModel)this.deserializeModel(layoutElement);
            if (!importModel) {
                perspective.setModel(m_);
            } else {
                PerspectiveModel m = perspective.getModel();
                Object[] objectArray = m_.getDockables();
                int n = objectArray.length;
                int n2 = 0;
                while (n2 < n) {
                    IDockable d = objectArray[n2];
                    m.setDockingState(d.getID(), m_.getDockingState(d, false));
                    ++n2;
                }
                objectArray = m_.getFloatingGroupIDs();
                n = objectArray.length;
                n2 = 0;
                while (n2 < n) {
                    Object groupID = objectArray[n2];
                    m.addFloatingGroup(m_.getFloatingGroup((String)groupID));
                    ++n2;
                }
            }
        }
        return perspective;
    }

    private Element serializeModel(Document document, Object object, Window mainWindow, Window floatingWindow) {
        ILayoutNode layoutNode;
        Object dockingStateElement;
        PerspectiveModel model = (PerspectiveModel)object;
        Element modelElement = document.createElement(MODEL_ELEMENT_NAME);
        IDockable[] dockables = model.getDockables();
        int i = 0;
        while (i < dockables.length) {
            IDockable dockable = dockables[i];
            DockingState dockingState = model.getDockingState(dockable, false);
            if (!(mainWindow != null && dockingState.isFloating() || floatingWindow != null && !dockingState.isFloating())) {
                dockingStateElement = this.serializeDockingState(document, dockingState);
                modelElement.appendChild((Node)dockingStateElement);
            }
            ++i;
        }
        if (mainWindow == null) {
            dockingStateElement = model.getFloatingGroupIDs();
            int dockingState = ((String[])dockingStateElement).length;
            int dockable = 0;
            while (dockable < dockingState) {
                String groupId = dockingStateElement[dockable];
                FloatingGroup floatingGroup = model.getGroup(groupId);
                if (floatingWindow == null || floatingGroup.getFloatingWindow() == floatingWindow) {
                    Element floatingGroupElement = this.serializeFloatingGroup(document, floatingGroup);
                    modelElement.appendChild(floatingGroupElement);
                }
                ++dockable;
            }
        }
        if ((layoutNode = model.getRestorationLayout()) != null) {
            Element layoutNodeElement = this.serializeLayoutNode(document, layoutNode);
            modelElement.appendChild(layoutNodeElement);
        }
        Element dockableSequenceElement = document.createElement(DOCKABLE_SEQUENCE_ELEMENT_NAME);
        List<DockingState> dockableSequence = model.getDockableSequence();
        int i2 = 0;
        while (i2 < dockableSequence.size()) {
            DockingState dockingState = dockableSequence.get(i2);
            Element dockingStateElement2 = this.serializeDockingState(document, dockingState);
            dockableSequenceElement.appendChild(dockingStateElement2);
            ++i2;
        }
        modelElement.appendChild(dockableSequenceElement);
        return modelElement;
    }

    private Object deserializeModel(Element element) {
        PerspectiveModel model = new PerspectiveModel();
        NodeList childs = element.getChildNodes();
        int i = 0;
        while (i < childs.getLength()) {
            if (childs.item(i) instanceof Element) {
                Element e = (Element)childs.item(i);
                String name = e.getNodeName();
                if (name.equals(DOCKING_STATE_ELEMENT_NAME)) {
                    DockingState dockingState = (DockingState)this.deserializeDockingState(e);
                    String dockableID = dockingState.getDockableID();
                    model.setDockingState(dockableID, dockingState);
                } else if (name.equals(FLOATING_GROUP_ELEMENT_NAME)) {
                    FloatingGroup floatingGroup = (FloatingGroup)this.deserializeFloatingGroup(e);
                    model.addFloatingGroup(floatingGroup);
                } else if (name.equals(DOCKING_PORT_NODE_ELEMENT_NAME)) {
                    ILayoutNode restorationLayout = (ILayoutNode)this.deserializeLayoutNode(e);
                    model.setRestorationLayout(restorationLayout);
                } else if (name.equals(DOCKABLE_SEQUENCE_ELEMENT_NAME)) {
                    ArrayList<DockingState> dockableSequence = new ArrayList<DockingState>();
                    NodeList dockingStateNodeList = e.getElementsByTagName(DOCKING_STATE_ELEMENT_NAME);
                    int j = 0;
                    while (j < dockingStateNodeList.getLength()) {
                        Node dockingStateNode = dockingStateNodeList.item(j);
                        if (dockingStateNode instanceof Element) {
                            Element dockingStateElement = (Element)dockingStateNode;
                            DockingState dockingState = (DockingState)this.deserializeDockingState(dockingStateElement);
                            dockableSequence.add(dockingState);
                        }
                        ++j;
                    }
                    model.setDockableSequence(dockableSequence);
                }
            }
            ++i;
        }
        return model;
    }

    private Element serializeDockingState(Document document, Object object) {
        Element dockingPathElement;
        DockingState dockingState = (DockingState)object;
        Element dockingStateElement = document.createElement(DOCKING_STATE_ELEMENT_NAME);
        dockingStateElement.setAttribute("dockableId", dockingState.getDockableID());
        if (dockingState.getRelativeParentID() != null && !dockingState.getRelativeParentID().equals("")) {
            dockingStateElement.setAttribute(DOCKING_STATE_ATTRIBUTE_RELATIVE_PARENT_ID, dockingState.getRelativeParentID());
        }
        dockingStateElement.setAttribute("dockingRegion", dockingState.getRegion().toLowerCase());
        if (dockingState.getSplitRatio() != -1.0f) {
            dockingStateElement.setAttribute(DOCKING_STATE_ATTRIBUTE_SPLIT_RATIO, String.valueOf(dockingState.getSplitRatio()));
        }
        if (dockingState.isMinimized()) {
            dockingStateElement.setAttribute(DOCKING_STATE_ATTRIBUTE_STATE, MINIMIZED_STATE);
        } else if (dockingState.isMaximized()) {
            dockingStateElement.setAttribute(DOCKING_STATE_ATTRIBUTE_STATE, MAXIMIZED_STATE);
        } else if (dockingState.isFloating()) {
            dockingStateElement.setAttribute(DOCKING_STATE_ATTRIBUTE_STATE, FLOATING_STATE);
        } else {
            dockingStateElement.setAttribute(DOCKING_STATE_ATTRIBUTE_STATE, OPENED_STATE);
        }
        if (dockingState.isActive()) {
            dockingStateElement.setAttribute(DOCKING_STATE_ATTRIBUTE_ACTIVE, "true");
        }
        if (dockingState.isSelected()) {
            dockingStateElement.setAttribute(DOCKING_STATE_ATTRIBUTE_SELECTED, "true");
        }
        if (dockingState.isFloating()) {
            dockingStateElement.setAttribute(DOCKING_STATE_ATTRIBUTE_FLOATING_GROUP_ID, dockingState.getFloatingGroupID());
        }
        if (dockingState.isMinimized()) {
            String placementString = null;
            int placement = dockingState.getPlacement();
            switch (placement) {
                case 2: {
                    placementString = "left";
                    break;
                }
                case 3: {
                    placementString = "bottom";
                    break;
                }
                case 4: {
                    placementString = "right";
                    break;
                }
                case 1: {
                    placementString = "top";
                    break;
                }
                case -1: {
                    placementString = "unspecified";
                    break;
                }
                default: {
                    throw new RuntimeException("Unknown dockbar placement");
                }
            }
            dockingStateElement.setAttribute(DOCKING_STATE_ATTRIBUTE_PLACEMENT, placementString);
        }
        if (dockingState.hasCenterPoint()) {
            Element pointElement = this.serializePoint(document, dockingState.getCenterPoint());
            dockingStateElement.appendChild(pointElement);
        }
        if (dockingState.hasDockingPath()) {
            dockingPathElement = this.serializeDockingPath(document, dockingState.getPath());
            dockingStateElement.appendChild(dockingPathElement);
        }
        if (dockingState.hasFloatingRestorePath()) {
            dockingPathElement = this.serializeFloatingRestorePath(document, dockingState.getFloatingRestorePath());
            dockingStateElement.appendChild(dockingPathElement);
        }
        return dockingStateElement;
    }

    private Object deserializeDockingState(Element element) {
        NodeList floatingRestorePathNodeList;
        NodeList dockingPathNodeList;
        NodeList pointNodeList;
        String floatingGroupId;
        String dockingStateState;
        String selectedString;
        String activeString;
        String dockableID = element.getAttribute("dockableId");
        String relativeParentID = element.getAttribute(DOCKING_STATE_ATTRIBUTE_RELATIVE_PARENT_ID);
        String region = element.getAttribute("dockingRegion");
        DockingState dockingState = new DockingState(dockableID);
        if (relativeParentID != null && !relativeParentID.equals("")) {
            dockingState.setRelativeParentID(relativeParentID);
        }
        dockingState.setRegion(region.toUpperCase());
        String splitRatioString = element.getAttribute(DOCKING_STATE_ATTRIBUTE_SPLIT_RATIO);
        if (splitRatioString != null && !splitRatioString.equals("")) {
            float splitRatio = Float.parseFloat(splitRatioString);
            dockingState.setSplitRatio(splitRatio);
        }
        if ((activeString = element.getAttribute(DOCKING_STATE_ATTRIBUTE_ACTIVE)) != null && !activeString.equals("")) {
            boolean active = Boolean.parseBoolean(activeString);
            dockingState.setActive(active);
        }
        if ((selectedString = element.getAttribute(DOCKING_STATE_ATTRIBUTE_SELECTED)) != null && !selectedString.equals("")) {
            boolean selected = Boolean.parseBoolean(selectedString);
            dockingState.setSelected(selected);
        }
        if ((dockingStateState = element.getAttribute(DOCKING_STATE_ATTRIBUTE_STATE)).equals(FLOATING_STATE) && (floatingGroupId = element.getAttribute(DOCKING_STATE_ATTRIBUTE_FLOATING_GROUP_ID)) != null && !floatingGroupId.equals("")) {
            dockingState.setFloatingGroupID(floatingGroupId);
        }
        if (dockingStateState.equals(MINIMIZED_STATE)) {
            String placementString = element.getAttribute(DOCKING_STATE_ATTRIBUTE_PLACEMENT);
            int placement = -1;
            if (placementString.equals("left")) {
                placement = 2;
            } else if (placementString.equals("bottom")) {
                placement = 3;
            } else if (placementString.equals("right")) {
                placement = 4;
            } else if (placementString.equals("top")) {
                placement = 1;
            } else {
                throw new RuntimeException("Minimization conversion error!");
            }
            dockingState.setPlacement(placement);
            String floatingGroupId2 = element.getAttribute(DOCKING_STATE_ATTRIBUTE_FLOATING_GROUP_ID);
            if (floatingGroupId2 != null && !floatingGroupId2.equals("")) {
                dockingState.setFloatingGroupID(floatingGroupId2);
            }
        } else if (dockingStateState.equals(MAXIMIZED_STATE)) {
            dockingState.setMaximized(true);
            floatingGroupId = element.getAttribute(DOCKING_STATE_ATTRIBUTE_FLOATING_GROUP_ID);
            if (floatingGroupId != null && !floatingGroupId.equals("")) {
                dockingState.setFloatingGroupID(floatingGroupId);
            }
        }
        if ((pointNodeList = element.getElementsByTagName(POINT_ELEMENT_NAME)).getLength() > 0 && pointNodeList.item(0) instanceof Element) {
            Element centerPointElement = (Element)pointNodeList.item(0);
            Point centerPoint = (Point)this.deserializePoint(centerPointElement);
            dockingState.setCenter(centerPoint);
        }
        if ((dockingPathNodeList = element.getElementsByTagName(DOCKING_PATH_ELEMENT_NAME)).getLength() > 0 && dockingPathNodeList.item(0) instanceof Element) {
            Element dockingPathElement = (Element)dockingPathNodeList.item(0);
            DockingPath dockingPath = (DockingPath)this.deserializeDockingPath(dockingPathElement);
            dockingState.setPath(dockingPath);
        }
        if ((floatingRestorePathNodeList = element.getElementsByTagName(FLOATING_RESTORE_PATH_ELEMENT_NAME)).getLength() > 0 && floatingRestorePathNodeList.item(0) instanceof Element) {
            Element dockingPathElement = (Element)floatingRestorePathNodeList.item(0);
            DockingPath path = (DockingPath)this.deserializeFloatingRestorePath(dockingPathElement);
            dockingState.setFloatingRestorePath(path);
        }
        return dockingState;
    }

    private Element serializeFloatingGroup(Document document, Object object) {
        FloatingGroup floatingGroup = (FloatingGroup)object;
        Element floatingGroupElement = document.createElement(FLOATING_GROUP_ELEMENT_NAME);
        floatingGroupElement.setAttribute("id", floatingGroup.getID());
        Element rectangleElement = this.serializeRectangle(document, floatingGroup.getBounds());
        floatingGroupElement.appendChild(rectangleElement);
        Iterator<String> it = floatingGroup.getDockableIterator();
        while (it.hasNext()) {
            String dockableID = it.next();
            Element dockableElement = document.createElement(DOCKABLE_ELEMENT_NAME);
            dockableElement.setAttribute("id", dockableID);
            floatingGroupElement.appendChild(dockableElement);
        }
        ILayoutNode layoutNode = floatingGroup.getRestorationLayout();
        if (layoutNode != null) {
            Element layoutNodeElement = this.serializeLayoutNode(document, layoutNode);
            floatingGroupElement.appendChild(layoutNodeElement);
        }
        return floatingGroupElement;
    }

    private Object deserializeFloatingGroup(Element element) {
        Node rectangleNode;
        String floatingGroupID = element.getAttribute("id");
        FloatingGroup floatingGroup = new FloatingGroup(floatingGroupID);
        NodeList rectangleNodeList = element.getElementsByTagName(RECTANGLE_ELEMENT_NAME);
        if (rectangleNodeList.getLength() > 0 && rectangleNodeList.item(0) instanceof Element && (rectangleNode = rectangleNodeList.item(0)) instanceof Element) {
            Element rectangleElement = (Element)rectangleNode;
            Rectangle rectangle = (Rectangle)this.deserializeRectangle(rectangleElement);
            floatingGroup.setBounds(rectangle);
        }
        NodeList dockableNodeList = element.getElementsByTagName(DOCKABLE_ELEMENT_NAME);
        int i = 0;
        while (i < dockableNodeList.getLength()) {
            Node dockableNode = dockableNodeList.item(i);
            if (dockableNode instanceof Element) {
                Element dockableElement = (Element)dockableNode;
                String dockableID = dockableElement.getAttribute("id");
                floatingGroup.addDockable(dockableID);
            }
            ++i;
        }
        NodeList restorationLayouts = element.getElementsByTagName(DOCKING_PORT_NODE_ELEMENT_NAME);
        if (restorationLayouts.getLength() > 0) {
            ILayoutNode restorationLayout = (ILayoutNode)this.deserializeLayoutNode((Element)restorationLayouts.item(0));
            floatingGroup.setRestorationLayout(restorationLayout);
        }
        return floatingGroup;
    }

    private Element serializeLayoutNode(Document document, Object object) {
        if (object instanceof PerspectiveModel.DockingPortNode) {
            return this.serializeDockingPortNode(document, object);
        }
        if (object instanceof PerspectiveModel.SplitNode) {
            return this.serializeSplitNode(document, object);
        }
        if (object instanceof PerspectiveModel.DockableNode) {
            return this.serializeDockableNode(document, object);
        }
        throw new RuntimeException("Incorrect element: " + object);
    }

    private Object deserializeLayoutNode(Element element) {
        if (element.getTagName().equals(DOCKING_PORT_NODE_ELEMENT_NAME)) {
            return this.deserializeDockingPortNode(element);
        }
        if (element.getTagName().equals(SPLIT_NODE_ELEMENT_NAME)) {
            return this.deserializeSplitNode(element);
        }
        if (element.getTagName().equals(DOCKABLE_NODE_ELEMENT_NAME)) {
            return this.deserializeDockableNode(element);
        }
        throw new RuntimeException("Incorrect element: " + element);
    }

    private Element serializeDockingPortNode(Document document, Object object) {
        ILayoutNode layoutNode = (ILayoutNode)object;
        Element layoutNodeElement = document.createElement(DOCKING_PORT_NODE_ELEMENT_NAME);
        int childCount = layoutNode.getChildCount();
        int i = 0;
        while (i < childCount) {
            MutableTreeNode childTreeNode = (MutableTreeNode)layoutNode.getChildAt(i);
            Element element = this.serializeLayoutNode(document, childTreeNode);
            layoutNodeElement.appendChild(element);
            ++i;
        }
        return layoutNodeElement;
    }

    private Object deserializeDockingPortNode(Element element) {
        PerspectiveModel.DockingPortNode layoutNode = new PerspectiveModel.DockingPortNode();
        NodeList nodeList = element.getChildNodes();
        int i = 0;
        while (i < nodeList.getLength()) {
            Node node = nodeList.item(i);
            if (node instanceof Element) {
                Element childElement = (Element)node;
                ILayoutNode childLayoutNode = (ILayoutNode)this.deserializeLayoutNode(childElement);
                layoutNode.add(childLayoutNode);
            }
            ++i;
        }
        return layoutNode;
    }

    private Element serializeSplitNode(Document document, Object object) {
        PerspectiveModel.SplitNode splitNode = (PerspectiveModel.SplitNode)object;
        Element layoutNodeElement = document.createElement(SPLIT_NODE_ELEMENT_NAME);
        int childCount = splitNode.getChildCount();
        int i = 0;
        while (i < childCount) {
            MutableTreeNode childTreeNode = (MutableTreeNode)splitNode.getChildAt(i);
            Element element = this.serializeLayoutNode(document, childTreeNode);
            layoutNodeElement.appendChild(element);
            ++i;
        }
        if (splitNode.getSiblingId() != null && !"".equals(splitNode.getSiblingId())) {
            layoutNodeElement.setAttribute("siblingId", splitNode.getSiblingId());
        }
        layoutNodeElement.setAttribute(SPLIT_NODE_ATTRIBUTE_ORIENTATION, splitNode.getOrientationDesc());
        layoutNodeElement.setAttribute(SPLIT_NODE_ATTRIBUTE_REGION, splitNode.getRegionDesc());
        layoutNodeElement.setAttribute(SPLIT_NODE_ATTRIBUTE_PERCENTAGE, String.valueOf(splitNode.getSplitRatio()));
        if (splitNode.getDockingRegion() != null) {
            layoutNodeElement.setAttribute("dockingRegion", splitNode.getDockingRegion().toLowerCase());
        }
        return layoutNodeElement;
    }

    private Object deserializeSplitNode(Element element) {
        PerspectiveModel.SplitNode splitNode = new PerspectiveModel.SplitNode(-1, -1, -1.0f, null);
        NodeList nodeList = element.getChildNodes();
        int i = 0;
        while (i < nodeList.getLength()) {
            Node node = nodeList.item(i);
            if (node instanceof Element) {
                Element childElement = (Element)node;
                ILayoutNode childLayoutNode = (ILayoutNode)this.deserializeLayoutNode(childElement);
                splitNode.add(childLayoutNode);
            }
            ++i;
        }
        String siblingId = element.getAttribute("siblingId");
        String orientationString = element.getAttribute(SPLIT_NODE_ATTRIBUTE_ORIENTATION);
        String regionString = element.getAttribute(SPLIT_NODE_ATTRIBUTE_REGION);
        String percentage = element.getAttribute(SPLIT_NODE_ATTRIBUTE_PERCENTAGE);
        String dockingRegion = element.getAttribute("dockingRegion");
        int orientation = -1;
        if (orientationString.equals("vertical")) {
            orientation = 0;
        } else if (orientationString.equals("horizontal")) {
            orientation = 1;
        }
        int region = -1;
        if (regionString.equals("top")) {
            region = 1;
        } else if (regionString.equals("bottom")) {
            region = 3;
        } else if (regionString.equals("left")) {
            region = 2;
        } else if (regionString.equals("right")) {
            region = 4;
        }
        splitNode.setOrientation(orientation);
        splitNode.setRegion(region);
        splitNode.setSplitRatio(Float.parseFloat(percentage));
        if (siblingId != null && !"".equals(siblingId)) {
            splitNode.setSiblingId(siblingId);
        }
        if (dockingRegion != null && !dockingRegion.equals("")) {
            splitNode.setDockingRegion(dockingRegion.toUpperCase());
        }
        return splitNode;
    }

    private Element serializeDockableNode(Document document, Object object) {
        PerspectiveModel.DockableNode dockableNode = (PerspectiveModel.DockableNode)object;
        Element dockableNodeElement = document.createElement(DOCKABLE_NODE_ELEMENT_NAME);
        dockableNodeElement.setAttribute("dockableId", dockableNode.getDockableID());
        return dockableNodeElement;
    }

    private Object deserializeDockableNode(Element element) {
        String dockableID = element.getAttribute("dockableId");
        PerspectiveModel.DockableNode dockableNode = new PerspectiveModel.DockableNode();
        dockableNode.setDockableID(dockableID);
        return dockableNode;
    }

    private Element serializeDockingPath(Document document, Object object) {
        DockingPath dockingPath = (DockingPath)object;
        Element dockingPathElement = document.createElement(DOCKING_PATH_ELEMENT_NAME);
        dockingPathElement.setAttribute(DOCKING_PATH_ATTRIBUTE_ROOT_PORT_ID, dockingPath.getRootPortId());
        if (dockingPath.getSiblingID() != null && !dockingPath.getSiblingID().equals("")) {
            dockingPathElement.setAttribute("siblingId", dockingPath.getSiblingID());
        }
        List<PerspectiveModel.SplitNode> splitNodes = dockingPath.getNodes();
        for (PerspectiveModel.SplitNode splitNode : splitNodes) {
            Element splitNodeElement = this.serializeSplitNode(document, splitNode);
            dockingPathElement.appendChild(splitNodeElement);
        }
        return dockingPathElement;
    }

    private Object deserializeDockingPath(Element element) {
        NodeList splitNodeList;
        DockingPath dockingPath = new DockingPath();
        String dockingPathRootPortId = element.getAttribute(DOCKING_PATH_ATTRIBUTE_ROOT_PORT_ID);
        String siblingId = element.getAttribute("siblingId");
        dockingPath.setRootPortId(dockingPathRootPortId);
        if (siblingId != null && !"".equals(siblingId)) {
            dockingPath.setSiblingId(siblingId);
        }
        if ((splitNodeList = element.getElementsByTagName(SPLIT_NODE_ELEMENT_NAME)).getLength() > 0 && splitNodeList.item(0) instanceof Element) {
            Element splitNodeElement = (Element)splitNodeList.item(0);
            PerspectiveModel.SplitNode splitNode = (PerspectiveModel.SplitNode)this.deserializeLayoutNode(splitNodeElement);
            dockingPath.getNodes().add(splitNode);
        }
        return dockingPath;
    }

    private Element serializeFloatingRestorePath(Document document, Object object) {
        DockingPath dockingPath = (DockingPath)object;
        Element dockingPathElement = document.createElement(FLOATING_RESTORE_PATH_ELEMENT_NAME);
        dockingPathElement.setAttribute(DOCKING_PATH_ATTRIBUTE_ROOT_PORT_ID, dockingPath.getRootPortId());
        if (dockingPath.getSiblingID() != null && !dockingPath.getSiblingID().equals("")) {
            dockingPathElement.setAttribute("siblingId", dockingPath.getSiblingID());
        }
        List<PerspectiveModel.SplitNode> splitNodes = dockingPath.getNodes();
        for (PerspectiveModel.SplitNode splitNode : splitNodes) {
            Element splitNodeElement = this.serializeSplitNode(document, splitNode);
            dockingPathElement.appendChild(splitNodeElement);
        }
        return dockingPathElement;
    }

    private Object deserializeFloatingRestorePath(Element element) {
        NodeList splitNodeList;
        DockingPath dockingPath = new DockingPath();
        String dockingPathRootPortId = element.getAttribute(DOCKING_PATH_ATTRIBUTE_ROOT_PORT_ID);
        String siblingId = element.getAttribute("siblingId");
        dockingPath.setRootPortId(dockingPathRootPortId);
        if (siblingId != null && !"".equals(siblingId)) {
            dockingPath.setSiblingId(siblingId);
        }
        if ((splitNodeList = element.getElementsByTagName(SPLIT_NODE_ELEMENT_NAME)).getLength() > 0 && splitNodeList.item(0) instanceof Element) {
            Element splitNodeElement = (Element)splitNodeList.item(0);
            PerspectiveModel.SplitNode splitNode = (PerspectiveModel.SplitNode)this.deserializeLayoutNode(splitNodeElement);
            dockingPath.getNodes().add(splitNode);
        }
        return dockingPath;
    }

    private Element serializeRectangle(Document document, Object object) {
        Rectangle rectangle = (Rectangle)object;
        Element rectangleElement = document.createElement(RECTANGLE_ELEMENT_NAME);
        Element pointElement = this.serializePoint(document, rectangle.getLocation());
        Element dimensionElement = this.serializeDimension(document, rectangle.getSize());
        rectangleElement.appendChild(pointElement);
        rectangleElement.appendChild(dimensionElement);
        return rectangleElement;
    }

    private Object deserializeRectangle(Element element) {
        NodeList pointNodeList;
        Rectangle rectangle = new Rectangle();
        NodeList dimenstionNodeList = element.getElementsByTagName(DIMENSION_ELEMENT_NAME);
        if (dimenstionNodeList.getLength() > 0 && dimenstionNodeList.item(0) instanceof Element) {
            Element dimensionElement = (Element)dimenstionNodeList.item(0);
            Dimension dimension = (Dimension)this.deserializeDimension(dimensionElement);
            rectangle.setSize(dimension);
        }
        if ((pointNodeList = element.getElementsByTagName(POINT_ELEMENT_NAME)).getLength() > 0 && pointNodeList.item(0) instanceof Element) {
            Element pointElement = (Element)pointNodeList.item(0);
            Point point = (Point)this.deserializePoint(pointElement);
            rectangle.setLocation(point);
        }
        return rectangle;
    }

    private Element serializeDimension(Document document, Object object) {
        Dimension dimension = (Dimension)object;
        Element dimensionElement = document.createElement(DIMENSION_ELEMENT_NAME);
        dimensionElement.setAttribute(DIMENSION_ATTRIBUTE_HEIGHT, String.valueOf(dimension.height));
        dimensionElement.setAttribute(DIMENSION_ATTRIBUTE_WIDTH, String.valueOf(dimension.width));
        return dimensionElement;
    }

    private Object deserializeDimension(Element element) {
        String width = element.getAttribute(DIMENSION_ATTRIBUTE_WIDTH);
        String height = element.getAttribute(DIMENSION_ATTRIBUTE_HEIGHT);
        return new Dimension(Integer.parseInt(width), Integer.parseInt(height));
    }

    private Element serializePoint(Document document, Object object) {
        Point point = (Point)object;
        Element pointElement = document.createElement(POINT_ELEMENT_NAME);
        pointElement.setAttribute(POINT_ATTRIBUTE_X, String.valueOf(point.x));
        pointElement.setAttribute(POINT_ATTRIBUTE_Y, String.valueOf(point.y));
        return pointElement;
    }

    private Object deserializePoint(Element element) {
        String xString = element.getAttribute(POINT_ATTRIBUTE_X);
        String yString = element.getAttribute(POINT_ATTRIBUTE_Y);
        return new Point(Integer.parseInt(xString), Integer.parseInt(yString));
    }
}

