/*
 * Decompiled with CFR 0.152.
 */
package de.javasoft.docking.ui;

import de.javasoft.docking.controls.Dockbar;
import de.javasoft.docking.ui.BasicDockingPainter;
import de.javasoft.docking.ui.DockbarUI;
import de.javasoft.plaf.synthetica.SyntheticaLookAndFeel;
import de.javasoft.plaf.synthetica.SyntheticaState;
import de.javasoft.widgets.util.WidgetUtils;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Insets;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JComponent;
import javax.swing.plaf.ComponentUI;

public class BasicDockbarUI
extends DockbarUI
implements PropertyChangeListener {
    protected Dockbar dockbar;

    public static ComponentUI createUI(JComponent c) {
        return new BasicDockbarUI();
    }

    @Override
    public void installUI(JComponent c) {
        this.dockbar = (Dockbar)c;
        super.installUI(c);
        this.installDefaults();
        this.installListener();
    }

    @Override
    public void uninstallUI(JComponent c) {
        super.uninstallUI(c);
        this.uninstallDefaults();
        this.uninstallListener();
    }

    protected void installDefaults() {
        this.updateDefaults();
    }

    protected void uninstallDefaults() {
    }

    protected void installListener() {
        this.dockbar.addPropertyChangeListener(this);
    }

    protected void uninstallListener() {
        this.dockbar.removePropertyChangeListener(this);
    }

    private void updateDefaults() {
        if (this.dockbar.dockbarItemGapIsUIResource()) {
            this.dockbar.setDockbarItemGap(SyntheticaLookAndFeel.getInt((String)"JYDocking.dockbar.itemGap", (Component)this.dockbar, (int)2), true);
        }
        this.dockbar.setOpaque(SyntheticaLookAndFeel.getBoolean((String)"JYDocking.dockbar.opaque", (Component)this.dockbar, (boolean)true));
        this.updateInsets(this.dockbar.getPlacement());
    }

    @Override
    public void paint(Graphics g, JComponent c) {
        int x = 0;
        int y = 0;
        int w = c.getWidth();
        int h = c.getHeight();
        this.paintBackground(c, g, x, y, w, h, ((Dockbar)c).getPlacement());
    }

    protected void paintBackground(JComponent c, Graphics g, int x, int y, int w, int h, int placement) {
        BasicDockingPainter.getInstance().paintDockingDockbarBackground(c, new SyntheticaState(), g, x, y, w, h, placement);
    }

    protected void updateInsets(int placement) {
        Insets insets = SyntheticaLookAndFeel.getInsets((String)("JYDocking.dockbar." + Dockbar.placementAsString(placement) + ".insets"), (Component)this.dockbar);
        if (insets == null) {
            insets = placement == 3 ? new Insets(3, 1, 1, 1) : (placement == 4 ? new Insets(1, 3, 1, 1) : new Insets(1, 1, 1, 3));
        }
        this.dockbar.setBorder(SyntheticaLookAndFeel.getInstance().createEmptyBorder(insets, true));
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        String name = evt.getPropertyName();
        if (WidgetUtils.shouldUpdateStyle((PropertyChangeEvent)evt)) {
            this.updateDefaults();
        }
        if ("placement".equals(name)) {
            this.updateInsets((Integer)evt.getNewValue());
        }
    }
}

