/*
 * Decompiled with CFR 0.152.
 */
package de.javasoft.docking.ui;

import de.javasoft.docking.ui.BasicDockingPainter;
import de.javasoft.docking.ui.DockingViewTitlebarUI;
import de.javasoft.docking.ui.controls.DockingButtonFactory;
import de.javasoft.docking.ui.controls.DockingViewTitlebar;
import de.javasoft.docking.ui.controls.IDockingButtonFactory;
import de.javasoft.plaf.synthetica.SyntheticaLookAndFeel;
import de.javasoft.plaf.synthetica.SyntheticaState;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Insets;
import javax.swing.BoxLayout;
import javax.swing.JComponent;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.FontUIResource;
import javax.swing.plaf.UIResource;

public class BasicDockingViewTitlebarUI
extends DockingViewTitlebarUI {
    private IDockingButtonFactory dockingButtonFactory;

    public static ComponentUI createUI(JComponent c) {
        return new BasicDockingViewTitlebarUI();
    }

    @Override
    public void installUI(JComponent c) {
        Color foreground;
        super.installUI(c);
        DockingViewTitlebar titlebar = (DockingViewTitlebar)c;
        Font font = c.getFont();
        if (font == null || font instanceof UIResource) {
            String fontName;
            float fontSize;
            Font panelFont = UIManager.getFont("Panel.font");
            int style = 0;
            String fontStyle = SyntheticaLookAndFeel.getString((String)"JYDocking.titlebar.font.style", (Component)c);
            if (fontStyle != null) {
                if (fontStyle.contains("BOLD")) {
                    style |= 1;
                }
                if (fontStyle.contains("ITALIC")) {
                    style |= 2;
                }
            }
            if ((fontSize = SyntheticaLookAndFeel.getInstance().scaleFontSize((float)SyntheticaLookAndFeel.getInt((String)"JYDocking.titlebar.font.size", (Component)c, (int)0))) == 0.0f) {
                fontSize = panelFont.getSize();
            }
            if ((fontName = SyntheticaLookAndFeel.getString((String)"JYDocking.titlebar.font.name", (Component)c)) == null) {
                fontName = panelFont.getFamily();
            }
            c.setFont(new FontUIResource(fontName, style, (int)fontSize));
        }
        if ((foreground = titlebar.getTitleForeground()) == null || foreground instanceof UIResource) {
            titlebar.setTitleForeground(SyntheticaLookAndFeel.getColor((String)"JYDocking.titlebar.foreground", (Component)c, (Color)Color.BLACK));
        }
        if ((foreground = titlebar.getActiveTitleForeground()) == null || foreground instanceof UIResource) {
            titlebar.setActiveTitleForeground(SyntheticaLookAndFeel.getColor((String)"JYDocking.titlebar.active.foreground", (Component)c, (Color)Color.BLACK));
        }
        c.setLayout(new BoxLayout(c, 2));
        Insets insets = SyntheticaLookAndFeel.getInsets((String)"JYDocking.titlebar.insets", (Component)c, (Insets)new Insets(3, 4, 1, 4), (boolean)true);
        c.setBorder(SyntheticaLookAndFeel.getInstance().createEmptyBorder(insets, false));
        this.installDockingButtonFactory(titlebar);
    }

    @Override
    public void uninstallUI(JComponent c) {
        super.uninstallUI(c);
    }

    @Override
    public void paint(Graphics g, JComponent c) {
        int x = 0;
        int y = 0;
        int w = c.getWidth();
        int h = c.getHeight();
        this.paintBackground(c, g, x, y, w, h);
        this.paintBorder(c, g, x, y, w, h);
    }

    protected void paintBackground(JComponent c, Graphics g, int x, int y, int w, int h) {
        BasicDockingPainter.getInstance().paintDockingTitleBarBackground(c, new SyntheticaState(((DockingViewTitlebar)c).isActive() ? SyntheticaState.State.SELECTED.toInt() : 0), g, x, y, w, h);
    }

    protected void paintBorder(JComponent c, Graphics g, int x, int y, int w, int h) {
    }

    private void installDockingButtonFactory(DockingViewTitlebar titlebar) {
        String className = SyntheticaLookAndFeel.getString((String)"JYDocking.dockingButtonFactory.className", (Component)titlebar);
        if (className == null) {
            this.dockingButtonFactory = new DockingButtonFactory();
        } else {
            try {
                this.dockingButtonFactory = (IDockingButtonFactory)Class.forName(className).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    public IDockingButtonFactory getDockingButtonFactory() {
        return this.dockingButtonFactory;
    }
}

