/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.cartogram.math;

public final class Matrix {
    public double[][] m;
    private final int rows;
    private final int columns;

    public Matrix(int rows, int columns) {
        this.rows = rows;
        this.columns = columns;
        assert (rows > 0);
        assert (columns > 0);
        this.m = new double[rows + 1][columns + 1];
    }

    public final double getValue(int row, int column) {
        return this.m[row][column];
    }

    public final void setValue(int row, int column, double value) {
        this.m[row][column] = value;
    }

    public final double getValue(int index) {
        return this.m[index / this.columns][index % this.columns];
    }

    public final void setValue(int index, double value) {
        this.m[index / this.columns][index % this.columns] = value;
    }
}

