/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.util.math.histogram;

import java.util.Arrays;
import java.util.Comparator;

public class Array {
    private Array() {
    }

    public static float[] crossSubArray(float[][] source, int index) {
        float[] fArray = new float[source.length];
        for (int i = 0; i < fArray.length; ++i) {
            fArray[i] = source[i][index];
        }
        return fArray;
    }

    public static int[] intList(int from, int to) {
        int n;
        int n2 = Math.abs(to - from) + 1;
        int[] nArray = new int[n2];
        n = n <= from ? -1 : 1;
        for (int i = 0; i < n2; ++i) {
            nArray[i] = from + i * n;
        }
        return nArray;
    }

    public static int[] duplicate(int[] roleModel) {
        int[] nArray;
        int[] nArray2 = new int[roleModel.length];
        System.arraycopy(nArray, 0, nArray2, 0, nArray2.length);
        return nArray2;
    }

    public static float[] duplicate(float[] roleModel) {
        float[] fArray;
        float[] fArray2 = new float[roleModel.length];
        System.arraycopy(fArray, 0, fArray2, 0, fArray2.length);
        return fArray2;
    }

    public static float[][] duplicate(float[][] roleModel) {
        float[][] fArrayArray = new float[roleModel.length][];
        for (int i = 0; i < roleModel.length; ++i) {
            fArrayArray[i] = new float[roleModel[i].length];
            System.arraycopy(roleModel[i], 0, fArrayArray[i], 0, roleModel[i].length);
        }
        return fArrayArray;
    }

    public static boolean[][] duplicate(boolean[][] roleModel) {
        boolean[][] blArrayArray = new boolean[roleModel.length][];
        for (int i = 0; i < roleModel.length; ++i) {
            blArrayArray[i] = new boolean[roleModel[i].length];
            System.arraycopy(roleModel[i], 0, blArrayArray[i], 0, roleModel[i].length);
        }
        return blArrayArray;
    }

    public static float[] abs(float[] data) {
        float[] fArray = new float[data.length];
        for (int i = 0; i < data.length; ++i) {
            fArray[i] = Math.abs(data[i]);
        }
        return fArray;
    }

    /*
     * WARNING - void declaration
     */
    public static float[] interpolate(float from, float to, int sampleCount) {
        float f;
        void var1_1;
        if (sampleCount <= 0) {
            return new float[0];
        }
        if (sampleCount == 1) {
            return new float[]{(from + to) / 2.0f};
        }
        float[] fArray = new float[sampleCount];
        float[] fArray2 = fArray;
        fArray[0] = from;
        f = (var1_1 - f) / (float)(sampleCount - 1);
        for (int i = 1; i < sampleCount; ++i) {
            fArray2[i] = fArray2[i - 1] + f;
        }
        return fArray2;
    }

    public static float[][] extract(float[][] values, int[] indices) {
        float[][] fArrayArray = new float[indices.length][];
        for (int i = 0; i < fArrayArray.length; ++i) {
            fArrayArray[i] = values[indices[i]];
        }
        return fArrayArray;
    }

    public static int[] extract(int[][] values, int[] rowIndices, int columnIndex) {
        int[] nArray = new int[rowIndices.length];
        for (int i = 0; i < nArray.length; ++i) {
            nArray[i] = values[rowIndices[i]][columnIndex];
        }
        return nArray;
    }

    public static float[] extract(float[][] values, int[] rowIndices, int columnIndex) {
        float[] fArray = new float[rowIndices.length];
        for (int i = 0; i < fArray.length; ++i) {
            fArray[i] = values[rowIndices[i]][columnIndex];
        }
        return fArray;
    }

    public static int[][] extract(int[][] values, int[] indices) {
        int[][] nArrayArray = new int[indices.length][];
        for (int i = 0; i < nArrayArray.length; ++i) {
            nArrayArray[i] = values[indices[i]];
        }
        return nArrayArray;
    }

    public static boolean[][] extract(boolean[][] values, int[] indices) {
        boolean[][] blArrayArray = new boolean[indices.length][];
        for (int i = 0; i < blArrayArray.length; ++i) {
            blArrayArray[i] = values[indices[i]];
        }
        return blArrayArray;
    }

    public static float[] extract(float[] values, int[] indices) {
        float[] fArray = new float[indices.length];
        for (int i = 0; i < fArray.length; ++i) {
            fArray[i] = values[indices[i]];
        }
        return fArray;
    }

    public static boolean[] extract(boolean[] values, int[] indices) {
        boolean[] blArray = new boolean[indices.length];
        for (int i = 0; i < blArray.length; ++i) {
            blArray[i] = values[indices[i]];
        }
        return blArray;
    }

    public static String[] extract(String[] values, int[] indices) {
        String[] stringArray = new String[indices.length];
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray[i] = values[indices[i]];
        }
        return stringArray;
    }

    public static double[] extract(double[] values, int[] indices) {
        double[] dArray = new double[indices.length];
        for (int i = 0; i < dArray.length; ++i) {
            dArray[i] = values[indices[i]];
        }
        return dArray;
    }

    public static int[] extractColumn(int[][] values, int column) {
        int[] nArray = new int[values.length];
        for (int i = 0; i < nArray.length; ++i) {
            nArray[i] = values[i][column];
        }
        return nArray;
    }

    public static float[] extractColumn(float[][] values, int column) {
        float[] fArray = new float[values.length];
        for (int i = 0; i < fArray.length; ++i) {
            fArray[i] = values[i][column];
        }
        return fArray;
    }

    public static float[][] extractColumns(float[][] values, int[] indices) {
        float[][] fArrayArray = new float[values.length][];
        for (int i = 0; i < fArrayArray.length; ++i) {
            fArrayArray[i] = Array.extract(values[i], indices);
        }
        return fArrayArray;
    }

    public static double[][] extractColumns(double[][] values, int[] indices) {
        double[][] dArrayArray = new double[values.length][];
        for (int i = 0; i < dArrayArray.length; ++i) {
            dArrayArray[i] = Array.extract(values[i], indices);
        }
        return dArrayArray;
    }

    public static boolean[][] extractColumns(boolean[][] values, int[] indices) {
        boolean[][] blArrayArray = new boolean[values.length][];
        for (int i = 0; i < blArrayArray.length; ++i) {
            blArrayArray[i] = Array.extract(values[i], indices);
        }
        return blArrayArray;
    }

    public static float[] extractValids(float[] values) {
        int n = 0;
        for (int i = 0; i < values.length; ++i) {
            if (Float.isNaN(values[i])) continue;
            ++n;
        }
        float[] fArray = new float[n];
        n = 0;
        for (int i = 0; i < values.length; ++i) {
            if (Float.isNaN(values[i])) continue;
            fArray[n++] = values[i];
        }
        return fArray;
    }

    public static int[] extract(int[] values, int[] indices) {
        int[] nArray = new int[indices.length];
        for (int i = 0; i < nArray.length; ++i) {
            nArray[i] = values[indices[i]];
        }
        return nArray;
    }

    public static int[] lengths(float[][] arrays) {
        int[] nArray = new int[arrays.length];
        for (int i = 0; i < arrays.length; ++i) {
            nArray[i] = arrays[i].length;
        }
        return nArray;
    }

    public static int[] lengths(int[][] arrays) {
        int[] nArray = new int[arrays.length];
        for (int i = 0; i < arrays.length; ++i) {
            nArray[i] = arrays[i].length;
        }
        return nArray;
    }

    /*
     * WARNING - void declaration
     */
    public static float[] concatenate(float[] xs, float[] ys) {
        void var1_1;
        float[] fArray;
        float[] fArray2 = new float[xs.length + ys.length];
        System.arraycopy(xs, 0, fArray2, 0, xs.length);
        System.arraycopy(ys, 0, fArray2, fArray.length, ((void)var1_1).length);
        return fArray2;
    }

    /*
     * WARNING - void declaration
     */
    public static double[] concatenate(double[] xs, double[] ys) {
        void var1_1;
        double[] dArray;
        double[] dArray2 = new double[xs.length + ys.length];
        System.arraycopy(xs, 0, dArray2, 0, xs.length);
        System.arraycopy(ys, 0, dArray2, dArray.length, ((void)var1_1).length);
        return dArray2;
    }

    public static float[] concatenate(float[][] xs) {
        int n = 0;
        for (int i = 0; i < xs.length; ++i) {
            n += xs[i].length;
        }
        float[] fArray = new float[n];
        n = 0;
        for (int i = 0; i < xs.length; ++i) {
            System.arraycopy(xs[i], 0, fArray, n, xs[i].length);
            n += xs[i].length;
        }
        return fArray;
    }

    public static int[] concatenate(int[][] xs) {
        int n = 0;
        for (int i = 0; i < xs.length; ++i) {
            n += xs[i].length;
        }
        int[] nArray = new int[n];
        n = 0;
        for (int i = 0; i < xs.length; ++i) {
            System.arraycopy(xs[i], 0, nArray, n, xs[i].length);
            n += xs[i].length;
        }
        return nArray;
    }

    /*
     * WARNING - void declaration
     */
    public static int[] concatenate(int[] xs, int[] ys) {
        void var1_1;
        int[] nArray;
        int[] nArray2 = new int[xs.length + ys.length];
        System.arraycopy(xs, 0, nArray2, 0, xs.length);
        System.arraycopy(ys, 0, nArray2, nArray.length, ((void)var1_1).length);
        return nArray2;
    }

    /*
     * WARNING - void declaration
     */
    public static int[] concatenate(int[] xs, int y) {
        void var1_1;
        int[] nArray = new int[xs.length + 1];
        System.arraycopy(xs, 0, nArray, 0, xs.length);
        nArray[var0.length] = var1_1;
        return nArray;
    }

    /*
     * WARNING - void declaration
     */
    public static Object[] concatenate(Object[] first, Object[] last) {
        void var1_1;
        Object[] objectArray;
        Object[] objectArray2 = first.getClass().getComponentType();
        Class<?> clazz = last.getClass().getComponentType();
        objectArray2 = Array.getMostSpecificCommonClass(objectArray2, clazz);
        objectArray2 = (Object[])java.lang.reflect.Array.newInstance(objectArray2, first.length + last.length);
        System.arraycopy(first, 0, objectArray2, 0, first.length);
        System.arraycopy(last, 0, objectArray2, objectArray.length, ((void)var1_1).length);
        return objectArray2;
    }

    public static Class getMostSpecificCommonClass(Class one, Class two) {
        while (!one.equals(two)) {
            if (one.isAssignableFrom(two)) {
                return one;
            }
            if (two.isAssignableFrom(one)) {
                return two;
            }
            two = two.getSuperclass();
            one = one.getSuperclass();
        }
        return one;
    }

    public static int[] findValids(float[] data) {
        int[] nArray = new int[data.length];
        int n = 0;
        for (int i = 0; i < data.length; ++i) {
            if (Float.isNaN(data[i])) continue;
            nArray[n++] = i;
        }
        return Array.trim(nArray, n);
    }

    public static int[] findPositives(float[] data) {
        int[] nArray = new int[data.length];
        int n = 0;
        for (int i = 0; i < data.length; ++i) {
            if (!(data[i] > 0.0f)) continue;
            nArray[n++] = i;
        }
        return Array.trim(nArray, n);
    }

    public static int[] findNegatives(float[] data) {
        int[] nArray = new int[data.length];
        int n = 0;
        for (int i = 0; i < data.length; ++i) {
            if (!(data[i] < 0.0f)) continue;
            nArray[n++] = i;
        }
        return Array.trim(nArray, n);
    }

    public static int[] findInvalids(float[] data) {
        int[] nArray = new int[data.length];
        int n = 0;
        for (int i = 0; i < data.length; ++i) {
            if (!Float.isNaN(data[i])) continue;
            nArray[n++] = i;
        }
        return Array.trim(nArray, n);
    }

    /*
     * WARNING - void declaration
     */
    public static int[] findValids(float[] xs, float[] ys, int minValids) {
        void var2_2;
        int[] nArray = new int[xs.length];
        int n = 0;
        for (int i = 0; i < xs.length; ++i) {
            if (Float.isNaN(xs[i]) || Float.isNaN(ys[i])) continue;
            nArray[n++] = i;
        }
        if (n >= var2_2) {
            return Array.trim(nArray, n);
        }
        return new int[0];
    }

    /*
     * WARNING - void declaration
     */
    public static int[] findValids(float[] data, int minValids) {
        void var1_1;
        int[] nArray = new int[data.length];
        int n = 0;
        for (int i = 0; i < data.length; ++i) {
            if (Float.isNaN(data[i])) continue;
            nArray[n++] = i;
        }
        if (n >= var1_1) {
            return Array.trim(nArray, n);
        }
        return new int[0];
    }

    public static int[] findValids(float[] xs, float[] ys) {
        int[] nArray = new int[xs.length];
        int n = 0;
        for (int i = 0; i < xs.length; ++i) {
            if (Float.isNaN(xs[i]) || Float.isNaN(ys[i])) continue;
            nArray[n++] = i;
        }
        return Array.trim(nArray, n);
    }

    public static int[] findValids(float[][] data, int minValids) {
        int[] nArray = new int[data.length];
        int n = 0;
        for (int i = 0; i < data.length; ++i) {
            int n2 = 0;
            for (int j = 0; j < data[i].length; ++j) {
                if (Float.isNaN(data[i][j])) continue;
                ++n2;
            }
            if (n2 < minValids) continue;
            nArray[n++] = i;
        }
        return Array.trim(nArray, n);
    }

    public static int[] findColumnValids(float[][] data, int minValids) {
        int[] nArray = new int[data[0].length];
        int n = 0;
        for (int i = 0; i < data[0].length; ++i) {
            int n2 = 0;
            for (int j = 0; j < data.length; ++j) {
                if (Float.isNaN(data[j][i])) continue;
                ++n2;
            }
            if (n2 < minValids) continue;
            nArray[n++] = i;
        }
        return Array.trim(nArray, n);
    }

    public static int[] findValids(float[] data, int start, int length) {
        length = Math.min(length, data.length - start);
        int[] nArray = new int[length];
        int n = 0;
        for (int i = start; i < start + length; ++i) {
            if (Float.isNaN(data[i])) continue;
            nArray[n++] = i;
        }
        return Array.trim(nArray, n);
    }

    public static int[] intersect(int[] a2, int[] b2) {
        int[] nArray;
        int[] nArray2;
        if (b2.length == 0 || a2.length == 0) {
            return new int[0];
        }
        if (a2.length < b2.length) {
            nArray2 = a2;
            a2 = b2;
            b2 = nArray2;
        }
        nArray2 = (int[])nArray.clone();
        Arrays.sort(nArray2);
        nArray = new int[b2.length];
        int n = 0;
        for (int i = 0; i < b2.length; ++i) {
            if (Arrays.binarySearch(nArray2, b2[i]) < 0) continue;
            nArray[n++] = b2[i];
        }
        return Array.trim(nArray, n);
    }

    /*
     * WARNING - void declaration
     */
    public static String[] trim(String[] strings, int len) {
        void var1_1;
        String[] stringArray;
        if (strings.length == len) {
            return strings;
        }
        String[] stringArray2 = new String[len];
        System.arraycopy(stringArray, 0, stringArray2, 0, (int)var1_1);
        return stringArray2;
    }

    /*
     * WARNING - void declaration
     */
    public static int[] trim(int[] vector, int len) {
        void var1_1;
        int[] nArray;
        if (vector.length == len) {
            return vector;
        }
        int[] nArray2 = new int[len];
        System.arraycopy(nArray, 0, nArray2, 0, (int)var1_1);
        return nArray2;
    }

    /*
     * WARNING - void declaration
     */
    public static byte[] trim(byte[] vector, int len) {
        void var1_1;
        byte[] byArray;
        if (vector.length == len) {
            return vector;
        }
        byte[] byArray2 = new byte[len];
        System.arraycopy(byArray, 0, byArray2, 0, (int)var1_1);
        return byArray2;
    }

    /*
     * WARNING - void declaration
     */
    public static float[] trim(float[] vector, int len) {
        void var1_1;
        float[] fArray;
        if (vector.length == len) {
            return vector;
        }
        float[] fArray2 = new float[len];
        System.arraycopy(fArray, 0, fArray2, 0, (int)var1_1);
        return fArray2;
    }

    /*
     * WARNING - void declaration
     */
    public static double[] trim(double[] vector, int len) {
        void var1_1;
        double[] dArray;
        if (vector.length == len) {
            return vector;
        }
        double[] dArray2 = new double[len];
        System.arraycopy(dArray, 0, dArray2, 0, (int)var1_1);
        return dArray2;
    }

    /*
     * WARNING - void declaration
     */
    public static boolean[] trim(boolean[] vector, int len) {
        void var1_1;
        boolean[] blArray;
        if (vector.length == len) {
            return vector;
        }
        boolean[] blArray2 = new boolean[len];
        System.arraycopy(blArray, 0, blArray2, 0, (int)var1_1);
        return blArray2;
    }

    /*
     * WARNING - void declaration
     */
    public static Object[] trim(Object[] vector, int len) {
        void var1_1;
        Object[] objectArray;
        if (vector.length == len) {
            return vector;
        }
        Object[] objectArray2 = (Object[])java.lang.reflect.Array.newInstance(vector.getClass().getComponentType(), len);
        System.arraycopy(objectArray, 0, objectArray2, 0, (int)var1_1);
        return objectArray2;
    }

    /*
     * WARNING - void declaration
     */
    public static float[] trim(float[] vector, int length, boolean onlyValids) {
        void var1_1;
        float[] fArray;
        if (onlyValids) {
            int n = 0;
            for (int i = 0; i < length; ++i) {
                if (Float.isNaN(vector[i]) || Float.isInfinite(vector[i])) continue;
                ++n;
            }
            float[] fArray2 = new float[n];
            n = 0;
            for (int i = 0; i < length; ++i) {
                if (Float.isNaN(vector[i]) || Float.isInfinite(vector[i])) continue;
                fArray2[n++] = vector[i];
            }
            return fArray2;
        }
        return Array.trim(fArray, (int)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static boolean[][] trim(boolean[][] vector, int len) {
        void var1_1;
        boolean[][] blArray;
        if (vector.length == len) {
            return vector;
        }
        boolean[][] blArrayArray = new boolean[len][];
        System.arraycopy(blArray, 0, blArrayArray, 0, (int)var1_1);
        return blArrayArray;
    }

    /*
     * WARNING - void declaration
     */
    public static float[][] trim(float[][] vector, int len) {
        void var1_1;
        float[][] fArray;
        if (vector.length == len) {
            return vector;
        }
        float[][] fArrayArray = new float[len][];
        System.arraycopy(fArray, 0, fArrayArray, 0, (int)var1_1);
        return fArrayArray;
    }

    public static float[] intsToFloats(int[] values) {
        float[] fArray = new float[values.length];
        for (int i = 0; i < values.length; ++i) {
            fArray[i] = values[i];
        }
        return fArray;
    }

    public static float[][] intsToFloats(int[][] values) {
        float[][] fArrayArray = new float[values.length][];
        for (int i = 0; i < values.length; ++i) {
            fArrayArray[i] = Array.intsToFloats(values[i]);
        }
        return fArrayArray;
    }

    public static byte[][] floatToBytes(float[][] data) {
        int n = data.length;
        int n2 = data[0].length;
        byte[][] byArray = new byte[n][n2];
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n2; ++j) {
                byArray[i][j] = (byte)data[i][j];
            }
        }
        return byArray;
    }

    public static float[][] bytesToFloats(byte[][] values) {
        int n = values.length;
        int n2 = values[0].length;
        float[][] fArray = new float[n][n2];
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n2; ++j) {
                fArray[i][j] = values[i][j];
            }
        }
        return fArray;
    }

    public static double[][] floatsToDoubles(float[][] data) {
        int n = data.length;
        int n2 = data[0].length;
        double[][] dArray = new double[n][n2];
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n2; ++j) {
                dArray[i][j] = data[i][j];
            }
        }
        return dArray;
    }

    public static double[][] bytesToDoubles(byte[][] data) {
        int n = data.length;
        int n2 = data[0].length;
        double[][] dArray = new double[n][n2];
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n2; ++j) {
                dArray[i][j] = data[i][j];
            }
        }
        return dArray;
    }

    public static int[] unique(int[] indices) {
        int[] nArray;
        if (indices.length < 2) {
            return indices;
        }
        nArray = (int[])nArray.clone();
        Arrays.sort(nArray);
        int n = 1;
        int n2 = nArray[0];
        for (int i = 1; i < nArray.length; ++i) {
            if (n2 == nArray[i]) continue;
            n2 = nArray[i];
            nArray[n++] = n2;
        }
        int[] nArray2 = new int[n];
        System.arraycopy(nArray, 0, nArray2, 0, n);
        return nArray2;
    }

    public static float[] unique(float[] values) {
        float[] fArray;
        int n = values.length;
        if (n < 2) {
            return values;
        }
        fArray = (float[])fArray.clone();
        Arrays.sort(fArray);
        int n2 = 1;
        float f = fArray[0];
        for (int i = 1; i < n; ++i) {
            if (f == fArray[i]) continue;
            f = fArray[i];
            fArray[n2++] = f;
        }
        float[] fArray2 = new float[n2];
        System.arraycopy(fArray, 0, fArray2, 0, n2);
        return fArray2;
    }

    public static int[] complement(int[] indices, int totalLength) {
        int[] nArray;
        if (totalLength < 0) {
            throw new IllegalArgumentException("totalLength must be >= 0");
        }
        if (indices.length == 0) {
            if (totalLength == 0) {
                return new int[0];
            }
            return Array.intList(0, totalLength - 1);
        }
        if ((nArray = Array.unique(nArray))[0] < 0) {
            throw new IllegalArgumentException("indices[] contains negative entries");
        }
        if (nArray[nArray.length - 1] >= totalLength) {
            throw new IllegalArgumentException("indices[] contains entries >= totalLength");
        }
        int[] nArray2 = new int[totalLength - nArray.length];
        int n = 0;
        int n2 = 0;
        ++n;
        int n3 = nArray[0];
        for (int i = 0; i < totalLength; ++i) {
            if (n3 == i) {
                if (n >= nArray.length) continue;
                n3 = nArray[n++];
                continue;
            }
            nArray2[n2++] = i;
        }
        return nArray2;
    }

    public static int[] reverse(int[] original) {
        int[] nArray = new int[original.length];
        for (int i = 0; i < nArray.length; ++i) {
            nArray[i] = original[original.length - 1 - i];
        }
        return nArray;
    }

    public static float[] reverse(float[] original) {
        int n = original.length;
        float[] fArray = new float[n];
        int n2 = 0;
        while (--n >= 0) {
            fArray[n2] = original[n];
            ++n2;
        }
        return fArray;
    }

    public static Object[] reverse(Object[] original) {
        int n = original.length;
        Object[] objectArray = (Object[])java.lang.reflect.Array.newInstance(original.getClass().getComponentType(), n);
        int n2 = 0;
        while (--n >= 0) {
            objectArray[n2] = original[n];
            ++n2;
        }
        return objectArray;
    }

    public static int getMax(int[] data) {
        int n = Integer.MIN_VALUE;
        int n2 = data.length;
        while (--n2 >= 0) {
            int n3 = data[n2];
            if (n3 <= n) continue;
            n = n3;
        }
        return n;
    }

    public static float getMax(float[] data) {
        float f = Float.NEGATIVE_INFINITY;
        int n = data.length;
        while (--n >= 0) {
            float f2;
            float f3 = data[n];
            if (!(f2 > f)) continue;
            f = f3;
        }
        return f;
    }

    public static double getMax(double[] data) {
        double d = Double.NEGATIVE_INFINITY;
        int n = data.length;
        while (--n >= 0) {
            double d2;
            double d3 = data[n];
            if (!(d2 > d)) continue;
            d = d3;
        }
        return d;
    }

    public static float[] getMinMaxAndSmallestPositive(float[] data) {
        float f = 3.402823E38f;
        float f2 = Float.MIN_VALUE;
        float f3 = Float.POSITIVE_INFINITY;
        for (int i = 0; i < data.length; ++i) {
            float f4;
            float f5 = data[i];
            if (f4 > f2) {
                f2 = f5;
            }
            if (f5 < f) {
                f = f5;
            }
            if (!(f5 > 0.0f) || !(f5 < f3)) continue;
            f3 = f5;
        }
        if (f3 == 3.402823E38f) {
            f3 = Float.NaN;
        }
        return new float[]{f, f2, f3};
    }

    public static float[] getMinMaxAndSmallestPositive(float[][] data) {
        float f = Float.POSITIVE_INFINITY;
        float f2 = Float.NEGATIVE_INFINITY;
        float f3 = Float.POSITIVE_INFINITY;
        for (int i = 0; i < data.length; ++i) {
            for (int j = 0; j < data[0].length; ++j) {
                float f4;
                float f5 = data[i][j];
                if (f4 < f) {
                    f = f5;
                } else if (f5 > f2) {
                    f2 = f5;
                }
                if (!(f5 > 0.0f) || !(f5 < f3)) continue;
                f3 = f5;
            }
        }
        if (f3 == 3.402823E38f) {
            f3 = Float.NaN;
        }
        return new float[]{f, f2, f3};
    }

    public static float getLogMean(float[][] data) {
        float f = 0.0f;
        int n = 0;
        for (int i = 0; i < data.length; ++i) {
            for (int j = 0; j < data[0].length; ++j) {
                if (!(data[i][j] > 0.0f)) continue;
                f += (float)Math.log(data[i][j]);
                ++n;
            }
        }
        if (n == 0) {
            return Float.NaN;
        }
        return (float)Math.exp(f / (float)n);
    }

    /*
     * WARNING - void declaration
     */
    public static int find(int[] array, int value) {
        void var1_1;
        return Array.indexOf(array, (int)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static int indexOf(float[] array, float value) {
        void var1_1;
        return Array.indexOf(array, (float)var1_1, 0);
    }

    public static int indexOfOrdered(float[] array, int[] order, float value) {
        int n = 0;
        int n2 = array.length;
        while (n2 - n > 1) {
            int n3 = n + n2 >> 1;
            if (array[order[n3]] > value) {
                n2 = n3;
                continue;
            }
            n = n3;
        }
        return n;
    }

    public static int indexOf(int[] array, int value) {
        int n = array.length;
        while (--n >= 0) {
            if (array[n] != value) continue;
            return n;
        }
        return -1;
    }

    /*
     * WARNING - void declaration
     */
    public static int indexOf(float[] array, float value, int index) {
        void var2_2;
        int n = array.length;
        if (index < 0) {
            index = 0;
        } else if (index >= n) {
            return -1;
        }
        while (var2_2 < n) {
            if (array[var2_2] == value) {
                return (int)var2_2;
            }
            ++var2_2;
        }
        return -1;
    }

    public static int indexOf(String[] array, String value) {
        int n = array.length;
        while (--n >= 0) {
            if (!array[n].equals(value)) continue;
            return n;
        }
        return -1;
    }

    public static int indexOf(Object[] array, Object value) {
        int n = array.length;
        while (--n >= 0) {
            if (array[n] != value) continue;
            return n;
        }
        return -1;
    }

    public static float[][] transpose(float[][] data) {
        float[][] fArray = new float[data[0].length][data.length];
        for (int i = 0; i < data.length; ++i) {
            for (int j = 0; j < data[i].length; ++j) {
                fArray[j][i] = data[i][j];
            }
        }
        return fArray;
    }

    public static double[][] transpose(double[][] data) {
        double[][] dArray = new double[data[0].length][data.length];
        for (int i = 0; i < data.length; ++i) {
            for (int j = 0; j < data[i].length; ++j) {
                dArray[j][i] = data[i][j];
            }
        }
        return dArray;
    }

    /*
     * WARNING - void declaration
     */
    public static Object[] subArray(Object[] input, int beginIndex, int endIndex) {
        void var1_1;
        void var2_2;
        if (input == null) {
            throw new NullPointerException();
        }
        int n = input.length;
        if (beginIndex < 0) {
            throw new IndexOutOfBoundsException("beginIndex too low: " + beginIndex);
        }
        if (endIndex > n) {
            throw new IndexOutOfBoundsException("endIndex too low: " + endIndex);
        }
        if (beginIndex > endIndex) {
            throw new IndexOutOfBoundsException("end - begin difference too low: " + (endIndex - beginIndex));
        }
        if (beginIndex == 0 && endIndex == n) {
            return input;
        }
        Class<?> clazz = input.getClass().getComponentType();
        Object[] objectArray = (Object[])java.lang.reflect.Array.newInstance(clazz, (int)(var2_2 - beginIndex));
        int n2 = 0;
        while (var1_1 < objectArray.length) {
            objectArray[n2] = input[var1_1];
            ++n2;
            ++var1_1;
        }
        return objectArray;
    }

    public static float[][] createArray(int rows, int cols, float initial) {
        float[][] fArrayArray = new float[rows][];
        for (int i = 0; i < rows; ++i) {
            fArrayArray[i] = Array.createVector(cols, initial);
        }
        return fArrayArray;
    }

    /*
     * WARNING - void declaration
     */
    public static float[] createVector(int length, float initial) {
        void var1_2;
        float[] fArray = new float[length];
        Arrays.fill(fArray, (float)var1_2);
        return fArray;
    }

    /*
     * WARNING - void declaration
     */
    public static int[] createVector(int length, int initial) {
        void var1_2;
        int[] nArray = new int[length];
        Arrays.fill(nArray, (int)var1_2);
        return nArray;
    }

    /*
     * WARNING - void declaration
     */
    public static void rangeCheck(int arrayLen, int fromIndex, int toIndex) {
        int n;
        if (fromIndex > toIndex) {
            throw new IllegalArgumentException("fromIndex(" + fromIndex + ") > toIndex(" + toIndex + ")");
        }
        if (fromIndex < 0) {
            void var1_1;
            throw new ArrayIndexOutOfBoundsException((int)var1_1);
        }
        if (toIndex > n) {
            void var2_2;
            throw new ArrayIndexOutOfBoundsException((int)var2_2);
        }
    }

    /*
     * WARNING - void declaration
     */
    public static void mergeSort(Object[] src, Object[] dest, int low, int high, Comparator c2) {
        int n = high - low;
        if (n < 7) {
            for (int i = low; i < high; ++i) {
                for (n = i; n > low && c2.compare(dest[n - 1], dest[n]) > 0; --n) {
                    int n2;
                    int n3 = n - 1;
                    src = dest;
                    Object object = dest[n2];
                    src[n2] = src[n3];
                    src[n3] = object;
                }
            }
            return;
        }
        int n4 = low + high >> 1;
        Array.mergeSort(dest, src, low, n4, c2);
        Array.mergeSort(dest, src, n4, high, c2);
        if (c2.compare(src[n4 - 1], src[n4]) <= 0) {
            System.arraycopy(src, low, dest, low, n);
            return;
        }
        int n5 = n4;
        for (n = low; n < high; ++n) {
            void var2_2;
            dest[n] = n5 >= high || var2_2 < n4 && c2.compare(src[var2_2], src[n5]) <= 0 ? src[var2_2++] : src[n5++];
        }
    }
}

