/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.util.math.histogram;

import com.macrofocus.math.stat.Histogram;
import com.macrofocus.util.math.histogram.Array;
import com.macrofocus.util.math.histogram.Range;
import java.util.Arrays;

public class GenedataHistogram
implements Histogram {
    private int[] a;
    private int[] b;
    private int c;
    private int d;
    private int e;
    private int f;
    private double g;
    private double h;
    private double i;
    private double j;
    private double k;
    private double l;
    private Range m;

    public int getNumberOfBins() {
        return this.getBinCount();
    }

    /*
     * WARNING - void declaration
     */
    public int getCountAtBin(int index) {
        void var1_1;
        return this.getPopulationAt((int)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public double getBinMinValue(int index) {
        void var1_1;
        return Math.max(this.getMinValue(), this.getBinMiddle((int)var1_1) - this.getBinWidth() / 2.0);
    }

    /*
     * WARNING - void declaration
     */
    public double getBinMaxValue(int index) {
        void var1_1;
        return Math.min(this.getMaxValue(), this.getBinMiddle((int)var1_1) + this.getBinWidth() / 2.0);
    }

    public double getMinValue() {
        return this.getRange().getMin();
    }

    public double getMaxValue() {
        return this.getRange().getMax();
    }

    public int getMaxCount() {
        return this.getMaxPopulation();
    }

    protected GenedataHistogram() {
    }

    /*
     * WARNING - void declaration
     */
    public GenedataHistogram(double[] values) {
        void var1_1;
        void v0 = var1_1;
        this.init((double[])v0, ((void)v0).length, 2.0, false);
    }

    /*
     * WARNING - void declaration
     */
    public GenedataHistogram(double[] values, double coef) {
        void var2_2;
        void var1_1;
        void v0 = var1_1;
        this.init((double[])v0, ((void)v0).length, (double)var2_2, false);
    }

    /*
     * WARNING - void declaration
     */
    public GenedataHistogram(double[] values, double coef, boolean sorted) {
        void var2_2;
        void var1_1;
        void v0 = var1_1;
        this.init((double[])v0, ((void)v0).length, (double)var2_2, sorted);
    }

    /*
     * WARNING - void declaration
     */
    public GenedataHistogram(double[] values, int valueCount, double coef, boolean sorted) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.init((double[])var1_1, (int)var2_2, (double)var3_3, sorted);
    }

    /*
     * WARNING - void declaration
     */
    public GenedataHistogram(double[] sortedValues, double centralValue, double binWidth) {
        void var2_2;
        void var1_1;
        void v0 = var1_1;
        this.init((double[])v0, ((void)v0).length, (double)var2_2, binWidth);
    }

    /*
     * WARNING - void declaration
     */
    protected void init(double[] values, int valueCount, double coef, boolean sorted) {
        void var2_2;
        void var1_1;
        void var3_3;
        if (valueCount == 0) {
            throw new IllegalArgumentException("Cannot make histogram from empty array.");
        }
        if (!sorted) {
            Arrays.sort(values, 0, valueCount);
        }
        double d = GenedataHistogram.a(0.5, values, valueCount);
        double d2 = GenedataHistogram.a(0.75, values, valueCount) - GenedataHistogram.a(0.25, values, valueCount);
        double d3 = var3_3 * d2 * Math.pow(valueCount, -0.3333333333333333);
        if ((d3 == 0.0 || Double.isNaN(d3) || Double.isInfinite(d3)) && ((d3 = (values[valueCount - 1] - values[0]) / 10.0) == 0.0 || Double.isNaN(d3) || Double.isInfinite(d3))) {
            d3 = 1.0;
        }
        this.init((double[])var1_1, (int)var2_2, d, d3);
    }

    /*
     * WARNING - void declaration
     */
    protected void init(double[] sortedValues, int valueCount, double centralValue, double binWidth) {
        void var3_3;
        if (valueCount == 0) {
            throw new IllegalArgumentException("Cannot make histogram from empty array.");
        }
        this.m = new Range(sortedValues[0], sortedValues[valueCount - 1]);
        this.l = centralValue;
        this.g = binWidth;
        this.c = valueCount;
        this.a = new int[this.c];
        this.b = new int[this.c];
        void var7_6 = var3_3 + binWidth * 0.5;
        this.j = var7_6 - binWidth * Math.floor((double)((var7_6 - sortedValues[0]) / binWidth));
        if (sortedValues[0] > this.j) {
            this.j += binWidth;
        }
        this.h = this.j - binWidth;
        this.i = this.j - binWidth / 2.0;
        int n = 0;
        this.k = this.j;
        this.d = this.c;
        this.e = this.c;
        this.f = 0;
        for (int i = 0; i < valueCount; ++i) {
            if (sortedValues[i] > this.k) {
                if (this.b[n] < this.d) {
                    this.d = this.b[n];
                }
                if (this.b[n] < this.e && this.b[n] > 0) {
                    this.e = this.b[n];
                }
                if (this.b[n] > this.f) {
                    this.f = this.b[n];
                }
                int n2 = 1 + (int)((sortedValues[i] - this.k) / binWidth);
                this.a[n + 1] = this.a[n] + n2;
                this.k += (double)n2 * binWidth;
            }
            int n3 = ++n;
            this.b[n3] = this.b[n3] + 1;
        }
        if (this.f == 0) {
            this.f = this.c;
        }
        this.a = Array.trim(this.a, ++n);
        this.b = Array.trim(this.b, n);
    }

    /*
     * WARNING - void declaration
     */
    public int getBin(double v) {
        void var1_1;
        if (v < this.h) {
            return -1;
        }
        if (v > this.k) {
            return -2;
        }
        return (int)((var1_1 - this.h) / this.g);
    }

    public int getBinCount() {
        return 1 + this.a[this.a.length - 1];
    }

    /*
     * WARNING - void declaration
     */
    public double getBinMiddle(int i) {
        void var1_1;
        return this.i + (double)var1_1 * this.g;
    }

    public double getBinWidth() {
        return this.g;
    }

    public double getCentralValue() {
        return this.l;
    }

    public double getLowerResidual(int i) {
        if (i < 0) {
            return 0.0;
        }
        int n = 0;
        for (int j = 0; j < this.a.length && this.a[j] < i; ++j) {
            n += this.b[j];
        }
        return (double)n * 100.0 / (double)this.c;
    }

    public int getMaxPopulation() {
        return this.f;
    }

    public int getMinNonZeroPopulation() {
        return this.e;
    }

    public int getMinPopulation() {
        return this.d;
    }

    public int getPopulationAt(int i) {
        int n;
        if ((n = Arrays.binarySearch(this.a, n)) < 0) {
            return 0;
        }
        return this.b[n];
    }

    public Range getRange() {
        return this.m;
    }

    public int getTotalPopulation() {
        return this.c;
    }

    public double getUpperResidual(int i) {
        int n;
        if (i + 1 > this.a[this.a.length - 1]) {
            return 0.0;
        }
        int n2 = 0;
        if ((n = Arrays.binarySearch(this.a, (int)(n + true))) < 0) {
            n = -(n + 1);
        }
        while (n < this.a.length) {
            n2 += this.b[n];
            ++n;
        }
        return (double)n2 * 100.0 / (double)this.c;
    }

    public String toString() {
        return "Histogram, range=" + this.m + ", total=" + this.c + ", binWidth=" + this.g + ", centralValue=" + this.l;
    }

    private static double a(double d, double[] dArray, int n) {
        double d2 = (double)(n - 1) * d;
        int n2 = (int)d2;
        if (n2 == n - 1) {
            return dArray[n2];
        }
        return dArray[n2] * (1.0 - (d2 -= (double)n2)) + dArray[n2 + 1] * d2;
    }
}

