/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.util.math.histogram;

import java.util.Arrays;

public class OutlierTolerantHistogram {
    private int[] a;
    private int[] b;
    private int c;
    private int d;
    private int e;
    private int f;
    private double g;
    private double h;
    private double i;
    private double j;
    private double k;
    private double l;
    private Range m;

    protected OutlierTolerantHistogram() {
    }

    /*
     * WARNING - void declaration
     */
    public OutlierTolerantHistogram(float[] values) {
        void var1_1;
        void v0 = var1_1;
        this.init((float[])v0, ((void)v0).length, 2.0f, false);
    }

    /*
     * WARNING - void declaration
     */
    public OutlierTolerantHistogram(float[] values, float coef) {
        void var2_2;
        void var1_1;
        void v0 = var1_1;
        this.init((float[])v0, ((void)v0).length, (float)var2_2, false);
    }

    /*
     * WARNING - void declaration
     */
    public OutlierTolerantHistogram(float[] values, float coef, boolean sorted) {
        void var3_3;
        void var2_2;
        void var1_1;
        void v0 = var1_1;
        this.init((float[])v0, ((void)v0).length, (float)var2_2, (boolean)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    public OutlierTolerantHistogram(float[] sortedValues, float centralValue, float binWidth) {
        void var3_3;
        void var2_2;
        void var1_1;
        void v0 = var1_1;
        this.init((float[])v0, ((void)v0).length, (float)var2_2, (float)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    protected void init(float[] values, int valueCount, float coef, boolean sorted) {
        void var2_2;
        void var1_1;
        float f;
        if (valueCount == 0) {
            throw new IllegalArgumentException("Cannot make histogram from empty array.");
        }
        if (!sorted) {
            Arrays.sort(values, 0, valueCount);
        }
        float f2 = OutlierTolerantHistogram.a(0.5f, values, valueCount);
        float f3 = OutlierTolerantHistogram.a(0.75f, values, valueCount) - OutlierTolerantHistogram.a(0.25f, values, valueCount);
        if (((f = f * f3 * (float)Math.pow(valueCount, -0.3333333333333333)) == 0.0f || Float.isNaN(f) || Float.isInfinite(f)) && ((f = (values[valueCount - 1] - values[0]) / 10.0f) == 0.0f || Float.isNaN(f) || Float.isInfinite(f))) {
            f = 1.0f;
        }
        this.init((float[])var1_1, (int)var2_2, f2, f);
    }

    /*
     * WARNING - void declaration
     */
    protected void init(float[] sortedValues, int valueCount, float centralValue, float binWidth) {
        void var3_3;
        if (valueCount == 0) {
            throw new IllegalArgumentException("Cannot make histogram from empty array.");
        }
        this.m = new Range(sortedValues[0], sortedValues[valueCount - 1]);
        this.l = centralValue;
        this.g = binWidth;
        this.c = valueCount;
        this.a = new int[this.c];
        this.b = new int[this.c];
        double d = (double)var3_3 + 0.5 * (double)binWidth;
        this.j = d - (double)binWidth * Math.floor((d - (double)sortedValues[0]) / (double)binWidth);
        if ((double)sortedValues[0] > this.j) {
            this.j += (double)binWidth;
        }
        this.h = this.j - (double)binWidth;
        this.i = this.j - (double)(binWidth / 2.0f);
        int n = 0;
        this.k = this.j;
        this.d = this.c;
        this.e = this.c;
        this.f = 0;
        for (int i = 0; i < valueCount; ++i) {
            if ((double)sortedValues[i] > this.k) {
                if (this.b[n] < this.d) {
                    this.d = this.b[n];
                }
                if (this.b[n] < this.e && this.b[n] > 0) {
                    this.e = this.b[n];
                }
                if (this.b[n] > this.f) {
                    this.f = this.b[n];
                }
                int n2 = 1 + (int)(((double)sortedValues[i] - this.k) / (double)binWidth);
                this.a[n + 1] = this.a[n] + n2;
                this.k += (double)((float)n2 * binWidth);
            }
            int n3 = ++n;
            this.b[n3] = this.b[n3] + 1;
        }
        if (this.f == 0) {
            this.f = this.c;
        }
        this.a = OutlierTolerantHistogram.a(this.a, ++n);
        this.b = OutlierTolerantHistogram.a(this.b, n);
    }

    /*
     * WARNING - void declaration
     */
    public int getBin(float v) {
        void var1_1;
        if ((double)v < this.h) {
            return -1;
        }
        if ((double)v > this.k) {
            return -2;
        }
        return (int)(((double)var1_1 - this.h) / this.g);
    }

    public int getBinCount() {
        return 1 + this.a[this.a.length - 1];
    }

    /*
     * WARNING - void declaration
     */
    public float getBinMiddle(int i) {
        void var1_1;
        return (float)(this.i + (double)var1_1 * this.g);
    }

    public float getBinWidth() {
        return (float)this.g;
    }

    public float getCentralValue() {
        return (float)this.l;
    }

    public float getLowerResidual(int i) {
        if (i < 0) {
            return 0.0f;
        }
        int n = 0;
        for (int j = 0; j < this.a.length && this.a[j] < i; ++j) {
            n += this.b[j];
        }
        return (float)n * 100.0f / (float)this.c;
    }

    public int getMaxPopulation() {
        return this.f;
    }

    public int getMinNonZeroPopulation() {
        return this.e;
    }

    public int getMinPopulation() {
        return this.d;
    }

    public int getPopulationAt(int i) {
        int n;
        if ((n = Arrays.binarySearch(this.a, n)) < 0) {
            return 0;
        }
        return this.b[n];
    }

    public Range getRange() {
        return this.m;
    }

    public int getTotalPopulation() {
        return this.c;
    }

    public float getUpperResidual(int i) {
        int n;
        if (i + 1 > this.a[this.a.length - 1]) {
            return 0.0f;
        }
        int n2 = 0;
        if ((n = Arrays.binarySearch(this.a, (int)(n + true))) < 0) {
            n = -(n + 1);
        }
        while (n < this.a.length) {
            n2 += this.b[n];
            ++n;
        }
        return (float)n2 * 100.0f / (float)this.c;
    }

    public String toString() {
        return "Histogram, range=" + this.m + ", total=" + this.c + ", binWidth=" + this.g + ", centralValue=" + this.l;
    }

    private static float a(float f, float[] fArray, int n) {
        int n2 = (int)(f = (float)(n - 1) * f);
        if (n2 == n - 1) {
            return fArray[n2];
        }
        return fArray[n2] * (1.0f - (f -= (float)n2)) + fArray[n2 + 1] * f;
    }

    private static int[] a(int[] nArray, int n) {
        if (nArray.length == n) {
            return nArray;
        }
        int[] nArray2 = new int[n];
        System.arraycopy(nArray, 0, nArray2, 0, n);
        return nArray2;
    }

    public static class Range {
        private final float a;
        private final float b;

        /*
         * WARNING - void declaration
         */
        public Range(float min, float max) {
            if (min <= max) {
                void var2_2;
                void var1_1;
                this.a = var1_1;
                this.b = var2_2;
                return;
            }
            this.a = Float.NaN;
            this.b = Float.NaN;
        }

        public float getMin() {
            return this.a;
        }

        public float getMax() {
            return this.b;
        }

        public String toString() {
            return "[" + this.a + ", " + this.b + "]";
        }

        public float getRange() {
            if (Float.isInfinite(this.b - this.a)) {
                return Float.NaN;
            }
            return this.b - this.a;
        }
    }
}

