/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.high_d.axis.group;

import com.macrofocus.common.properties.MutableProperty;
import com.macrofocus.common.properties.PropertyEvent;
import com.macrofocus.common.properties.PropertyListener;
import com.macrofocus.common.properties.SimpleProperty;
import com.macrofocus.common.selection.Selection;
import com.macrofocus.common.selection.SingleSelection;
import com.macrofocus.crossplatform.CPFactory;
import com.macrofocus.filter.MutableFilter;
import com.macrofocus.high_d.axis.AxisFactory;
import com.macrofocus.high_d.axis.AxisListener;
import com.macrofocus.high_d.axis.AxisModel;
import com.macrofocus.high_d.axis.group.AbstractAxisGroupModel;
import com.macrofocus.high_d.axis.group.MutableAxisGroupModel;
import com.macrofocus.molap.dataframe.DataFrame;
import com.macrofocus.order.DefaultVisibleOrder;
import com.macrofocus.order.MutableVisibleOrder;
import com.macrofocus.order.OrderEvent;
import com.macrofocus.order.OrderListener;
import java.util.ArrayList;
import java.util.Date;

public class DefaultAxisGroupModel<R, C>
extends AbstractAxisGroupModel<R, C>
implements MutableAxisGroupModel<R, C> {
    private final String name;
    private boolean collapsible;
    private MutableProperty<Boolean> collapsed = new SimpleProperty((Object)Boolean.FALSE);
    private MutableVisibleOrder<AxisModel<R, C>> axisOrder;
    private final AxisListener axisListener = new AxisListener(this){
        private /* synthetic */ DefaultAxisGroupModel this$0;
        {
            void var1_1;
            this.this$0 = var1_1;
        }

        @Override
        public final void axisChanged() {
            this.this$0.fireAxisChanged();
        }
    };

    /*
     * WARNING - void declaration
     */
    private DefaultAxisGroupModel(String name) {
        void var1_1;
        this.name = var1_1;
        this.collapsed.addPropertyListener((PropertyListener)new PropertyListener<Boolean>(this){
            private /* synthetic */ DefaultAxisGroupModel this$0;
            {
                void var1_1;
                this.this$0 = var1_1;
            }

            public final void propertyChanged(PropertyEvent<Boolean> event) {
                this.this$0.fireAxisChanged();
            }
        });
    }

    /*
     * WARNING - void declaration
     */
    public DefaultAxisGroupModel(String name, AxisModel<R, C> ... axisModels) {
        this((String)var1_1);
        void var2_2;
        void var1_1;
        this.axisOrder = new DefaultVisibleOrder((Object[])axisModels);
        this.axisOrder.addOrderListener(new OrderListener<AxisModel<R, C>>(this){
            private /* synthetic */ DefaultAxisGroupModel this$0;
            {
                void var1_1;
                this.this$0 = var1_1;
            }

            public final void orderChanged(OrderEvent<AxisModel<R, C>> event) {
            }

            public final void orderVisibility(OrderEvent<AxisModel<R, C>> event) {
            }

            public final void orderAdded(OrderEvent<AxisModel<R, C>> event) {
                for (AxisModel axisModel : event.getAffected()) {
                    axisModel.addAxisListener(this.this$0.axisListener);
                }
            }

            public final void orderRemoved(OrderEvent<AxisModel<R, C>> event) {
                for (AxisModel axisModel : event.getAffected()) {
                    axisModel.removeAxisListener(this.this$0.axisListener);
                }
            }
        });
        for (void var4_5 : var2_2) {
            var4_5.addAxisListener(this.axisListener);
        }
    }

    /*
     * WARNING - void declaration
     */
    public DefaultAxisGroupModel(CPFactory factory, String name, DataFrame<R, C, ?> dataFrame, DataFrame<?, C, ?> annotationDataFrame, SingleSelection<R> probing, Selection<R> selection, MutableFilter<R> filter) {
        this(name);
        void var2_2;
        ArrayList<AxisModel> groupContent = new ArrayList<AxisModel>();
        AxisFactory axisFactory = new AxisFactory(factory, dataFrame, null, annotationDataFrame, probing, selection, filter);
        for (Object c : dataFrame.columns()) {
            AxisModel axisModel = axisFactory.getAxisModel(c);
            if (axisModel == null) continue;
            axisModel.addAxisListener(this.axisListener);
            groupContent.add(axisModel);
        }
        ArrayList<AxisModel> arrayList = groupContent;
        this.axisOrder = new DefaultVisibleOrder((Object[])arrayList.toArray(new AxisModel[arrayList.size()]));
        int count = 0;
        for (AxisModel axisModel : var2_2) {
            if (count < 10) {
                if (factory.isNumericType(axisModel.getType()) && !axisModel.getInterval().isDegenerate()) {
                    ++count;
                    continue;
                }
                if (factory.isAssignableFrom(Date.class, axisModel.getType()) && !axisModel.getInterval().isDegenerate()) {
                    ++count;
                    continue;
                }
                this.getAxisOrder().setVisible((Object)axisModel, false);
                continue;
            }
            this.getAxisOrder().setVisible((Object)axisModel, true);
        }
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public boolean isCollapsible() {
        return this.collapsible;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void setCollapsible(boolean collapsible) {
        if (this.collapsible != collapsible) {
            void var1_1;
            this.collapsible = var1_1;
            this.fireAxisChanged();
        }
    }

    @Override
    public MutableProperty<Boolean> collapsedProperty() {
        return this.collapsed;
    }

    @Override
    public boolean isCollapsed() {
        return (Boolean)this.collapsed.getValue();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void setCollapsed(boolean collapsed) {
        void var1_1;
        this.collapsed.setValue((Object)((boolean)var1_1));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void add(AxisModel<R, C> axisModel) {
        void var1_1;
        this.axisOrder.add((Object)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void remove(AxisModel<R, C> axisModel) {
        void var1_1;
        this.axisOrder.remove((Object)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public AxisModel<R, C> getAxisModel(String name) {
        for (AxisModel axisModel : this.axisOrder.iterableAll()) {
            void var3_3;
            if (!name.equals(axisModel.getName())) continue;
            return var3_3;
        }
        return null;
    }

    @Override
    public Iterable<AxisModel<R, C>> getAxisModels() {
        return this.axisOrder.iterableAll();
    }

    @Override
    public MutableVisibleOrder<AxisModel<R, C>> getAxisOrder() {
        return this.axisOrder;
    }

    @Override
    public int getVisibleAxisCount() {
        return this.axisOrder.size();
    }

    public String toString() {
        return "Group{name='" + this.name + '\'' + '}';
    }
}

