/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.high_d.filters;

import com.macrofocus.common.properties.EnumProperties;
import com.macrofocus.common.properties.MutableProperties;
import com.macrofocus.common.properties.MutableProperty;
import com.macrofocus.common.properties.PropertiesListener;
import com.macrofocus.common.properties.PropertyEvent;
import com.macrofocus.common.selection.MutableSingleSelection;
import com.macrofocus.common.selection.NullSingleSelection;
import com.macrofocus.common.selection.SelectionEvent;
import com.macrofocus.common.selection.SelectionListener;
import com.macrofocus.common.selection.SingleSelectionEvent;
import com.macrofocus.common.selection.SingleSelectionListener;
import com.macrofocus.crossplatform.CPCanvas;
import com.macrofocus.format.CPFormat;
import com.macrofocus.geom.Point2D;
import com.macrofocus.geom.Rectangle;
import com.macrofocus.geom.Rectangle2D;
import com.macrofocus.geom.Shape;
import com.macrofocus.high_d.filters.AbstractCategoricalFilterComponent;
import com.macrofocus.high_d.filters.BinnedFilterComponent;
import com.macrofocus.high_d.interaction.InteractionMode;
import com.macrofocus.igraphics.CPColor;
import com.macrofocus.igraphics.CPColorFactory;
import com.macrofocus.igraphics.IDrawing;
import com.macrofocus.igraphics.IDrawingListener;
import com.macrofocus.igraphics.IGraphics;
import com.macrofocus.igraphics.colortheme.ColorTheme;
import com.macrofocus.igraphics.colortheme.LightColorTheme;
import com.macrofocus.molap.subset.DimensionEvent;
import com.macrofocus.molap.subset.DimensionListener;
import com.macrofocus.molap.subset.DistributionDimension;
import com.macrofocus.molap.subset.Group;
import com.macrofocus.molap.subset.Reducer;
import com.macrofocus.palette.Palette;
import com.macrofocus.utils.RandomAccessIterable;
import com.macrofocus.utils.RandomAccessIterables;
import com.macrofocus.utils.UniversalComparator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

public abstract class AbstractBinnedFilterComponent<Component, Color, Format, Row, C, V, Bin>
implements BinnedFilterComponent<Component, Color, Format> {
    protected final MutableProperties<BinnedFilterComponent.PropertyType> properties = new EnumProperties(BinnedFilterComponent.PropertyType.class);
    protected final CPColorFactory<Color> factory;
    protected final DistributionDimension<Row, V, Bin> dimension;
    protected final Group group;
    protected List<Bin> activeValues;
    protected String search = null;
    protected CPFormat format;
    private double textHeight = -1.0;
    protected MutableSingleSelection<Bin> probing = new NullSingleSelection();
    private final DimensionListener dimensionListener;
    private final PropertiesListener propertiesListener;

    /*
     * WARNING - void declaration
     */
    public AbstractBinnedFilterComponent(CPColorFactory<Color> factory, DistributionDimension<Row, V, Bin> dimension, Reducer<Row, Bin> reducer) {
        void var2_2;
        void var1_1;
        void var3_3;
        this.properties.createProperty((Object)BinnedFilterComponent.PropertyType.Orientation, (Object)BinnedFilterComponent.Orientation.Vertical);
        this.properties.createProperty((Object)BinnedFilterComponent.PropertyType.MinItemSize, (Object)18);
        this.properties.createProperty((Object)BinnedFilterComponent.PropertyType.MaxItemSize, (Object)1000);
        this.properties.createProperty((Object)BinnedFilterComponent.PropertyType.GapSize, (Object)2);
        this.properties.createProperty((Object)BinnedFilterComponent.PropertyType.Proportional, (Object)Boolean.FALSE);
        this.properties.createProperty((Object)BinnedFilterComponent.PropertyType.ShowFiltered, (Object)Boolean.TRUE);
        this.properties.createProperty((Object)BinnedFilterComponent.PropertyType.Sort, (Object)Boolean.FALSE);
        this.properties.createProperty((Object)BinnedFilterComponent.PropertyType.ShowAxis, (Object)Boolean.FALSE);
        this.properties.createProperty((Object)BinnedFilterComponent.PropertyType.Filterable, (Object)Boolean.TRUE);
        this.properties.createProperty((Object)BinnedFilterComponent.PropertyType.ShowCumulative, (Object)Boolean.FALSE);
        this.properties.createProperty((Object)BinnedFilterComponent.PropertyType.ShowDistribution, (Object)Boolean.TRUE);
        this.properties.createProperty((Object)BinnedFilterComponent.PropertyType.NullLabel, (Object)"(null)");
        this.properties.createProperty((Object)BinnedFilterComponent.PropertyType.InteractionMode, (Object)InteractionMode.Filter);
        this.dimensionListener = new DimensionListener(this){
            private /* synthetic */ AbstractBinnedFilterComponent this$0;
            {
                void var1_1;
                this.this$0 = var1_1;
            }

            public final void dimensionChanged(DimensionEvent event) {
                this.this$0.activeValues = null;
            }

            public final void selectedCountChanged() {
            }
        };
        this.propertiesListener = new PropertiesListener(this){
            private /* synthetic */ AbstractBinnedFilterComponent this$0;
            {
                void var1_1;
                this.this$0 = var1_1;
            }

            public final void propertyChanged(Object name, PropertyEvent event) {
                this.this$0.activeValues = null;
            }
        };
        this.factory = factory;
        this.dimension = dimension;
        this.group = reducer != null ? dimension.getGroup((Reducer)var3_3) : null;
        this.properties.createProperty((Object)BinnedFilterComponent.PropertyType.ColorTheme, (Object)new LightColorTheme((CPColorFactory)var1_1));
        var2_2.addWeakDimensionListener(this.dimensionListener);
        this.properties.addPropertiesListener(this.propertiesListener);
    }

    @Override
    public MutableProperty<ColorTheme<Color>> getColorTheme() {
        return this.properties.getProperty((Object)BinnedFilterComponent.PropertyType.ColorTheme);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void setColorTheme(MutableProperty<ColorTheme<Color>> colorTheme) {
        void var1_1;
        this.properties.replaceProperty((Object)BinnedFilterComponent.PropertyType.ColorTheme, (MutableProperty)var1_1);
    }

    public DistributionDimension<Row, V, Bin> getDimension() {
        return this.dimension;
    }

    public Group getGroup() {
        return this.group;
    }

    @Override
    public MutableProperty<BinnedFilterComponent.Orientation> getOrientation() {
        return this.properties.getProperty((Object)BinnedFilterComponent.PropertyType.Orientation);
    }

    @Override
    public MutableProperty<Integer> getMinItemSize() {
        return this.properties.getProperty((Object)BinnedFilterComponent.PropertyType.MinItemSize);
    }

    @Override
    public MutableProperty<Integer> getMaxItemSize() {
        return this.properties.getProperty((Object)BinnedFilterComponent.PropertyType.MaxItemSize);
    }

    @Override
    public MutableProperty<Integer> getGapSize() {
        return this.properties.getProperty((Object)BinnedFilterComponent.PropertyType.GapSize);
    }

    @Override
    public MutableProperty<Boolean> getProportional() {
        return this.properties.getProperty((Object)BinnedFilterComponent.PropertyType.Proportional);
    }

    @Override
    public MutableProperty<Boolean> getShowFiltered() {
        return this.properties.getProperty((Object)BinnedFilterComponent.PropertyType.ShowFiltered);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void setShowFiltered(MutableProperty<Boolean> showFiltered) {
        void var1_1;
        this.properties.replaceProperty((Object)BinnedFilterComponent.PropertyType.ShowFiltered, (MutableProperty)var1_1);
    }

    @Override
    public MutableProperty<Boolean> getSort() {
        return this.properties.getProperty((Object)BinnedFilterComponent.PropertyType.Sort);
    }

    @Override
    public MutableProperty<Boolean> getShowAxis() {
        return this.properties.getProperty((Object)BinnedFilterComponent.PropertyType.ShowAxis);
    }

    @Override
    public MutableProperty<Boolean> getShowCumulative() {
        return this.properties.getProperty((Object)BinnedFilterComponent.PropertyType.ShowCumulative);
    }

    @Override
    public MutableProperty<Boolean> getFilterable() {
        return this.properties.getProperty((Object)BinnedFilterComponent.PropertyType.Filterable);
    }

    @Override
    public MutableProperty<Boolean> getShowDistribution() {
        return this.properties.getProperty((Object)BinnedFilterComponent.PropertyType.ShowDistribution);
    }

    @Override
    public MutableProperty<String> getNullLabel() {
        return this.properties.getProperty((Object)BinnedFilterComponent.PropertyType.NullLabel);
    }

    @Override
    public MutableProperty<InteractionMode> getInteractionMode() {
        return this.properties.getProperty((Object)BinnedFilterComponent.PropertyType.InteractionMode);
    }

    public String getSearch() {
        return this.search;
    }

    /*
     * WARNING - void declaration
     */
    public void setSearch(String search) {
        if (this.search != search) {
            void var1_1;
            this.search = var1_1;
            this.activeValues = null;
        }
    }

    /*
     * WARNING - void declaration
     */
    protected List<Bin> getValues() {
        if (this.activeValues == null) {
            void var1_1;
            ArrayList activeValues = (Boolean)this.getShowFiltered().getValue() == false ? RandomAccessIterables.toArrayList((RandomAccessIterable)this.dimension.getActiveBins()) : RandomAccessIterables.toArrayList((RandomAccessIterable)this.dimension.getBins());
            if (this.search != null) {
                void var2_2;
                ArrayList searchedValues = new ArrayList();
                String search = this.search != null ? this.search.toLowerCase() : null;
                for (Object value : activeValues) {
                    String s = value != null ? value.toString().toLowerCase() : null;
                    if (s == null || !s.contains(search)) continue;
                    searchedValues.add(value);
                }
                activeValues = var2_2;
            }
            if (((Boolean)this.getSort().getValue()).booleanValue()) {
                activeValues = new ArrayList(activeValues);
                Collections.sort(activeValues, new Comparator<Bin>(this){
                    private /* synthetic */ AbstractBinnedFilterComponent this$0;
                    {
                        void var1_1;
                        this.this$0 = var1_1;
                    }

                    /*
                     * WARNING - void declaration
                     */
                    @Override
                    public final int compare(Bin o1, Bin o2) {
                        void var1_1;
                        void var2_2;
                        return Double.compare(this.this$0.getActiveCount(var2_2), this.this$0.getActiveCount(var1_1));
                    }
                });
            } else {
                Collections.sort(activeValues, new UniversalComparator());
            }
            this.activeValues = var1_1;
        }
        return this.activeValues;
    }

    /*
     * WARNING - void declaration
     */
    protected double getCount(Bin o2) {
        void var1_1;
        if (this.group != null) {
            throw new UnsupportedOperationException("Not yet implemented");
        }
        return this.dimension.getDensity((Object)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    protected double getActiveCount(Bin o2) {
        void var1_1;
        if (this.group != null) {
            return this.group.getValue(o2);
        }
        return this.dimension.getActiveDensity((Object)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    protected double getSelectedCount(Bin o2) {
        void var1_1;
        if (this.group != null) {
            throw new UnsupportedOperationException("Not yet implemented");
        }
        return this.dimension.getSelectionDensity((Object)var1_1);
    }

    protected double getMax() {
        if (this.group != null) {
            if (((Boolean)this.getProportional().getValue()).booleanValue()) {
                return this.group.getActiveMaxValue();
            }
            return this.group.getMaxValue();
        }
        if (((Boolean)this.getProportional().getValue()).booleanValue()) {
            return this.dimension.getMaxActiveDensity();
        }
        return this.dimension.getMaxDensity();
    }

    /*
     * WARNING - void declaration
     */
    protected long computeIdealHeight(int actualWidth) {
        void var1_1;
        return Math.min((long)((Integer)this.getMaxItemSize().getValue()).intValue() * (long)this.getValues().size() - (long)((Integer)this.getGapSize().getValue()).intValue(), Math.max((long)((Integer)this.getMinItemSize().getValue()).intValue() * (long)this.getValues().size() - (long)((Integer)this.getGapSize().getValue()).intValue(), (long)var1_1));
    }

    /*
     * WARNING - void declaration
     */
    protected AbstractCategoricalFilterComponent.State getState(Bin value) {
        boolean bl = !this.dimension.getFilterExact().isActive() || this.dimension.getFilterExact().isSelected(value);
        if (bl && this.dimension.getActiveDensity(value) > 0.0) {
            if (this.probing.isActive() && this.probing.isSelected(value)) {
                if (this.dimension.getFilterExact().isSelected(value)) {
                    return AbstractCategoricalFilterComponent.State.ProbedSelected;
                }
                return AbstractCategoricalFilterComponent.State.Probed;
            }
            if (this.dimension.getFilterExact().isSelected(value)) {
                return AbstractCategoricalFilterComponent.State.Selected;
            }
            return AbstractCategoricalFilterComponent.State.Active;
        }
        if (this.dimension.getActiveDensity(value) > 0.0) {
            void var1_1;
            if (this.probing.isActive() && this.probing.isSelected((Object)var1_1)) {
                return AbstractCategoricalFilterComponent.State.ProbedSelectable;
            }
            return AbstractCategoricalFilterComponent.State.Selectable;
        }
        return AbstractCategoricalFilterComponent.State.Inactive;
    }

    /*
     * Unable to fully structure code
     */
    public void select(CPCanvas.MouseEvent e, boolean continuous) {
        block12: {
            block14: {
                block15: {
                    block13: {
                        if (!((Boolean)this.getFilterable().getValue()).booleanValue() || (index = this.getIndex(y = this.getOrientation().getValue() == BinnedFilterComponent.Orientation.Horizontal ? e.getY() : e.getX())) < 0 || index >= this.getValues().size() || !(var4_6 = this.dimension.getActiveDensity(value = this.getValues().get(index)) > 0.0)) break block12;
                        interactionMode = (InteractionMode)this.getInteractionMode().getValue();
                        if (e.isAltKeyDown()) {
                            switch (4.$SwitchMap$com$macrofocus$high_d$interaction$InteractionMode[interactionMode.ordinal()]) {
                                case 1: {
                                    v0 = InteractionMode.Filter;
                                    break;
                                }
                                case 2: {
                                    v0 = InteractionMode.Filter;
                                    break;
                                }
                                case 3: {
                                    v0 = interactionMode = this.dimension.getSelection() != null ? InteractionMode.Selection : InteractionMode.Toggle;
                                }
                            }
                        }
                        if (interactionMode != InteractionMode.Selection) break block13;
                        if (this.dimension.getSelection() != null) {
                            if (e.isMenuShortcutKeyDown()) {
                                this.dimension.getSelection().setSelectedIterableState(this.dimension.getRows(value), true);
                                return;
                            }
                            this.dimension.getSelection().setSelectedIterable(this.dimension.getRows(value));
                            return;
                        }
                        break block12;
                    }
                    if (var2_3 == false && this.dimension.getFilterExact().isSelected(value) && this.dimension.getFilterExact().getSelectedCount() == 1) {
                        this.dimension.filterAll();
                        return;
                    }
                    if (interactionMode == InteractionMode.Filter && !e.isMenuShortcutKeyDown() || interactionMode == InteractionMode.Toggle && e.isMenuShortcutKeyDown()) {
                        this.dimension.filterExact(new Object[]{value});
                        return;
                    }
                    e = this.dimension.getFilterExact().isActive() == false;
                    if (!e) break block14;
                    if (interactionMode != InteractionMode.Filter) break block15;
                    this.dimension.getFilterExact().setSelectedIterable(this.getValues());
                    v1 = this.dimension.getFilterExact();
                    v2 = value;
                    ** GOTO lbl-1000
                }
                this.dimension.filterExact(new Object[]{value});
                return;
            }
            currentlySelected = this.dimension.getFilterExact().isSelected(value);
            v1 = this.dimension.getFilterExact();
            v2 = var3_5;
            if (var1_2 == false) {
                v3 = true;
            } else lbl-1000:
            // 2 sources

            {
                v3 = false;
            }
            v1.setSelectedState(v2, v3);
        }
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    public void probe(CPCanvas.MouseEvent e, boolean continuous) {
        int y = this.getOrientation().getValue() == BinnedFilterComponent.Orientation.Horizontal ? e.getY() : e.getX();
        int index = this.getIndex(y);
        if (index >= 0 && index < this.getValues().size()) {
            Bin value = this.getValues().get(index);
            boolean bl = this.dimension.getActiveDensity(value) > 0.0;
            if (bl) {
                void var1_3;
                this.probing.setSelected((Object)var1_3);
                return;
            }
            this.probing.clearSelection();
            return;
        }
        this.probing.clearSelection();
    }

    /*
     * WARNING - void declaration
     */
    private int getIndex(int y) {
        void var3_3;
        void var1_1;
        void var2_2;
        int height = this.getOrientation().getValue() == BinnedFilterComponent.Orientation.Horizontal ? this.getHeight() : this.getWidth();
        long idealHeight = this.computeIdealHeight((int)var2_2);
        return (int)((long)var1_1 * (long)this.getValues().size() / var3_3);
    }

    public abstract int getWidth();

    public abstract int getHeight();

    /*
     * WARNING - void declaration
     */
    @Override
    public void setFormat(CPFormat format) {
        void var1_1;
        this.format = var1_1;
    }

    static /* synthetic */ double access$000(AbstractBinnedFilterComponent x0, IGraphics x1) {
        AbstractBinnedFilterComponent abstractBinnedFilterComponent;
        AbstractBinnedFilterComponent abstractBinnedFilterComponent2 = x0;
        if (abstractBinnedFilterComponent.textHeight <= 0.0) {
            Rectangle2D rectangle2D;
            rectangle2D = rectangle2D.getStringBounds("Macrofocus");
            abstractBinnedFilterComponent2.textHeight = rectangle2D.getHeight();
        }
        return abstractBinnedFilterComponent2.textHeight;
    }

    protected class DefaultKeyListener
    implements CPCanvas.KeyListener {
        private final DistributionDimension<Row, V, Bin> dimension;
        private /* synthetic */ AbstractBinnedFilterComponent this$0;

        /*
         * WARNING - void declaration
         */
        public DefaultKeyListener(AbstractBinnedFilterComponent this$0, DistributionDimension<Row, V, Bin> dimension) {
            void var2_2;
            void var1_1;
            this.this$0 = var1_1;
            this.dimension = var2_2;
        }

        public void keyTyped(CPCanvas.KeyEvent e) {
        }

        /*
         * WARNING - void declaration
         */
        public void keyPressed(CPCanvas.KeyEvent e) {
            switch (e.getKeyCode()) {
                case 39: {
                    int next;
                    if (!((Boolean)this.this$0.getFilterable().getValue()).booleanValue() || this.dimension.getFilterExact().isActive() || this.dimension.getFilterExact().getSelectedCount() != 1) break;
                    if (this.dimension.getFilterExact().isActive()) {
                        Object first3 = this.dimension.getFilterExact().iterator().next();
                        int first2 = this.this$0.getValues().indexOf(first3);
                        next = first2 + 1;
                    } else {
                        next = 0;
                    }
                    if (next < this.this$0.getValues().size()) {
                        this.dimension.getFilterExact().setSelected(this.this$0.getValues().get(next));
                    }
                    return;
                }
                case 37: {
                    void var1_3;
                    int next;
                    if (!((Boolean)this.this$0.getFilterable().getValue()).booleanValue() || this.dimension.getFilterExact().getSelectedCount() != 1) break;
                    if (this.dimension.getFilterExact().isActive()) {
                        first3 = this.dimension.getFilterExact().iterator().next();
                        int first3 = this.this$0.getValues().indexOf(first3);
                        next = first3 - 1;
                    } else {
                        next = this.this$0.getValues().size() - 1;
                    }
                    if (next < 0) break;
                    this.dimension.getFilterExact().setSelected(this.this$0.getValues().get((int)var1_3));
                }
            }
        }

        public void keyReleased(CPCanvas.KeyEvent e) {
        }
    }

    public class DefaultMouseMotionListener
    implements CPCanvas.MouseMotionListener {
        private /* synthetic */ AbstractBinnedFilterComponent this$0;

        /*
         * WARNING - void declaration
         */
        public DefaultMouseMotionListener(AbstractBinnedFilterComponent this$0) {
            void var1_1;
            this.this$0 = var1_1;
        }

        /*
         * WARNING - void declaration
         */
        public void mouseDragged(CPCanvas.MouseEvent e) {
            void var1_1;
            this.this$0.select((CPCanvas.MouseEvent)var1_1, true);
        }

        /*
         * WARNING - void declaration
         */
        public void mouseMoved(CPCanvas.MouseEvent e) {
            void var1_1;
            this.this$0.probe((CPCanvas.MouseEvent)var1_1, true);
        }
    }

    public class DefaultMouseListener
    implements CPCanvas.MouseListener {
        private /* synthetic */ AbstractBinnedFilterComponent this$0;

        /*
         * WARNING - void declaration
         */
        public DefaultMouseListener(AbstractBinnedFilterComponent this$0) {
            void var1_1;
            this.this$0 = var1_1;
        }

        public void mouseClicked(CPCanvas.MouseEvent e) {
        }

        /*
         * WARNING - void declaration
         */
        public void mousePressed(CPCanvas.MouseEvent e) {
            void var1_1;
            this.this$0.select((CPCanvas.MouseEvent)var1_1, false);
        }

        public void mouseReleased(CPCanvas.MouseEvent e) {
        }

        /*
         * WARNING - void declaration
         */
        public void mouseEntered(CPCanvas.MouseEvent e) {
            void var1_1;
            this.this$0.probe((CPCanvas.MouseEvent)var1_1, true);
        }

        public void mouseExited(CPCanvas.MouseEvent e) {
            this.this$0.probing.clearSelection();
        }
    }

    private static final class CumulativeShape {
        private final Rectangle2D.Double shape;
        private final double sum;

        /*
         * WARNING - void declaration
         */
        public CumulativeShape(Rectangle2D.Double shape, double sum) {
            void var2_2;
            void var1_1;
            this.shape = var1_1;
            this.sum = var2_2;
        }

        public final Rectangle2D.Double getShape() {
            return this.shape;
        }

        public final double getSum() {
            return this.sum;
        }
    }

    protected class FilterIDrawing
    implements IDrawing {
        private int width;
        private int height;
        private SelectionListener<Bin> selectionListener;
        private /* synthetic */ AbstractBinnedFilterComponent this$0;

        /*
         * WARNING - void declaration
         */
        public FilterIDrawing(AbstractBinnedFilterComponent this$0) {
            void var1_1;
            this.this$0 = var1_1;
        }

        public boolean isActive() {
            return true;
        }

        /*
         * WARNING - void declaration
         */
        public void draw(IGraphics g, Point2D point, double width, double height2, Rectangle clipBounds) {
            int clipY2;
            this.width = (int)width;
            this.height = (int)height2;
            CPColor background = ((ColorTheme)this.this$0.getColorTheme().getValue()).getBackground();
            if (background != null) {
                g.setColor(background);
                g.fillRectangle2D((Rectangle2D)new Rectangle2D.Double(0.0, 0.0, width, height2));
            }
            g.setTextBaseline(IGraphics.TextBaseline.Middle);
            int clipY1 = this.this$0.getOrientation().getValue() == BinnedFilterComponent.Orientation.Horizontal ? clipBounds.y : clipBounds.x;
            int n = clipY2 = this.this$0.getOrientation().getValue() == BinnedFilterComponent.Orientation.Horizontal ? clipBounds.y + clipBounds.height : clipBounds.x + clipBounds.width;
            if (this.this$0.getOrientation().getValue() == BinnedFilterComponent.Orientation.Vertical) {
                FilterIDrawing height2 = this;
                int w2 = height2.width / 2;
                height2 = this;
                int h2 = height2.height / 2;
                g.translate(w2, h2);
                g.rotate(-1.5707963267948966);
                g.translate(-h2, -w2);
            }
            int start = Math.max(0, this.getIndex(clipY1));
            int end = Math.min(this.getIndex(clipY2), this.this$0.getValues().size() - 1);
            CumulativeShape previous = null;
            if (((Boolean)this.this$0.getShowCumulative().getValue()).booleanValue()) {
                for (int i = 0; i < start; ++i) {
                    Object value = this.this$0.getValues().get(i);
                    double count = this.this$0.getActiveCount(value);
                    previous = this.getCumulativeShape(i, count, previous);
                }
            }
            int probedIndex = -1;
            for (int i = start; i <= end; ++i) {
                Object value = this.this$0.getValues().get(i);
                previous = this.draw(g, i, value, previous);
                if (!this.this$0.probing.isActive() || !this.this$0.probing.isSelected(value)) continue;
                probedIndex = i;
            }
            if (probedIndex >= 0) {
                void var3_6;
                void var1_1;
                Object value = this.this$0.getValues().get(probedIndex);
                this.draw((IGraphics)var1_1, (int)var3_6, value, null);
            }
        }

        /*
         * WARNING - void declaration
         */
        private int getIndex(int y) {
            void var3_5;
            void var1_1;
            void var2_4;
            int n;
            if (this.this$0.getOrientation().getValue() == BinnedFilterComponent.Orientation.Horizontal) {
                FilterIDrawing filterIDrawing = this;
                n = filterIDrawing.height;
            } else {
                FilterIDrawing filterIDrawing = this;
                n = filterIDrawing.width;
            }
            int height = n;
            long idealHeight = this.this$0.computeIdealHeight((int)var2_4);
            return (int)((long)var1_1 * (long)this.this$0.getValues().size() / var3_5);
        }

        /*
         * WARNING - void declaration
         */
        public void addIDrawingListener(IDrawingListener listener) {
            void var1_1;
            this.this$0.dimension.addDimensionListener(new DimensionListener<Row>(this, listener){
                private /* synthetic */ IDrawingListener val$listener;
                {
                    this.val$listener = iDrawingListener;
                }

                public final void dimensionChanged(DimensionEvent<Row> event) {
                    this.val$listener.iDrawingChanged();
                }

                public final void selectedCountChanged() {
                    this.val$listener.iDrawingChanged();
                }
            });
            this.selectionListener = new SelectionListener<Bin>(this, listener){
                private /* synthetic */ IDrawingListener val$listener;
                {
                    this.val$listener = iDrawingListener;
                }

                public final void selectionChanged(SelectionEvent<Bin> event) {
                    this.val$listener.iDrawingChanged();
                }
            };
            this.this$0.dimension.getFilterExact().addWeakSelectionListener(this.selectionListener);
            this.this$0.probing.addSingleSelectionListener(new SingleSelectionListener<Bin>(this, (IDrawingListener)var1_1){
                private /* synthetic */ IDrawingListener val$listener;
                {
                    this.val$listener = iDrawingListener;
                }

                public final void selectionChanged(SingleSelectionEvent<Bin> event) {
                    this.val$listener.iDrawingChanged();
                }
            });
        }

        public void removeIDrawingListener(IDrawingListener listener) {
            throw new UnsupportedOperationException("To implement");
        }

        /*
         * WARNING - void declaration
         */
        private CumulativeShape draw(IGraphics g2, int i2, Bin value, CumulativeShape previous) {
            double d;
            CPColor labelColor;
            Object fillColor;
            CPColor outlineColor;
            if (!((Boolean)this.this$0.getProportional().getValue()).booleanValue()) {
                CumulativeShape unfilteredShape = this.getCumulativeShape(i2, this.this$0.getCount(value), null);
                g2.setColor(this.this$0.factory.createRGBColor(245, 245, 245));
                g2.fillShape((Shape)unfilteredShape.getShape());
            }
            CumulativeShape cumulativeShape = this.getCumulativeShape(i2, this.this$0.getActiveCount(value), previous);
            Rectangle2D.Double shape = cumulativeShape.getShape();
            AbstractCategoricalFilterComponent.State state = this.this$0.getState(value);
            Palette palette = ((ColorTheme)this.this$0.getColorTheme().getValue()).getPalette();
            switch (state) {
                case Active: {
                    outlineColor = null;
                    fillColor = (Boolean)this.this$0.getShowDistribution().getValue() != false ? palette.getColor(0.3) : null;
                    labelColor = palette.getColor(0.7);
                    break;
                }
                case Probed: {
                    outlineColor = ((ColorTheme)this.this$0.getColorTheme().getValue()).getProbing();
                    fillColor = (Boolean)this.this$0.getShowDistribution().getValue() != false ? labelColor.getColor(0.3) : null;
                    labelColor = ((ColorTheme)this.this$0.getColorTheme().getValue()).getProbing();
                    break;
                }
                case Selected: {
                    outlineColor = labelColor.getColor(1.0);
                    fillColor = (Boolean)this.this$0.getShowDistribution().getValue() != false ? labelColor.getColor(0.55) : ((ColorTheme)this.this$0.getColorTheme().getValue()).getSelection();
                    labelColor = labelColor.getColor(1.0);
                    break;
                }
                case ProbedSelected: {
                    outlineColor = ((ColorTheme)this.this$0.getColorTheme().getValue()).getProbing();
                    fillColor = (Boolean)this.this$0.getShowDistribution().getValue() != false ? labelColor.getColor(0.55) : ((ColorTheme)this.this$0.getColorTheme().getValue()).getSelection();
                    labelColor = ((ColorTheme)this.this$0.getColorTheme().getValue()).getProbing();
                    break;
                }
                case Selectable: {
                    if (((Boolean)this.this$0.getShowDistribution().getValue()).booleanValue()) {
                        outlineColor = labelColor.getColor(0.5);
                        fillColor = labelColor.getColor(0.1);
                    } else {
                        outlineColor = null;
                        fillColor = null;
                    }
                    labelColor = labelColor.getColor(0.3);
                    break;
                }
                case ProbedSelectable: {
                    outlineColor = ((ColorTheme)this.this$0.getColorTheme().getValue()).getProbing();
                    fillColor = (Boolean)this.this$0.getShowDistribution().getValue() != false ? labelColor.getColor(0.1) : null;
                    labelColor = labelColor.getColor(0.7);
                    break;
                }
                case Inactive: {
                    outlineColor = null;
                    fillColor = (Boolean)this.this$0.getShowDistribution().getValue() != false ? labelColor.getColor(0.05) : null;
                    labelColor = labelColor.getColor(0.2);
                    break;
                }
                default: {
                    outlineColor = this.this$0.factory.createRGBColor(255, 0, 0);
                    fillColor = (Boolean)this.this$0.getShowDistribution().getValue() != false ? this.this$0.factory.getGray() : null;
                    labelColor = null;
                }
            }
            if (fillColor != null) {
                g2.setColor(fillColor);
                g2.fillShape((Shape)shape);
            }
            if (outlineColor != null) {
                g2.setColor(outlineColor);
                g2.drawShape((Shape)shape);
            }
            double selectedCount = this.this$0.getSelectedCount(value);
            if (d > 0.0) {
                CumulativeShape selectedShape = this.getCumulativeShape(i2, selectedCount, null);
                g2.setColor(((ColorTheme)this.this$0.getColorTheme().getValue()).getSelection());
                g2.fillShape((Shape)selectedShape.getShape());
            }
            if (((Boolean)this.this$0.getShowCumulative().getValue()).booleanValue() && previous != null) {
                void var2_5;
                int n;
                g2.setColor(((ColorTheme)this.this$0.getColorTheme().getValue()).getVisiblePalette().getColor(0.75));
                double maxCount = this.getSum();
                if (this.this$0.getOrientation().getValue() == BinnedFilterComponent.Orientation.Horizontal) {
                    FilterIDrawing i2 = this;
                    n = i2.width - 1;
                } else {
                    FilterIDrawing i2 = this;
                    n = i2.height - 1;
                }
                int fullX = n;
                double x1 = Math.max(1.0, (double)fullX * previous.getSum() / maxCount);
                double x2 = Math.max(1.0, (double)var2_5 * cumulativeShape.getSum() / maxCount);
                g2.drawLine((int)x1, (int)previous.getShape().getCenterY(), (int)x2, (int)shape.getCenterY());
            }
            if (labelColor != null) {
                void var3_6;
                String text;
                g2.setColor(labelColor);
                if (this.this$0.format != null) {
                    text = value != null ? this.this$0.format.formatHtml(value, true) : (String)this.this$0.getNullLabel().getValue();
                } else {
                    String string = text = value != null ? value.toString() : (String)this.this$0.getNullLabel().getValue();
                }
                if (shape.getHeight() >= AbstractBinnedFilterComponent.access$000(this.this$0, g2) || this.this$0.probing.isActive() && this.this$0.probing.isSelected((Object)var3_6)) {
                    void var1_1;
                    var1_1.drawString(text, 2.0f, (float)(shape.getY() + shape.getHeight() / 2.0));
                }
            }
            return cumulativeShape;
        }

        /*
         * WARNING - void declaration
         */
        private CumulativeShape getCumulativeShape(int i, double count, CumulativeShape previous) {
            void var2_2;
            void var1_1;
            double width;
            int fullX;
            int n;
            int n2;
            FilterIDrawing filterIDrawing;
            if (this.this$0.getOrientation().getValue() == BinnedFilterComponent.Orientation.Horizontal) {
                filterIDrawing = this;
                n2 = filterIDrawing.height - 1;
            } else {
                filterIDrawing = this;
                n2 = filterIDrawing.width - 1;
            }
            int fullY = n2;
            float y1 = (float)i * (float)fullY / (float)this.this$0.getValues().size();
            float y2 = (float)(i + 1) * (float)fullY / (float)this.this$0.getValues().size();
            if (this.this$0.getOrientation().getValue() == BinnedFilterComponent.Orientation.Horizontal) {
                filterIDrawing = this;
                n = filterIDrawing.width - 1;
            } else {
                filterIDrawing = this;
                n = fullX = filterIDrawing.height - 1;
            }
            if (((Boolean)this.this$0.getShowDistribution().getValue()).booleanValue()) {
                double maxCount = this.getMax();
                width = Math.max(1.0, (double)fullX * count / maxCount);
            } else {
                width = Math.max(1, fullX);
            }
            float height = Math.max(1.0f, y2 - y1 - (float)(var1_1 < this.this$0.getValues().size() - 1 ? (Integer)this.this$0.getGapSize().getValue() : 0));
            return new CumulativeShape(new Rectangle2D.Double(0.0, (double)y1, width, (double)height), previous != null ? previous.getSum() + count : var2_2);
        }

        private double getSum() {
            if (this.this$0.group != null) {
                if (((Boolean)this.this$0.getProportional().getValue()).booleanValue()) {
                    return (float)this.this$0.group.getActiveSumValue();
                }
                return (float)this.this$0.group.getSumValue();
            }
            if (((Boolean)this.this$0.getProportional().getValue()).booleanValue()) {
                return (float)this.this$0.dimension.getSumActiveDensity();
            }
            return (float)this.this$0.dimension.getSumDensity();
        }

        private double getMax() {
            if (this.this$0.group != null) {
                if (((Boolean)this.this$0.getProportional().getValue()).booleanValue()) {
                    return (float)this.this$0.group.getActiveMaxValue();
                }
                return (float)this.this$0.group.getMaxValue();
            }
            if (((Boolean)this.this$0.getProportional().getValue()).booleanValue()) {
                return (float)this.this$0.dimension.getMaxActiveDensity();
            }
            return (float)this.this$0.dimension.getMaxDensity();
        }
    }

    protected static enum State {
        Active,
        Probed,
        Selected,
        ProbedSelected,
        Selectable,
        ProbedSelectable,
        Inactive;

    }
}

