/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.margin;

import com.jidesoft.margin.AbstractMarginSupport;
import com.jidesoft.margin.AbstractRowMarginSupport;
import com.jidesoft.margin.MarginSupport;
import java.awt.Point;
import java.awt.Rectangle;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JList;
import javax.swing.JScrollPane;
import javax.swing.ListModel;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;

public class ListRowMarginSupport
extends AbstractRowMarginSupport {
    protected JList _list;
    private ListDataListener c;
    private PropertyChangeListener d;

    public ListRowMarginSupport(JList jList, JScrollPane jScrollPane) {
        super(jScrollPane);
        this._list = jList;
    }

    @Override
    public int getRowCount() {
        return this._list.getModel().getSize();
    }

    @Override
    public void scrollTo(int n2, int n3, boolean bl) {
        if (bl) {
            this._list.getSelectionModel().setSelectionInterval(Math.min(n2, n3), Math.max(n2, n3));
        }
        this._list.scrollRectToVisible(this._list.getCellBounds(n3, n3));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public int getRowHeight(int n2) {
        Rectangle rectangle;
        int[] nArray = AbstractMarginSupport.b();
        Rectangle rectangle2 = rectangle = this._list.getCellBounds(n2, n2);
        if (nArray != null) {
            if (rectangle2 == null) return -1;
            rectangle2 = rectangle;
        }
        int n3 = rectangle2.height;
        return n3;
    }

    @Override
    public int positionToRow(int n2) {
        int n3 = this.getViewPosition();
        return this._list.locationToIndex(new Point(0, n3 + n2));
    }

    @Override
    public int rowToPosition(int n2) {
        Point point = this._list.indexToLocation(n2);
        if (point != null) {
            int n3 = this.getViewPosition();
            return point.y - n3;
        }
        return Integer.MIN_VALUE;
    }

    @Override
    public void installListeners(MarginSupport.RepaintCallback repaintCallback, final MarginSupport.ModelChangedCallback modelChangedCallback) {
        block8: {
            ListRowMarginSupport listRowMarginSupport;
            int[] nArray;
            block7: {
                nArray = AbstractMarginSupport.b();
                listRowMarginSupport = this;
                if (nArray == null) break block7;
                super.installListeners(repaintCallback, modelChangedCallback);
                if (modelChangedCallback == null) break block8;
                listRowMarginSupport = this;
            }
            if (nArray != null) {
                if (listRowMarginSupport.c == null) {
                    this.c = new ListDataListener(){

                        @Override
                        public void intervalAdded(ListDataEvent listDataEvent) {
                            modelChangedCallback.modelChanged(listDataEvent);
                        }

                        @Override
                        public void intervalRemoved(ListDataEvent listDataEvent) {
                            modelChangedCallback.modelChanged(listDataEvent);
                        }

                        @Override
                        public void contentsChanged(ListDataEvent listDataEvent) {
                            modelChangedCallback.modelChanged(listDataEvent);
                        }
                    };
                }
                listRowMarginSupport = this;
            }
            if (nArray != null) {
                if (listRowMarginSupport.d == null) {
                    this.d = new PropertyChangeListener(){

                        @Override
                        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                            Object object;
                            Object object2;
                            int[] nArray = AbstractMarginSupport.b();
                            Object object3 = object2 = propertyChangeEvent.getOldValue();
                            if (nArray != null) {
                                if (object3 instanceof ListModel) {
                                    ((ListModel)object2).removeListDataListener(ListRowMarginSupport.this.c);
                                }
                                object3 = object = propertyChangeEvent.getNewValue();
                            }
                            if (nArray != null) {
                                if (object instanceof ListModel) {
                                    ((ListModel)object).addListDataListener(ListRowMarginSupport.this.c);
                                }
                                modelChangedCallback.modelChanged(propertyChangeEvent);
                            }
                        }
                    };
                }
                this._list.addPropertyChangeListener("model", this.d);
                listRowMarginSupport = this;
            }
            listRowMarginSupport._list.getModel().addListDataListener(this.c);
        }
    }

    @Override
    public void uninstallListeners(MarginSupport.RepaintCallback repaintCallback, MarginSupport.ModelChangedCallback modelChangedCallback) {
        int[] nArray = AbstractMarginSupport.b();
        ListRowMarginSupport listRowMarginSupport = this;
        if (nArray != null) {
            if (listRowMarginSupport.d != null) {
                this._list.removePropertyChangeListener("model", this.d);
            }
            listRowMarginSupport = this;
        }
        if (nArray != null) {
            if (listRowMarginSupport.c != null) {
                this._list.getModel().removeListDataListener(this.c);
            }
            listRowMarginSupport = this;
        }
        super.uninstallListeners(repaintCallback, modelChangedCallback);
    }
}

