/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.colormap;

import com.macrofocus.colormap.AbstractColorMap;
import com.macrofocus.colormap.ColorMap;
import com.macrofocus.colormap.ColorMapEvent;
import com.macrofocus.colormap.MutableColorMap;
import com.macrofocus.colormap.a;
import com.macrofocus.common.interval.IntervalEvent;
import com.macrofocus.common.interval.IntervalListener;
import com.macrofocus.common.interval.MutableInterval;
import com.macrofocus.common.properties.EnumProperties;
import com.macrofocus.common.properties.MutableProperties;
import com.macrofocus.common.properties.MutableProperty;
import com.macrofocus.common.properties.PropertyEvent;
import com.macrofocus.common.properties.PropertyListener;
import com.macrofocus.common.properties.SimpleProperty;
import com.macrofocus.igraphics.CPColor;
import com.macrofocus.igraphics.CPColorFactory;
import com.macrofocus.palette.CustomPalette;
import com.macrofocus.palette.InterpolatedPalette;
import com.macrofocus.palette.MutablePalette;
import com.macrofocus.palette.PaletteEvent;
import com.macrofocus.palette.PaletteListener;
import com.macrofocus.utils.UniversalComparator;
import java.util.Comparator;
import java.util.Date;
import java.util.Iterator;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;

public class SimpleColorMap<Color>
extends AbstractColorMap<Color>
implements MutableColorMap<Color> {
    protected final MutableProperties<PropertyType> properties = new EnumProperties(PropertyType.class);
    private MutableInterval a;
    private MutableProperty<MutablePalette<Color>> b;
    private final TreeMap<Object, CPColor<Color>> c;
    private ColorMap.Matching d;
    private ColorMap.Assignments e;
    private MutableProperty<CPColor<Color>> f;
    private MutableProperty<Boolean> g;
    private MutableProperty<CPColor<Color>> h;
    private MutableProperty<CPColor<Color>> i;
    private MutableProperty<Boolean> j;
    private MutableProperty<CPColor<Color>> k;
    private MutableProperty<CPColor<Color>> l;
    private MutableProperty<Boolean> m;
    private MutableProperty<Boolean> n;
    private MutableProperty<Integer> o;
    private MutableProperty<Number> p;
    private MutableProperty<Number> q;
    private float r;
    private final CPColorFactory<Color> s;
    private final IntervalListener t;
    private final PaletteListener u;

    /*
     * WARNING - void declaration
     */
    private SimpleColorMap(CPColorFactory<Color> factory) {
        void var1_1;
        this.properties.createProperty((Object)PropertyType.Inverval, null);
        this.b = this.properties.createProperty((Object)PropertyType.Palette, null);
        this.properties.createProperty((Object)PropertyType.Matching, (Object)ColorMap.Matching.EXACT);
        this.properties.createProperty((Object)PropertyType.Assignments, (Object)ColorMap.Assignments.STATIC);
        this.f = this.properties.createProperty((Object)PropertyType.MissingValuesColor, null);
        this.g = new SimpleProperty((Object)Boolean.FALSE);
        this.h = new SimpleProperty(null);
        this.j = new SimpleProperty((Object)Boolean.FALSE);
        this.k = new SimpleProperty(null);
        this.m = this.properties.createProperty((Object)PropertyType.Inverted, (Object)Boolean.FALSE);
        this.n = new SimpleProperty((Object)Boolean.FALSE);
        this.o = this.properties.createProperty((Object)PropertyType.NumberOfSteps, (Object)3);
        this.p = this.properties.createProperty((Object)PropertyType.Brightness, (Object)0);
        this.q = this.properties.createProperty((Object)PropertyType.Saturation, (Object)0);
        this.d = ColorMap.Matching.EXACT;
        this.e = ColorMap.Assignments.STATIC;
        this.r = 1.0f;
        this.t = new IntervalListener(this){
            private /* synthetic */ SimpleColorMap a;
            {
                this.a = simpleColorMap;
            }

            public final void intervalChanged(IntervalEvent event) {
                this.a.notifyColorMapChanged(new ColorMapEvent(this.a, "inverval", null, null));
            }
        };
        this.u = new PaletteListener(this){
            private /* synthetic */ SimpleColorMap a;
            {
                this.a = simpleColorMap;
            }

            @Override
            public final void paletteChanged(PaletteEvent event) {
                this.a.notifyColorMapChanged(new ColorMapEvent(this.a, "palette", null, null));
            }
        };
        this.s = factory;
        this.i = this.properties.addProperty((Object)PropertyType.UnderflowColor, new a<Color>(this.g, this.h, this.b, 0.0));
        this.l = this.properties.addProperty((Object)PropertyType.OverflowColor, new a<Color>(this.j, this.k, this.b, 1.0));
        this.b.addPropertyListener(new PropertyListener<MutablePalette<Color>>(this){
            private /* synthetic */ SimpleColorMap a;
            {
                this.a = simpleColorMap;
            }

            /*
             * WARNING - void declaration
             */
            public final void propertyChanged(PropertyEvent<MutablePalette<Color>> event) {
                void var1_1;
                if (event.getOldValue() != null) {
                    ((MutablePalette)event.getOldValue()).removePaletteListener(this.a.u);
                }
                if (event.getNewValue() != null) {
                    ((MutablePalette)event.getNewValue()).addPaletteListener(this.a.u);
                }
                this.a.notifyColorMapChanged(new ColorMapEvent(this.a, "palette", event.getOldValue(), var1_1.getNewValue()));
            }
        });
        this.m.addPropertyListener((PropertyListener)new PropertyListener<Boolean>(this){
            private /* synthetic */ SimpleColorMap a;
            {
                this.a = simpleColorMap;
            }

            /*
             * WARNING - void declaration
             */
            public final void propertyChanged(PropertyEvent<Boolean> event) {
                void var1_1;
                this.a.notifyColorMapChanged(new ColorMapEvent(this.a, "inverted", event.getOldValue(), var1_1.getNewValue()));
            }
        });
        this.p.addPropertyListener((PropertyListener)new PropertyListener<Number>(this){
            private /* synthetic */ SimpleColorMap a;
            {
                this.a = simpleColorMap;
            }

            /*
             * WARNING - void declaration
             */
            public final void propertyChanged(PropertyEvent<Number> event) {
                void var1_1;
                this.a.notifyColorMapChanged(new ColorMapEvent(this.a, "brightness", event.getOldValue(), var1_1.getNewValue()));
            }
        });
        this.q.addPropertyListener((PropertyListener)new PropertyListener<Number>(this){
            private /* synthetic */ SimpleColorMap a;
            {
                this.a = simpleColorMap;
            }

            /*
             * WARNING - void declaration
             */
            public final void propertyChanged(PropertyEvent<Number> event) {
                void var1_1;
                this.a.notifyColorMapChanged(new ColorMapEvent(this.a, "saturation", event.getOldValue(), var1_1.getNewValue()));
            }
        });
        this.l.addPropertyListener(new PropertyListener<CPColor<Color>>(this){
            private /* synthetic */ SimpleColorMap a;
            {
                this.a = simpleColorMap;
            }

            /*
             * WARNING - void declaration
             */
            public final void propertyChanged(PropertyEvent<CPColor<Color>> event) {
                void var1_1;
                this.a.notifyColorMapChanged(new ColorMapEvent(this.a, "overflowColor", event.getOldValue(), var1_1.getNewValue()));
            }
        });
        this.i.addPropertyListener(new PropertyListener<CPColor<Color>>(this){
            private /* synthetic */ SimpleColorMap a;
            {
                this.a = simpleColorMap;
            }

            /*
             * WARNING - void declaration
             */
            public final void propertyChanged(PropertyEvent<CPColor<Color>> event) {
                void var1_1;
                this.a.notifyColorMapChanged(new ColorMapEvent(this.a, "underflowColor", event.getOldValue(), var1_1.getNewValue()));
            }
        });
        this.f.addPropertyListener(new PropertyListener<CPColor<Color>>(this){
            private /* synthetic */ SimpleColorMap a;
            {
                this.a = simpleColorMap;
            }

            /*
             * WARNING - void declaration
             */
            public final void propertyChanged(PropertyEvent<CPColor<Color>> event) {
                void var1_1;
                this.a.notifyColorMapChanged(new ColorMapEvent(this.a, "missingValuesColor", event.getOldValue(), var1_1.getNewValue()));
            }
        });
        this.n.addPropertyListener((PropertyListener)new PropertyListener<Boolean>(this){
            private /* synthetic */ SimpleColorMap a;
            {
                this.a = simpleColorMap;
            }

            /*
             * WARNING - void declaration
             */
            public final void propertyChanged(PropertyEvent<Boolean> event) {
                void var1_1;
                this.a.notifyColorMapChanged(new ColorMapEvent(this.a, "numberOfSteps", event.getOldValue(), var1_1.getNewValue()));
            }
        });
        this.o.addPropertyListener((PropertyListener)new PropertyListener<Integer>(this){
            private /* synthetic */ SimpleColorMap a;
            {
                this.a = simpleColorMap;
            }

            /*
             * WARNING - void declaration
             */
            public final void propertyChanged(PropertyEvent<Integer> event) {
                void var1_1;
                this.a.notifyColorMapChanged(new ColorMapEvent(this.a, "numberOfSteps", event.getOldValue(), var1_1.getNewValue()));
            }
        });
        this.f.setValue(var1_1.getGray());
        this.c = new TreeMap(new UniversalComparator());
    }

    /*
     * WARNING - void declaration
     */
    public SimpleColorMap(CPColorFactory<Color> factory, MutableInterval interval, MutablePalette<Color> palette) {
        this((CPColorFactory<Color>)var1_1);
        void var3_3;
        void var2_2;
        void var1_1;
        this.setInterval((MutableInterval)var2_2);
        this.setPalette((MutablePalette<Color>)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    public SimpleColorMap(CPColorFactory<Color> factory, Set values, boolean cyclic, MutablePalette<Color> palette) {
        this((CPColorFactory<Color>)var1_1);
        void var1_1;
        this.setPalette(palette);
        if (values != null) {
            void var3_3;
            void var2_2;
            this.assignColors((Set)var2_2, (boolean)var3_3);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public CPColor<Color> getColor(Object value) {
        CPColor<Color> cPColor;
        if (value != null) {
            void var1_1;
            cPColor = this.s.createNativeColor(value);
            if (cPColor != null) {
                return cPColor;
            }
            if (value instanceof CPColor) {
                return (CPColor)value;
            }
            if (value instanceof Comparable && this.c.containsKey(value)) {
                cPColor = this.c.get(value);
            } else if (value instanceof Number && this.a != null) {
                double d2 = ((Number)value).doubleValue();
                double d3 = !this.a.isDegenerate() ? (d2 - this.a.getStart()) / this.a.getExtent() : 0.5;
                if (this.isInverted()) {
                    d3 = 1.0 - d3;
                }
                if (d3 < this.getLowestFraction()) {
                    return this.getUnderflowColor();
                }
                if (d3 > this.getHighestFraction()) {
                    return this.getOverflowColor();
                }
                int n = (Boolean)this.n.getValue() != false ? this.getColorCount() : 0;
                if (n > 0) {
                    d3 = n > 1 ? (double)((int)(d3 * (double)n)) / (double)(n - 1) : 0.5;
                }
                cPColor = ((MutablePalette)this.b.getValue()).getColor(d3);
            } else if (var1_1 instanceof Date && this.a != null) {
                long l = ((Date)var1_1).getTime();
                double d4 = ((double)l - this.a.getStart()) / this.a.getExtent();
                if (this.isInverted()) {
                    d4 = 1.0 - d4;
                }
                if (d4 < this.getLowestFraction()) {
                    return this.getUnderflowColor();
                }
                if (d4 > this.getHighestFraction()) {
                    return this.getOverflowColor();
                }
                int n = (Boolean)this.n.getValue() != false ? this.getColorCount() : 0;
                if (n > 0) {
                    if (n > 1) {
                        d4 = (double)((int)(d4 * (double)n)) / (double)(n - 1);
                    }
                } else {
                    d4 = 0.5;
                }
                cPColor = ((MutablePalette)this.b.getValue()).getColor(d4);
            } else if (var1_1 instanceof Object[]) {
                Object[] objectArray = (Object[])var1_1;
                String string = SimpleColorMap.a(objectArray);
                cPColor = this.c.containsKey(string) ? this.c.get(string) : this.getNullColor();
            } else if (this.e == ColorMap.Assignments.DYNAMIC) {
                CPColor cPColor2 = ((MutablePalette)this.b.getValue()).getColorAt(this.c.size() % ((MutablePalette)this.b.getValue()).getColorCount());
                this.c.put(var1_1, cPColor2);
                cPColor = cPColor2;
            } else {
                cPColor = this.getNullColor();
            }
        } else {
            cPColor = this.getNullColor();
        }
        if (cPColor != null && (((Number)this.p.getValue()).intValue() != 0 || ((Number)this.q.getValue()).intValue() != 0)) {
            cPColor = cPColor.brightenAndSaturate((float)((Number)this.p.getValue()).intValue() / 300.0f, (float)((Number)this.q.getValue()).intValue() / 300.0f);
        }
        if (cPColor != null && this.r != 1.0f) {
            cPColor = cPColor.alpha(this.r);
        }
        return cPColor;
    }

    private static String a(Object[] objectArray) {
        String string = "";
        for (int i = 0; i < objectArray.length; ++i) {
            Object object = objectArray[i];
            if (object != null) {
                string = string + object.toString();
            }
            if (i >= objectArray.length - 1) continue;
            string = string + "/";
        }
        return string;
    }

    @Override
    public double getLowestFraction() {
        Object object = (MutablePalette)this.b.getValue();
        if (object instanceof InterpolatedPalette) {
            if (!((TreeSet)(object = (TreeSet)((InterpolatedPalette)object).getEntries())).isEmpty()) {
                return ((InterpolatedPalette.Entry)((TreeSet)object).first()).getFraction();
            }
        } else if (object instanceof CustomPalette && !((TreeSet)(object = (TreeSet)((CustomPalette)object).getEntries())).isEmpty()) {
            return ((CustomPalette.Entry)((TreeSet)object).first()).getFraction();
        }
        return 0.0;
    }

    @Override
    public double getHighestFraction() {
        Object object = (MutablePalette)this.b.getValue();
        if (object instanceof InterpolatedPalette) {
            if (!((TreeSet)(object = (TreeSet)((InterpolatedPalette)object).getEntries())).isEmpty()) {
                return ((InterpolatedPalette.Entry)((TreeSet)object).last()).getFraction();
            }
        } else if (object instanceof CustomPalette && !((TreeSet)(object = (TreeSet)((CustomPalette)object).getEntries())).isEmpty()) {
            return ((CustomPalette.Entry)((TreeSet)object).last()).getFraction();
        }
        return 1.0;
    }

    @Override
    public MutableInterval getInterval() {
        return this.a;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void setInterval(MutableInterval interval) {
        if (this.a != interval) {
            void var1_1;
            MutableInterval mutableInterval = this.a;
            if (this.a != null) {
                this.a.removeIntervalListener(this.t);
            }
            this.a = interval;
            if (this.a != null) {
                this.a.addIntervalListener(this.t);
            }
            this.notifyColorMapChanged(new ColorMapEvent(this, "inverval", mutableInterval, var1_1));
        }
    }

    @Override
    public MutablePalette<Color> getPalette() {
        return (MutablePalette)this.b.getValue();
    }

    @Override
    public MutableProperty<MutablePalette<Color>> paletteProperty() {
        return this.b;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void setPalette(MutablePalette<Color> palette) {
        if (this.b.getValue() != palette) {
            void var1_1;
            this.b.setValue((Object)var1_1);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void setMatching(ColorMap.Matching matching) {
        if (this.d != matching) {
            void var1_1;
            ColorMap.Matching matching2 = this.d;
            this.d = matching;
            this.notifyColorMapChanged(new ColorMapEvent(this, "matching", (Object)matching2, var1_1));
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void setAssignments(ColorMap.Assignments assignments) {
        if (this.e != assignments) {
            void var1_1;
            ColorMap.Assignments assignments2 = this.e;
            this.e = assignments;
            this.notifyColorMapChanged(new ColorMapEvent(this, "assignments", (Object)assignments2, var1_1));
        }
    }

    @Override
    public CPColor<Color> getNullColor() {
        return (CPColor)this.f.getValue();
    }

    @Override
    public MutableProperty<CPColor<Color>> nullColorProperty() {
        return this.f;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void setNullColor(CPColor<Color> nullColor) {
        void var1_1;
        this.f.setValue((Object)var1_1);
    }

    @Override
    public CPColor<Color> getUnderflowColor() {
        return (CPColor)this.i.getValue();
    }

    @Override
    public MutableProperty<Boolean> underColorSetProperty() {
        return this.g;
    }

    @Override
    public MutableProperty<CPColor<Color>> underColorStoreProperty() {
        return this.h;
    }

    @Override
    public MutableProperty<CPColor<Color>> underColorProperty() {
        return this.i;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void setUnderColor(CPColor<Color> underColor) {
        if (!(this.getUnderflowColor() == underColor || this.getUnderflowColor() != null && this.getUnderflowColor().equals(underColor))) {
            void var1_1;
            this.i.setValue((Object)var1_1);
        }
    }

    @Override
    public CPColor<Color> getOverflowColor() {
        return (CPColor)this.l.getValue();
    }

    @Override
    public MutableProperty<Boolean> overColorSetProperty() {
        return this.j;
    }

    @Override
    public MutableProperty<CPColor<Color>> overColorStoreProperty() {
        return this.k;
    }

    @Override
    public MutableProperty<CPColor<Color>> overColorProperty() {
        return this.l;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void setOverColor(CPColor<Color> overColor) {
        if (!(this.getOverflowColor() == overColor || this.getOverflowColor() != null && this.getOverflowColor().equals(overColor))) {
            void var1_1;
            this.l.setValue((Object)var1_1);
        }
    }

    @Override
    public boolean isOverflowColorSet() {
        return (Boolean)this.j.getValue();
    }

    @Override
    public boolean isUnderflowColorSet() {
        return (Boolean)this.g.getValue();
    }

    @Override
    public boolean isInverted() {
        return (Boolean)this.m.getValue();
    }

    @Override
    public MutableProperty<Boolean> invertedProperty() {
        return this.m;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void setInverted(boolean inverted) {
        void var1_1;
        this.m.setValue((Object)((boolean)var1_1));
    }

    @Override
    public int getColorCount() {
        if (((Boolean)this.n.getValue()).booleanValue()) {
            int n = (Integer)this.o.getValue();
            if (n > 0 && n < 256) {
                return n;
            }
            return 0;
        }
        return 0;
    }

    @Override
    public MutableProperty<Boolean> colorCountSetProperty() {
        return this.n;
    }

    @Override
    public MutableProperty<Integer> colorCountProperty() {
        return this.o;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void setColorCount(int colorCount) {
        boolean bl = colorCount > 0 && colorCount < 256;
        this.n.setValue((Object)bl);
        if (bl) {
            void var1_1;
            this.o.setValue((Object)((int)var1_1));
        }
    }

    @Override
    public int getBrightness() {
        return ((Number)this.p.getValue()).intValue();
    }

    @Override
    public MutableProperty<Number> brightnessProperty() {
        return this.p;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void setBrightness(int brightness) {
        void var1_1;
        this.p.setValue((Object)((int)var1_1));
    }

    @Override
    public int getSaturation() {
        return ((Number)this.q.getValue()).intValue();
    }

    @Override
    public MutableProperty<Number> saturationProperty() {
        return this.q;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void setSaturation(int saturation) {
        void var1_1;
        this.q.setValue((Object)((int)var1_1));
    }

    @Override
    public float getAlpha() {
        return this.r;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void setAlpha(float alpha) {
        if (this.r != alpha) {
            void var1_1;
            float f2 = this.r;
            this.r = alpha;
            this.notifyColorMapChanged(new ColorMapEvent(this, "alpha", Float.valueOf(f2), Float.valueOf((float)var1_1)));
        }
    }

    @Override
    public void assignColors(Set values, boolean cyclic) {
        this.c.clear();
        int n = 0;
        for (Object object : values) {
            CPColor cPColor = !cyclic ? ((MutablePalette)this.b.getValue()).getColor((double)n / (double)values.size()) : ((MutablePalette)this.b.getValue()).getColorAt(n % ((MutablePalette)this.b.getValue()).getColorCount());
            if (object instanceof Object[]) {
                object = SimpleColorMap.a((Object[])object);
            }
            this.c.put(object, cPColor);
            ++n;
        }
        this.notifyColorMapChanged(new ColorMapEvent(this, "assignments", null, null));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void assignColors(Object ... values) {
        void var1_1;
        this.c.clear();
        int n = 0;
        for (void var5_5 : var1_1) {
            if (this.c.containsKey(var5_5)) continue;
            this.c.put(var5_5, ((MutablePalette)this.b.getValue()).getColorAt(n % ((MutablePalette)this.b.getValue()).getColorCount()));
            ++n;
        }
        this.notifyColorMapChanged(new ColorMapEvent(this, "assignments", null, null));
    }

    @Override
    public void assignColors(Iterable<Object> values) {
        Iterator iterator;
        this.c.clear();
        int n = 0;
        iterator = iterator.iterator();
        while (iterator.hasNext()) {
            Object t = iterator.next();
            if (this.c.containsKey(t)) continue;
            this.c.put(t, ((MutablePalette)this.b.getValue()).getColorAt(n % ((MutablePalette)this.b.getValue()).getColorCount()));
            ++n;
        }
        this.notifyColorMapChanged(new ColorMapEvent(this, "assignments", null, null));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void setColor(Object value, CPColor<Color> color) {
        void var2_2;
        void var1_1;
        this.c.put(var1_1, (CPColor<Color>)var2_2);
        this.notifyColorMapChanged(new ColorMapEvent(this, "assignments", null, null));
    }

    @Override
    public void clearAssignedColor() {
        this.c.clear();
        this.notifyColorMapChanged(new ColorMapEvent(this, "assignments", null, null));
    }

    @Override
    public Set<Object> getAssignedValues() {
        return this.c.keySet();
    }

    @Override
    public void resetAssignedValues() {
        TreeSet<Object> treeSet = new TreeSet<Object>((Comparator<Object>)new UniversalComparator());
        treeSet.addAll(this.c.keySet());
        this.assignColors(treeSet, true);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void setProperty(String property, Object value) {
        void var1_1;
        if (property.equals("inverval")) {
            this.setInterval((MutableInterval)value);
            return;
        }
        if (property.equals("palette")) {
            this.setPalette((MutablePalette)value);
            return;
        }
        if (property.equals("matching")) {
            this.setMatching((ColorMap.Matching)((Object)value));
            return;
        }
        if (property.equals("assignments")) {
            this.setAssignments((ColorMap.Assignments)((Object)value));
            return;
        }
        if (property.equals("missingValuesColor")) {
            this.setNullColor((CPColor)value);
            return;
        }
        if (property.equals("underflowColor")) {
            this.setUnderColor((CPColor)value);
            return;
        }
        if (property.equals("overflowColor")) {
            this.setOverColor((CPColor)value);
            return;
        }
        if (property.equals("inverted")) {
            this.setInverted((Boolean)value);
            return;
        }
        if (property.equals("numberOfSteps")) {
            this.setColorCount((Integer)value);
            return;
        }
        if (property.equals("brightness")) {
            this.setBrightness((Integer)value);
            return;
        }
        if (property.equals("saturation")) {
            this.setSaturation((Integer)value);
            return;
        }
        if (property.equals("alpha")) {
            void var2_2;
            this.setAlpha(((Float)var2_2).floatValue());
            return;
        }
        System.err.println("Unknonw property " + (String)var1_1);
    }

    public String toString() {
        return "SimpleColorMap{interval=" + this.a + ", palette=" + this.b + ", nullColor=" + this.f + ", underColor=" + this.i + ", overColor=" + this.l + '}';
    }

    public static enum PropertyType {
        Inverval,
        Palette,
        Matching,
        Assignments,
        MissingValuesColor,
        UnderflowColor,
        OverflowColor,
        Inverted,
        NumberOfSteps,
        Brightness,
        Saturation,
        Alpha;

    }
}

