/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.geom;

import com.macrofocus.geom.Crossings;
import com.macrofocus.geom.PathIterator;
import com.macrofocus.geom.Rectangle2D;
import com.macrofocus.geom.c;
import com.macrofocus.geom.d;
import com.macrofocus.geom.e;
import com.macrofocus.geom.f;
import java.util.Vector;

public abstract class Curve {
    public static final int INCREASING = 1;
    public static final int DECREASING = -1;
    public static final int RECT_INTERSECTS = Integer.MIN_VALUE;
    public static final double TMIN = 0.001;
    protected final int direction;

    /*
     * WARNING - void declaration
     */
    public Curve(int direction) {
        void var1_1;
        this.direction = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public static void insertMove(Vector<Curve> curves, double x, double y) {
        void var3_2;
        void var1_1;
        curves.add(new c((double)var1_1, (double)var3_2));
    }

    /*
     * WARNING - void declaration
     */
    public static void insertLine(Vector<Curve> curves, double x0, double y0, double x1, double y1) {
        if (y0 < y1) {
            curves.add(new d(x0, y0, x1, y1, 1));
            return;
        }
        if (y0 > y1) {
            void var3_2;
            void var1_1;
            Vector<Curve> vector;
            vector.add(new d(x1, y1, (double)var1_1, (double)var3_2, -1));
        }
    }

    /*
     * WARNING - void declaration
     */
    public static void insertQuad(Vector<Curve> curves, double x0, double y0, double[] coords) {
        void var3_2;
        void var1_1;
        Vector<Curve> vector;
        double d2 = coords[3];
        if (y0 > d2) {
            e.a(curves, coords, coords[2], d2, coords[0], coords[1], x0, y0, -1);
            return;
        }
        if (y0 == d2 && y0 == coords[1]) {
            return;
        }
        e.a(vector, coords, (double)var1_1, (double)var3_2, coords[0], coords[1], coords[2], d2, 1);
    }

    /*
     * WARNING - void declaration
     */
    public static void insertCubic(Vector<Curve> curves, double x0, double y0, double[] coords) {
        void var3_2;
        void var1_1;
        Vector<Curve> vector;
        double d2 = coords[5];
        if (y0 > d2) {
            f.a(curves, coords, coords[4], d2, coords[2], coords[3], coords[0], coords[1], x0, y0, -1);
            return;
        }
        if (y0 == d2 && y0 == coords[1] && y0 == coords[3]) {
            return;
        }
        f.a(vector, coords, (double)var1_1, (double)var3_2, coords[0], coords[1], coords[2], coords[3], coords[4], d2, 1);
    }

    /*
     * WARNING - void declaration
     */
    public static int pointCrossingsForPath(PathIterator pi, double px, double py) {
        if (pi.isDone()) {
            return 0;
        }
        double[] dArray = new double[6];
        if (pi.currentSegment(dArray) != 0) {
            throw new IllegalStateException("missing initial moveto in path definition");
        }
        pi.next();
        double d2 = dArray[0];
        double d3 = dArray[1];
        double d4 = d2;
        double d5 = d3;
        int n = 0;
        while (!pi.isDone()) {
            switch (pi.currentSegment(dArray)) {
                case 0: {
                    if (d5 != d3) {
                        n += Curve.pointCrossingsForLine(px, py, d4, d5, d2, d3);
                    }
                    d2 = d4 = dArray[0];
                    d3 = d5 = dArray[1];
                    break;
                }
                case 1: {
                    double d6 = dArray[0];
                    double d7 = dArray[1];
                    n += Curve.pointCrossingsForLine(px, py, d4, d5, d6, d7);
                    d4 = d6;
                    d5 = d7;
                    break;
                }
                case 2: {
                    double d6 = dArray[2];
                    double d7 = dArray[3];
                    n += Curve.pointCrossingsForQuad(px, py, d4, d5, dArray[0], dArray[1], d6, d7, 0);
                    d4 = d6;
                    d5 = d7;
                    break;
                }
                case 3: {
                    double d6 = dArray[4];
                    double d7 = dArray[5];
                    n += Curve.pointCrossingsForCubic(px, py, d4, d5, dArray[0], dArray[1], dArray[2], dArray[3], d6, d7, 0);
                    d4 = d6;
                    d5 = d7;
                    break;
                }
                case 4: {
                    if (d5 != d3) {
                        n += Curve.pointCrossingsForLine(px, py, d4, d5, d2, d3);
                    }
                    d4 = d2;
                    d5 = d3;
                }
            }
            pi.next();
        }
        if (d5 != d3) {
            void var3_2;
            void var1_1;
            n += Curve.pointCrossingsForLine((double)var1_1, (double)var3_2, d4, d5, d2, d3);
        }
        return n;
    }

    /*
     * WARNING - void declaration
     */
    public static int pointCrossingsForLine(double px, double py, double x0, double y0, double x1, double y1) {
        double d2;
        void var2_2;
        if (py < y0 && py < y1) {
            return 0;
        }
        if (py >= y0 && py >= y1) {
            return 0;
        }
        if (px >= x0 && px >= x1) {
            return 0;
        }
        if (px < x0 && px < x1) {
            if (y0 < y1) {
                return 1;
            }
            return -1;
        }
        double d3 = x0 + (var2_2 - y0) * (x1 - x0) / (y1 - y0);
        if (d2 >= d3) {
            return 0;
        }
        if (y0 < y1) {
            return 1;
        }
        return -1;
    }

    /*
     * WARNING - void declaration
     */
    public static int pointCrossingsForQuad(double px, double py, double x0, double y0, double xc, double yc, double x1, double y1, int level) {
        void var2_2;
        double d2;
        if (py < y0 && py < yc && py < y1) {
            return 0;
        }
        if (py >= y0 && py >= yc && py >= y1) {
            return 0;
        }
        if (px >= x0 && px >= xc && px >= x1) {
            return 0;
        }
        if (px < x0 && px < xc && px < x1) {
            if (py >= y0) {
                if (py < y1) {
                    return 1;
                }
            } else if (py >= y1) {
                return -1;
            }
            return 0;
        }
        if (level > 52) {
            return Curve.pointCrossingsForLine(px, py, x0, y0, x1, y1);
        }
        double d3 = (x0 + xc) / 2.0;
        double d4 = (y0 + yc) / 2.0;
        double d5 = (xc + x1) / 2.0;
        double d6 = (yc + y1) / 2.0;
        xc = (d3 + d5) / 2.0;
        yc = (d4 + d6) / 2.0;
        if (Double.isNaN(xc) || Double.isNaN(yc)) {
            return 0;
        }
        return Curve.pointCrossingsForQuad(px, py, x0, y0, d3, d4, xc, yc, level + 1) + Curve.pointCrossingsForQuad(d2, (double)var2_2, xc, yc, d5, d6, x1, y1, level + 1);
    }

    /*
     * WARNING - void declaration
     */
    public static int pointCrossingsForCubic(double px, double py, double x0, double y0, double xc0, double yc0, double xc1, double yc1, double x1, double y1, int level) {
        void var2_2;
        double d2;
        if (py < y0 && py < yc0 && py < yc1 && py < y1) {
            return 0;
        }
        if (py >= y0 && py >= yc0 && py >= yc1 && py >= y1) {
            return 0;
        }
        if (px >= x0 && px >= xc0 && px >= xc1 && px >= x1) {
            return 0;
        }
        if (px < x0 && px < xc0 && px < xc1 && px < x1) {
            if (py >= y0) {
                if (py < y1) {
                    return 1;
                }
            } else if (py >= y1) {
                return -1;
            }
            return 0;
        }
        if (level > 52) {
            return Curve.pointCrossingsForLine(px, py, x0, y0, x1, y1);
        }
        double d3 = (xc0 + xc1) / 2.0;
        double d4 = (yc0 + yc1) / 2.0;
        xc0 = (x0 + xc0) / 2.0;
        yc0 = (y0 + yc0) / 2.0;
        xc1 = (xc1 + x1) / 2.0;
        yc1 = (yc1 + y1) / 2.0;
        double d5 = (xc0 + d3) / 2.0;
        double d6 = (yc0 + d4) / 2.0;
        double d7 = (d3 + xc1) / 2.0;
        double d8 = (d4 + yc1) / 2.0;
        d3 = (d5 + d7) / 2.0;
        d4 = (d6 + d8) / 2.0;
        if (Double.isNaN(d3) || Double.isNaN(d4)) {
            return 0;
        }
        return Curve.pointCrossingsForCubic(px, py, x0, y0, xc0, yc0, d5, d6, d3, d4, level + 1) + Curve.pointCrossingsForCubic(d2, (double)var2_2, d3, d4, d7, d8, xc1, yc1, x1, y1, level + 1);
    }

    /*
     * WARNING - void declaration
     */
    public static int rectCrossingsForPath(PathIterator pi, double rxmin, double rymin, double rxmax, double rymax) {
        double d2;
        double d3;
        if (rxmax <= rxmin || rymax <= rymin) {
            return 0;
        }
        if (pi.isDone()) {
            return 0;
        }
        double[] dArray = new double[6];
        if (pi.currentSegment(dArray) != 0) {
            throw new IllegalStateException("missing initial moveto in path definition");
        }
        pi.next();
        double d4 = d3 = dArray[0];
        double d5 = d2 = dArray[1];
        int n = 0;
        while (n != Integer.MIN_VALUE && !pi.isDone()) {
            switch (pi.currentSegment(dArray)) {
                case 0: {
                    if (d4 != d3 || d5 != d2) {
                        n = Curve.rectCrossingsForLine(n, rxmin, rymin, rxmax, rymax, d4, d5, d3, d2);
                    }
                    d3 = d4 = dArray[0];
                    d2 = d5 = dArray[1];
                    break;
                }
                case 1: {
                    double d6 = dArray[0];
                    double d7 = dArray[1];
                    n = Curve.rectCrossingsForLine(n, rxmin, rymin, rxmax, rymax, d4, d5, d6, d7);
                    d4 = d6;
                    d5 = d7;
                    break;
                }
                case 2: {
                    double d6 = dArray[2];
                    double d7 = dArray[3];
                    n = Curve.rectCrossingsForQuad(n, rxmin, rymin, rxmax, rymax, d4, d5, dArray[0], dArray[1], d6, d7, 0);
                    d4 = d6;
                    d5 = d7;
                    break;
                }
                case 3: {
                    double d6 = dArray[4];
                    double d7 = dArray[5];
                    n = Curve.rectCrossingsForCubic(n, rxmin, rymin, rxmax, rymax, d4, d5, dArray[0], dArray[1], dArray[2], dArray[3], d6, d7, 0);
                    d4 = d6;
                    d5 = d7;
                    break;
                }
                case 4: {
                    if (d4 != d3 || d5 != d2) {
                        n = Curve.rectCrossingsForLine(n, rxmin, rymin, rxmax, rymax, d4, d5, d3, d2);
                    }
                    d4 = d3;
                    d5 = d2;
                }
            }
            pi.next();
        }
        if (n != Integer.MIN_VALUE && (d4 != d3 || d5 != d2)) {
            void var3_2;
            void var1_1;
            n = Curve.rectCrossingsForLine(n, (double)var1_1, (double)var3_2, rxmax, rymax, d4, d5, d3, d2);
        }
        return n;
    }

    /*
     * WARNING - void declaration
     */
    public static int rectCrossingsForLine(int crossings, double rxmin, double rymin, double rxmax, double rymax, double x0, double y0, double x1, double y1) {
        void var1_1;
        if (y0 >= rymax && y1 >= rymax) {
            return crossings;
        }
        if (y0 <= rymin && y1 <= rymin) {
            return crossings;
        }
        if (x0 <= rxmin && x1 <= rxmin) {
            return crossings;
        }
        if (x0 >= rxmax && x1 >= rxmax) {
            if (y0 < y1) {
                if (y0 <= rymin) {
                    ++crossings;
                }
                if (y1 >= rymax) {
                    ++crossings;
                }
            } else if (y1 < y0) {
                if (y1 <= rymin) {
                    --crossings;
                }
                if (y0 >= rymax) {
                    --crossings;
                }
            }
            return crossings;
        }
        if (x0 > rxmin && x0 < rxmax && y0 > rymin && y0 < rymax || x1 > rxmin && x1 < rxmax && y1 > rymin && y1 < rymax) {
            return Integer.MIN_VALUE;
        }
        double d2 = x0;
        if (y0 < rymin) {
            d2 = x0 + (rymin - y0) * (x1 - x0) / (y1 - y0);
        } else if (y0 > rymax) {
            d2 = x0 + (rymax - y0) * (x1 - x0) / (y1 - y0);
        }
        double d3 = x1;
        if (y1 < rymin) {
            d3 = x1 + (rymin - y1) * (x0 - x1) / (y0 - y1);
        } else if (y1 > rymax) {
            d3 = x1 + (rymax - y1) * (x0 - x1) / (y0 - y1);
        }
        if (d2 <= rxmin && d3 <= var1_1) {
            return crossings;
        }
        if (d2 >= rxmax && d3 >= rxmax) {
            int n;
            if (y0 < y1) {
                if (y0 <= rymin) {
                    ++crossings;
                }
                if (y1 >= rymax) {
                    ++crossings;
                }
            } else if (y1 < y0) {
                void var3_2;
                if (y1 <= var3_2) {
                    --crossings;
                }
                if (y0 >= rymax) {
                    --crossings;
                }
            }
            return n;
        }
        return Integer.MIN_VALUE;
    }

    /*
     * WARNING - void declaration
     */
    public static int rectCrossingsForQuad(int crossings, double rxmin, double rymin, double rxmax, double rymax, double x0, double y0, double xc, double yc, double x1, double y1, int level) {
        int n;
        if (y0 >= rymax && yc >= rymax && y1 >= rymax) {
            return crossings;
        }
        if (y0 <= rymin && yc <= rymin && y1 <= rymin) {
            return crossings;
        }
        if (x0 <= rxmin && xc <= rxmin && x1 <= rxmin) {
            return crossings;
        }
        if (x0 >= rxmax && xc >= rxmax && x1 >= rxmax) {
            if (y0 < y1) {
                if (y0 <= rymin && y1 > rymin) {
                    ++crossings;
                }
                if (y0 < rymax && y1 >= rymax) {
                    ++crossings;
                }
            } else if (y1 < y0) {
                if (y1 <= rymin && y0 > rymin) {
                    --crossings;
                }
                if (y1 < rymax && y0 >= rymax) {
                    --crossings;
                }
            }
            return crossings;
        }
        if (x0 < rxmax && x0 > rxmin && y0 < rymax && y0 > rymin || x1 < rxmax && x1 > rxmin && y1 < rymax && y1 > rymin) {
            return Integer.MIN_VALUE;
        }
        if (level > 52) {
            return Curve.rectCrossingsForLine(crossings, rxmin, rymin, rxmax, rymax, x0, y0, x1, y1);
        }
        double d2 = (x0 + xc) / 2.0;
        double d3 = (y0 + yc) / 2.0;
        double d4 = (xc + x1) / 2.0;
        double d5 = (yc + y1) / 2.0;
        xc = (d2 + d4) / 2.0;
        yc = (d3 + d5) / 2.0;
        if (Double.isNaN(xc) || Double.isNaN(yc)) {
            return 0;
        }
        if ((crossings = Curve.rectCrossingsForQuad(crossings, rxmin, rymin, rxmax, rymax, x0, y0, d2, d3, xc, yc, level + 1)) != Integer.MIN_VALUE) {
            void var3_3;
            void var1_1;
            crossings = Curve.rectCrossingsForQuad(crossings, (double)var1_1, (double)var3_3, rxmax, rymax, xc, yc, d4, d5, x1, y1, level + 1);
        }
        return n;
    }

    /*
     * WARNING - void declaration
     */
    public static int rectCrossingsForCubic(int crossings, double rxmin, double rymin, double rxmax, double rymax, double x0, double y0, double xc0, double yc0, double xc1, double yc1, double x1, double y1, int level) {
        int n;
        if (y0 >= rymax && yc0 >= rymax && yc1 >= rymax && y1 >= rymax) {
            return crossings;
        }
        if (y0 <= rymin && yc0 <= rymin && yc1 <= rymin && y1 <= rymin) {
            return crossings;
        }
        if (x0 <= rxmin && xc0 <= rxmin && xc1 <= rxmin && x1 <= rxmin) {
            return crossings;
        }
        if (x0 >= rxmax && xc0 >= rxmax && xc1 >= rxmax && x1 >= rxmax) {
            if (y0 < y1) {
                if (y0 <= rymin && y1 > rymin) {
                    ++crossings;
                }
                if (y0 < rymax && y1 >= rymax) {
                    ++crossings;
                }
            } else if (y1 < y0) {
                if (y1 <= rymin && y0 > rymin) {
                    --crossings;
                }
                if (y1 < rymax && y0 >= rymax) {
                    --crossings;
                }
            }
            return crossings;
        }
        if (x0 > rxmin && x0 < rxmax && y0 > rymin && y0 < rymax || x1 > rxmin && x1 < rxmax && y1 > rymin && y1 < rymax) {
            return Integer.MIN_VALUE;
        }
        if (level > 52) {
            return Curve.rectCrossingsForLine(crossings, rxmin, rymin, rxmax, rymax, x0, y0, x1, y1);
        }
        double d2 = (xc0 + xc1) / 2.0;
        double d3 = (yc0 + yc1) / 2.0;
        xc0 = (x0 + xc0) / 2.0;
        yc0 = (y0 + yc0) / 2.0;
        xc1 = (xc1 + x1) / 2.0;
        yc1 = (yc1 + y1) / 2.0;
        double d4 = (xc0 + d2) / 2.0;
        double d5 = (yc0 + d3) / 2.0;
        double d6 = (d2 + xc1) / 2.0;
        double d7 = (d3 + yc1) / 2.0;
        d2 = (d4 + d6) / 2.0;
        d3 = (d5 + d7) / 2.0;
        if (Double.isNaN(d2) || Double.isNaN(d3)) {
            return 0;
        }
        if ((crossings = Curve.rectCrossingsForCubic(crossings, rxmin, rymin, rxmax, rymax, x0, y0, xc0, yc0, d4, d5, d2, d3, level + 1)) != Integer.MIN_VALUE) {
            void var3_2;
            void var1_1;
            crossings = Curve.rectCrossingsForCubic(crossings, (double)var1_1, (double)var3_2, rxmax, rymax, d2, d3, d6, d7, xc1, yc1, x1, y1, level + 1);
        }
        return n;
    }

    /*
     * WARNING - void declaration
     */
    public static int orderof(double x1, double x2) {
        void var2_1;
        double d2;
        if (x1 < x2) {
            return -1;
        }
        if (d2 > var2_1) {
            return 1;
        }
        return 0;
    }

    /*
     * WARNING - void declaration
     */
    public static long signeddiffbits(double y1, double y2) {
        void var2_1;
        return Double.doubleToLongBits(y1) - Double.doubleToLongBits((double)var2_1);
    }

    /*
     * WARNING - void declaration
     */
    public static long diffbits(double y1, double y2) {
        void var2_1;
        return Math.abs(Double.doubleToLongBits(y1) - Double.doubleToLongBits((double)var2_1));
    }

    public static double prev(double v) {
        return Double.longBitsToDouble(Double.doubleToLongBits(v) - 1L);
    }

    public static double next(double v) {
        return Double.longBitsToDouble(Double.doubleToLongBits(v) + 1L);
    }

    private static boolean a(double d2, double d3) {
        return Math.abs(d2 - d3) < Math.max(Math.abs(d2), Math.abs(d3)) * 1.0E-10;
    }

    public final int getDirection() {
        return this.direction;
    }

    /*
     * WARNING - void declaration
     */
    public final Curve getWithDirection(int direction) {
        void var1_1;
        if (this.direction == var1_1) {
            return this;
        }
        return this.getReversedCurve();
    }

    public abstract Curve getReversedCurve();

    public String toString() {
        return "Curve[" + this.getOrder() + ", (" + Curve.round(this.getX0()) + ", " + Curve.round(this.getY0()) + "), " + this.controlPointString() + "(" + Curve.round(this.getX1()) + ", " + Curve.round(this.getY1()) + "), " + (this.direction == 1 ? "D" : "U") + ']';
    }

    public static double round(double v) {
        return v;
    }

    public String controlPointString() {
        return "";
    }

    public abstract int getOrder();

    public abstract double getX0();

    public abstract double getY0();

    public abstract double getX1();

    public abstract double getY1();

    public abstract double getXTop();

    public abstract double getXBot();

    public abstract double YforT(double var1);

    public abstract double dXforT(double var1, int var3);

    public abstract double dYforT(double var1, int var3);

    /*
     * WARNING - void declaration
     */
    public int crossingsFor(double x, double y) {
        void var3_2;
        void var1_1;
        if (y >= this.getYTop() && y < this.getYBot() && x < this.getXMax() && (x < this.getXMin() || var1_1 < this.XforY((double)var3_2))) {
            return 1;
        }
        return 0;
    }

    public abstract double getYTop();

    public abstract double getYBot();

    public abstract double getXMin();

    public abstract double getXMax();

    public abstract double XforY(double var1);

    /*
     * WARNING - void declaration
     */
    public boolean accumulateCrossings(Crossings c2) {
        double d2;
        double d3;
        double d4;
        double d5;
        double d6 = c2.getXHi();
        if (this.getXMin() >= d6) {
            return false;
        }
        double d7 = c2.getXLo();
        double d8 = c2.getYLo();
        double d9 = c2.getYHi();
        double d10 = this.getYTop();
        double d11 = this.getYBot();
        if (d10 < d8) {
            if (d11 <= d8) {
                return false;
            }
            d5 = d8;
            d4 = this.TforY(d8);
        } else {
            if (d10 >= d9) {
                return false;
            }
            d5 = d10;
            d4 = 0.0;
        }
        if (d11 > d9) {
            d3 = d9;
            d2 = this.TforY(d9);
        } else {
            d3 = d11;
            d2 = 1.0;
        }
        boolean bl = false;
        boolean bl2 = false;
        while (true) {
            double d12;
            double d13 = this.XforT(d4);
            if (d12 < d6) {
                if (bl2 || d13 > d7) {
                    return true;
                }
                bl = true;
            } else {
                if (bl) {
                    return true;
                }
                bl2 = true;
            }
            if (d4 >= d2) break;
            d4 = this.nextVertical(d4, d2);
        }
        if (bl) {
            void var1_1;
            var1_1.record(d5, d3, this.direction);
        }
        return false;
    }

    public abstract Rectangle2D enlarge(Rectangle2D var1);

    public abstract double TforY(double var1);

    public abstract double XforT(double var1);

    public abstract double nextVertical(double var1, double var3);

    /*
     * WARNING - void declaration
     */
    public Curve getSubCurve(double ystart, double yend) {
        void var3_2;
        void var1_1;
        return this.getSubCurve((double)var1_1, (double)var3_2, this.direction);
    }

    public abstract Curve getSubCurve(double var1, double var3, int var5);

    /*
     * WARNING - void declaration
     */
    public int compareTo(Curve that, double[] yrange) {
        void var1_1;
        void var2_3;
        double d2;
        double d3;
        double d4;
        double d5;
        double d6;
        double d7;
        double d8;
        double d9;
        double d10;
        double d11 = yrange[0];
        double d12 = yrange[1];
        d12 = Math.min(Math.min(d12, this.getYBot()), that.getYBot());
        if (d10 <= yrange[0]) {
            System.err.println("this == " + this);
            System.err.println("that == " + that);
            System.out.println("target range = " + yrange[0] + "=>" + yrange[1]);
            throw new Error("backstepping from " + yrange[0] + " to " + d12);
        }
        yrange[1] = d12;
        if (this.getXMax() <= that.getXMin()) {
            if (this.getXMin() == that.getXMax()) {
                return 0;
            }
            return -1;
        }
        if (this.getXMin() >= that.getXMax()) {
            return 1;
        }
        double d13 = this.TforY(d11);
        double d14 = this.YforT(d13);
        if (d9 < d11) {
            d13 = this.refineTforY(d13, d14, d11);
            d14 = this.YforT(d13);
        }
        if (this.YforT(d8 = this.TforY(d12)) < d11) {
            d8 = this.refineTforY(d8, this.YforT(d8), d11);
        }
        double d15 = that.TforY(d11);
        double d16 = that.YforT(d15);
        if (d7 < d11) {
            d15 = that.refineTforY(d15, d16, d11);
            d16 = that.YforT(d15);
        }
        if (that.YforT(d6 = that.TforY(d12)) < d11) {
            d6 = that.refineTforY(d6, that.YforT(d6), d11);
        }
        double d17 = this.XforT(d13);
        double d18 = that.XforT(d15);
        double d19 = Math.max(Math.abs(d11), Math.abs(d12));
        double d20 = Math.max(d19 * 1.0E-14, 1.0E-300);
        if (Curve.a(d17, d18)) {
            d5 = d20;
            d4 = Math.min(d20 * 1.0E13, (d12 - d11) * 0.1);
            for (d3 = d11 + d5; d3 <= d12; d3 += d5) {
                if (Curve.a(this.XforY(d3), that.XforY(d3))) {
                    double d21;
                    d5 *= 2.0;
                    if (!(d21 > d4)) continue;
                    d5 = d4;
                    continue;
                }
                d3 -= d5;
                while (!((d2 = d3 + (d5 /= 2.0)) <= d3)) {
                    if (!Curve.a(this.XforY(d2), that.XforY(d2))) continue;
                    d3 = d2;
                }
                break;
            }
            if (d3 > d11) {
                if (d3 < d12) {
                    yrange[1] = d3;
                }
                return 0;
            }
        }
        if (d20 <= 0.0) {
            System.out.println("ymin = " + d20);
        }
        while (d13 < d8 && d15 < d6) {
            d5 = this.nextVertical(d13, d8);
            d4 = this.XforT(d5);
            d3 = this.YforT(d5);
            d2 = that.nextVertical(d15, d6);
            double d22 = that.XforT(d2);
            double d23 = that.YforT(d2);
            try {
                if (this.findIntersect(that, yrange, d20, 0, 0, d13, d17, d14, d5, d4, d3, d15, d18, d16, d2, d22, d23)) {
                    break;
                }
            }
            catch (Throwable throwable) {
                System.err.println("Error: " + throwable);
                System.err.println("y range was " + yrange[0] + "=>" + yrange[1]);
                System.err.println("s y range is " + d14 + "=>" + d3);
                System.err.println("t y range is " + d16 + "=>" + d23);
                System.err.println("ymin is " + d20);
                return 0;
            }
            if (d3 < d23) {
                if (d3 > yrange[0]) {
                    if (!(d3 < yrange[1])) break;
                    yrange[1] = d3;
                    break;
                }
                d13 = d5;
                d17 = d4;
                d14 = d3;
                continue;
            }
            if (d23 > yrange[0]) {
                if (!(d23 < yrange[1])) break;
                yrange[1] = d23;
                break;
            }
            d15 = d2;
            d18 = d22;
            d16 = d23;
        }
        d5 = (yrange[0] + var2_3[1]) / 2.0;
        return Curve.orderof(this.XforY(d5), var1_1.XforY(d5));
    }

    /*
     * WARNING - void declaration
     */
    public boolean findIntersect(Curve that, double[] yrange, double ymin, int slevel, int tlevel, double s0, double xs0, double ys0, double s1, double xs1, double ys1, double t0, double xt0, double yt0, double t1, double xt1, double yt1) {
        if (ys0 > yt1 || yt0 > ys1) {
            return false;
        }
        if (Math.min(xs0, xs1) > Math.max(xt0, xt1) || Math.max(xs0, xs1) < Math.min(xt0, xt1)) {
            return false;
        }
        if (s1 - s0 > 0.001) {
            double d2 = (s0 + s1) / 2.0;
            double d3 = this.XforT(d2);
            double d4 = this.YforT(d2);
            if (d2 == s0 || d2 == s1) {
                System.out.println("s0 = " + s0);
                System.out.println("s1 = " + s1);
                throw new Error("no s progress!");
            }
            if (t1 - t0 > 0.001) {
                double d5 = (t0 + t1) / 2.0;
                double d6 = that.XforT(d5);
                double d7 = that.YforT(d5);
                if (d5 == t0 || d5 == t1) {
                    System.out.println("t0 = " + t0);
                    System.out.println("t1 = " + t1);
                    throw new Error("no t progress!");
                }
                if (d4 >= yt0 && d7 >= ys0 && this.findIntersect(that, yrange, ymin, slevel + 1, tlevel + 1, s0, xs0, ys0, d2, d3, d4, t0, xt0, yt0, d5, d6, d7)) {
                    return true;
                }
                if (d4 >= d7 && this.findIntersect(that, yrange, ymin, slevel + 1, tlevel + 1, s0, xs0, ys0, d2, d3, d4, d5, d6, d7, t1, xt1, yt1)) {
                    return true;
                }
                if (d7 >= d4 && this.findIntersect(that, yrange, ymin, slevel + 1, tlevel + 1, d2, d3, d4, s1, xs1, ys1, t0, xt0, yt0, d5, d6, d7)) {
                    return true;
                }
                if (ys1 >= d7 && yt1 >= d4) {
                    return this.findIntersect(that, yrange, ymin, slevel + 1, tlevel + 1, d2, d3, d4, s1, xs1, ys1, d5, d6, d7, t1, xt1, yt1);
                }
            } else {
                if (d4 >= yt0 && this.findIntersect(that, yrange, ymin, slevel + 1, tlevel, s0, xs0, ys0, d2, d3, d4, t0, xt0, yt0, t1, xt1, yt1)) {
                    return true;
                }
                if (yt1 >= d4) {
                    return this.findIntersect(that, yrange, ymin, slevel + 1, tlevel, d2, d3, d4, s1, xs1, ys1, t0, xt0, yt0, t1, xt1, yt1);
                }
            }
        } else if (t1 - t0 > 0.001) {
            double d8 = (t0 + t1) / 2.0;
            double d9 = that.XforT(d8);
            double d10 = that.YforT(d8);
            if (d8 == t0 || d8 == t1) {
                System.out.println("t0 = " + t0);
                System.out.println("t1 = " + t1);
                throw new Error("no t progress!");
            }
            if (d10 >= ys0 && this.findIntersect(that, yrange, ymin, slevel, tlevel + 1, s0, xs0, ys0, s1, xs1, ys1, t0, xt0, yt0, d8, d9, d10)) {
                return true;
            }
            if (ys1 >= d10) {
                void var3_3;
                return this.findIntersect(that, yrange, (double)var3_3, slevel, tlevel + 1, s0, xs0, ys0, s1, xs1, ys1, d8, d9, d10, t1, xt1, yt1);
            }
        } else {
            double d11 = xt1 - xt0;
            double d12 = ys1 - ys0;
            double d13 = yt1 - yt0;
            double d14 = xs1 - xs0;
            double d15 = d11 * d12 - d13 * d14;
            if (d15 != 0.0) {
                double d16 = 1.0 / d15;
                double d17 = yt0 - ys0;
                double d18 = xt0 - xs0;
                double d19 = (d11 * d17 - d13 * d18) * d16;
                double d20 = (d14 * d17 - d12 * d18) * d16;
                if (d19 >= 0.0 && d19 <= 1.0 && d20 >= 0.0 && d20 <= 1.0) {
                    double d21;
                    void var1_1;
                    d19 = s0 + d19 * (s1 - s0);
                    d20 = t0 + d20 * (t1 - t0);
                    if (d19 < 0.0 || d19 > 1.0 || d20 < 0.0 || d20 > 1.0) {
                        System.out.println("Uh oh!");
                    }
                    double d22 = (this.YforT(d19) + var1_1.YforT(d20)) / 2.0;
                    if (d21 <= yrange[1] && d22 > yrange[0]) {
                        var2_2[1] = d22;
                        return true;
                    }
                }
            }
        }
        return false;
    }

    public double refineTforY(double t0, double yt0, double y0) {
        double d2 = 1.0;
        while (true) {
            double d3;
            double d4;
            if ((d4 = (t0 + d2) / 2.0) == t0 || d4 == d2) {
                return d2;
            }
            double d5 = this.YforT(d4);
            if (d3 < y0) {
                t0 = d4;
                continue;
            }
            if (!(d5 > y0)) break;
            d2 = d4;
        }
        return d2;
    }

    public abstract int getSegment(double[] var1);
}

