/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.geom;

import com.macrofocus.common.annotations.GwtIncompatible;
import com.macrofocus.geom.AffineTransform;
import com.macrofocus.geom.Curve;
import com.macrofocus.geom.FlatteningPathIterator;
import com.macrofocus.geom.PathIterator;
import com.macrofocus.geom.Point2D;
import com.macrofocus.geom.Rectangle2D;
import com.macrofocus.geom.Shape;
import java.util.Arrays;

public abstract class Path2D
implements Shape {
    public static final int WIND_EVEN_ODD = 0;
    public static final int WIND_NON_ZERO = 1;
    transient byte[] a;
    transient int b;
    transient int c;
    transient int d;

    Path2D() {
    }

    /*
     * WARNING - void declaration
     */
    Path2D(int rule, int initialTypes) {
        void var2_2;
        void var1_1;
        this.setWindingRule((int)var1_1);
        this.a = new byte[var2_2];
    }

    /*
     * WARNING - void declaration
     */
    public static boolean contains(PathIterator pi, Point2D p) {
        void var1_1;
        return Path2D.contains(pi, p.getX(), var1_1.getY());
    }

    /*
     * WARNING - void declaration
     */
    public static boolean contains(PathIterator pi, double x, double y) {
        if (x * 0.0 + y * 0.0 == 0.0) {
            void var3_3;
            void var1_2;
            PathIterator pathIterator;
            int n = pi.getWindingRule() == 1 ? -1 : 1;
            int n2 = Curve.pointCrossingsForPath(pathIterator, (double)var1_2, (double)var3_3);
            return (n2 & n) != 0;
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    public static boolean contains(PathIterator pi, Rectangle2D r) {
        void var1_1;
        return Path2D.contains(pi, r.getX(), r.getY(), r.getWidth(), var1_1.getHeight());
    }

    /*
     * WARNING - void declaration
     */
    public static boolean contains(PathIterator pi, double x, double y, double w, double h) {
        void var3_3;
        void var1_2;
        PathIterator pathIterator;
        if (java.lang.Double.isNaN(x + w) || java.lang.Double.isNaN(y + h)) {
            return false;
        }
        if (w <= 0.0 || h <= 0.0) {
            return false;
        }
        int n = pi.getWindingRule() == 1 ? -1 : 2;
        int n2 = Curve.rectCrossingsForPath(pathIterator, x, y, (double)(var1_2 + w), (double)(var3_3 + h));
        return n2 != Integer.MIN_VALUE && (n2 & n) != 0;
    }

    /*
     * WARNING - void declaration
     */
    public static boolean intersects(PathIterator pi, Rectangle2D r) {
        void var1_1;
        return Path2D.intersects(pi, r.getX(), r.getY(), r.getWidth(), var1_1.getHeight());
    }

    /*
     * WARNING - void declaration
     */
    public static boolean intersects(PathIterator pi, double x, double y, double w, double h) {
        void var3_3;
        void var1_2;
        PathIterator pathIterator;
        if (java.lang.Double.isNaN(x + w) || java.lang.Double.isNaN(y + h)) {
            return false;
        }
        if (w <= 0.0 || h <= 0.0) {
            return false;
        }
        int n = pi.getWindingRule() == 1 ? -1 : 2;
        int n2 = Curve.rectCrossingsForPath(pathIterator, x, y, (double)(var1_2 + w), (double)(var3_3 + h));
        return n2 == Integer.MIN_VALUE || (n2 & n) != 0;
    }

    /*
     * WARNING - void declaration
     */
    public static byte[] copyOf(byte[] original, int newLength) {
        void var1_1;
        byte[] byArray;
        byte[] byArray2 = new byte[newLength];
        System.arraycopy(original, 0, byArray2, 0, Math.min(byArray.length, (int)var1_1));
        return byArray2;
    }

    /*
     * WARNING - void declaration
     */
    public static double[] copyOf(double[] original, int newLength) {
        void var1_1;
        double[] dArray;
        double[] dArray2 = new double[newLength];
        System.arraycopy(original, 0, dArray2, 0, Math.min(dArray.length, (int)var1_1));
        return dArray2;
    }

    abstract double[] a(AffineTransform var1);

    public abstract Shape createTransformedShape(AffineTransform var1);

    public abstract void moveTo(double var1, double var3);

    public abstract void lineTo(double var1, double var3);

    public abstract void quadTo(double var1, double var3, double var5, double var7);

    public abstract void curveTo(double var1, double var3, double var5, double var7, double var9, double var11);

    public final synchronized void closePath() {
        if (this.b == 0 || this.a[this.b - 1] != 4) {
            this.a(true, 0);
            this.a[this.b++] = 4;
        }
    }

    abstract void a(boolean var1, int var2);

    public abstract void append(PathIterator var1, boolean var2);

    public final synchronized int getWindingRule() {
        return this.d;
    }

    /*
     * WARNING - void declaration
     */
    public final void setWindingRule(int rule) {
        void var1_1;
        if (rule != 0 && rule != 1) {
            throw new IllegalArgumentException("winding rule must be WIND_EVEN_ODD or WIND_NON_ZERO");
        }
        this.d = var1_1;
    }

    /*
     * Enabled aggressive block sorting
     */
    public final synchronized Point2D getCurrentPoint() {
        int n = this.c;
        if (this.b <= 0) return null;
        if (n <= 0) {
            return null;
        }
        if (this.a[this.b - 1] != 4) return this.a(n - 2);
        int n2 = this.b - 2;
        while (n2 > 0) {
            switch (this.a[n2]) {
                case 0: {
                    return this.a(n - 2);
                }
                case 1: {
                    n -= 2;
                    break;
                }
                case 2: {
                    n -= 4;
                    break;
                }
                case 3: {
                    n -= 6;
                }
            }
            --n2;
        }
        return this.a(n - 2);
    }

    abstract Point2D a(int var1);

    public final synchronized void reset() {
        Path2D path2D = this;
        path2D.c = 0;
        path2D.b = 0;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final boolean contains(Point2D p) {
        void var1_1;
        return this.contains(p.getX(), var1_1.getY());
    }

    /*
     * WARNING - void declaration
     */
    public final boolean contains(double x, double y) {
        if (x * 0.0 + y * 0.0 == 0.0) {
            void var3_2;
            void var1_1;
            int n;
            if (this.b < 2) {
                return false;
            }
            int n2 = n = this.d == 1 ? -1 : 1;
            return (this.a((double)var1_1, (double)var3_2) & n) != 0;
        }
        return false;
    }

    abstract int a(double var1, double var3);

    /*
     * WARNING - void declaration
     */
    @Override
    public final boolean intersects(Rectangle2D r) {
        void var1_1;
        return this.intersects(r.getX(), r.getY(), r.getWidth(), var1_1.getHeight());
    }

    /*
     * WARNING - void declaration
     */
    public final boolean intersects(double x, double y, double w, double h) {
        void var3_3;
        void var1_1;
        if (java.lang.Double.isNaN(x + w) || java.lang.Double.isNaN(y + h)) {
            return false;
        }
        if (w <= 0.0 || h <= 0.0) {
            return false;
        }
        int n = this.d == 1 ? -1 : 2;
        int n2 = this.a(x, y, (double)(var1_1 + w), (double)(var3_3 + h));
        return n2 == Integer.MIN_VALUE || (n2 & n) != 0;
    }

    /*
     * WARNING - void declaration
     */
    public final boolean contains(Rectangle2D r) {
        void var1_1;
        return this.contains(r.getX(), r.getY(), r.getWidth(), var1_1.getHeight());
    }

    /*
     * WARNING - void declaration
     */
    public final boolean contains(double x, double y, double w, double h) {
        void var3_3;
        void var1_1;
        if (java.lang.Double.isNaN(x + w) || java.lang.Double.isNaN(y + h)) {
            return false;
        }
        if (w <= 0.0 || h <= 0.0) {
            return false;
        }
        int n = this.d == 1 ? -1 : 2;
        int n2 = this.a(x, y, (double)(var1_1 + w), (double)(var3_3 + h));
        return n2 != Integer.MIN_VALUE && (n2 & n) != 0;
    }

    abstract int a(double var1, double var3, double var5, double var7);

    static abstract class a
    implements PathIterator {
        static final int[] a = new int[]{2, 2, 4, 6, 0};
        final Path2D b;
        int c;
        int d;

        a(Path2D path2D) {
            this.b = path2D;
        }

        @Override
        public int getWindingRule() {
            return this.b.getWindingRule();
        }

        @Override
        public boolean isDone() {
            return this.c >= this.b.b;
        }

        @Override
        public void next() {
            byte by = this.b.a[this.c++];
            this.d += a[by];
        }
    }

    public static class Double
    extends Path2D {
        transient double[] e;

        public Double() {
            this(1, 20);
        }

        /*
         * WARNING - void declaration
         */
        public Double(int rule, int initialCapacity) {
            super((int)var1_1, initialCapacity);
            void var2_2;
            void var1_1;
            this.e = new double[var2_2 << 1];
        }

        /*
         * WARNING - void declaration
         */
        public Double(int rule) {
            this((int)var1_1, 20);
            void var1_1;
        }

        /*
         * WARNING - void declaration
         */
        public Double(Path2D p2d) {
            void var1_1;
            this.setWindingRule(p2d.d);
            this.b = p2d.b;
            this.a = Double.copyOf(p2d.a, p2d.a.length);
            this.c = p2d.c;
            this.e = var1_1.a(null);
        }

        /*
         * WARNING - void declaration
         */
        public Double(Shape s, AffineTransform at) {
            void var2_2;
            Object object;
            if (s instanceof Path2D) {
                object = (Path2D)s;
                this.setWindingRule(((Path2D)object).d);
                this.b = ((Path2D)object).b;
                this.a = Arrays.copyOf(((Path2D)object).a, ((Path2D)object).b);
                this.c = ((Path2D)object).c;
                this.e = ((Path2D)object).a(at);
                return;
            }
            object = object.getPathIterator((AffineTransform)var2_2);
            this.setWindingRule(object.getWindingRule());
            this.a = new byte[20];
            this.e = new double[40];
            this.append((PathIterator)object, false);
        }

        /*
         * WARNING - void declaration
         */
        public Double(PathIterator pi) {
            void var1_1;
            this.setWindingRule(pi.getWindingRule());
            this.a = new byte[20];
            this.e = new double[40];
            this.append((PathIterator)var1_1, false);
        }

        @Override
        final double[] a(AffineTransform affineTransform) {
            double[] dArray;
            if (affineTransform == null) {
                dArray = Arrays.copyOf(this.e, this.c);
            } else {
                dArray = new double[this.c];
                affineTransform.transform(this.e, 0, dArray, 0, this.c / 2);
            }
            return dArray;
        }

        @Override
        final Point2D a(int n) {
            return new Point2D.Double(this.e[n], this.e[n + 1]);
        }

        @Override
        final void a(boolean n, int n2) {
            int n3;
            if (n != 0 && this.b == 0) {
                throw new IllegalStateException("missing initial moveto in path definition");
            }
            n = this.a.length;
            if (this.b >= n) {
                n3 = n;
                if (n > 500) {
                    n3 = 500;
                }
                this.a = Double.copyOf(this.a, n + n3);
            }
            if (this.c + n2 > (n = this.e.length)) {
                n3 = n;
                if (n > 1000) {
                    n3 = 1000;
                }
                if (n3 < n2) {
                    n3 = n2;
                }
                this.e = Double.copyOf(this.e, n + n3);
            }
        }

        @Override
        final int a(double d2, double d3) {
            double d4;
            double d5;
            if (this.b == 0) {
                return 0;
            }
            double[] dArray = this.e;
            double d6 = d5 = this.e[0];
            double d7 = d4 = dArray[1];
            int n = 0;
            int n2 = 2;
            block7: for (int i = 1; i < this.b; ++i) {
                switch (this.a[i]) {
                    case 0: {
                        if (d7 != d4) {
                            n += Curve.pointCrossingsForLine(d2, d3, d6, d7, d5, d4);
                        }
                        d5 = d6 = dArray[n2++];
                        d4 = d7 = dArray[n2++];
                        continue block7;
                    }
                    case 1: {
                        double d8 = dArray[n2++];
                        double d9 = dArray[n2++];
                        n += Curve.pointCrossingsForLine(d2, d3, d6, d7, d8, d9);
                        d6 = d8;
                        d7 = d9;
                        continue block7;
                    }
                    case 2: {
                        int n3 = n2++;
                        int n4 = n2++;
                        double d8 = dArray[n2++];
                        double d9 = dArray[n2++];
                        n += Curve.pointCrossingsForQuad(d2, d3, d6, d7, dArray[n3], dArray[n4], d8, d9, 0);
                        d6 = d8;
                        d7 = d9;
                        continue block7;
                    }
                    case 3: {
                        int n5 = n2++;
                        int n6 = n2++;
                        int n7 = n2++;
                        int n8 = n2++;
                        double d8 = dArray[n2++];
                        double d9 = dArray[n2++];
                        n += Curve.pointCrossingsForCubic(d2, d3, d6, d7, dArray[n5], dArray[n6], dArray[n7], dArray[n8], d8, d9, 0);
                        d6 = d8;
                        d7 = d9;
                        continue block7;
                    }
                    case 4: {
                        if (d7 != d4) {
                            n += Curve.pointCrossingsForLine(d2, d3, d6, d7, d5, d4);
                        }
                        d6 = d5;
                        d7 = d4;
                    }
                }
            }
            if (d7 != d4) {
                n += Curve.pointCrossingsForLine(d2, d3, d6, d7, d5, d4);
            }
            return n;
        }

        @Override
        final int a(double d2, double d3, double d4, double d5) {
            double d6;
            double d7;
            if (this.b == 0) {
                return 0;
            }
            double[] dArray = this.e;
            double d8 = d7 = this.e[0];
            double d9 = d6 = dArray[1];
            int n = 0;
            int n2 = 2;
            block7: for (int i = 1; n != Integer.MIN_VALUE && i < this.b; ++i) {
                switch (this.a[i]) {
                    case 0: {
                        if (d8 != d7 || d9 != d6) {
                            n = Curve.rectCrossingsForLine(n, d2, d3, d4, d5, d8, d9, d7, d6);
                        }
                        d7 = d8 = dArray[n2++];
                        d6 = d9 = dArray[n2++];
                        continue block7;
                    }
                    case 1: {
                        double d10 = dArray[n2++];
                        double d11 = dArray[n2++];
                        n = Curve.rectCrossingsForLine(n, d2, d3, d4, d5, d8, d9, d10, d11);
                        d8 = d10;
                        d9 = d11;
                        continue block7;
                    }
                    case 2: {
                        int n3 = n2++;
                        int n4 = n2++;
                        double d10 = dArray[n2++];
                        double d11 = dArray[n2++];
                        n = Curve.rectCrossingsForQuad(n, d2, d3, d4, d5, d8, d9, dArray[n3], dArray[n4], d10, d11, 0);
                        d8 = d10;
                        d9 = d11;
                        continue block7;
                    }
                    case 3: {
                        int n5 = n2++;
                        int n6 = n2++;
                        int n7 = n2++;
                        int n8 = n2++;
                        double d10 = dArray[n2++];
                        double d11 = dArray[n2++];
                        n = Curve.rectCrossingsForCubic(n, d2, d3, d4, d5, d8, d9, dArray[n5], dArray[n6], dArray[n7], dArray[n8], d10, d11, 0);
                        d8 = d10;
                        d9 = d11;
                        continue block7;
                    }
                    case 4: {
                        if (d8 != d7 || d9 != d6) {
                            n = Curve.rectCrossingsForLine(n, d2, d3, d4, d5, d8, d9, d7, d6);
                        }
                        d8 = d7;
                        d9 = d6;
                    }
                }
            }
            if (n != Integer.MIN_VALUE && (d8 != d7 || d9 != d6)) {
                n = Curve.rectCrossingsForLine(n, d2, d3, d4, d5, d8, d9, d7, d6);
            }
            return n;
        }

        @Override
        public Shape createTransformedShape(AffineTransform transform) {
            return null;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final synchronized void moveTo(double x, double y) {
            void var3_2;
            void var1_1;
            if (this.b > 0 && this.a[this.b - 1] == 0) {
                this.e[this.c - 2] = x;
                this.e[this.c - 1] = y;
                return;
            }
            this.a(false, 2);
            this.a[this.b++] = 0;
            this.e[this.c++] = var1_1;
            this.e[this.c++] = var3_2;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final synchronized void lineTo(double x, double y) {
            void var3_2;
            void var1_1;
            this.a(true, 2);
            this.a[this.b++] = 1;
            this.e[this.c++] = var1_1;
            this.e[this.c++] = var3_2;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final synchronized void quadTo(double x1, double y1, double x2, double y2) {
            void var3_2;
            void var1_1;
            this.a(true, 4);
            this.a[this.b++] = 2;
            this.e[this.c++] = var1_1;
            this.e[this.c++] = var3_2;
            this.e[this.c++] = x2;
            this.e[this.c++] = y2;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final synchronized void curveTo(double x1, double y1, double x2, double y2, double x3, double y3) {
            void var3_2;
            void var1_1;
            this.a(true, 6);
            this.a[this.b++] = 3;
            this.e[this.c++] = var1_1;
            this.e[this.c++] = var3_2;
            this.e[this.c++] = x2;
            this.e[this.c++] = y2;
            this.e[this.c++] = x3;
            this.e[this.c++] = y3;
        }

        @Override
        public final void append(PathIterator pi, boolean connect) {
            double[] dArray = new double[6];
            while (!pi.isDone()) {
                switch (pi.currentSegment(dArray)) {
                    case 0: {
                        if (!connect || this.b <= 0 || this.c <= 0) {
                            this.moveTo(dArray[0], dArray[1]);
                            break;
                        }
                        if (this.a[this.b - 1] != 4 && this.e[this.c - 2] == dArray[0] && this.e[this.c - 1] == dArray[1]) break;
                    }
                    case 1: {
                        this.lineTo(dArray[0], dArray[1]);
                        break;
                    }
                    case 2: {
                        this.quadTo(dArray[0], dArray[1], dArray[2], dArray[3]);
                        break;
                    }
                    case 3: {
                        this.curveTo(dArray[0], dArray[1], dArray[2], dArray[3], dArray[4], dArray[5]);
                        break;
                    }
                    case 4: {
                        this.closePath();
                    }
                }
                pi.next();
                connect = false;
            }
        }

        public final void transform(AffineTransform at) {
            at.transform(this.e, 0, this.e, 0, this.c / 2);
        }

        @Override
        public final synchronized Rectangle2D getBounds2D() {
            double d2;
            double d3;
            double d4;
            double d5;
            int n = this.c;
            if (n > 0) {
                d4 = d5 = this.e[--n];
                d2 = d3 = this.e[--n];
                while (n > 0) {
                    double d6;
                    double d7 = this.e[--n];
                    double d8 = this.e[--n];
                    if (d6 < d2) {
                        d2 = d8;
                    }
                    if (d7 < d4) {
                        d4 = d7;
                    }
                    if (d8 > d3) {
                        d3 = d8;
                    }
                    if (!(d7 > d5)) continue;
                    d5 = d7;
                }
            } else {
                d5 = 0.0;
                d3 = 0.0;
                d4 = 0.0;
                d2 = 0.0;
            }
            return new Rectangle2D.Double(d2, d4, d3 - d2, d5 - d4);
        }

        @Override
        public PathIterator getPathIterator() {
            return this.getPathIterator(null);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public PathIterator getPathIterator(AffineTransform at) {
            void var1_1;
            if (at == null) {
                return new a(this);
            }
            return new b(this, (AffineTransform)var1_1);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final PathIterator getFlattenPathIterator(double flatness) {
            void var1_1;
            return new FlatteningPathIterator(this.getPathIterator(), (double)var1_1);
        }

        @GwtIncompatible
        protected Object clone() throws CloneNotSupportedException {
            return super.clone();
        }

        static final class b
        extends com.macrofocus.geom.Path2D$a {
            private double[] e;
            private AffineTransform f;

            b(Double double_, AffineTransform affineTransform) {
                super(double_);
                this.e = double_.e;
                this.f = affineTransform;
            }

            /*
             * WARNING - void declaration
             */
            @Override
            public final int currentSegment(float[] coords) {
                byte by = this.b.a[this.c];
                int n = a[by];
                if (n > 0) {
                    void var1_1;
                    this.f.transform(this.e, this.d, (float[])var1_1, 0, n / 2);
                }
                return by;
            }

            /*
             * WARNING - void declaration
             */
            @Override
            public final int currentSegment(double[] coords) {
                byte by = this.b.a[this.c];
                int n = a[by];
                if (n > 0) {
                    void var1_1;
                    this.f.transform(this.e, this.d, (double[])var1_1, 0, n / 2);
                }
                return by;
            }
        }

        static final class a
        extends com.macrofocus.geom.Path2D$a {
            private double[] e;

            a(Double double_) {
                super(double_);
                this.e = double_.e;
            }

            @Override
            public final int currentSegment(float[] coords) {
                byte by = this.b.a[this.c];
                int n = a[by];
                if (n > 0) {
                    for (int i = 0; i < n; ++i) {
                        coords[i] = (float)this.e[this.d + i];
                    }
                }
                return by;
            }

            @Override
            public final int currentSegment(double[] coords) {
                byte by = this.b.a[this.c];
                int n = a[by];
                if (n > 0) {
                    for (int i = 0; i < n; ++i) {
                        coords[i] = this.e[this.d + i];
                    }
                }
                return by;
            }
        }
    }
}

