/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.geom;

import com.macrofocus.geom.AffineTransform;
import com.macrofocus.geom.FlatteningPathIterator;
import com.macrofocus.geom.Line2D;
import com.macrofocus.geom.PathIterator;
import com.macrofocus.geom.Point2D;
import com.macrofocus.geom.QuadIterator;
import com.macrofocus.geom.Rectangle2D;
import com.macrofocus.geom.Shape;

public abstract class QuadCurve2D
implements Shape {
    /*
     * WARNING - void declaration
     */
    public static double getFlatnessSq(double[] coords, int offset) {
        void var1_1;
        double[] dArray;
        return Line2D.ptSegDistSq(coords[offset], coords[offset + 1], coords[offset + 4], coords[offset + 5], coords[offset + 2], dArray[var1_1 + 3]);
    }

    /*
     * WARNING - void declaration
     */
    public static void subdivide(double[] src, int srcoff, double[] left, int leftoff, double[] right, int rightoff) {
        void var1_1;
        double[] dArray;
        double d2 = src[srcoff];
        double d3 = src[srcoff + 1];
        double d4 = src[srcoff + 2];
        double d5 = src[srcoff + 3];
        double d6 = src[srcoff + 4];
        double d7 = dArray[var1_1 + 5];
        if (left != null) {
            left[leftoff] = d2;
            left[leftoff + 1] = d3;
        }
        if (right != null) {
            right[rightoff + 4] = d6;
            right[rightoff + 5] = d7;
        }
        d2 = (d2 + d4) / 2.0;
        d3 = (d3 + d5) / 2.0;
        d6 = (d6 + d4) / 2.0;
        d7 = (d7 + d5) / 2.0;
        d4 = (d2 + d6) / 2.0;
        d5 = (d3 + d7) / 2.0;
        if (left != null) {
            left[leftoff + 2] = d2;
            left[leftoff + 3] = d3;
            left[leftoff + 4] = d4;
            var2_2[var3_3 + 5] = d5;
        }
        if (right != null) {
            right[rightoff] = d4;
            right[rightoff + 1] = d5;
            right[rightoff + 2] = d6;
            right[rightoff + 3] = d7;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean contains(Point2D point) {
        void var1_1;
        return this.contains(point.getX(), var1_1.getY());
    }

    /*
     * WARNING - void declaration
     */
    public boolean contains(double x, double y) {
        void var3_2;
        void var1_1;
        double d2;
        double d3;
        double d4;
        double d5;
        double d6;
        double d7;
        double d8;
        double d9;
        double d10;
        block3: {
            block2: {
                double d11;
                d10 = this.getX1();
                d9 = this.getY1();
                d8 = this.getCtrlX();
                d7 = this.getCtrlY();
                double d12 = this.getX2();
                double d13 = x - d10;
                double d14 = this.getY2();
                d6 = d9 - d7 * 2.0 + d14;
                d2 = (d13 * d6 - (d11 = y - d9) * (d5 = d10 - d8 * 2.0 + d12)) / ((d4 = d12 - d10) * d6 - (d3 = d14 - d9) * d5);
                if (d2 < 0.0 || d2 > 1.0) break block2;
                double d15 = d2;
                if (d15 == d15) break block3;
            }
            return false;
        }
        double d16 = d5 * d2 * d2 + 2.0 * (d8 - d10) * d2 + d10;
        double d17 = d6 * d2 * d2 + 2.0 * (d7 - d9) * d2 + d9;
        double d18 = d4 * d2 + d10;
        double d19 = d3 * d2 + d9;
        return x >= d16 && x < d18 || x >= d18 && var1_1 < d16 || y >= d17 && y < d19 || y >= d19 && var3_2 < d17;
    }

    public abstract double getX1();

    public abstract double getY1();

    public abstract double getCtrlX();

    public abstract double getCtrlY();

    public abstract double getX2();

    public abstract double getY2();

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean intersects(Rectangle2D r) {
        void var1_1;
        return this.intersects(r.getX(), r.getY(), r.getWidth(), var1_1.getHeight());
    }

    /*
     * WARNING - void declaration
     */
    public boolean intersects(double x, double y, double w, double h) {
        void var3_3;
        void var1_1;
        if (w <= 0.0 || h <= 0.0) {
            return false;
        }
        double d2 = this.getX1();
        double d3 = this.getY1();
        double d4 = x;
        int n = QuadCurve2D.a(d2, d4, d4 + w);
        double d5 = y;
        int n2 = QuadCurve2D.a(d3, d5, d5 + h);
        if (n == 0 && n2 == 0) {
            return true;
        }
        double d6 = this.getX2();
        double d7 = this.getY2();
        double d8 = x;
        int n3 = QuadCurve2D.a(d6, d8, d8 + w);
        double d9 = y;
        int n4 = QuadCurve2D.a(d7, d9, d9 + h);
        if (n3 == 0 && n4 == 0) {
            return true;
        }
        double d10 = this.getCtrlX();
        double d11 = this.getCtrlY();
        double d12 = x;
        int n5 = QuadCurve2D.a(d10, d12, d12 + w);
        double d13 = y;
        int n6 = QuadCurve2D.a(d11, d13, d13 + h);
        if (n < 0 && n3 < 0 && n5 < 0) {
            return false;
        }
        if (n2 < 0 && n4 < 0 && n6 < 0) {
            return false;
        }
        if (n > 0 && n3 > 0 && n5 > 0) {
            return false;
        }
        if (n2 > 0 && n4 > 0 && n6 > 0) {
            return false;
        }
        if (QuadCurve2D.a(n, n3, n5) && QuadCurve2D.a(n2, n4, n6)) {
            return true;
        }
        if (QuadCurve2D.a(n3, n, n5) && QuadCurve2D.a(n4, n2, n6)) {
            return true;
        }
        int n7 = n5 = n2 * n4 <= 0 ? 1 : 0;
        if (n == 0 && n3 == 0 && n5 != 0) {
            return true;
        }
        int n8 = n6 = n * n3 <= 0 ? 1 : 0;
        if (n2 == 0 && n4 == 0 && n6 != 0) {
            return true;
        }
        double[] dArray = new double[3];
        double[] dArray2 = new double[3];
        if (n5 == 0) {
            QuadCurve2D.a(dArray, n2 < 0 ? y : y + h, d3, d11, d7);
            if (QuadCurve2D.solveQuadratic(dArray, dArray2) == 2 && QuadCurve2D.a(dArray2, 2, true, true, null, d2, d10, d6) == 2) {
                double d14 = x;
                double d15 = x;
                if (QuadCurve2D.a(dArray2[0], d14, d14 + w) * QuadCurve2D.a(dArray2[1], d15, d15 + w) <= 0) {
                    return true;
                }
            }
            return false;
        }
        if (n6 == 0) {
            QuadCurve2D.a(dArray, n < 0 ? x : x + w, d2, d10, d6);
            if (QuadCurve2D.solveQuadratic(dArray, dArray2) == 2 && QuadCurve2D.a(dArray2, 2, true, true, null, d3, d11, d7) == 2) {
                double d16 = y;
                double d17 = y;
                if (QuadCurve2D.a(dArray2[0], d16, d16 + h) * QuadCurve2D.a(dArray2[1], d17, d17 + h) <= 0) {
                    return true;
                }
            }
            return false;
        }
        double d18 = d6 - d2;
        double d19 = d7 - d3;
        double d20 = d7 * d2 - d6 * d3;
        if (n2 == 0) {
            n5 = n;
        } else {
            double d21 = x;
            n5 = QuadCurve2D.a((d20 + d18 * (n2 < 0 ? y : y + h)) / d19, d21, d21 + w);
        }
        if (n4 != 0) {
            double d22 = x;
            n3 = QuadCurve2D.a((d20 + d18 * (n4 < 0 ? y : y + h)) / d19, d22, d22 + w);
        }
        if (n5 * n3 <= 0) {
            return true;
        }
        n5 = n5 * n <= 0 ? n2 : n4;
        QuadCurve2D.a(dArray, n3 < 0 ? x : var1_1 + w, d2, d10, d6);
        int n9 = QuadCurve2D.solveQuadratic(dArray, dArray2);
        QuadCurve2D.a(dArray2, n9, true, true, null, d3, d11, d7);
        void v14 = var3_3;
        n3 = QuadCurve2D.a(dArray2[0], (double)v14, (double)(v14 + h));
        return n5 * n3 <= 0;
    }

    public static int solveQuadratic(double[] eqn, double[] res) {
        double[] dArray;
        double d2 = eqn[2];
        double d3 = eqn[1];
        double d4 = dArray[0];
        int n = 0;
        if (d2 == 0.0) {
            if (d3 == 0.0) {
                return -1;
            }
            ++n;
            res[0] = -d4 / d3;
        } else {
            double d5;
            double d6 = d3;
            double d7 = d6 * d6 - d2 * 4.0 * d4;
            if (d5 < 0.0) {
                return 0;
            }
            d7 = Math.sqrt(d7);
            if (d3 < 0.0) {
                d7 = -d7;
            }
            double d8 = (d3 + d7) / -2.0;
            ++n;
            res[0] = d8 / d2;
            if (d8 != 0.0) {
                ++n;
                var1_2[1] = d4 / d8;
            }
        }
        return n;
    }

    private static void a(double[] dArray, double d2, double d3, double d4, double d5) {
        dArray[0] = d3 - d2;
        double d6 = d4;
        dArray[1] = d6 + d6 - d3 - d3;
        dArray[2] = d3 - d4 - d4 + d5;
    }

    private static int a(double[] dArray, int n, boolean bl, boolean n2, double[] dArray2, double d2, double d3, double d4) {
        bl = false;
        for (n2 = 0; n2 < n; ++n2) {
            double d5;
            double d6 = dArray[n2];
            if (!(d5 >= 0.0) || !(d6 <= 1.0) || dArray2 != null && dArray2[1] + 2.0 * dArray2[2] * d6 == 0.0) continue;
            double d7 = 1.0 - d6;
            dArray[(int)(bl++ ? 1 : 0)] = d2 * d7 * d7 + d3 * 2.0 * d6 * d7 + d4 * d6 * d6;
        }
        return bl ? 1 : 0;
    }

    private static int a(double d2, double d3, double d4) {
        if (d2 <= d3) {
            if (d2 < d3) {
                return -2;
            }
            return -1;
        }
        if (d2 >= d4) {
            if (d2 > d4) {
                return 2;
            }
            return 1;
        }
        return 0;
    }

    private static boolean a(int n, int n2, int n3) {
        switch (n) {
            default: {
                return false;
            }
            case -1: {
                return n2 >= 0 || n3 >= 0;
            }
            case 0: {
                return true;
            }
            case 1: 
        }
        return n2 <= 0 || n3 <= 0;
    }

    @Override
    public PathIterator getPathIterator() {
        return this.getPathIterator(null);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public PathIterator getPathIterator(AffineTransform at) {
        void var1_1;
        return new QuadIterator(this, (AffineTransform)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public PathIterator getFlattenPathIterator(double flatness) {
        void var1_1;
        return new FlatteningPathIterator(this.getPathIterator(), (double)var1_1);
    }

    public static class Double
    extends QuadCurve2D {
        public double x1;
        public double y1;
        public double ctrlx;
        public double ctrly;
        public double x2;
        public double y2;

        public Double() {
        }

        /*
         * WARNING - void declaration
         */
        public Double(double x1, double y1, double ctrlx, double ctrly, double x2, double y2) {
            void var3_2;
            void var1_1;
            this.setCurve((double)var1_1, (double)var3_2, ctrlx, ctrly, x2, y2);
        }

        /*
         * WARNING - void declaration
         */
        public void setCurve(double x1, double y1, double ctrlx, double ctrly, double x2, double y2) {
            void var3_2;
            void var1_1;
            this.x1 = var1_1;
            this.y1 = var3_2;
            this.ctrlx = ctrlx;
            this.ctrly = ctrly;
            this.x2 = x2;
            this.y2 = y2;
        }

        @Override
        public double getX1() {
            return this.x1;
        }

        @Override
        public double getY1() {
            return this.y1;
        }

        @Override
        public double getCtrlX() {
            return this.ctrlx;
        }

        @Override
        public double getCtrlY() {
            return this.ctrly;
        }

        @Override
        public double getX2() {
            return this.x2;
        }

        @Override
        public double getY2() {
            return this.y2;
        }

        @Override
        public Rectangle2D getBounds2D() {
            double d2 = Math.min(Math.min(this.x1, this.x2), this.ctrlx);
            double d3 = Math.min(Math.min(this.y1, this.y2), this.ctrly);
            double d4 = Math.max(Math.max(this.x1, this.x2), this.ctrlx);
            double d5 = Math.max(Math.max(this.y1, this.y2), this.ctrly);
            return new Rectangle2D.Double(d2, d3, d4 - d2, d5 - d3);
        }
    }
}

