/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.palette;

import com.macrofocus.common.properties.MutableProperty;
import com.macrofocus.common.properties.PropertyEvent;
import com.macrofocus.common.properties.PropertyListener;
import com.macrofocus.common.properties.SimpleProperty;
import com.macrofocus.igraphics.CPColor;
import com.macrofocus.igraphics.CPColorFactory;
import com.macrofocus.palette.DynamicPalette;
import com.macrofocus.palette.Palette;
import com.macrofocus.palette.PaletteEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import jsinterop.annotations.JsIgnore;
import jsinterop.annotations.JsType;

@JsType
public class CustomPalette<Color>
extends DynamicPalette<Color> {
    private final CPColorFactory<Color> a;
    private MutableProperty<Mode> b = new SimpleProperty((Object)Mode.Ramps);
    private final SortedSet<Entry> c;

    /*
     * WARNING - void declaration
     */
    @JsIgnore
    private CustomPalette(CPColorFactory<Color> factory, SortedSet<Entry> entries) {
        void var2_2;
        void var1_1;
        this.a = var1_1;
        this.c = var2_2;
        this.b.addPropertyListener((PropertyListener)new PropertyListener<Mode>(this){
            private /* synthetic */ CustomPalette a;
            {
                this.a = customPalette;
            }

            public final void propertyChanged(PropertyEvent<Mode> event) {
                this.a.notifyPaletteChanged(new PaletteEvent());
                this.a.a();
            }
        });
    }

    /*
     * WARNING - void declaration
     */
    @JsIgnore
    public CustomPalette(CPColorFactory<Color> factory, Palette<Color> palette) {
        this((CPColorFactory<Color>)var1_1, (SortedSet<Entry>)new TreeSet<Entry>());
        void var1_1;
        for (int i = 0; i < palette.getColorCount(); ++i) {
            CPColor<Color> cPColor = palette.getColorAt(i);
            this.c.add(new Entry<Color>((double)i / (double)(palette.getColorCount() - 1), cPColor));
        }
    }

    /*
     * WARNING - void declaration
     */
    @JsIgnore
    public CustomPalette(CPColorFactory<Color> factory, Entry ... entries) {
        this((CPColorFactory<Color>)var1_1, (SortedSet<Entry>)new TreeSet<Entry>(Arrays.asList(var2_2)));
        void var2_2;
        void var1_1;
    }

    private void a() {
        ArrayList<CPColor<Color>> arrayList = new ArrayList<CPColor<Color>>();
        for (int i = 0; i < 256; ++i) {
            double d2 = 1.0 * (double)i / 255.0;
            CPColor<Color> cPColor = this.a(d2);
            arrayList.add(cPColor);
        }
        this.colors = arrayList;
        this.colorCount = this.colors.size();
        this.notifyPaletteChanged(new PaletteEvent());
    }

    private CPColor<Color> a(double d2) {
        if (!this.c.isEmpty()) {
            Object object = null;
            for (Entry entry : this.c) {
                if (object != null && ((Entry)object).getFraction() <= d2 && d2 <= entry.getFraction()) {
                    double d3 = (d2 - ((Entry)object).getFraction()) / (entry.getFraction() - ((Entry)object).getFraction());
                    CPColor cPColor = ((Entry)object).getColor();
                    double d4 = d3;
                    object = entry.getColor();
                    CPColor cPColor2 = cPColor;
                    CustomPalette customPalette = this;
                    switch ((Mode)((Object)customPalette.b.getValue())) {
                        case Ramps: {
                            if (d4 == 0.0) {
                                return cPColor2;
                            }
                            if (d4 == 1.0) {
                                return object;
                            }
                            return customPalette.a.createRGBAColor((int)((double)cPColor2.getRed() * (1.0 - d4) + (double)object.getRed() * d4), (int)((double)cPColor2.getGreen() * (1.0 - d4) + (double)object.getGreen() * d4), (int)((double)cPColor2.getBlue() * (1.0 - d4) + (double)object.getBlue() * d4), (int)((double)cPColor2.getAlpha() * (1.0 - d4) + (double)object.getAlpha() * d4));
                        }
                        case Bands: {
                            return cPColor2;
                        }
                    }
                    return null;
                }
                object = entry;
            }
            if (d2 < this.c.first().getFraction()) {
                return this.c.first().getColor();
            }
            if (d2 > this.c.last().getFraction()) {
                return this.c.last().getColor();
            }
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    public void setColor(double fraction, CPColor<Color> color) {
        void var3_3;
        void var1_1;
        Entry<Color> entry = new Entry<Color>((double)var1_1, color);
        if (var3_3 != null) {
            this.c.remove(entry);
            this.c.add(entry);
        } else {
            this.c.remove(entry);
        }
        this.notifyPaletteChanged(new PaletteEvent());
        this.a();
    }

    public Mode getMode() {
        return (Mode)((Object)this.b.getValue());
    }

    public MutableProperty<Mode> modeProperty() {
        return this.b;
    }

    /*
     * WARNING - void declaration
     */
    public void setMode(Mode mode) {
        void var1_1;
        this.b.setValue((Object)var1_1);
    }

    public Set<Entry> getEntries() {
        return this.c;
    }

    public void setEntries(Iterable<Entry> entries) {
        Iterator iterator;
        this.c.clear();
        iterator = iterator.iterator();
        while (iterator.hasNext()) {
            Entry entry = (Entry)iterator.next();
            this.c.add(entry);
        }
        this.notifyPaletteChanged(new PaletteEvent());
        this.a();
    }

    @Override
    protected double getLowestFraction() {
        if (!this.c.isEmpty()) {
            return this.c.first().getFraction();
        }
        return super.getLowestFraction();
    }

    @Override
    protected double getHighestFraction() {
        if (!this.c.isEmpty()) {
            return this.c.last().getFraction();
        }
        return super.getHighestFraction();
    }

    @JsType
    public static class Entry<Color>
    implements Comparable<Entry> {
        private final double a;
        private final CPColor<Color> b;

        /*
         * WARNING - void declaration
         */
        public Entry(double fraction, CPColor<Color> color) {
            void var3_2;
            void var1_1;
            this.a = var1_1;
            this.b = var3_2;
        }

        public double getFraction() {
            return this.a;
        }

        public CPColor<Color> getColor() {
            return this.b;
        }

        public boolean equals(Object o) {
            Entry entry;
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            entry = entry;
            return Double.compare(entry.a, this.a) == 0;
        }

        public int hashCode() {
            long l = this.a != 0.0 ? Double.doubleToLongBits(this.a) : 0L;
            return (int)(l ^ l >>> 32);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public int compareTo(Entry o) {
            void var1_1;
            return Double.compare(this.a, var1_1.a);
        }
    }

    @JsType
    public static enum Mode {
        Ramps,
        Bands;

    }
}

