/*
 * Decompiled with CFR 0.152.
 */
package org.web3d.x3d.jsail.Core;

import java.util.ArrayList;
import java.util.Arrays;
import org.web3d.x3d.jsail.ConfigurationProperties;
import org.web3d.x3d.jsail.Core.CommentsBlock;
import org.web3d.x3d.jsail.Core.ProtoBody;
import org.web3d.x3d.jsail.Core.ProtoInterface;
import org.web3d.x3d.jsail.Core.field;
import org.web3d.x3d.jsail.X3DConcreteElement;
import org.web3d.x3d.jsail.X3DConcreteNode;
import org.web3d.x3d.jsail.X3DConcreteStatement;
import org.web3d.x3d.jsail.fields.SFString;
import org.web3d.x3d.sai.Core.X3DChildNode;
import org.web3d.x3d.sai.Core.X3DMetadataObject;
import org.web3d.x3d.sai.Core.X3DNode;
import org.web3d.x3d.sai.InvalidFieldValueException;

public class ProtoDeclare
extends X3DConcreteStatement
implements X3DChildNode {
    private ArrayList<String> commentsList;
    private String appinfo;
    private String documentation;
    private String name;
    private ProtoBody ProtoBody;
    private ProtoInterface ProtoInterface;
    public static final String NAME = "ProtoDeclare";
    public static final String COMPONENT = "Core";
    public static final int LEVEL = 2;
    public static final String APPINFO_DEFAULT_VALUE = "";
    public static final String DOCUMENTATION_DEFAULT_VALUE = "";
    public static final String NAME_DEFAULT_VALUE = "";
    public static final ProtoBody PROTOBODY_DEFAULT_VALUE = null;
    public static final ProtoInterface PROTOINTERFACE_DEFAULT_VALUE = null;

    @Override
    public final String getElementName() {
        return NAME;
    }

    @Override
    public final String getComponent() {
        return COMPONENT;
    }

    @Override
    public final int getComponentLevel() {
        return 2;
    }

    @Override
    public String getFieldType(String fieldName) {
        String result;
        switch (fieldName) {
            case "containerField": {
                result = "SFString";
                break;
            }
            case "appinfo": {
                result = "SFString";
                break;
            }
            case "documentation": {
                result = "SFString";
                break;
            }
            case "name": {
                result = "SFString";
                break;
            }
            case "ProtoBody": {
                result = "SFNode";
                break;
            }
            case "ProtoInterface": {
                result = "SFNode";
                break;
            }
            default: {
                result = fieldName.trim().startsWith("set_") ? this.getFieldType(fieldName.trim().substring(4)) : (fieldName.trim().endsWith("_changed") ? this.getFieldType(fieldName.trim().substring(0, fieldName.length() - 8)) : "ERROR_UNKNOWN_FIELD_TYPE");
            }
        }
        field fieldDeclaration = this.findFieldByName(fieldName);
        if (fieldDeclaration != null) {
            result = fieldDeclaration.getType();
        }
        return result;
    }

    @Override
    public String getAccessType(String fieldName) {
        String result;
        switch (fieldName) {
            case "appinfo": {
                result = "inputOutput";
                break;
            }
            case "documentation": {
                result = "inputOutput";
                break;
            }
            case "name": {
                result = "inputOutput";
                break;
            }
            case "ProtoBody": {
                result = "inputOutput";
                break;
            }
            case "ProtoInterface": {
                result = "inputOutput";
                break;
            }
            default: {
                result = fieldName.trim().startsWith("set_") ? this.getAccessType(fieldName.trim().substring(4)) : (fieldName.trim().endsWith("_changed") ? this.getAccessType(fieldName.trim().substring(0, fieldName.length() - 8)) : "ERROR_UNKNOWN_FIELD_ACCESSTYPE");
            }
        }
        field fieldDeclaration = this.findFieldByName(fieldName);
        if (fieldDeclaration != null) {
            result = fieldDeclaration.getAccessType();
        }
        return result;
    }

    public ProtoDeclare() {
        this.initialize();
    }

    @Override
    public final void initialize() {
        super.initialize();
        this.appinfo = "";
        this.documentation = "";
        this.name = "";
        this.ProtoBody = null;
        this.ProtoInterface = null;
        this.commentsList = new ArrayList();
    }

    public String getAppinfo() {
        return this.appinfo;
    }

    public ProtoDeclare setAppinfo(String newValue) {
        if (newValue == null) {
            newValue = new String();
        }
        this.appinfo = newValue;
        return this;
    }

    public ProtoDeclare setAppinfo(SFString newValue) {
        this.setAppinfo(newValue.getPrimitiveValue());
        return this;
    }

    public String getDocumentation() {
        return this.documentation;
    }

    public ProtoDeclare setDocumentation(String newValue) {
        if (newValue == null) {
            newValue = new String();
        }
        this.documentation = newValue;
        return this;
    }

    public ProtoDeclare setDocumentation(SFString newValue) {
        this.setDocumentation(newValue.getPrimitiveValue());
        return this;
    }

    public String getName() {
        return this.name;
    }

    public final ProtoDeclare setName(String newValue) {
        if (newValue == null) {
            newValue = new String();
        }
        if (!SFString.isNMTOKEN(newValue)) {
            throw new InvalidFieldValueException("ProtoDeclare name newValue='" + newValue + "' has illegal name value, cannot be empty and must be defined with valid NMTOKEN name string (with legal characters and no embedded whitespace).");
        }
        if (!SFString.meetsX3dInteroperabilityNamingConventions(newValue)) {
            System.out.println("ProtoDeclare name newValue='" + newValue + "' has name value that does not meet X3D naming conventions.");
        }
        this.name = newValue;
        return this;
    }

    public ProtoDeclare setName(SFString newValue) {
        this.setName(newValue.getPrimitiveValue());
        return this;
    }

    public ProtoBody getProtoBody() {
        return this.ProtoBody;
    }

    public ProtoDeclare setProtoBody(ProtoBody newValue) {
        this.ProtoBody = newValue;
        if (newValue != null) {
            this.ProtoBody.setParent(this);
        }
        return this;
    }

    public ProtoDeclare clearProtoBody() {
        this.ProtoBody.clearParent();
        this.ProtoBody = null;
        return this;
    }

    public boolean hasProtoBody() {
        return this.ProtoBody != null;
    }

    public ProtoInterface getProtoInterface() {
        return this.ProtoInterface;
    }

    public ProtoDeclare setProtoInterface(ProtoInterface newValue) {
        this.ProtoInterface = newValue;
        if (newValue != null) {
            this.ProtoInterface.setParent(this);
        }
        return this;
    }

    public ProtoDeclare clearProtoInterface() {
        this.ProtoInterface.clearParent();
        this.ProtoInterface = null;
        return this;
    }

    public boolean hasProtoInterface() {
        return this.ProtoInterface != null;
    }

    public ProtoDeclare(String prototypeName) {
        this.initialize();
        this.setName(prototypeName);
    }

    public String getNodeType() {
        if (this.ProtoBody != null) {
            return this.ProtoBody.getNodeType();
        }
        String errorNotice = "ERROR_UNKNOWN_PROTODECLARE_NODE_TYPE: ProtoDeclare name='" + this.getName() + "' has no ProtoBody and thus has no node type yet.";
        this.validationResult.append(errorNotice).append("\n");
        return errorNotice;
    }

    public String getContainerFieldDefault() {
        if (this.ProtoBody != null) {
            return this.ProtoBody.getContainerFieldDefault();
        }
        return "";
    }

    public field findFieldByName(String fieldName) {
        if (this.hasProtoInterface()) {
            return this.getProtoInterface().findFieldByName(fieldName);
        }
        return null;
    }

    public boolean hasField(String fieldName) {
        return this.findFieldByName(fieldName) != null;
    }

    @Override
    public ProtoDeclare addComments(String newComment) {
        this.commentsList.add(newComment);
        return this;
    }

    @Override
    public ProtoDeclare addComments(String[] newComments) {
        this.commentsList.addAll(Arrays.asList(newComments));
        return this;
    }

    @Override
    public ProtoDeclare addComments(CommentsBlock newCommentsBlock) {
        this.commentsList.addAll(newCommentsBlock.toStringList());
        return this;
    }

    @Override
    public String toStringX3D(int indentLevel) {
        boolean hasAttributes = true;
        boolean hasChild = this.ProtoBody != null || this.ProtoInterface != null || !this.commentsList.isEmpty();
        StringBuilder indent = new StringBuilder();
        int indentIncrement = ConfigurationProperties.getIndentIncrement();
        char indentCharacter = ConfigurationProperties.getIndentCharacter();
        for (int i = 0; i < indentLevel; ++i) {
            indent.append(indentCharacter);
        }
        StringBuilder stringX3D = new StringBuilder();
        stringX3D.append((CharSequence)indent).append("<ProtoDeclare");
        if (hasAttributes) {
            if (!this.getName().equals("")) {
                stringX3D.append(" name='").append(SFString.toString(this.getName())).append("'");
            }
            if (!this.getAppinfo().equals("") || !ConfigurationProperties.getStripDefaultAttributes()) {
                stringX3D.append(" appinfo='").append(new SFString(this.getAppinfo()).toStringX3D()).append("'");
            }
            if (!this.getDocumentation().equals("") || !ConfigurationProperties.getStripDefaultAttributes()) {
                stringX3D.append(" documentation='").append(new SFString(this.getDocumentation()).toStringX3D()).append("'");
            }
        }
        if (hasChild) {
            stringX3D.append(">").append("\n");
            if (!this.commentsList.isEmpty()) {
                CommentsBlock commentsBlock = new CommentsBlock(this.commentsList);
                stringX3D.append(commentsBlock.toStringX3D(indentLevel + indentIncrement));
            }
            if (this.ProtoInterface != null) {
                stringX3D.append(((X3DConcreteElement)this.ProtoInterface).toStringX3D(indentLevel + indentIncrement));
            }
            if (this.ProtoBody != null) {
                stringX3D.append(((X3DConcreteElement)this.ProtoBody).toStringX3D(indentLevel + indentIncrement));
            }
            stringX3D.append((CharSequence)indent).append("</ProtoDeclare>").append("\n");
        } else {
            stringX3D.append("/>").append("\n");
        }
        return stringX3D.toString();
    }

    @Override
    public String toStringClassicVRML(int indentLevel) {
        StringBuilder stringClassicVRML = new StringBuilder();
        boolean hasAttributes = true;
        boolean hasChild = this.ProtoBody != null || this.ProtoInterface != null || !this.commentsList.isEmpty();
        StringBuilder indent = new StringBuilder();
        char indentCharacter = ConfigurationProperties.getIndentCharacter();
        int indentIncrement = ConfigurationProperties.getIndentIncrement();
        for (int i = 0; i < indentLevel; ++i) {
            indent.append(indentCharacter);
        }
        stringClassicVRML.append("PROTO ").append(this.name).append(" [").append("\n").append((CharSequence)indent);
        if (!this.getAppinfo().equals("") || !this.getAppinfo().isEmpty() && !ConfigurationProperties.getStripDefaultAttributes()) {
            stringClassicVRML.append((CharSequence)indent).append(indentCharacter).append(indentCharacter);
            stringClassicVRML.append(" # [appinfo] ").append("\"").append(SFString.toString(this.getAppinfo())).append("\"");
        }
        if (!this.getDocumentation().equals("") || !this.getDocumentation().isEmpty() && !ConfigurationProperties.getStripDefaultAttributes()) {
            stringClassicVRML.append("\n").append((CharSequence)indent).append(indentCharacter).append(indentCharacter);
            stringClassicVRML.append("# [documentation] ").append("\"").append(SFString.toString(this.getDocumentation())).append("\"").append("\n").append((CharSequence)indent).append(indentCharacter);
        }
        if (this.ProtoInterface != null) {
            stringClassicVRML.append("\n").append((CharSequence)indent).append(indentCharacter).append(indentCharacter);
            stringClassicVRML.append(this.ProtoInterface.toStringClassicVRML(indentLevel + indentIncrement));
            for (field nextField : this.ProtoInterface.getFieldList()) {
                stringClassicVRML.append(nextField.toStringClassicVRML(indentLevel + indentIncrement));
            }
        }
        if (!this.commentsList.isEmpty()) {
            CommentsBlock commentsBlock = new CommentsBlock(this.commentsList);
            stringClassicVRML.append(commentsBlock.toStringClassicVRML(indentLevel));
        }
        stringClassicVRML.append("] {").append("\n").append((CharSequence)indent);
        if (this.ProtoBody != null) {
            stringClassicVRML.append("\n").append((CharSequence)indent).append(indentCharacter).append(indentCharacter);
            stringClassicVRML.append(this.ProtoBody.toStringClassicVRML(indentLevel + indentIncrement));
            stringClassicVRML.append("\n").append((CharSequence)indent).append(indentCharacter).append(indentCharacter);
            for (X3DNode element : this.ProtoBody.getChildren()) {
                stringClassicVRML.append(((X3DConcreteElement)((Object)element)).toStringClassicVRML(indentLevel + indentIncrement));
            }
        }
        stringClassicVRML.append("}").append("\n").append((CharSequence)indent);
        return stringClassicVRML.toString();
    }

    @Override
    public String toStringVRML97(int indentLevel) {
        return this.toStringClassicVRML(indentLevel);
    }

    @Override
    public X3DConcreteElement findElementByNameValue(String nameValue) {
        return this.findElementByNameValue(nameValue, "");
    }

    @Override
    public X3DConcreteElement findElementByNameValue(String nameValue, String elementName) {
        X3DConcreteElement referenceElement;
        if (nameValue == null || nameValue.isEmpty()) {
            String errorNotice = "findElementByNameValue(\"\", " + elementName + ") cannot use empty string to find a name attribute";
            this.validationResult.append(errorNotice).append("\n");
            throw new InvalidFieldValueException(errorNotice);
        }
        if (elementName == null) {
            elementName = "";
        }
        if (this.getName().equals(nameValue) && (elementName.isEmpty() || elementName.equals(this.getElementName()))) {
            return this;
        }
        if (this.ProtoBody != null && (referenceElement = ((X3DConcreteElement)this.ProtoBody).findElementByNameValue(nameValue, elementName)) != null) {
            return referenceElement;
        }
        if (this.ProtoInterface != null && (referenceElement = ((X3DConcreteElement)this.ProtoInterface).findElementByNameValue(nameValue, elementName)) != null) {
            return referenceElement;
        }
        return null;
    }

    public boolean hasElementByNameValue(String nameValue, String elementName) {
        return this.findElementByNameValue(nameValue, elementName) != null;
    }

    @Override
    public X3DConcreteNode findNodeByDEF(String DEFvalue) {
        X3DConcreteNode referenceNode;
        if (DEFvalue == null || DEFvalue.isEmpty()) {
            String errorNotice = "findNodeByDEF(\"\") cannot use empty string to find a name";
            this.validationResult.append(errorNotice).append("\n");
            throw new InvalidFieldValueException(errorNotice);
        }
        if (this.ProtoBody != null && (referenceNode = ((X3DConcreteElement)this.ProtoBody).findNodeByDEF(DEFvalue)) != null) {
            return referenceNode;
        }
        if (this.ProtoInterface != null && (referenceNode = ((X3DConcreteElement)this.ProtoInterface).findNodeByDEF(DEFvalue)) != null) {
            return referenceNode;
        }
        return null;
    }

    public boolean hasNodeByDEF(String DEFvalue) {
        return this.findNodeByDEF(DEFvalue) != null;
    }

    @Override
    public String validate() {
        this.validationResult = new StringBuilder();
        this.setAppinfo(this.getAppinfo());
        this.setDocumentation(this.getDocumentation());
        if (this.getName().isEmpty()) {
            String errorNotice = "ERROR_VALUE_NOT_FOUND, ProtoDeclare name field is required but no value found. ";
            this.validationResult.append(errorNotice).append("\n");
            throw new InvalidFieldValueException(errorNotice);
        }
        this.setName(this.getName());
        if (this.ProtoBody != null) {
            this.setProtoBody(this.getProtoBody());
            ((X3DConcreteElement)this.ProtoBody).validate();
            this.validationResult.append(this.ProtoBody.getValidationResult());
        }
        if (this.ProtoInterface != null) {
            this.setProtoInterface(this.getProtoInterface());
            ((X3DConcreteElement)this.ProtoInterface).validate();
            this.validationResult.append(this.ProtoInterface.getValidationResult());
        }
        if (this.findAncestorScene().findElementByNameValue(this.getName(), "ProtoInstance") == null) {
            String warningNotice = "WARNING_PROTOINSTANCE_NOT_FOUND, ProtoDeclare " + this.getName() + " has no corresponding " + "ProtoInstance" + " attached to the scene graph. ";
            this.validationResult.append(warningNotice).append("\n");
        }
        return this.validationResult.toString();
    }

    @Override
    @Deprecated
    public X3DMetadataObject getMetadata() {
        return null;
    }

    @Override
    @Deprecated
    public ProtoDeclare setMetadata(X3DMetadataObject newValue) {
        return this;
    }

    @Deprecated
    public ProtoDeclare setDEF(String newValue) {
        return this;
    }

    @Deprecated
    public ProtoDeclare setUSE(String newValue) {
        return this;
    }

    @Deprecated
    public ProtoDeclare setCssClass(String newValue) {
        return this;
    }
}

