/*
 * Decompiled with CFR 0.152.
 */
package org.web3d.x3d.jsail.Core;

import com.siemens.ct.exi.CodingMode;
import com.siemens.ct.exi.EXIFactory;
import com.siemens.ct.exi.GrammarFactory;
import com.siemens.ct.exi.api.sax.EXIResult;
import com.siemens.ct.exi.api.sax.EXISource;
import com.siemens.ct.exi.exceptions.EXIException;
import com.siemens.ct.exi.grammars.Grammars;
import com.siemens.ct.exi.helpers.DefaultEXIFactory;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.sax.SAXTransformerFactory;
import javax.xml.transform.sax.TransformerHandler;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import net.sf.saxon.s9api.Destination;
import net.sf.saxon.s9api.Processor;
import net.sf.saxon.s9api.QName;
import net.sf.saxon.s9api.SaxonApiException;
import net.sf.saxon.s9api.Serializer;
import net.sf.saxon.s9api.XdmAtomicValue;
import net.sf.saxon.s9api.XdmNode;
import net.sf.saxon.s9api.XdmValue;
import net.sf.saxon.s9api.XsltCompiler;
import net.sf.saxon.s9api.XsltExecutable;
import net.sf.saxon.s9api.XsltTransformer;
import org.openexi.proc.common.AlignmentType;
import org.openexi.proc.common.EXIOptionsException;
import org.openexi.proc.grammars.GrammarCache;
import org.openexi.sax.EXIReader;
import org.openexi.sax.Transmogrifier;
import org.openexi.sax.TransmogrifierException;
import org.openexi.schema.EXISchema;
import org.openexi.scomp.EXISchemaFactoryException;
import org.openexi.scomp.EXISchemaReader;
import org.w3c.dom.Document;
import org.web3d.x3d.jsail.CommandLine;
import org.web3d.x3d.jsail.ConfigurationProperties;
import org.web3d.x3d.jsail.Core.CommentsBlock;
import org.web3d.x3d.jsail.Core.Scene;
import org.web3d.x3d.jsail.Core.component;
import org.web3d.x3d.jsail.Core.head;
import org.web3d.x3d.jsail.Core.meta;
import org.web3d.x3d.jsail.X3DConcreteElement;
import org.web3d.x3d.jsail.X3DConcreteNode;
import org.web3d.x3d.jsail.X3DConcreteStatement;
import org.web3d.x3d.jsail.X3DLoaderDOM;
import org.web3d.x3d.jsail.fields.MFString;
import org.web3d.x3d.jsail.fields.SFString;
import org.web3d.x3d.sai.InvalidFieldValueException;
import org.web3d.x3d.sai.X3DException;
import org.web3d.x3d.util.exi.SerializeEXISchema;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class X3D
extends X3DConcreteStatement {
    private ArrayList<String> commentsList;
    private head head;
    private String profile;
    private Scene Scene;
    private String version;
    public static final String XML_HEADER = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>";
    public static final String XML_DOCTYPE_X3D_4_1 = "<!DOCTYPE X3D PUBLIC \"ISO//Web3D//DTD X3D 4.1//EN\" \"http://www.web3d.org/specifications/x3d-4.1.dtd\">";
    public static final String XML_DOCTYPE_X3D_4_0 = "<!DOCTYPE X3D PUBLIC \"ISO//Web3D//DTD X3D 4.0//EN\" \"http://www.web3d.org/specifications/x3d-4.0.dtd\">";
    public static final String XML_DOCTYPE_X3D_3_3 = "<!DOCTYPE X3D PUBLIC \"ISO//Web3D//DTD X3D 3.3//EN\" \"http://www.web3d.org/specifications/x3d-3.3.dtd\">";
    public static final String XML_DOCTYPE_X3D_3_2 = "<!DOCTYPE X3D PUBLIC \"ISO//Web3D//DTD X3D 3.2//EN\" \"http://www.web3d.org/specifications/x3d-3.2.dtd\">";
    public static final String XML_DOCTYPE_X3D_3_1 = "<!DOCTYPE X3D PUBLIC \"ISO//Web3D//DTD X3D 3.1//EN\" \"http://www.web3d.org/specifications/x3d-3.1.dtd\">";
    public static final String XML_DOCTYPE_X3D_3_0 = "<!DOCTYPE X3D PUBLIC \"ISO//Web3D//DTD X3D 3.0//EN\" \"http://www.web3d.org/specifications/x3d-3.0.dtd\">";
    public static final String X3D_XML_SCHEMA_3_0_ATTRIBUTES = "xmlns:xsd='http://www.w3.org/2001/XMLSchema-instance' xsd:noNamespaceSchemaLocation='http://www.web3d.org/specifications/x3d-3.0.xsd'";
    public static final String X3D_XML_SCHEMA_3_1_ATTRIBUTES = "xmlns:xsd='http://www.w3.org/2001/XMLSchema-instance' xsd:noNamespaceSchemaLocation='http://www.web3d.org/specifications/x3d-3.1.xsd'";
    public static final String X3D_XML_SCHEMA_3_2_ATTRIBUTES = "xmlns:xsd='http://www.w3.org/2001/XMLSchema-instance' xsd:noNamespaceSchemaLocation='http://www.web3d.org/specifications/x3d-3.2.xsd'";
    public static final String X3D_XML_SCHEMA_3_3_ATTRIBUTES = "xmlns:xsd='http://www.w3.org/2001/XMLSchema-instance' xsd:noNamespaceSchemaLocation='http://www.web3d.org/specifications/x3d-3.3.xsd'";
    public static final String X3D_XML_SCHEMA_4_0_ATTRIBUTES = "xmlns:xsd='http://www.w3.org/2001/XMLSchema-instance' xsd:noNamespaceSchemaLocation='http://www.web3d.org/specifications/x3d-4.0.xsd'";
    public static final String X3D_XML_SCHEMA_4_1_ATTRIBUTES = "xmlns:xsd='http://www.w3.org/2001/XMLSchema-instance' xsd:noNamespaceSchemaLocation='http://www.web3d.org/specifications/x3d-4.1.xsd'";
    public static final String PROFILE_CORE = "Core";
    public static final String PROFILE_INTERCHANGE = "Interchange";
    public static final String PROFILE_CADINTERCHANGE = "CADInterchange";
    public static final String PROFILE_INTERACTIVE = "Interactive";
    public static final String PROFILE_IMMERSIVE = "Immersive";
    public static final String PROFILE_MEDICALINTERCHANGE = "MedicalInterchange";
    public static final String PROFILE_MPEG4INTERACTIVE = "MPEG4Interactive";
    public static final String PROFILE_FULL = "Full";
    public static final String VERSION_3_0 = "3.0";
    public static final String VERSION_3_1 = "3.1";
    public static final String VERSION_3_2 = "3.2";
    public static final String VERSION_3_3 = "3.3";
    public static final String VERSION_4_0 = "4.0";
    public static final String NAME = "X3D";
    public static final String COMPONENT = "Core";
    public static final int LEVEL = 1;
    public static final head HEAD_DEFAULT_VALUE = null;
    public static final String PROFILE_DEFAULT_VALUE = "Immersive";
    public static final Scene SCENE_DEFAULT_VALUE = null;
    public static final String VERSION_DEFAULT_VALUE = "4.0";
    public static final String FILE_EXTENSION_X3D = ".x3d";
    public static final String FILE_EXTENSION_CLASSICVRML = ".x3dv";
    public static final String FILE_EXTENSION_X3DB = ".x3db";
    public static final String FILE_EXTENSION_VRML97 = ".wrl";
    public static final String FILE_EXTENSION_XML = ".xml";
    public static final String FILE_EXTENSION_SVG = ".svg";
    public static final String FILE_EXTENSION_HTML = ".html";
    public static final String FILE_EXTENSION_MARKDOWN = ".md";
    public static final String FILE_EXTENSION_PLY = ".ply";
    public static final String FILE_EXTENSION_STL = ".stl";
    public static final String FILE_EXTENSION_XHTML = ".xhtml";
    public static final String FILE_EXTENSION_TEXT = ".txt";
    public static final String FILE_EXTENSION_GIF = ".gif";
    public static final String FILE_EXTENSION_JPG = ".jpg";
    public static final String FILE_EXTENSION_JPEG = ".jpeg";
    public static final String FILE_EXTENSION_PNG = ".png";
    public static final String FILE_EXTENSION_JAVA = ".java";
    public static final String FILE_EXTENSION_JAVASCRIPT = ".js";
    public static final String FILE_EXTENSION_JSON = ".json";
    public static final String FILE_EXTENSION_PYTHON = ".py";
    public static final String FILE_EXTENSION_EXI = ".exi";
    public static final String FILE_EXTENSION_GZIP = ".gz";
    public static final String FILE_EXTENSION_ZIP = ".zip";
    private BufferedWriter bufferedWriter;
    Grammars exificientGrammarX3D;
    private boolean includeSubdirectoryPaths = true;

    @Override
    public final String getElementName() {
        return NAME;
    }

    @Override
    public final String getComponent() {
        return "Core";
    }

    @Override
    public final int getComponentLevel() {
        return 1;
    }

    @Override
    public String getFieldType(String fieldName) {
        String result;
        switch (fieldName) {
            case "containerField": {
                result = "SFString";
                break;
            }
            case "head": {
                result = "SFNode";
                break;
            }
            case "profile": {
                result = "SFString";
                break;
            }
            case "Scene": {
                result = "SFNode";
                break;
            }
            case "version": {
                result = "SFString";
                break;
            }
            default: {
                result = fieldName.trim().startsWith("set_") ? this.getFieldType(fieldName.trim().substring(4)) : (fieldName.trim().endsWith("_changed") ? this.getFieldType(fieldName.trim().substring(0, fieldName.length() - 8)) : "ERROR_UNKNOWN_FIELD_TYPE");
            }
        }
        return result;
    }

    @Override
    public String getAccessType(String fieldName) {
        String result;
        switch (fieldName) {
            case "head": {
                result = "inputOutput";
                break;
            }
            case "profile": {
                result = "inputOutput";
                break;
            }
            case "Scene": {
                result = "inputOutput";
                break;
            }
            case "version": {
                result = "inputOutput";
                break;
            }
            default: {
                result = fieldName.trim().startsWith("set_") ? this.getAccessType(fieldName.trim().substring(4)) : (fieldName.trim().endsWith("_changed") ? this.getAccessType(fieldName.trim().substring(0, fieldName.length() - 8)) : "ERROR_UNKNOWN_FIELD_ACCESSTYPE");
            }
        }
        return result;
    }

    public X3D() {
        this.initialize();
    }

    @Override
    public final void initialize() {
        super.initialize();
        this.head = null;
        this.profile = "Immersive";
        this.Scene = null;
        this.version = "4.0";
        this.commentsList = new ArrayList();
    }

    public String toStringXML() {
        return this.toStringX3D();
    }

    public String toStringXML(int indentLevel) {
        return this.toStringX3D(indentLevel);
    }

    public File toFileXML(String fileName) {
        return this.toFileX3D(fileName);
    }

    public static boolean isFileNameNMTOKEN(String fileName) {
        String strippedFileName = fileName;
        if (strippedFileName.contains("/")) {
            strippedFileName = strippedFileName.substring(strippedFileName.lastIndexOf("/") + 1);
        }
        if (strippedFileName.contains("\\")) {
            strippedFileName = strippedFileName.substring(strippedFileName.lastIndexOf("\\") + 1);
        }
        return SFString.isNMTOKEN(strippedFileName);
    }

    public static boolean fileNameMeetsX3dNamingConventions(String fileName) {
        String strippedFileName = fileName;
        if (strippedFileName.contains("/")) {
            strippedFileName = strippedFileName.substring(strippedFileName.lastIndexOf("/") + 1);
        }
        if (strippedFileName.contains("\\")) {
            strippedFileName = strippedFileName.substring(strippedFileName.lastIndexOf("\\") + 1);
        }
        if (strippedFileName.contains(".")) {
            strippedFileName = strippedFileName.substring(0, strippedFileName.lastIndexOf("."));
        }
        if (!fileName.endsWith(FILE_EXTENSION_X3D) || fileName.toUpperCase().contains(".EXI") || fileName.toUpperCase().contains(".OPENEXI") || fileName.toUpperCase().contains(".NASHORN") || fileName.toUpperCase().contains(".JS") || fileName.toUpperCase().contains(".JAVA") || fileName.toUpperCase().contains(".JSON") || fileName.toUpperCase().contains(".PY") || fileName.toUpperCase().contains(".TEMP") || fileName.toUpperCase().contains("ROUNDTRIP")) {
            return true;
        }
        return SFString.meetsX3dInteroperabilityNamingConventions(strippedFileName);
    }

    public File toFileX3D(String fileName) {
        String errorNotice = new String();
        if (fileName == null || fileName.isEmpty()) {
            throw new X3DException("toFileX3D(fileName) fileName not provided; be sure to end with extension \".x3d\"");
        }
        if (!fileName.endsWith(FILE_EXTENSION_X3D) && !fileName.endsWith(FILE_EXTENSION_XML)) {
            throw new X3DException("fileName " + fileName + " does not end with extension \"" + FILE_EXTENSION_X3D + "\" or \"" + FILE_EXTENSION_XML + "\"");
        }
        if (!X3D.fileNameMeetsX3dNamingConventions(fileName)) {
            System.out.println("Warning: " + fileName + " does not meet suggested X3D naming conventions, continuing...");
        } else if (!X3D.isFileNameNMTOKEN(fileName)) {
            System.out.println("Warning: " + fileName + " is not a valid NMTOKEN, continuing...");
        }
        Path outputFilePath = Paths.get(fileName, new String[0]);
        if (ConfigurationProperties.isDebugModeActive()) {
            errorNotice = errorNotice + "[diagnostic] Output file path=" + outputFilePath.toAbsolutePath() + "\n";
            System.out.println(errorNotice);
        }
        Charset charset = Charset.forName("UTF-8");
        try {
            this.validate();
        }
        catch (Exception e) {
            System.out.println(e);
            e.printStackTrace();
            if (ConfigurationProperties.isValidationExceptionAllowed()) {
                System.out.println("Output serialization allowed to continue, file may be editable...");
            }
            throw e;
        }
        File priorFile = new File(fileName);
        if (priorFile.exists() && ConfigurationProperties.isOverwriteExistingFiles()) {
            System.out.println("Warning: toFileX3D() is overwriting prior file " + fileName);
        } else if (priorFile.exists()) {
            System.out.println("Warning: toFileX3D() is not allowed to overwrite prior file: " + fileName);
            System.out.println("  see X3DJSAIL.properties file, or ConfigurationProperties.isOverwriteExistingFiles() and .setOverwriteExistingFiles(), to get/set permissions");
            return null;
        }
        String outputSceneText = this.toStringX3D();
        try {
            Path directoryPath = outputFilePath.getParent();
            if (directoryPath != null) {
                Files.createDirectories(directoryPath, new FileAttribute[0]);
            }
            this.bufferedWriter = Files.newBufferedWriter(outputFilePath, charset, new OpenOption[0]);
            this.bufferedWriter.write(outputSceneText, 0, outputSceneText.length());
            this.bufferedWriter.close();
            return outputFilePath.toFile();
        }
        catch (IOException exception) {
            exception.printStackTrace();
            throw new X3DException("IOException for fileName " + fileName + ", unable to save file: " + exception);
        }
    }

    public File toFileClassicVRML(String fileName) {
        String errorNotice = new String();
        if (fileName == null || fileName.isEmpty()) {
            throw new X3DException("toFileClassicVRML(fileName) fileName not provided; be sure to end with extension \".x3dv\"");
        }
        if (!fileName.endsWith(FILE_EXTENSION_CLASSICVRML)) {
            throw new X3DException("fileName " + fileName + " does not end with extension \"" + FILE_EXTENSION_CLASSICVRML + "\"");
        }
        if (!X3D.fileNameMeetsX3dNamingConventions(fileName)) {
            System.out.println("Warning: " + fileName + " does not meet suggested X3D naming conventions, continuing...");
        } else if (!X3D.isFileNameNMTOKEN(fileName)) {
            System.out.println("Warning: " + fileName + " is not a valid NMTOKEN, continuing...");
        }
        Path outputFilePath = Paths.get(fileName, new String[0]);
        if (ConfigurationProperties.isDebugModeActive()) {
            if (errorNotice.isEmpty()) {
                errorNotice = errorNotice + "\n";
            }
            errorNotice = errorNotice + "[diagnostic] Output file path=" + outputFilePath.toAbsolutePath() + "\n";
            System.out.println(errorNotice);
        }
        Charset charset = Charset.forName("UTF-8");
        try {
            this.validate();
        }
        catch (Exception e) {
            System.out.println(e);
            e.printStackTrace();
            if (ConfigurationProperties.isValidationExceptionAllowed()) {
                System.out.println("Output serialization allowed to continue, file may be editable...");
            }
            throw e;
        }
        File priorFile = new File(fileName);
        if (priorFile.exists() && ConfigurationProperties.isOverwriteExistingFiles()) {
            System.out.println("Warning: toFileClassicVRML() is overwriting prior file " + fileName);
        } else if (priorFile.exists()) {
            System.out.println("Warning: toFileClassicVRML() is not allowed to overwrite prior file: " + fileName);
            System.out.println("  see X3DJSAIL.properties file, or ConfigurationProperties.isOverwriteExistingFiles() and .setOverwriteExistingFiles(), to get/set permissions");
            return null;
        }
        String outputSceneText = this.toStringClassicVRML();
        try {
            Path directoryPath = outputFilePath.getParent();
            if (directoryPath != null) {
                Files.createDirectories(directoryPath, new FileAttribute[0]);
            }
            this.bufferedWriter = Files.newBufferedWriter(outputFilePath, charset, new OpenOption[0]);
            this.bufferedWriter.write(outputSceneText, 0, outputSceneText.length());
            this.bufferedWriter.close();
            return outputFilePath.toFile();
        }
        catch (IOException exception) {
            exception.printStackTrace();
            throw new X3DException("IOException for fileName " + fileName + ", unable to save file: " + exception);
        }
    }

    public File toFileVRML97(String fileName) {
        String errorNotice = new String();
        if (fileName == null || fileName.isEmpty()) {
            throw new X3DException("toFileVRML97(fileName) fileName not provided; be sure to end with extension \".wrl\"");
        }
        if (!fileName.endsWith(FILE_EXTENSION_VRML97)) {
            throw new X3DException("fileName " + fileName + " does not end with extension \"" + FILE_EXTENSION_VRML97 + "\"");
        }
        if (!X3D.fileNameMeetsX3dNamingConventions(fileName)) {
            System.out.println("Warning: " + fileName + " does not meet suggested X3D naming conventions, continuing...");
        } else if (!X3D.isFileNameNMTOKEN(fileName)) {
            System.out.println("Warning: " + fileName + " is not a valid NMTOKEN, continuing...");
        }
        Path outputFilePath = Paths.get(fileName, new String[0]);
        if (ConfigurationProperties.isDebugModeActive()) {
            if (errorNotice.isEmpty()) {
                errorNotice = errorNotice + "\n";
            }
            errorNotice = errorNotice + "[diagnostic] Output file path=" + outputFilePath.toAbsolutePath() + "\n";
            System.out.println(errorNotice);
        }
        Charset charset = Charset.forName("UTF-8");
        try {
            this.validate();
        }
        catch (Exception e) {
            System.out.println(e);
            e.printStackTrace();
            if (ConfigurationProperties.isValidationExceptionAllowed()) {
                System.out.println("Output serialization allowed to continue, file may be editable...");
            }
            throw e;
        }
        File priorFile = new File(fileName);
        if (priorFile.exists() && ConfigurationProperties.isOverwriteExistingFiles()) {
            System.out.println("Warning: toFileVRML97() is overwriting prior file " + fileName);
        } else if (priorFile.exists()) {
            System.out.println("Warning: toFileVRML97() is not allowed to overwrite prior file: " + fileName);
            System.out.println("  see X3DJSAIL.properties file, or ConfigurationProperties.isOverwriteExistingFiles() and .setOverwriteExistingFiles(), to get/set permissions");
            return null;
        }
        String outputSceneText = this.toStringVRML97();
        try {
            Path directoryPath = outputFilePath.getParent();
            if (directoryPath != null) {
                Files.createDirectories(directoryPath, new FileAttribute[0]);
            }
            this.bufferedWriter = Files.newBufferedWriter(outputFilePath, charset, new OpenOption[0]);
            this.bufferedWriter.write(outputSceneText, 0, outputSceneText.length());
            this.bufferedWriter.close();
            return outputFilePath.toFile();
        }
        catch (IOException exception) {
            exception.printStackTrace();
            throw new X3DException("IOException for fileName " + fileName + ", unable to save file: " + exception);
        }
    }

    public File toFileStylesheetConversion(String stylesheetName, String fileName) {
        return this.toFileStylesheetConversion(stylesheetName, fileName, "", "", "", "");
    }

    public File toFileStylesheetConversion(String stylesheetName, String fileName, String parameterName1, String parameterValue1) {
        return this.toFileStylesheetConversion(stylesheetName, fileName, parameterName1, parameterValue1, "", "");
    }

    public File toFileStylesheetConversion(String stylesheetName, String fileName, String parameterName1, String parameterValue1, String parameterName2, String parameterValue2) {
        String errorNotice = new String();
        String expectedFileNameExtension = "";
        if (stylesheetName == null || stylesheetName.isEmpty()) {
            throw new X3DException("toFileStylesheetConversion(stylesheetName, fileName) stylesheetName not provided; (see ConfigurationProperties for allowed choices)");
        }
        expectedFileNameExtension = ConfigurationProperties.getExpectedOutputFileExtension(stylesheetName);
        if (fileName == null || fileName.isEmpty()) {
            throw new X3DException("toFileStylesheetConversion(stylesheetName, fileName) fileName not provided; (see ConfigurationProperties for allowed choices)");
        }
        if (!(fileName.endsWith(expectedFileNameExtension) || fileName.endsWith(FILE_EXTENSION_XHTML) && expectedFileNameExtension.equals(FILE_EXTENSION_HTML) || fileName.endsWith(FILE_EXTENSION_JAVASCRIPT) && expectedFileNameExtension.equals(FILE_EXTENSION_JSON))) {
            throw new X3DException("fileName " + fileName + " does not end with expected extension \"" + expectedFileNameExtension + "\"");
        }
        if (!X3D.isFileNameNMTOKEN(fileName)) {
            System.out.println("Warning: " + fileName + " is not a valid NMTOKEN, continuing...");
        }
        Path outputFilePath = Paths.get(fileName, new String[0]);
        if (ConfigurationProperties.isDebugModeActive()) {
            errorNotice = errorNotice + "[diagnostic] Output file path=" + outputFilePath.toAbsolutePath() + "\n";
        }
        String intermediateX3DFileName = fileName.substring(0, fileName.length() - 5) + "PrettyPrint.intermediate.x3d";
        Path intermediateX3DFilePath = Paths.get(intermediateX3DFileName, new String[0]);
        if (ConfigurationProperties.isDebugModeActive()) {
            errorNotice = errorNotice + "[diagnostic] intermediateX3DFilePath=" + intermediateX3DFilePath.toAbsolutePath() + "\n";
        }
        Charset charset = Charset.forName("UTF-8");
        try {
            this.validate();
        }
        catch (Exception e) {
            System.out.println(e);
            e.printStackTrace();
            if (ConfigurationProperties.isValidationExceptionAllowed()) {
                System.out.println("Output serialization allowed to continue, file may be editable...");
            }
            throw e;
        }
        File priorFile = new File(fileName);
        if (priorFile.exists() && ConfigurationProperties.isOverwriteExistingFiles()) {
            System.out.println("Warning: toFileStylesheetConversion(" + stylesheetName + ") is overwriting prior file " + fileName);
        } else if (priorFile.exists()) {
            System.out.println("Warning: toFileStylesheetConversion() is not allowed to overwrite prior file: " + fileName);
            System.out.println("  see X3DJSAIL.properties file, or ConfigurationProperties.isOverwriteExistingFiles() and .setOverwriteExistingFiles(), to get/set permissions");
            return null;
        }
        String outputSceneText = this.toStringX3D();
        try {
            this.bufferedWriter = Files.newBufferedWriter(intermediateX3DFilePath, charset, new OpenOption[0]);
            this.bufferedWriter.write(outputSceneText, 0, outputSceneText.length());
            this.bufferedWriter.close();
        }
        catch (IOException exception) {
            throw new X3DException("IOException when creating intermediateX3DFilePath " + intermediateX3DFilePath + ", unable to save file: " + exception);
        }
        try {
            File outputFile;
            InputStream stylesheetInputStream;
            String systemClassPath = ConfigurationProperties.getClassPath();
            String currentX3dJsailJarName = "(unlocated)";
            boolean foundX3dJsailJar = false;
            if (systemClassPath.contains("X3DJSAIL")) {
                currentX3dJsailJarName = systemClassPath.substring(systemClassPath.indexOf("X3DJSAIL"));
                if (systemClassPath.indexOf("X3DJSAIL") > 0 && currentX3dJsailJarName.indexOf(File.pathSeparatorChar) > 0) {
                    currentX3dJsailJarName = currentX3dJsailJarName.substring(0, currentX3dJsailJarName.indexOf(File.pathSeparatorChar));
                }
                for (String nextX3dJsailJar : ConfigurationProperties.X3DJSAIL_JAR_RELEASE_VERSIONS) {
                    if (!currentX3dJsailJarName.equals(nextX3dJsailJar)) continue;
                    foundX3dJsailJar = true;
                    break;
                }
            }
            if (!foundX3dJsailJar) {
                errorNotice = "ERROR_CONFIGURATION_X3DJSAIL X3DJSAIL .jar archive " + currentX3dJsailJarName + " not found in\n  CLASSPATH=" + systemClassPath + "\n";
                errorNotice = errorNotice + "  invoked from toFileStylesheetConversion(" + stylesheetName + ", " + fileName + ", " + parameterName1 + ", " + parameterValue1 + ", " + parameterName2 + ", " + parameterValue2 + ")\n";
                this.validationResult.append(errorNotice);
                throw new InvalidFieldValueException(errorNotice);
            }
            String jarPath = "jar:file:" + currentX3dJsailJarName + "!/";
            String stylesheetPath = "stylesheets/" + stylesheetName;
            if (ConfigurationProperties.isDebugModeActive()) {
                errorNotice = errorNotice + "[diagnostic] ConfigurationProperties.isDebugModeActive()=" + ConfigurationProperties.isDebugModeActive() + "\n";
                errorNotice = errorNotice + "[diagnostic] System java.class.path=" + systemClassPath + "\n";
                errorNotice = errorNotice + "[diagnostic] jarPath=" + jarPath + ", ";
                errorNotice = errorNotice + "stylesheetPath=" + stylesheetPath + "\n";
            }
            if ((stylesheetInputStream = this.getClass().getResourceAsStream("/" + stylesheetPath)) == null) {
                errorNotice = errorNotice + "Stylesheet not found in " + jarPath + ": " + stylesheetPath + ", ";
            }
            File stylesheetFile = new File("lib/stylesheets/", "X3dToXhtml.xslt");
            if (stylesheetInputStream == null && !stylesheetFile.exists()) {
                errorNotice = errorNotice + "Stylesheet not found: " + stylesheetFile.getAbsolutePath() + ", ";
            }
            if ((outputFile = outputFilePath.toFile()) == null) {
                errorNotice = errorNotice + "outputFile not created: " + outputFilePath.getFileName() + ", ";
            }
            if (ConfigurationProperties.getXsltEngine().equals("SAXON9HE")) {
                Processor processor = new Processor(false);
                XsltCompiler xsltCompiler = processor.newXsltCompiler();
                XsltExecutable xsltExecutable = stylesheetInputStream != null ? xsltCompiler.compile((Source)new StreamSource(stylesheetInputStream)) : xsltCompiler.compile((Source)new StreamSource(stylesheetFile));
                XdmNode source = processor.newDocumentBuilder().build((Source)new StreamSource(intermediateX3DFilePath.toFile()));
                Serializer out = processor.newSerializer(outputFile);
                out.setOutputProperty(Serializer.Property.METHOD, "html");
                out.setOutputProperty(Serializer.Property.INDENT, "yes");
                XsltTransformer xsltTransformer = xsltExecutable.load();
                xsltTransformer.setInitialContextNode(source);
                xsltTransformer.setDestination((Destination)out);
                if (parameterName1.length() > 0) {
                    xsltTransformer.setParameter(new QName(parameterName1), (XdmValue)new XdmAtomicValue(parameterValue1));
                }
                if (parameterName2.length() > 0) {
                    xsltTransformer.setParameter(new QName(parameterName2), (XdmValue)new XdmAtomicValue(parameterValue2));
                }
                if (stylesheetInputStream != null) {
                    xsltTransformer.setParameter(new QName("produceSVGfigures"), (XdmValue)new XdmAtomicValue("false"));
                }
                xsltTransformer.transform();
            } else if (ConfigurationProperties.getXsltEngine().equals("NATIVE_JAVA")) {
                DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
                DocumentBuilder builder = factory.newDocumentBuilder();
                Document x3dDocument = builder.parse(intermediateX3DFilePath.toFile());
                TransformerFactory tFactory = TransformerFactory.newInstance();
                StreamSource styleStreamSource = stylesheetInputStream != null ? new StreamSource(stylesheetInputStream) : new StreamSource(stylesheetFile);
                Transformer transformer = tFactory.newTransformer(styleStreamSource);
                if (parameterName1.length() > 0) {
                    transformer.setParameter(parameterName1, parameterValue1);
                }
                if (parameterName2.length() > 0) {
                    transformer.setParameter(parameterName2, parameterValue2);
                }
                if (stylesheetInputStream != null) {
                    transformer.setParameter("produceSVGfigures", "false");
                }
                DOMSource domSource = new DOMSource(x3dDocument);
                StreamResult streamResult = new StreamResult(outputFile);
                transformer.transform(domSource, streamResult);
            } else {
                errorNotice = "Invalid ConfigurationProperties.getXsltEngine() value='" + ConfigurationProperties.getXsltEngine() + "', legal values are ConfigurationProperties.XSLT_ENGINE_SAXON or ConfigurationProperties.XSLT_ENGINE_NATIVE_JAVA";
                throw new InvalidFieldValueException(errorNotice);
            }
            if (ConfigurationProperties.isDeleteIntermediateFiles()) {
                intermediateX3DFilePath.toFile().deleteOnExit();
            }
        }
        catch (IOException | ParserConfigurationException | TransformerException | SAXException exception) {
            throw new X3DException(errorNotice + exception.toString() + " exception when transforming and creating fileName " + outputFilePath + ", unable to save result: " + exception);
        }
        catch (SaxonApiException saxonApiException) {
            throw new X3DException(errorNotice + "SaxonApiException when transforming and creating fileName " + outputFilePath + ", unable to save result: " + (Object)((Object)saxonApiException));
        }
        return outputFilePath.toFile();
    }

    public File toFileHtmlDocumentation(String fileName) {
        String svgFileName = fileName;
        svgFileName = svgFileName.endsWith(FILE_EXTENSION_HTML) ? svgFileName.replace(FILE_EXTENSION_HTML, FILE_EXTENSION_SVG) : (svgFileName.endsWith(FILE_EXTENSION_XHTML) ? svgFileName.replace(FILE_EXTENSION_XHTML, FILE_EXTENSION_SVG) : svgFileName + FILE_EXTENSION_SVG);
        this.toFileStylesheetConversion("X3dExtrusionCrossSectionToSvg.xslt", svgFileName);
        return this.toFileStylesheetConversion("X3dToXhtml.xslt", fileName);
    }

    public static File getTempFileFromX3dJsailJar(String internalPath, String fileName) {
        File outputFile;
        InputStream fileInputStream;
        String systemClassPath = ConfigurationProperties.getClassPath();
        String currentX3dJsailJarName = new String();
        String errorNotice = new String();
        boolean foundX3dJsailJar = false;
        if (systemClassPath.contains("X3DJSAIL")) {
            currentX3dJsailJarName = systemClassPath.substring(systemClassPath.indexOf("X3DJSAIL"));
            if (systemClassPath.indexOf("X3DJSAIL") > 0 && currentX3dJsailJarName.indexOf(File.pathSeparatorChar) > 0) {
                currentX3dJsailJarName = currentX3dJsailJarName.substring(0, currentX3dJsailJarName.indexOf(File.pathSeparatorChar));
            }
            for (String nextX3dJsailJar : ConfigurationProperties.X3DJSAIL_JAR_RELEASE_VERSIONS) {
                if (!currentX3dJsailJarName.equals(nextX3dJsailJar)) continue;
                foundX3dJsailJar = true;
                break;
            }
        }
        if (!foundX3dJsailJar) {
            errorNotice = "ERROR_CONFIGURATION_X3DJSAIL X3DJSAIL jar archive \"" + currentX3dJsailJarName + "\" not found in CLASSPATH=" + systemClassPath + "\n";
            errorNotice = errorNotice + "  invoked from getTempFileFromX3dJsailJar(" + internalPath + ", " + fileName + ")\n";
            System.out.println(errorNotice);
        }
        String jarPath = "jar:file:" + currentX3dJsailJarName + "!/";
        String filePath = internalPath;
        if (!filePath.startsWith("/")) {
            filePath = "/" + filePath;
        }
        if (!filePath.endsWith("/")) {
            filePath = filePath + "/";
        }
        filePath = filePath + fileName;
        String fileNameRoot = fileName;
        String fileExtension = new String();
        if (fileName.contains(".")) {
            fileNameRoot = fileName.substring(0, fileName.lastIndexOf("."));
            fileExtension = fileName.substring(fileName.lastIndexOf("."));
        }
        if (ConfigurationProperties.isDebugModeActive()) {
            errorNotice = errorNotice + "[diagnostic] System java.class.path=" + systemClassPath + "\n";
            errorNotice = errorNotice + "[diagnostic] jarPath=" + jarPath + ", ";
            errorNotice = errorNotice + "filePath=" + filePath + "\n";
        }
        if ((fileInputStream = X3D.class.getResourceAsStream(filePath)) == null) {
            errorNotice = errorNotice + "File not found in " + jarPath + ": " + filePath + ", ";
        }
        try {
            outputFile = File.createTempFile(fileNameRoot, fileExtension);
            if (outputFile == null) {
                errorNotice = errorNotice + "outputFile not created: " + fileName + ", ";
            }
            outputFile.deleteOnExit();
            Files.copy(fileInputStream, outputFile.toPath(), StandardCopyOption.REPLACE_EXISTING);
        }
        catch (IOException ex) {
            ex.printStackTrace();
            outputFile = null;
        }
        if (!errorNotice.isEmpty() && errorNotice.trim().startsWith("[diagnostic]")) {
            System.out.println("*** " + errorNotice.trim());
        } else if (!errorNotice.isEmpty()) {
            System.out.println("*** Error: " + errorNotice.trim());
        }
        return outputFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String readFile(String file) throws IOException {
        BufferedReader reader = new BufferedReader(new FileReader(file));
        StringBuilder stringBuilder = new StringBuilder();
        String ls = System.getProperty("line.separator");
        try {
            String line;
            while ((line = reader.readLine()) != null) {
                stringBuilder.append(line);
                stringBuilder.append(ls);
            }
            String string = stringBuilder.toString();
            return string;
        }
        finally {
            reader.close();
        }
    }

    public String toStringJSON() {
        String temporaryFileName = "temporaryJsonOutputFile.json";
        try {
            File fileJSON = this.toFileJSON(temporaryFileName);
            if (fileJSON != null && fileJSON.exists()) {
                String fileContents = this.readFile(temporaryFileName);
                fileJSON.delete();
                return fileContents;
            }
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
            throw new X3DException("IOException when converting toStringJSON(): " + ioe);
        }
        return "";
    }

    public String toStringPython() {
        String temporaryFileName = "temporaryPythonOutputFile.py";
        try {
            File filePython = this.toFilePython(temporaryFileName);
            if (filePython != null && filePython.exists()) {
                String fileContents = this.readFile(temporaryFileName);
                filePython.delete();
                return fileContents;
            }
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
            throw new X3DException("IOException when converting toStringPython(): " + ioe);
        }
        return "";
    }

    public String toStringJava() {
        String temporaryFileName = "temporaryJavaOutputFile.java";
        try {
            File fileJava = this.toFileJava(temporaryFileName);
            if (fileJava != null && fileJava.exists()) {
                String fileContents = this.readFile(temporaryFileName);
                fileJava.delete();
                return fileContents;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return "";
    }

    public String toStringJavaScript() {
        String temporaryFileName = "temporaryJavaScriptOutputFile.js";
        try {
            File fileJavaScript = this.toFileJavaScript(temporaryFileName);
            if (fileJavaScript != null && fileJavaScript.exists()) {
                String fileContents = this.readFile(temporaryFileName);
                fileJavaScript.delete();
                return fileContents;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return "";
    }

    public File toFileJavaScript(String fileName) {
        return this.toFileJavaScript(fileName, false);
    }

    public File toFileJavaScript(String fileName, boolean includeWeb3dLicense) {
        String className;
        String errorNotice = new String();
        if (fileName == null || fileName.isEmpty()) {
            throw new X3DException("toFileJavaScript(fileName, includeWeb3dLicense) fileName not provided; be sure to end with extension \".x3d\"");
        }
        if (!fileName.endsWith(FILE_EXTENSION_JAVASCRIPT)) {
            throw new X3DException("fileName " + fileName + " does not end with extension \"" + FILE_EXTENSION_JAVASCRIPT + "\"");
        }
        Path outputFilePath = Paths.get(fileName, new String[0]);
        if (ConfigurationProperties.isDebugModeActive()) {
            errorNotice = errorNotice + "[diagnostic] Output file path=" + outputFilePath.toAbsolutePath() + "\n";
            System.out.println(errorNotice);
        }
        if ((className = fileName.substring(0, fileName.indexOf(FILE_EXTENSION_JAVASCRIPT))).contains("/")) {
            className = className.substring(fileName.lastIndexOf("/") + 1);
        }
        if (className.contains("\\/")) {
            className = className.substring(fileName.lastIndexOf("\\") + 1);
        }
        String parameterName1 = "className";
        String parameterValue1 = className;
        String parameterName2 = "";
        String parameterValue2 = "";
        if (includeWeb3dLicense) {
            parameterName2 = "includeLicenseoriginals";
            parameterValue2 = Boolean.toString(includeWeb3dLicense);
        }
        return this.toFileStylesheetConversion("X3dToNodeJS.xslt", fileName, parameterName1, parameterValue1, parameterName2, parameterValue2);
    }

    public String toStringHtmlDocumentation() {
        String temporaryFileName = "temporaryPrettyPrintOutputFile.html";
        try {
            File fileHTML = this.toFileHtmlDocumentation(temporaryFileName);
            if (fileHTML != null && fileHTML.exists()) {
                String fileContents = this.readFile(temporaryFileName);
                fileHTML.delete();
                return fileContents;
            }
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
            throw new X3DException("IOException when converting toHtmlDocumentation(): " + ioe);
        }
        return "";
    }

    public String toStringModelMetaMarkdown() {
        String temporaryFileName = "temporaryModelMetaMarkdownOutputFile.x3d";
        try {
            File fileMarkdown = this.toFileModelMetaMarkdown(temporaryFileName);
            if (fileMarkdown != null && fileMarkdown.exists()) {
                String fileContents = this.readFile(temporaryFileName);
                fileMarkdown.delete();
                return fileContents;
            }
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
            throw new X3DException("IOException when converting toStringModelMetaMarkdown(): " + ioe);
        }
        return "";
    }

    public String toStringX3dTidy() {
        String temporaryFileName = "temporaryPrettyPrintOutputFile.x3d";
        try {
            File fileHTML = this.toFileX3dTidy(temporaryFileName);
            if (fileHTML != null && fileHTML.exists()) {
                String fileContents = this.readFile(temporaryFileName);
                fileHTML.delete();
                return fileContents;
            }
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
            throw new X3DException("IOException when converting toStringX3dTidy(): " + ioe);
        }
        return "";
    }

    public String toStringX3DOM() {
        String temporaryFileName = "temporaryX3domOutputFile.html";
        try {
            File fileX3DOM = this.toFileX3DOM(temporaryFileName);
            if (fileX3DOM != null && fileX3DOM.exists()) {
                String fileContents = this.readFile(temporaryFileName);
                fileX3DOM.delete();
                return fileContents;
            }
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
            throw new X3DException("IOException when converting toStringX3DOM(): " + ioe);
        }
        return "";
    }

    public String toStringX_ITE(String sourceSceneName) {
        String temporaryFileName = "temporaryX3domOutputFile.html";
        try {
            File fileX_ITE = this.toFileX_ITE(sourceSceneName, temporaryFileName);
            if (fileX_ITE != null && fileX_ITE.exists()) {
                String fileContents = this.readFile(temporaryFileName);
                fileX_ITE.delete();
                return fileContents;
            }
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
            throw new X3DException("IOException when converting toStringX_ITE(): " + ioe);
        }
        return "";
    }

    public File toFileJSON(String fileName) {
        return this.toFileStylesheetConversion("X3dToJson.xslt", fileName, "normalizeCommentWhitespace", Boolean.toString(ConfigurationProperties.isNormalizeCommentWhitespace()));
    }

    public File toFilePython(String fileName) {
        return this.toFileStylesheetConversion("X3dToPython.xslt", fileName, "normalizeCommentWhitespace", Boolean.toString(ConfigurationProperties.isNormalizeCommentWhitespace()));
    }

    public File toFileJava(String fileName) {
        return this.toFileJava(fileName, false);
    }

    public File toFileJava(String fileName, boolean includeWeb3dLicense) {
        String className;
        String errorNotice = new String();
        if (fileName == null || fileName.isEmpty()) {
            throw new X3DException("toFileJava(fileName, includeWeb3dLicense) fileName not provided; be sure to end with extension \".x3d\"");
        }
        if (!fileName.endsWith(FILE_EXTENSION_JAVA)) {
            throw new X3DException("fileName " + fileName + " does not end with extension \"" + FILE_EXTENSION_JAVA + "\"");
        }
        Path outputFilePath = Paths.get(fileName, new String[0]);
        if (ConfigurationProperties.isDebugModeActive()) {
            errorNotice = errorNotice + "[diagnostic] Output file path=" + outputFilePath.toAbsolutePath() + "\n";
            System.out.println(errorNotice);
        }
        if ((className = fileName.substring(0, fileName.indexOf(FILE_EXTENSION_JAVA))).contains("/")) {
            className = className.substring(fileName.lastIndexOf("/") + 1);
        }
        if (className.contains("\\/")) {
            className = className.substring(fileName.lastIndexOf("\\") + 1);
        }
        String parameterName1 = "className";
        String parameterValue1 = className;
        String parameterName2 = "";
        String parameterValue2 = "";
        if (includeWeb3dLicense) {
            parameterName2 = "includeLicenseoriginals";
            parameterValue2 = Boolean.toString(includeWeb3dLicense);
        }
        return this.toFileStylesheetConversion("X3dToJava.xslt", fileName, parameterName1, parameterValue1, parameterName2, parameterValue2);
    }

    public void setIncludeSubdirectoryPaths(boolean value) {
        this.includeSubdirectoryPaths = value;
    }

    public File toFileModelMetaMarkdown(String fileName) {
        String errorNotice = new String();
        if (fileName == null || fileName.isEmpty()) {
            throw new X3DException("toFileX3dTidy(fileName) fileName not provided; be sure to end with extension \".md\"");
        }
        if (!fileName.endsWith(FILE_EXTENSION_MARKDOWN)) {
            throw new X3DException("fileName " + fileName + " does not end with extension \"" + FILE_EXTENSION_MARKDOWN + "\"");
        }
        if (!X3D.fileNameMeetsX3dNamingConventions(fileName)) {
            System.out.println("Warning: " + fileName + " does not meet suggested X3D naming conventions, continuing...");
        } else if (!X3D.isFileNameNMTOKEN(fileName)) {
            System.out.println("Warning: " + fileName + " is not a valid NMTOKEN, continuing...");
        }
        Path outputFilePath = Paths.get(fileName, new String[0]);
        if (ConfigurationProperties.isDebugModeActive()) {
            errorNotice = errorNotice + "[diagnostic] Output file path=" + outputFilePath.toAbsolutePath() + "\n";
            System.out.println(errorNotice);
        }
        return this.toFileStylesheetConversion("X3dModelMetaToMarkdown.xslt", fileName, "includeSubdirectoryPaths", Boolean.toString(this.includeSubdirectoryPaths));
    }

    public File toFileX3dTidy(String fileName) {
        String errorNotice = new String();
        if (fileName == null || fileName.isEmpty()) {
            throw new X3DException("toFileX3dTidy(fileName) fileName not provided; be sure to end with extension \".x3d\"");
        }
        if (!fileName.endsWith(FILE_EXTENSION_X3D)) {
            throw new X3DException("fileName " + fileName + " does not end with extension \"" + FILE_EXTENSION_X3D + "\"");
        }
        if (!X3D.fileNameMeetsX3dNamingConventions(fileName)) {
            System.out.println("Warning: " + fileName + " does not meet suggested X3D naming conventions, continuing...");
        } else if (!X3D.isFileNameNMTOKEN(fileName)) {
            System.out.println("Warning: " + fileName + " is not a valid NMTOKEN, continuing...");
        }
        Path outputFilePath = Paths.get(fileName, new String[0]);
        if (ConfigurationProperties.isDebugModeActive()) {
            errorNotice = errorNotice + "[diagnostic] Output file path=" + outputFilePath.toAbsolutePath() + "\n";
            System.out.println(errorNotice);
        }
        return this.toFileStylesheetConversion("X3dTidy.xslt", fileName);
    }

    public File toFileX3DOM(String fileName) {
        String errorNotice = new String();
        if (fileName == null || fileName.isEmpty()) {
            throw new X3DException("toFileX3DOM(fileName) fileName not provided; be sure to end with extension \".html\" or \".xhtml\"");
        }
        if (!fileName.endsWith(FILE_EXTENSION_HTML) && !fileName.endsWith(FILE_EXTENSION_XHTML)) {
            throw new X3DException("fileName " + fileName + " does not end with extension \"" + FILE_EXTENSION_HTML + "\" or \"" + FILE_EXTENSION_XHTML + "\"");
        }
        if (!X3D.fileNameMeetsX3dNamingConventions(fileName)) {
            System.out.println("Warning: " + fileName + " does not meet suggested X3D naming conventions, continuing...");
        } else if (!X3D.isFileNameNMTOKEN(fileName)) {
            System.out.println("Warning: " + fileName + " is not a valid NMTOKEN, continuing...");
        }
        Path outputFilePath = Paths.get(fileName, new String[0]);
        if (ConfigurationProperties.isDebugModeActive()) {
            errorNotice = errorNotice + "[diagnostic] Output file path=" + outputFilePath.toAbsolutePath() + "\n";
            System.out.println(errorNotice);
        }
        return this.toFileStylesheetConversion("X3dToX3dom.xslt", fileName, "player", "X3DOM");
    }

    public File toFileX_ITE(String sourceSceneName, String resultFileName) {
        return this.toFileStylesheetConversion("X3dToX3dom.xslt", resultFileName, "player", "Cobweb", "urlScene", sourceSceneName);
    }

    @Deprecated
    public File toFileCobweb(String sourceSceneName, String resultFileName) {
        return this.toFileX_ITE(sourceSceneName, resultFileName);
    }

    public boolean fromFileZIP(String zipFileName, String outputFileName) {
        return this.fromFileZIP(zipFileName, outputFileName, "");
    }

    public boolean fromFileZIP(String zipFileName, String outputFileName, String modelFileName) {
        File zipFile;
        if (modelFileName == null) {
            modelFileName = new String();
        }
        String errorNotice = new String();
        if (zipFileName == null || zipFileName.isEmpty()) {
            throw new X3DException("fromFileZIP(zipFileName, modelFileName) zipFileName not provided; be sure to end with extension \".zip\"");
        }
        if (!zipFileName.endsWith(FILE_EXTENSION_ZIP)) {
            errorNotice = errorNotice + "fromFileZIP zipFileName " + zipFileName + " does not end with extension \"" + FILE_EXTENSION_ZIP + "\"\n";
            System.out.println(errorNotice);
            return false;
        }
        if (!zipFileName.endsWith(FILE_EXTENSION_ZIP)) {
            errorNotice = errorNotice + "fromFileZIP zipFileName " + zipFileName + " does not end with extension \"" + FILE_EXTENSION_ZIP + "\"\n";
            System.out.println(errorNotice);
            return false;
        }
        Path inputFilePath = Paths.get(zipFileName, new String[0]);
        if (ConfigurationProperties.isDebugModeActive()) {
            errorNotice = errorNotice + "[diagnostic] fromFileZIP zipFileName path=" + inputFilePath.toAbsolutePath() + "\n";
            System.out.println(errorNotice);
        }
        if (!(zipFile = new File(zipFileName)).exists() || zipFile == null) {
            errorNotice = errorNotice + "zipFileName " + zipFileName + "not found\n";
            System.out.println(errorNotice);
            return false;
        }
        try {
            FileInputStream fileInputStream = new FileInputStream(zipFile);
            ZipInputStream zipInputStream = new ZipInputStream(fileInputStream);
            ZipEntry zipEntry = null;
            while ((zipEntry = zipInputStream.getNextEntry()) != null) {
                File priorFile;
                if (ConfigurationProperties.isDebugModeActive()) {
                    System.out.println("Unzipping " + zipEntry.getName() + " size=" + zipEntry.getSize() + " bytes");
                }
                if (outputFileName.isEmpty()) {
                    outputFileName = zipEntry.getName();
                    System.out.println("Warning: fromFileZIP() outputFileName was empty, unzipping found initial X3D file to save: " + outputFileName);
                }
                if (modelFileName.isEmpty() && (zipEntry.getName().endsWith(FILE_EXTENSION_X3D) || zipEntry.getName().endsWith(FILE_EXTENSION_XML))) {
                    modelFileName = zipEntry.getName();
                    System.out.println("Warning: fromFileZIP() modelFileName was empty, unzipping found initial X3D file to load: " + modelFileName);
                }
                if ((priorFile = new File(outputFileName)).exists() && ConfigurationProperties.isOverwriteExistingFiles()) {
                    System.out.println("Warning: fromFileZIP() is overwriting prior file " + outputFileName);
                } else if (priorFile.exists()) {
                    System.out.println("Warning: fromFileZIP() is not allowed to overwrite prior file: " + outputFileName);
                    System.out.println("  see X3DJSAIL.properties file, or ConfigurationProperties.isOverwriteExistingFiles() and .setOverwriteExistingFiles(), to get/set permissions");
                    return false;
                }
                FileOutputStream fileOutputStream = new FileOutputStream(outputFileName);
                int c = zipInputStream.read();
                while (c != -1) {
                    fileOutputStream.write(c);
                    c = zipInputStream.read();
                }
                zipInputStream.closeEntry();
                fileOutputStream.close();
                System.out.println("Unzipped " + outputFileName + " size=" + zipEntry.getSize() + " bytes");
            }
            zipInputStream.close();
            if (modelFileName.isEmpty()) {
                System.out.println("fromZIP output modelFileName not found in zipFileName " + zipFileName + ", no X3D model to load");
                return false;
            }
            X3DLoaderDOM x3dLoader = new X3DLoaderDOM();
            boolean x3dLoaderSuccess = x3dLoader.loadModelFromFileX3D(modelFileName);
            if (x3dLoaderSuccess) {
                this.replace((X3D)x3dLoader.getX3dObjectTree());
            }
        }
        catch (IOException e) {
            errorNotice = errorNotice + "zipFileName " + zipFileName + "not readable\n";
            System.out.println(errorNotice);
            return false;
        }
        return this.hasHead() || this.hasScene();
    }

    public boolean fromFileGZIP(String gzipFileName) {
        File gzipFile;
        String errorNotice = new String();
        if (gzipFileName == null || gzipFileName.isEmpty()) {
            throw new X3DException("fromFileGZIP(gzipFileName) fileName not provided; be sure to end with extension \".gz\"");
        }
        if (!gzipFileName.endsWith(FILE_EXTENSION_GZIP)) {
            errorNotice = errorNotice + "gzipFileName " + gzipFileName + " does not end with extension \"" + FILE_EXTENSION_GZIP + "\"\n";
        }
        Path inputFilePath = Paths.get(gzipFileName, new String[0]);
        if (ConfigurationProperties.isDebugModeActive()) {
            errorNotice = errorNotice + "[diagnostic] gzipFileName path=" + inputFilePath.toAbsolutePath() + "\n";
            System.out.println(errorNotice);
        }
        if (!(gzipFile = new File(gzipFileName)).exists() || gzipFile == null) {
            errorNotice = errorNotice + "gzipFileName " + gzipFileName + "not found\n";
            System.out.println(errorNotice);
            return false;
        }
        String modelFileName = gzipFileName;
        if (modelFileName.contains(FILE_EXTENSION_GZIP)) {
            modelFileName = modelFileName.substring(0, modelFileName.lastIndexOf(FILE_EXTENSION_GZIP));
        }
        if (!modelFileName.endsWith(FILE_EXTENSION_X3D)) {
            modelFileName = modelFileName + FILE_EXTENSION_X3D;
        }
        if (modelFileName.isEmpty()) {
            return false;
        }
        System.out.println("  fromFileGZIP() output modelFileName " + modelFileName);
        File priorFile = new File(modelFileName);
        if (priorFile.exists() && ConfigurationProperties.isOverwriteExistingFiles()) {
            System.out.println("Warning: fromFileGZIP() is overwriting prior file " + modelFileName);
        } else if (priorFile.exists()) {
            System.out.println("Warning: fromFileGZIP() is not allowed to overwrite prior file: " + modelFileName);
            System.out.println("  see X3DJSAIL.properties file, or ConfigurationProperties.isOverwriteExistingFiles() and .setOverwriteExistingFiles(), to get/set permissions");
            return false;
        }
        try {
            FileInputStream fileInputStream = new FileInputStream(gzipFile);
            GZIPInputStream gzipInputStream = new GZIPInputStream(fileInputStream);
            if (ConfigurationProperties.isDebugModeActive()) {
                System.out.println("gunzipping " + gzipFile);
            }
            FileOutputStream fileOutputStream = new FileOutputStream(modelFileName);
            int c = gzipInputStream.read();
            while (c != -1) {
                fileOutputStream.write(c);
                c = gzipInputStream.read();
            }
            gzipInputStream.close();
            fileOutputStream.close();
            File decompressedFile = new File(modelFileName);
            System.out.println("gunzipped " + decompressedFile.getPath() + " size=" + decompressedFile.length() + " bytes");
            X3DLoaderDOM x3dLoader = new X3DLoaderDOM();
            boolean x3dLoaderSuccess = x3dLoader.loadModelFromFileX3D(modelFileName);
            if (x3dLoaderSuccess) {
                this.replace((X3D)x3dLoader.getX3dObjectTree());
            }
        }
        catch (IOException e) {
            errorNotice = errorNotice + "gzipFileName " + gzipFileName + "not readable\n";
            System.out.println(errorNotice);
            return false;
        }
        return this.hasHead() || this.hasScene();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean fromFileEXI(String exiFileName) {
        File priorFile;
        String errorNotice = new String();
        if (exiFileName == null) throw new X3DException("fromFileEXI(exiFileName) fileName not provided; be sure to end with extension \".exi\"");
        if (exiFileName.isEmpty()) {
            throw new X3DException("fromFileEXI(exiFileName) fileName not provided; be sure to end with extension \".exi\"");
        }
        if (!exiFileName.endsWith(FILE_EXTENSION_EXI)) {
            errorNotice = errorNotice + "exiFileName " + exiFileName + " does not end with extension \"" + FILE_EXTENSION_EXI + "\"\n";
        }
        if ((priorFile = new File(exiFileName)).exists() && ConfigurationProperties.isOverwriteExistingFiles()) {
            System.out.println("Warning: fromFileEXI() is overwriting prior file " + exiFileName);
        } else if (priorFile.exists()) {
            System.out.println("Warning: fromFileEXI() is not allowed to overwrite prior file: " + exiFileName);
            System.out.println("  see X3DJSAIL.properties file, or ConfigurationProperties.isOverwriteExistingFiles() and .setOverwriteExistingFiles(), to get/set permissions");
            return false;
        }
        Path inputFilePath = Paths.get(exiFileName, new String[0]);
        if (ConfigurationProperties.isDebugModeActive()) {
            errorNotice = errorNotice + "[diagnostic] exiFileName path=" + inputFilePath.toAbsolutePath() + "\n";
            System.out.println(errorNotice);
        }
        String xmlFileName = "examples/temp.exiInputTransformed.x3d";
        switch (ConfigurationProperties.getExiEngine()) {
            case "EXIFICIENT": {
                try {
                    EXIFactory exiFactory = DefaultEXIFactory.newInstance();
                    if (this.exificientGrammarX3D == null) {
                        this.exificientGrammarX3D = GrammarFactory.newInstance().createGrammars("http://www.web3d.org/specifications/x3d-4.0.xsd");
                    }
                    exiFactory.setGrammars(this.exificientGrammarX3D);
                    exiFactory.setCodingMode(CodingMode.COMPRESSION);
                    StreamResult result = new StreamResult(xmlFileName);
                    InputSource exiFileInputSource = new InputSource(exiFileName);
                    EXISource exiSource = new EXISource(exiFactory);
                    exiSource.setInputSource(exiFileInputSource);
                    TransformerFactory tf = TransformerFactory.newInstance();
                    Transformer transformer = tf.newTransformer();
                    transformer.transform((Source)exiSource, result);
                    break;
                }
                catch (EXIException | TransformerException ex) {
                    Logger.getLogger(X3D.class.getName()).log(Level.SEVERE, null, ex);
                    return false;
                }
            }
            case "OPENEXI": {
                InputStream fileInputStream = null;
                InputStream schemaInputStream = null;
                Writer out = null;
                StringWriter stringWriter = new StringWriter();
                short options = 2;
                try {
                    SAXTransformerFactory saxTransformerFactory = (SAXTransformerFactory)SAXTransformerFactory.newInstance();
                    SAXParserFactory saxParserFactory = SAXParserFactory.newInstance();
                    saxParserFactory.setNamespaceAware(true);
                    TransformerHandler transformerHandler = saxTransformerFactory.newTransformerHandler();
                    EXIReader reader = new EXIReader();
                    reader.setAlignmentType(AlignmentType.compress);
                    File inputFile = new File(exiFileName);
                    fileInputStream = new FileInputStream(inputFile);
                    out = new OutputStreamWriter((OutputStream)new FileOutputStream(xmlFileName), "UTF-8");
                    FileInputStream fis = null;
                    EXISchema schema = null;
                    if (!new File("examples/x3d-4.0.xsd.exig").exists()) {
                        SerializeEXISchema s = new SerializeEXISchema();
                        try {
                            schemaInputStream = this.getClass().getResourceAsStream("/specifications/x3d-4.0.xsd");
                            s.serializeEXISchema("/specifications/x3d-4.0.xsd", schemaInputStream, "examples/x3d-4.0.xsd.exig");
                        }
                        catch (IOException | EXISchemaFactoryException ex) {
                            Logger.getLogger(X3D.class.getName()).log(Level.SEVERE, null, ex);
                            throw new IllegalArgumentException(ex);
                        }
                        finally {
                            try {
                                if (schemaInputStream != null) {
                                    schemaInputStream.close();
                                }
                            }
                            catch (IOException ex) {
                                Logger.getLogger(X3D.class.getName()).log(Level.SEVERE, null, ex);
                            }
                        }
                    }
                    try {
                        fis = new FileInputStream("examples/x3d-4.0.xsd.exig");
                        schema = new EXISchemaReader().parse((InputStream)fis);
                    }
                    finally {
                        if (fis != null) {
                            fis.close();
                        }
                    }
                    GrammarCache grammarCache = new GrammarCache(schema, options);
                    reader.setGrammarCache(grammarCache);
                    transformerHandler.setResult(new StreamResult(stringWriter));
                    byte[] fileContent = new byte[(int)inputFile.length()];
                    fileInputStream.read(fileContent);
                    reader.setContentHandler((ContentHandler)transformerHandler);
                    reader.parse(new InputSource(new ByteArrayInputStream(fileContent)));
                    String reconstitutedString = stringWriter.getBuffer().toString();
                    out.write(reconstitutedString);
                    out.flush();
                    try {
                        if (fileInputStream != null) {
                            fileInputStream.close();
                        }
                        if (out == null) break;
                        out.close();
                    }
                    catch (IOException ex) {
                        Logger.getLogger(X3D.class.getName()).log(Level.SEVERE, null, ex);
                    }
                    break;
                }
                catch (IOException | TransformerConfigurationException | EXIOptionsException | SAXException ex) {
                    Logger.getLogger(X3D.class.getName()).log(Level.SEVERE, null, ex);
                    boolean bl = false;
                    return bl;
                }
                finally {
                    try {
                        if (fileInputStream != null) {
                            fileInputStream.close();
                        }
                        if (out != null) {
                            out.close();
                        }
                    }
                    catch (IOException ex) {
                        Logger.getLogger(X3D.class.getName()).log(Level.SEVERE, null, ex);
                    }
                }
            }
            default: {
                errorNotice = "ERROR_CONFIGURATION_X3DJSAIL illegal value \"" + ConfigurationProperties.getExiEngine() + "\" found for ConfigurationProperties.getExiEngine()\n   allowed values are ConfigurationProperties.EXI_ENGINE_EXIFICIENT and ConfigurationProperties.EXI_ENGINE_OPENEXI";
                if (ConfigurationProperties.isDebugModeActive()) {
                    errorNotice = errorNotice + "[diagnostic] exiFileName path=" + inputFilePath.toAbsolutePath() + "\n";
                }
                System.err.println(errorNotice);
                throw new InvalidFieldValueException(errorNotice);
            }
        }
        File decompressedFile = new File(xmlFileName);
        System.out.println("EXI decompressed " + decompressedFile.getPath() + " size=" + decompressedFile.length() + " bytes");
        X3DLoaderDOM x3dLoader = new X3DLoaderDOM();
        boolean x3dLoaderSuccess = x3dLoader.loadModelFromFileX3D(xmlFileName);
        if (x3dLoaderSuccess) {
            this.replace((X3D)x3dLoader.getX3dObjectTree());
        }
        if (this.hasHead()) return true;
        if (this.hasScene()) return true;
        return false;
    }

    public boolean isEmpty() {
        return !this.hasHead() && !this.hasScene();
    }

    public boolean loadModelFromFileX3D(String fileName) {
        return this.loadModelFromFileX3D("", fileName);
    }

    public boolean loadModelFromFileX3D(String path, String fileName) {
        File x3dFile = path == null || path.isEmpty() || path.equals(".") ? new File(fileName) : new File(path, fileName);
        if (!x3dFile.exists()) {
            throw new X3DException("path, fileName " + path + ", " + fileName + " does not exist and cannot be loaded, check path and filename.");
        }
        return this.loadModelFromFileX3D(x3dFile);
    }

    public boolean loadModelFromFileX3D(File x3dFile) {
        X3DLoaderDOM x3dLoader = new X3DLoaderDOM();
        boolean x3dLoaderSuccess = x3dLoader.loadModelFromFileX3D(x3dFile);
        if (x3dLoaderSuccess) {
            return this.replace((X3D)x3dLoader.getX3dObjectTree());
        }
        return false;
    }

    public boolean replace(X3D newX3DObject) {
        if (newX3DObject == null) {
            return false;
        }
        this.setHead(newX3DObject.getHead());
        this.setScene(newX3DObject.getScene());
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public File toFileEXI(String resultFileName) {
        String errorNotice = new String();
        if (resultFileName == null || resultFileName.isEmpty()) {
            throw new X3DException("toFileJava(resultFileName) fileName not provided; be sure to end with extension \".exi\"");
        }
        if (!resultFileName.endsWith(FILE_EXTENSION_EXI)) {
            throw new X3DException("resultFileName " + resultFileName + " does not end with extension \"" + FILE_EXTENSION_EXI + "\"");
        }
        Path outputFilePath = Paths.get(resultFileName, new String[0]);
        if (ConfigurationProperties.isDebugModeActive()) {
            errorNotice = errorNotice + "[diagnostic] Output file path=" + outputFilePath.toAbsolutePath() + "\n";
            System.out.println(errorNotice);
        }
        File newXmlFile = this.toFileX3D(resultFileName + ".temp.x3d");
        newXmlFile.deleteOnExit();
        String exiFileName = resultFileName;
        if (!exiFileName.endsWith(FILE_EXTENSION_EXI)) {
            exiFileName = exiFileName + FILE_EXTENSION_EXI;
            System.out.println(resultFileName + " changed to " + exiFileName);
        }
        File newExiFile = new File(exiFileName);
        switch (ConfigurationProperties.getExiEngine()) {
            case "EXIFICIENT": {
                try {
                    EXIFactory exiFactory = DefaultEXIFactory.newInstance();
                    if (this.exificientGrammarX3D == null) {
                        this.exificientGrammarX3D = GrammarFactory.newInstance().createGrammars("http://www.web3d.org/specifications/x3d-4.0.xsd");
                    }
                    exiFactory.setGrammars(this.exificientGrammarX3D);
                    exiFactory.setCodingMode(CodingMode.COMPRESSION);
                    try (FileOutputStream osEXI = new FileOutputStream(exiFileName);){
                        EXIResult exiResult = new EXIResult(exiFactory);
                        exiResult.setOutputStream((OutputStream)osEXI);
                        SAXParserFactory spf = SAXParserFactory.newInstance();
                        spf.setNamespaceAware(true);
                        SAXParser saxParser = spf.newSAXParser();
                        saxParser.parse(newXmlFile, (DefaultHandler)exiResult.getHandler());
                    }
                }
                catch (EXIException | IOException | ParserConfigurationException | SAXException ex) {
                    Logger.getLogger(X3D.class.getName()).log(Level.SEVERE, null, ex);
                }
                break;
            }
            case "OPENEXI": {
                InputStream fileInputStream = null;
                InputStream schemaInputStream = null;
                OutputStream out = null;
                Transmogrifier transmogrifier = new Transmogrifier();
                transmogrifier.setAlignmentType(AlignmentType.compress);
                short options = 2;
                fileInputStream = new FileInputStream(newXmlFile);
                out = new FileOutputStream(newExiFile);
                if (!new File("examples/x3d-4.0.xsd.exig").exists()) {
                    SerializeEXISchema s = new SerializeEXISchema();
                    try {
                        schemaInputStream = this.getClass().getResourceAsStream("/specifications/x3d-4.0.xsd");
                        s.serializeEXISchema("/specifications/x3d-4.0.xsd", schemaInputStream, "examples/x3d-4.0.xsd.exig");
                    }
                    catch (IOException | EXISchemaFactoryException ex) {
                        Logger.getLogger(X3D.class.getName()).log(Level.SEVERE, null, ex);
                        throw new IllegalArgumentException(ex);
                    }
                    finally {
                        try {
                            if (schemaInputStream != null) {
                                schemaInputStream.close();
                            }
                        }
                        catch (IOException ex) {
                            Logger.getLogger(X3D.class.getName()).log(Level.SEVERE, null, ex);
                        }
                    }
                }
                EXISchema schema = null;
                try (FileInputStream fis = null;){
                    fis = new FileInputStream("examples/x3d-4.0.xsd.exig");
                    schema = new EXISchemaReader().parse((InputStream)fis);
                }
                GrammarCache grammarCache = new GrammarCache(schema, options);
                transmogrifier.setGrammarCache(grammarCache);
                transmogrifier.setOutputStream(out);
                transmogrifier.encode(new InputSource(fileInputStream));
                try {
                    if (fileInputStream != null) {
                        fileInputStream.close();
                    }
                    if (out == null) break;
                    out.close();
                }
                catch (IOException ex) {
                    Logger.getLogger(X3D.class.getName()).log(Level.SEVERE, null, ex);
                }
                break;
                catch (IOException | EXIOptionsException | TransmogrifierException ex) {
                    try {
                        Logger.getLogger(X3D.class.getName()).log(Level.SEVERE, null, ex);
                    }
                    catch (Throwable throwable) {
                        try {
                            if (fileInputStream != null) {
                                fileInputStream.close();
                            }
                            if (out != null) {
                                out.close();
                            }
                        }
                        catch (IOException ex2) {
                            Logger.getLogger(X3D.class.getName()).log(Level.SEVERE, null, ex2);
                        }
                        throw throwable;
                    }
                    try {
                        if (fileInputStream != null) {
                            fileInputStream.close();
                        }
                        if (out == null) break;
                        out.close();
                    }
                    catch (IOException ex3) {
                        Logger.getLogger(X3D.class.getName()).log(Level.SEVERE, null, ex3);
                    }
                    break;
                }
            }
            default: {
                errorNotice = "ERROR_CONFIGURATION_X3DJSAIL illegal value \"" + ConfigurationProperties.getExiEngine() + "\" found for ConfigurationProperties.getExiEngine()\n   allowed values are ConfigurationProperties.EXI_ENGINE_EXIFICIENT and ConfigurationProperties.EXI_ENGINE_OPENEXI";
                if (ConfigurationProperties.isDebugModeActive()) {
                    errorNotice = errorNotice + "[diagnostic] Output file path=" + outputFilePath.toAbsolutePath() + "\n";
                }
                System.err.println(errorNotice);
                throw new InvalidFieldValueException(errorNotice);
            }
        }
        return newExiFile;
    }

    public File toFileGZIP(String resultFileName) {
        File resultFile = new File(resultFileName);
        try {
            FileOutputStream fos = new FileOutputStream(resultFile);
            GZIPOutputStream gzos = new GZIPOutputStream(fos);
            gzos.write(this.toStringX3D().getBytes());
            gzos.close();
        }
        catch (IOException ioe) {
            System.out.println(ioe.getMessage());
            ioe.printStackTrace();
        }
        return resultFile;
    }

    public File toFileZIP(String zipFileName, String modelName) {
        File resultFile = new File(zipFileName);
        try {
            FileOutputStream fos = new FileOutputStream(resultFile);
            ZipOutputStream zos = new ZipOutputStream(fos);
            zos.setMethod(8);
            zos.setLevel(9);
            zos.setComment("Created by X3D Java Scene Access Interface Library (X3DJSAIL) https://www.web3d.org/specifications/java/X3DJSAIL.html");
            ZipEntry ze = new ZipEntry(modelName);
            zos.putNextEntry(ze);
            zos.write(this.toStringX3D().getBytes());
            zos.close();
        }
        catch (IOException ioe) {
            System.out.println(ioe.getMessage());
            ioe.printStackTrace();
        }
        return resultFile;
    }

    public String validationReport() {
        String exceptionResult;
        String validationResult;
        String metaResult;
        block12: {
            metaResult = new String();
            validationResult = new String();
            exceptionResult = new String();
            try {
                if (this.getHead() != null) {
                    for (meta meta2 : this.getHead().getMetaList()) {
                        if (!meta2.getName().equals("error")) {
                            if (!meta2.getName().equals("warning")) {
                                if (!meta2.getName().equals("hint")) {
                                    if (!meta2.getName().equals("info")) {
                                        if (!meta2.getName().equals("TODO")) continue;
                                    }
                                }
                            }
                        }
                        metaResult = metaResult + meta2.toStringX3D();
                    }
                }
                validationResult = validationResult + this.validate();
            }
            catch (Exception e) {
                exceptionResult = e.getMessage();
                if (exceptionResult != null) break block12;
                exceptionResult = "Exception caught but null message!";
                e.printStackTrace();
            }
        }
        if (metaResult.isEmpty() && exceptionResult.isEmpty() && validationResult.isEmpty()) {
            return "success";
        }
        if (!metaResult.isEmpty()) {
            metaResult = "\n" + metaResult;
        }
        String returnMessage = metaResult;
        if (!exceptionResult.isEmpty() && !validationResult.isEmpty()) {
            returnMessage = returnMessage + "\n*** ";
        }
        returnMessage = returnMessage + exceptionResult;
        if (exceptionResult.isEmpty() && !validationResult.isEmpty()) {
            returnMessage = "\n" + returnMessage;
        }
        returnMessage = returnMessage + validationResult;
        return returnMessage.trim();
    }

    public void handleArguments(String[] args) {
        String fileName = new String();
        CommandLine.setLoadedX3dModel(this);
        CommandLine.run(args);
    }

    public head getHead() {
        return this.head;
    }

    public X3D setHead(head newValue) {
        this.head = newValue;
        if (newValue != null) {
            this.head.setParent(this);
        }
        return this;
    }

    public X3D clearHead() {
        this.head.clearParent();
        this.head = null;
        return this;
    }

    public boolean hasHead() {
        return this.head != null;
    }

    public String getProfile() {
        return this.profile;
    }

    public X3D setProfile(String newValue) {
        if (newValue == null) {
            newValue = new String();
        }
        if (!((newValue = MFString.cleanupUnescapedEnclosingQuotes(newValue)).isEmpty() || newValue.equals("Core") || newValue.equals(PROFILE_INTERCHANGE) || newValue.equals(PROFILE_CADINTERCHANGE) || newValue.equals(PROFILE_INTERACTIVE) || newValue.equals("Immersive") || newValue.equals(PROFILE_MEDICALINTERCHANGE) || newValue.equals(PROFILE_MPEG4INTERACTIVE) || newValue.equals(PROFILE_FULL))) {
            String warningMessage = "Warning: X3D profile newValue=\"" + newValue + "\" has an unrecognized value not matching any of the required enumeration string tokens.";
            System.out.println(warningMessage);
            if (!newValue.isEmpty()) {
                throw new InvalidFieldValueException(warningMessage);
            }
        }
        if (newValue == null) {
            newValue = new String();
        }
        this.profile = newValue;
        return this;
    }

    public X3D setProfile(SFString newValue) {
        this.setProfile(newValue.getPrimitiveValue());
        return this;
    }

    public Scene getScene() {
        return this.Scene;
    }

    public X3D setScene(Scene newValue) {
        this.Scene = newValue;
        if (newValue != null) {
            this.Scene.setParent(this);
        }
        return this;
    }

    public X3D clearScene() {
        this.Scene.clearParent();
        this.Scene = null;
        return this;
    }

    public boolean hasScene() {
        return this.Scene != null;
    }

    public String getVersion() {
        return this.version;
    }

    public X3D setVersion(String newValue) {
        if (newValue == null) {
            newValue = new String();
        }
        if (!((newValue = MFString.cleanupUnescapedEnclosingQuotes(newValue)).isEmpty() || newValue.equals(VERSION_3_0) || newValue.equals(VERSION_3_1) || newValue.equals(VERSION_3_2) || newValue.equals(VERSION_3_3) || newValue.equals("4.0"))) {
            String warningMessage = "Warning: X3D version newValue=\"" + newValue + "\" has an unrecognized value not matching any of the required enumeration string tokens.";
            System.out.println(warningMessage);
            if (!newValue.isEmpty()) {
                throw new InvalidFieldValueException(warningMessage);
            }
        }
        if (newValue == null) {
            newValue = new String();
        }
        this.version = newValue;
        return this;
    }

    public X3D setVersion(SFString newValue) {
        this.setVersion(newValue.getPrimitiveValue());
        return this;
    }

    @Override
    public X3D addComments(String newComment) {
        this.commentsList.add(newComment);
        return this;
    }

    @Override
    public X3D addComments(String[] newComments) {
        this.commentsList.addAll(Arrays.asList(newComments));
        return this;
    }

    @Override
    public X3D addComments(CommentsBlock newCommentsBlock) {
        this.commentsList.addAll(newCommentsBlock.toStringList());
        return this;
    }

    @Override
    public String toStringX3D(int indentLevel) {
        boolean hasAttributes = true;
        boolean hasChild = this.head != null || this.Scene != null || !this.commentsList.isEmpty();
        StringBuilder indent = new StringBuilder();
        int indentIncrement = ConfigurationProperties.getIndentIncrement();
        char indentCharacter = ConfigurationProperties.getIndentCharacter();
        for (int i = 0; i < indentLevel; ++i) {
            indent.append(indentCharacter);
        }
        StringBuilder stringX3D = new StringBuilder();
        stringX3D.append(XML_HEADER).append("\n");
        switch (this.version) {
            case "3.0": {
                stringX3D.append(XML_DOCTYPE_X3D_3_0).append("\n");
                break;
            }
            case "3.1": {
                stringX3D.append(XML_DOCTYPE_X3D_3_1).append("\n");
                break;
            }
            case "3.2": {
                stringX3D.append(XML_DOCTYPE_X3D_3_2).append("\n");
                break;
            }
            case "3.3": {
                stringX3D.append(XML_DOCTYPE_X3D_3_3).append("\n");
                break;
            }
            case "4.0": {
                stringX3D.append(XML_DOCTYPE_X3D_4_0).append("\n");
                break;
            }
            case "4.1": {
                stringX3D.append(XML_DOCTYPE_X3D_4_1).append("\n");
                break;
            }
            default: {
                stringX3D.append("<!-- unknown DOCTYPE for X3D version ").append(this.version).append(" -->").append("\n");
            }
        }
        stringX3D.append((CharSequence)indent).append("<X3D");
        if (hasAttributes) {
            stringX3D.append(" profile='").append(new SFString(this.getProfile()).toStringX3D()).append("'");
            stringX3D.append(" version='").append(new SFString(this.getVersion()).toStringX3D()).append("'");
            switch (this.version) {
                case "3.0": {
                    stringX3D.append(" ").append(X3D_XML_SCHEMA_3_0_ATTRIBUTES);
                    break;
                }
                case "3.1": {
                    stringX3D.append(" ").append(X3D_XML_SCHEMA_3_1_ATTRIBUTES);
                    break;
                }
                case "3.2": {
                    stringX3D.append(" ").append(X3D_XML_SCHEMA_3_2_ATTRIBUTES);
                    break;
                }
                case "3.3": {
                    stringX3D.append(" ").append(X3D_XML_SCHEMA_3_3_ATTRIBUTES);
                    break;
                }
                case "4.0": {
                    stringX3D.append(" ").append(X3D_XML_SCHEMA_4_0_ATTRIBUTES);
                    break;
                }
                case "4.1": {
                    stringX3D.append(" ").append(X3D_XML_SCHEMA_4_1_ATTRIBUTES);
                    break;
                }
                default: {
                    stringX3D.append(" ").append(X3D_XML_SCHEMA_3_3_ATTRIBUTES);
                }
            }
        }
        if (hasChild) {
            stringX3D.append(">").append("\n");
            if (!this.commentsList.isEmpty()) {
                CommentsBlock commentsBlock = new CommentsBlock(this.commentsList);
                stringX3D.append(commentsBlock.toStringX3D(indentLevel + indentIncrement));
            }
            if (this.head != null) {
                stringX3D.append(((X3DConcreteElement)this.head).toStringX3D(indentLevel + indentIncrement));
            }
            if (this.Scene != null) {
                stringX3D.append(((X3DConcreteElement)this.Scene).toStringX3D(indentLevel + indentIncrement));
            }
            stringX3D.append((CharSequence)indent).append("</X3D>").append("\n");
        } else {
            stringX3D.append("/>").append("\n");
        }
        return stringX3D.toString();
    }

    @Override
    public String toStringClassicVRML(int indentLevel) {
        StringBuilder stringClassicVRML = new StringBuilder();
        boolean hasAttributes = true;
        boolean hasChild = this.head != null || this.Scene != null || !this.commentsList.isEmpty();
        StringBuilder indent = new StringBuilder();
        char indentCharacter = ConfigurationProperties.getIndentCharacter();
        int indentIncrement = ConfigurationProperties.getIndentIncrement();
        for (int i = 0; i < indentLevel; ++i) {
            indent.append(indentCharacter);
        }
        stringClassicVRML.append("#X3D V").append(this.version).append(" utf8").append("\n");
        stringClassicVRML.append("PROFILE").append(" ").append(this.profile).append("\n");
        if (hasAttributes) {
            // empty if block
        }
        if (hasChild) {
            if (this.Scene != null) {
                stringClassicVRML.append(((X3DConcreteElement)this.Scene).toStringClassicVRML(indentLevel));
            }
            if (this.head != null) {
                stringClassicVRML.append(((X3DConcreteElement)this.head).toStringClassicVRML(indentLevel));
            }
            if (!this.commentsList.isEmpty()) {
                CommentsBlock commentsBlock = new CommentsBlock(this.commentsList);
                stringClassicVRML.append(commentsBlock.toStringClassicVRML(indentLevel));
            }
        }
        return stringClassicVRML.toString();
    }

    @Override
    public String toStringVRML97(int indentLevel) {
        return this.toStringClassicVRML(indentLevel).replace("#X3D V4.0 utf8", "#VRML V2.0 utf8").replace("#X3D V3.3 utf8", "#VRML V2.0 utf8").replace("#X3D V3.2 utf8", "#VRML V2.0 utf8").replace("#X3D V3.1 utf8", "#VRML V2.0 utf8").replace("#X3D V3.0 utf8", "#VRML V2.0 utf8").replaceAll("PROFILE ", "#PROFILE ").replaceAll("COMPONENT ", "#COMPONENT ").replaceAll("META ", "#META ").replaceAll("UNIT ", "#UNIT ");
    }

    @Override
    public X3DConcreteElement findElementByNameValue(String nameValue) {
        return this.findElementByNameValue(nameValue, "");
    }

    @Override
    public X3DConcreteElement findElementByNameValue(String nameValue, String elementName) {
        X3DConcreteElement referenceElement;
        if (nameValue == null || nameValue.isEmpty()) {
            String errorNotice = "findElementByNameValue(\"\", " + elementName + ") cannot use empty string to find a name attribute";
            this.validationResult.append(errorNotice).append("\n");
            throw new InvalidFieldValueException(errorNotice);
        }
        if (this.head != null && (referenceElement = ((X3DConcreteElement)this.head).findElementByNameValue(nameValue, elementName)) != null) {
            return referenceElement;
        }
        if (this.Scene != null && (referenceElement = ((X3DConcreteElement)this.Scene).findElementByNameValue(nameValue, elementName)) != null) {
            return referenceElement;
        }
        return null;
    }

    public boolean hasElementByNameValue(String nameValue, String elementName) {
        return this.findElementByNameValue(nameValue, elementName) != null;
    }

    @Override
    public X3DConcreteNode findNodeByDEF(String DEFvalue) {
        X3DConcreteNode referenceNode;
        if (DEFvalue == null || DEFvalue.isEmpty()) {
            String errorNotice = "findNodeByDEF(\"\") cannot use empty string to find a name";
            this.validationResult.append(errorNotice).append("\n");
            throw new InvalidFieldValueException(errorNotice);
        }
        if (this.head != null && (referenceNode = ((X3DConcreteElement)this.head).findNodeByDEF(DEFvalue)) != null) {
            return referenceNode;
        }
        if (this.Scene != null && (referenceNode = ((X3DConcreteElement)this.Scene).findNodeByDEF(DEFvalue)) != null) {
            return referenceNode;
        }
        return null;
    }

    public boolean hasNodeByDEF(String DEFvalue) {
        return this.findNodeByDEF(DEFvalue) != null;
    }

    @Override
    public String validate() {
        this.validationResult = new StringBuilder();
        if (this.getProfile().isEmpty()) {
            String errorNotice = "ERROR_VALUE_NOT_FOUND, X3D profile field is required but no value found. ";
            this.validationResult.append(errorNotice).append("\n");
            throw new InvalidFieldValueException(errorNotice);
        }
        this.setProfile(this.getProfile());
        if (!this.hasHead()) {
            this.validationResult.append("ERROR_NODE_NOT_FOUND: X3D has no head element, and thus has no meta elements and is undescribed\n");
        }
        if (!this.hasScene()) {
            this.validationResult.append("ERROR_NODE_NOT_FOUND: X3D has no Scene element and thus has no model defined\n");
        }
        if (this.getVersion().isEmpty()) {
            String errorNotice = "ERROR_VALUE_NOT_FOUND, X3D version field is required but no value found. ";
            this.validationResult.append(errorNotice).append("\n");
            throw new InvalidFieldValueException(errorNotice);
        }
        this.setVersion(this.getVersion());
        if (!this.hasHead()) {
            this.validationResult.append("ERROR_NODE_NOT_FOUND: X3D has no head element, and thus has no meta elements and is undescribed\n");
        }
        if (!this.hasScene()) {
            this.validationResult.append("ERROR_NODE_NOT_FOUND: X3D has no Scene element and thus has no model defined\n");
        }
        if (this.head != null) {
            this.setHead(this.getHead());
            ((X3DConcreteElement)this.head).validate();
            this.validationResult.append(this.head.getValidationResult());
        }
        if (!this.hasHead()) {
            this.validationResult.append("ERROR_NODE_NOT_FOUND: X3D has no head element, and thus has no meta elements and is undescribed\n");
        }
        if (!this.hasScene()) {
            this.validationResult.append("ERROR_NODE_NOT_FOUND: X3D has no Scene element and thus has no model defined\n");
        }
        if (this.Scene != null) {
            this.setScene(this.getScene());
            ((X3DConcreteElement)this.Scene).validate();
            this.validationResult.append(this.Scene.getValidationResult());
        }
        if (!this.hasHead()) {
            this.validationResult.append("ERROR_NODE_NOT_FOUND: X3D has no head element, and thus has no meta elements and is undescribed\n");
        }
        if (!this.hasScene()) {
            this.validationResult.append("ERROR_NODE_NOT_FOUND: X3D has no Scene element and thus has no model defined\n");
        }
        return this.validationResult.toString();
    }

    public boolean supportsX3dVersion(String otherVersion) throws InvalidFieldValueException {
        if (otherVersion == null || otherVersion.isEmpty()) {
            otherVersion = "4.0";
            System.out.println("Warning: X3D.supportsX3dVersion{\"\") called with empty otherVersion value, substituting VERSION_DEFAULT_VALUE=4.0");
        }
        if (!(otherVersion.equals(VERSION_3_0) || otherVersion.equals(VERSION_3_1) || otherVersion.equals(VERSION_3_2) || otherVersion.equals(VERSION_3_3) || otherVersion.equals("4.0"))) {
            String errorNotice = "ERROR_ILLEGAL_VALUE illegal X3D version " + otherVersion;
            throw new InvalidFieldValueException(errorNotice);
        }
        return this.getVersion().compareTo(otherVersion) >= 0;
    }

    public boolean supportsX3dProfile(String otherProfile) throws InvalidFieldValueException {
        boolean legalProfile;
        if (otherProfile == null || otherProfile.isEmpty()) {
            otherProfile = "Immersive";
            System.out.println("Warning: X3D.supportsX3dProfile{\"\") called with empty otherProfile value, substituting PROFILE_DEFAULT_VALUE=Immersive");
        }
        boolean bl = legalProfile = this.profile.equals("Core") || this.profile.equals(PROFILE_CADINTERCHANGE) || this.profile.equals(PROFILE_FULL) || this.profile.equals("Immersive") || this.profile.equals(PROFILE_INTERACTIVE) || this.profile.equals(PROFILE_INTERCHANGE) || this.profile.equals(PROFILE_MEDICALINTERCHANGE) || this.profile.equals(PROFILE_MPEG4INTERACTIVE);
        if (!legalProfile) {
            String errorNotice = "ERROR_ILLEGAL_VALUE illegal X3D profile " + otherProfile;
            throw new InvalidFieldValueException(errorNotice);
        }
        boolean hasComponentCAD = this.head != null && this.head.hasComponent("CADGeometry");
        boolean hasComponentVolume = this.head != null && this.head.hasComponent("VolumeRendering");
        boolean hasSupportedProfile = this.profile.equals(PROFILE_FULL) || otherProfile.equals(this.profile) || otherProfile.equals("Core") || otherProfile.equals(PROFILE_INTERCHANGE) && !this.profile.equals("Core") || otherProfile.equals(PROFILE_INTERACTIVE) && this.profile.equals("Immersive") || otherProfile.equals("Immersive") && this.profile.equals("Immersive") || otherProfile.equals(PROFILE_CADINTERCHANGE) && this.profile.equals("Immersive") && hasComponentCAD || otherProfile.equals(PROFILE_MEDICALINTERCHANGE) && this.profile.equals("Immersive") && hasComponentVolume;
        return hasSupportedProfile;
    }

    public boolean supportsX3dComponent(String otherComponent, int minimumLevel) throws InvalidFieldValueException {
        if (otherComponent == null || otherComponent.isEmpty()) {
            System.out.println("Warning: X3D.supportsX3dComponent(\"\"," + minimumLevel + ") called with empty otherComponent value, nothing to do, returning false");
            return false;
        }
        if (minimumLevel < 1 || minimumLevel > 5) {
            System.out.println("Warning: X3D.supportsX3dComponent(\"" + otherComponent + "\") called with minimumLevel value outside allowed range [1..5], returning false");
            return false;
        }
        component componentTest = new component().setName(otherComponent).setLevel(minimumLevel);
        boolean hasComponentCADGEOMETRY = this.head != null && this.head.hasComponent("CADGeometry");
        boolean hasComponentCORE = this.head != null && this.head.hasComponent("Core");
        boolean hasComponentCUBEMAPTEXTURING = this.head != null && this.head.hasComponent("CubeMapTexturing");
        boolean hasComponentDIS = this.head != null && this.head.hasComponent("DIS");
        boolean hasComponentENVIRONMENTALEFFECTS = this.head != null && this.head.hasComponent("EnvironmentalEffects");
        boolean hasComponentENVIRONMENTALSENSOR = this.head != null && this.head.hasComponent("EnvironmentalSensor");
        boolean hasComponentEVENTUTILITIES = this.head != null && this.head.hasComponent("EventUtilities");
        boolean hasComponentFOLLOWERS = this.head != null && this.head.hasComponent("Followers");
        boolean hasComponentGEOMETRY2D = this.head != null && this.head.hasComponent("Geometry2D");
        boolean hasComponentGEOMETRY3D = this.head != null && this.head.hasComponent("Geometry3D");
        boolean hasComponentGEOSPATIAL = this.head != null && this.head.hasComponent("Geospatial");
        boolean hasComponentGROUPING = this.head != null && this.head.hasComponent("Grouping");
        boolean hasComponentH_ANIM = this.head != null && this.head.hasComponent("H-Anim");
        boolean hasComponentINTERPOLATION = this.head != null && this.head.hasComponent("Interpolation");
        boolean hasComponentKEYDEVICESENSOR = this.head != null && this.head.hasComponent("KeyDeviceSensor");
        boolean hasComponentLAYERING = this.head != null && this.head.hasComponent("Layering");
        boolean hasComponentLAYOUT = this.head != null && this.head.hasComponent("Layout");
        boolean hasComponentLIGHTING = this.head != null && this.head.hasComponent("Lighting");
        boolean hasComponentNAVIGATION = this.head != null && this.head.hasComponent("Navigation");
        boolean hasComponentNETWORKING = this.head != null && this.head.hasComponent("Networking");
        boolean hasComponentNURBS = this.head != null && this.head.hasComponent("NURBS");
        boolean hasComponentPARTICLESYSTEMS = this.head != null && this.head.hasComponent("ParticleSystems");
        boolean hasComponentPICKING = this.head != null && this.head.hasComponent("Picking");
        boolean hasComponentPOINTINGDEVICESENSOR = this.head != null && this.head.hasComponent("PointingDeviceSensor");
        boolean hasComponentRENDERING = this.head != null && this.head.hasComponent("Rendering");
        boolean hasComponentRIGIDBODYPHYSICS = this.head != null && this.head.hasComponent("RigidBodyPhysics");
        boolean hasComponentSCRIPTING = this.head != null && this.head.hasComponent("Scripting");
        boolean hasComponentSHADERS = this.head != null && this.head.hasComponent("Shaders");
        boolean hasComponentSHAPE = this.head != null && this.head.hasComponent("Shape");
        boolean hasComponentSOUND = this.head != null && this.head.hasComponent("Sound");
        boolean hasComponentTEXT = this.head != null && this.head.hasComponent("Text");
        boolean hasComponentTEXTURING = this.head != null && this.head.hasComponent("Texturing");
        boolean hasComponentTEXTURING3D = this.head != null && this.head.hasComponent("Texturing3D");
        boolean hasComponentTIME = this.head != null && this.head.hasComponent("Time");
        boolean hasComponentVOLUMERENDERING = this.head != null && this.head.hasComponent("VolumeRendering");
        int hasLevelCADGEOMETRY = 0;
        int hasLevelCORE = 0;
        int hasLevelCUBEMAPTEXTURING = 0;
        int hasLevelDIS = 0;
        int hasLevelENVIRONMENTALEFFECTS = 0;
        int hasLevelENVIRONMENTALSENSOR = 0;
        int hasLevelEVENTUTILITIES = 0;
        int hasLevelFOLLOWERS = 0;
        int hasLevelGEOMETRY2D = 0;
        int hasLevelGEOMETRY3D = 0;
        int hasLevelGEOSPATIAL = 0;
        int hasLevelGROUPING = 0;
        int hasLevelH_ANIM = 0;
        int hasLevelINTERPOLATION = 0;
        int hasLevelKEYDEVICESENSOR = 0;
        int hasLevelLAYERING = 0;
        int hasLevelLAYOUT = 0;
        int hasLevelLIGHTING = 0;
        int hasLevelNAVIGATION = 0;
        int hasLevelNETWORKING = 0;
        int hasLevelNURBS = 0;
        int hasLevelPARTICLESYSTEMS = 0;
        int hasLevelPICKING = 0;
        int hasLevelPOINTINGDEVICESENSOR = 0;
        int hasLevelRENDERING = 0;
        int hasLevelRIGIDBODYPHYSICS = 0;
        int hasLevelSCRIPTING = 0;
        int hasLevelSHADERS = 0;
        int hasLevelSHAPE = 0;
        int hasLevelSOUND = 0;
        int hasLevelTEXT = 0;
        int hasLevelTEXTURING = 0;
        int hasLevelTEXTURING3D = 0;
        int hasLevelTIME = 0;
        int hasLevelVOLUMERENDERING = 0;
        if (this.head != null) {
            if (this.head.hasComponent("CADGeometry")) {
                hasLevelCADGEOMETRY = this.head.findComponentByName("CADGeometry").getLevel();
            }
            if (this.head.hasComponent("Core")) {
                hasLevelCORE = this.head.findComponentByName("Core").getLevel();
            }
            if (this.head.hasComponent("CubeMapTexturing")) {
                hasLevelCUBEMAPTEXTURING = this.head.findComponentByName("CubeMapTexturing").getLevel();
            }
            if (this.head.hasComponent("DIS")) {
                hasLevelDIS = this.head.findComponentByName("DIS").getLevel();
            }
            if (this.head.hasComponent("EnvironmentalEffects")) {
                hasLevelENVIRONMENTALEFFECTS = this.head.findComponentByName("EnvironmentalEffects").getLevel();
            }
            if (this.head.hasComponent("EnvironmentalSensor")) {
                hasLevelENVIRONMENTALSENSOR = this.head.findComponentByName("EnvironmentalSensor").getLevel();
            }
            if (this.head.hasComponent("EventUtilities")) {
                hasLevelEVENTUTILITIES = this.head.findComponentByName("EventUtilities").getLevel();
            }
            if (this.head.hasComponent("Followers")) {
                hasLevelFOLLOWERS = this.head.findComponentByName("Followers").getLevel();
            }
            if (this.head.hasComponent("Geometry2D")) {
                hasLevelGEOMETRY2D = this.head.findComponentByName("Geometry2D").getLevel();
            }
            if (this.head.hasComponent("Geometry3D")) {
                hasLevelGEOMETRY3D = this.head.findComponentByName("Geometry3D").getLevel();
            }
            if (this.head.hasComponent("Geospatial")) {
                hasLevelGEOSPATIAL = this.head.findComponentByName("Geospatial").getLevel();
            }
            if (this.head.hasComponent("Grouping")) {
                hasLevelGROUPING = this.head.findComponentByName("Grouping").getLevel();
            }
            if (this.head.hasComponent("H-Anim")) {
                hasLevelH_ANIM = this.head.findComponentByName("H-Anim").getLevel();
            }
            if (this.head.hasComponent("Interpolation")) {
                hasLevelINTERPOLATION = this.head.findComponentByName("Interpolation").getLevel();
            }
            if (this.head.hasComponent("KeyDeviceSensor")) {
                hasLevelKEYDEVICESENSOR = this.head.findComponentByName("KeyDeviceSensor").getLevel();
            }
            if (this.head.hasComponent("Layering")) {
                hasLevelLAYERING = this.head.findComponentByName("Layering").getLevel();
            }
            if (this.head.hasComponent("Layout")) {
                hasLevelLAYOUT = this.head.findComponentByName("Layout").getLevel();
            }
            if (this.head.hasComponent("Lighting")) {
                hasLevelLIGHTING = this.head.findComponentByName("Lighting").getLevel();
            }
            if (this.head.hasComponent("Navigation")) {
                hasLevelNAVIGATION = this.head.findComponentByName("Navigation").getLevel();
            }
            if (this.head.hasComponent("Networking")) {
                hasLevelNETWORKING = this.head.findComponentByName("Networking").getLevel();
            }
            if (this.head.hasComponent("NURBS")) {
                hasLevelNURBS = this.head.findComponentByName("NURBS").getLevel();
            }
            if (this.head.hasComponent("ParticleSystems")) {
                hasLevelPARTICLESYSTEMS = this.head.findComponentByName("ParticleSystems").getLevel();
            }
            if (this.head.hasComponent("Picking")) {
                hasLevelPICKING = this.head.findComponentByName("Picking").getLevel();
            }
            if (this.head.hasComponent("PointingDeviceSensor")) {
                hasLevelPOINTINGDEVICESENSOR = this.head.findComponentByName("PointingDeviceSensor").getLevel();
            }
            if (this.head.hasComponent("Rendering")) {
                hasLevelRENDERING = this.head.findComponentByName("Rendering").getLevel();
            }
            if (this.head.hasComponent("RigidBodyPhysics")) {
                hasLevelRIGIDBODYPHYSICS = this.head.findComponentByName("RigidBodyPhysics").getLevel();
            }
            if (this.head.hasComponent("Scripting")) {
                hasLevelSCRIPTING = this.head.findComponentByName("Scripting").getLevel();
            }
            if (this.head.hasComponent("Shaders")) {
                hasLevelSHADERS = this.head.findComponentByName("Shaders").getLevel();
            }
            if (this.head.hasComponent("Shape")) {
                hasLevelSHAPE = this.head.findComponentByName("Shape").getLevel();
            }
            if (this.head.hasComponent("Sound")) {
                hasLevelSOUND = this.head.findComponentByName("Sound").getLevel();
            }
            if (this.head.hasComponent("Text")) {
                hasLevelTEXT = this.head.findComponentByName("Text").getLevel();
            }
            if (this.head.hasComponent("Texturing")) {
                hasLevelTEXTURING = this.head.findComponentByName("Texturing").getLevel();
            }
            if (this.head.hasComponent("Texturing3D")) {
                hasLevelTEXTURING3D = this.head.findComponentByName("Texturing3D").getLevel();
            }
            if (this.head.hasComponent("Time")) {
                hasLevelTIME = this.head.findComponentByName("Time").getLevel();
            }
            if (this.head.hasComponent("VolumeRendering")) {
                hasLevelVOLUMERENDERING = this.head.findComponentByName("VolumeRendering").getLevel();
            }
        }
        if (this.profile.equals("Core")) {
            hasComponentCORE = true;
            hasLevelCORE = Integer.max(hasLevelCORE, 1);
        } else if (this.profile.equals(PROFILE_INTERCHANGE)) {
            hasComponentCORE = true;
            hasLevelCORE = Integer.max(hasLevelCORE, 1);
            hasComponentTIME = true;
            hasLevelTIME = Integer.max(hasLevelTIME, 1);
            hasComponentNETWORKING = true;
            hasLevelNETWORKING = Integer.max(hasLevelNETWORKING, 1);
            hasComponentGROUPING = true;
            hasLevelGROUPING = Integer.max(hasLevelGROUPING, 1);
            hasComponentRENDERING = true;
            hasLevelRENDERING = Integer.max(hasLevelRENDERING, 3);
            hasComponentSHAPE = true;
            hasLevelSHAPE = Integer.max(hasLevelSHAPE, 1);
            hasComponentGEOMETRY3D = true;
            hasLevelGEOMETRY3D = Integer.max(hasLevelGEOMETRY3D, 2);
            hasComponentLIGHTING = true;
            hasLevelLIGHTING = Integer.max(hasLevelLIGHTING, 1);
            hasComponentTEXTURING = true;
            hasLevelTEXTURING = Integer.max(hasLevelTEXTURING, 2);
            hasComponentINTERPOLATION = true;
            hasLevelINTERPOLATION = Integer.max(hasLevelINTERPOLATION, 2);
            hasComponentNAVIGATION = true;
            hasLevelNAVIGATION = Integer.max(hasLevelNAVIGATION, 1);
            hasComponentENVIRONMENTALEFFECTS = true;
            hasLevelENVIRONMENTALEFFECTS = Integer.max(hasLevelENVIRONMENTALEFFECTS, 1);
        } else if (this.profile.equals(PROFILE_INTERACTIVE)) {
            hasComponentCORE = true;
            hasLevelCORE = Integer.max(hasLevelCORE, 1);
            hasComponentTIME = true;
            hasLevelTIME = Integer.max(hasLevelTIME, 1);
            hasComponentNETWORKING = true;
            hasLevelNETWORKING = Integer.max(hasLevelNETWORKING, 2);
            hasComponentGROUPING = true;
            hasLevelGROUPING = Integer.max(hasLevelGROUPING, 2);
            hasComponentRENDERING = true;
            hasLevelRENDERING = Integer.max(hasLevelRENDERING, 3);
            hasComponentSHAPE = true;
            hasLevelSHAPE = Integer.max(hasLevelSHAPE, 1);
            hasComponentGEOMETRY3D = true;
            hasLevelGEOMETRY3D = Integer.max(hasLevelGEOMETRY3D, 3);
            hasComponentLIGHTING = true;
            hasLevelLIGHTING = Integer.max(hasLevelLIGHTING, 2);
            hasComponentTEXTURING = true;
            hasLevelTEXTURING = Integer.max(hasLevelTEXTURING, 2);
            hasComponentINTERPOLATION = true;
            hasLevelINTERPOLATION = Integer.max(hasLevelINTERPOLATION, 2);
            hasComponentPOINTINGDEVICESENSOR = true;
            hasLevelPOINTINGDEVICESENSOR = Integer.max(hasLevelPOINTINGDEVICESENSOR, 2);
            hasComponentKEYDEVICESENSOR = true;
            hasLevelKEYDEVICESENSOR = Integer.max(hasLevelKEYDEVICESENSOR, 1);
            hasComponentENVIRONMENTALSENSOR = true;
            hasLevelENVIRONMENTALSENSOR = Integer.max(hasLevelENVIRONMENTALSENSOR, 1);
            hasComponentNAVIGATION = true;
            hasLevelNAVIGATION = Integer.max(hasLevelNAVIGATION, 1);
            hasComponentENVIRONMENTALEFFECTS = true;
            hasLevelENVIRONMENTALEFFECTS = Integer.max(hasLevelENVIRONMENTALEFFECTS, 1);
            hasComponentEVENTUTILITIES = true;
            hasLevelEVENTUTILITIES = Integer.max(hasLevelEVENTUTILITIES, 1);
        } else if (this.profile.equals("Immersive")) {
            hasComponentCORE = true;
            hasLevelCORE = Integer.max(hasLevelCORE, 2);
            hasComponentTIME = true;
            hasLevelTIME = Integer.max(hasLevelTIME, 1);
            hasComponentNETWORKING = true;
            hasLevelNETWORKING = Integer.max(hasLevelNETWORKING, 3);
            hasComponentGROUPING = true;
            hasLevelGROUPING = Integer.max(hasLevelGROUPING, 2);
            hasComponentRENDERING = true;
            hasLevelRENDERING = Integer.max(hasLevelRENDERING, 3);
            hasComponentSHAPE = true;
            hasLevelSHAPE = Integer.max(hasLevelSHAPE, 2);
            hasComponentGEOMETRY3D = true;
            hasLevelGEOMETRY3D = Integer.max(hasLevelGEOMETRY3D, 4);
            hasComponentGEOMETRY2D = true;
            hasLevelGEOMETRY2D = Integer.max(hasLevelGEOMETRY2D, 1);
            hasComponentTEXT = true;
            hasLevelTEXT = Integer.max(hasLevelTEXT, 1);
            hasComponentSOUND = true;
            hasLevelSOUND = Integer.max(hasLevelSOUND, 1);
            hasComponentLIGHTING = true;
            hasLevelLIGHTING = Integer.max(hasLevelLIGHTING, 2);
            hasComponentTEXTURING = true;
            hasLevelTEXTURING = Integer.max(hasLevelTEXTURING, 3);
            hasComponentINTERPOLATION = true;
            hasLevelINTERPOLATION = Integer.max(hasLevelINTERPOLATION, 2);
            hasComponentPOINTINGDEVICESENSOR = true;
            hasLevelPOINTINGDEVICESENSOR = Integer.max(hasLevelPOINTINGDEVICESENSOR, 1);
            hasComponentKEYDEVICESENSOR = true;
            hasLevelKEYDEVICESENSOR = Integer.max(hasLevelKEYDEVICESENSOR, 2);
            hasComponentENVIRONMENTALSENSOR = true;
            hasLevelENVIRONMENTALSENSOR = Integer.max(hasLevelENVIRONMENTALSENSOR, 2);
            hasComponentNAVIGATION = true;
            hasLevelNAVIGATION = Integer.max(hasLevelNAVIGATION, 2);
            hasComponentENVIRONMENTALEFFECTS = true;
            hasLevelENVIRONMENTALEFFECTS = Integer.max(hasLevelENVIRONMENTALEFFECTS, 2);
            hasComponentSCRIPTING = true;
            hasLevelSCRIPTING = Integer.max(hasLevelSCRIPTING, 1);
            hasComponentEVENTUTILITIES = true;
            hasLevelEVENTUTILITIES = Integer.max(hasLevelEVENTUTILITIES, 1);
        } else if (this.profile.equals(PROFILE_CADINTERCHANGE)) {
            hasComponentCORE = true;
            hasLevelCORE = Integer.max(hasLevelCORE, 1);
            hasComponentNETWORKING = true;
            hasLevelNETWORKING = Integer.max(hasLevelNETWORKING, 2);
            hasComponentGROUPING = true;
            hasLevelGROUPING = Integer.max(hasLevelGROUPING, 1);
            hasComponentRENDERING = true;
            hasLevelRENDERING = Integer.max(hasLevelRENDERING, 4);
            hasComponentSHAPE = true;
            hasLevelSHAPE = Integer.max(hasLevelSHAPE, 2);
            hasComponentLIGHTING = true;
            hasLevelLIGHTING = Integer.max(hasLevelLIGHTING, 1);
            hasComponentTEXTURING = true;
            hasLevelTEXTURING = Integer.max(hasLevelTEXTURING, 2);
            hasComponentNAVIGATION = true;
            hasLevelNAVIGATION = Integer.max(hasLevelNAVIGATION, 2);
            hasComponentSHADERS = true;
            hasLevelSHADERS = Integer.max(hasLevelSHADERS, 1);
            hasComponentCADGEOMETRY = true;
            hasLevelCADGEOMETRY = Integer.max(hasLevelCADGEOMETRY, 1);
        } else if (this.profile.equals(PROFILE_MEDICALINTERCHANGE)) {
            hasComponentCORE = true;
            hasLevelCORE = Integer.max(hasLevelCORE, 1);
            hasComponentTIME = true;
            hasLevelTIME = Integer.max(hasLevelTIME, 1);
            hasComponentNETWORKING = true;
            hasLevelNETWORKING = Integer.max(hasLevelNETWORKING, 2);
            hasComponentGROUPING = true;
            hasLevelGROUPING = Integer.max(hasLevelGROUPING, 3);
            hasComponentRENDERING = true;
            hasLevelRENDERING = Integer.max(hasLevelRENDERING, 5);
            hasComponentSHAPE = true;
            hasLevelSHAPE = Integer.max(hasLevelSHAPE, 3);
            hasComponentGEOMETRY3D = true;
            hasLevelGEOMETRY3D = Integer.max(hasLevelGEOMETRY3D, 2);
            hasComponentGEOMETRY2D = true;
            hasLevelGEOMETRY2D = Integer.max(hasLevelGEOMETRY2D, 2);
            hasComponentTEXT = true;
            hasLevelTEXT = Integer.max(hasLevelTEXT, 1);
            hasComponentLIGHTING = true;
            hasLevelLIGHTING = Integer.max(hasLevelLIGHTING, 2);
            hasComponentTEXTURING = true;
            hasLevelTEXTURING = Integer.max(hasLevelTEXTURING, 2);
            hasComponentNAVIGATION = true;
            hasLevelNAVIGATION = Integer.max(hasLevelNAVIGATION, 3);
            hasComponentENVIRONMENTALEFFECTS = true;
            hasLevelENVIRONMENTALEFFECTS = Integer.max(hasLevelENVIRONMENTALEFFECTS, 1);
            hasComponentEVENTUTILITIES = true;
            hasLevelEVENTUTILITIES = Integer.max(hasLevelEVENTUTILITIES, 1);
            hasComponentTEXTURING3D = true;
            hasLevelTEXTURING3D = Integer.max(hasLevelTEXTURING3D, 2);
            hasComponentVOLUMERENDERING = true;
            hasLevelVOLUMERENDERING = Integer.max(hasLevelVOLUMERENDERING, 4);
        } else if (this.profile.equals(PROFILE_MPEG4INTERACTIVE)) {
            hasComponentCORE = true;
            hasLevelCORE = Integer.max(hasLevelCORE, 1);
            hasComponentTIME = true;
            hasLevelTIME = Integer.max(hasLevelTIME, 1);
            hasComponentNETWORKING = true;
            hasLevelNETWORKING = Integer.max(hasLevelNETWORKING, 2);
            hasComponentGROUPING = true;
            hasLevelGROUPING = Integer.max(hasLevelGROUPING, 2);
            hasComponentRENDERING = true;
            hasLevelRENDERING = Integer.max(hasLevelRENDERING, 1);
            hasComponentSHAPE = true;
            hasLevelSHAPE = Integer.max(hasLevelSHAPE, 1);
            hasComponentGEOMETRY3D = true;
            hasLevelGEOMETRY3D = Integer.max(hasLevelGEOMETRY3D, 2);
            hasComponentLIGHTING = true;
            hasLevelLIGHTING = Integer.max(hasLevelLIGHTING, 1);
            hasComponentTEXTURING = true;
            hasLevelTEXTURING = Integer.max(hasLevelTEXTURING, 2);
            hasComponentINTERPOLATION = true;
            hasLevelINTERPOLATION = Integer.max(hasLevelINTERPOLATION, 1);
            hasComponentPOINTINGDEVICESENSOR = true;
            hasLevelPOINTINGDEVICESENSOR = Integer.max(hasLevelPOINTINGDEVICESENSOR, 1);
            hasComponentENVIRONMENTALSENSOR = true;
            hasLevelENVIRONMENTALSENSOR = Integer.max(hasLevelENVIRONMENTALSENSOR, 1);
            hasComponentNAVIGATION = true;
            hasLevelNAVIGATION = Integer.max(hasLevelNAVIGATION, 1);
            hasComponentENVIRONMENTALEFFECTS = true;
            hasLevelENVIRONMENTALEFFECTS = Integer.max(hasLevelENVIRONMENTALEFFECTS, 1);
        }
        boolean hasSupport = this.profile.equals(PROFILE_FULL) || otherComponent.equals("Core") && hasComponentCORE && minimumLevel <= hasLevelCORE || otherComponent.equals("CADGeometry") && hasComponentCADGEOMETRY && minimumLevel <= hasLevelCADGEOMETRY || otherComponent.equals("CubeMapTexturing") && hasComponentCUBEMAPTEXTURING && minimumLevel <= hasLevelCUBEMAPTEXTURING || otherComponent.equals("DIS") && hasComponentDIS && minimumLevel <= hasLevelDIS || otherComponent.equals("EnvironmentalEffects") && hasComponentENVIRONMENTALEFFECTS && minimumLevel <= hasLevelENVIRONMENTALEFFECTS || otherComponent.equals("EnvironmentalSensor") && hasComponentENVIRONMENTALSENSOR && minimumLevel <= hasLevelENVIRONMENTALSENSOR || otherComponent.equals("EventUtilities") && hasComponentEVENTUTILITIES && minimumLevel <= hasLevelEVENTUTILITIES || otherComponent.equals("Followers") && hasComponentFOLLOWERS && minimumLevel <= hasLevelFOLLOWERS || otherComponent.equals("Geometry2D") && hasComponentGEOMETRY2D && minimumLevel <= hasLevelGEOMETRY2D || otherComponent.equals("Geometry3D") && hasComponentGEOMETRY3D && minimumLevel <= hasLevelGEOMETRY3D || otherComponent.equals("Geospatial") && hasComponentGEOSPATIAL && minimumLevel <= hasLevelGEOSPATIAL || otherComponent.equals("Grouping") && hasComponentGROUPING && minimumLevel <= hasLevelGROUPING || otherComponent.equals("H-Anim") && hasComponentH_ANIM && minimumLevel <= hasLevelH_ANIM || otherComponent.equals("Interpolation") && hasComponentINTERPOLATION && minimumLevel <= hasLevelINTERPOLATION || otherComponent.equals("KeyDeviceSensor") && hasComponentKEYDEVICESENSOR && minimumLevel <= hasLevelKEYDEVICESENSOR || otherComponent.equals("Layering") && hasComponentLAYERING && minimumLevel <= hasLevelLAYERING || otherComponent.equals("Layout") && hasComponentLAYOUT && minimumLevel <= hasLevelLAYOUT || otherComponent.equals("Interpolation") && hasComponentINTERPOLATION && minimumLevel <= hasLevelINTERPOLATION || otherComponent.equals("Lighting") && hasComponentLIGHTING && minimumLevel <= hasLevelLIGHTING || otherComponent.equals("Navigation") && hasComponentNAVIGATION && minimumLevel <= hasLevelNAVIGATION || otherComponent.equals("Networking") && hasComponentNETWORKING && minimumLevel <= hasLevelNETWORKING || otherComponent.equals("NURBS") && hasComponentNURBS && minimumLevel <= hasLevelNURBS || otherComponent.equals("ParticleSystems") && hasComponentPARTICLESYSTEMS && minimumLevel <= hasLevelPARTICLESYSTEMS || otherComponent.equals("Picking") && hasComponentPICKING && minimumLevel <= hasLevelPICKING || otherComponent.equals("PointingDeviceSensor") && hasComponentPOINTINGDEVICESENSOR && minimumLevel <= hasLevelPOINTINGDEVICESENSOR || otherComponent.equals("Rendering") && hasComponentRENDERING && minimumLevel <= hasLevelRENDERING || otherComponent.equals("RigidBodyPhysics") && hasComponentRIGIDBODYPHYSICS && minimumLevel <= hasLevelRIGIDBODYPHYSICS || otherComponent.equals("Scripting") && hasComponentSCRIPTING && minimumLevel <= hasLevelSCRIPTING || otherComponent.equals("Shaders") && hasComponentSHADERS && minimumLevel <= hasLevelSHADERS || otherComponent.equals("Shape") && hasComponentSHAPE && minimumLevel <= hasLevelSHAPE || otherComponent.equals("Sound") && hasComponentSOUND && minimumLevel <= hasLevelSOUND || otherComponent.equals("Text") && hasComponentTEXT && minimumLevel <= hasLevelTEXT || otherComponent.equals("Texturing") && hasComponentTEXTURING && minimumLevel <= hasLevelTEXTURING || otherComponent.equals("Texturing3D") && hasComponentTEXTURING3D && minimumLevel <= hasLevelTEXTURING3D || otherComponent.equals("Time") && hasComponentTIME && minimumLevel <= hasLevelTIME || otherComponent.equals("VolumeRendering") && hasComponentVOLUMERENDERING && minimumLevel <= hasLevelVOLUMERENDERING;
        return hasSupport;
    }
}

