/*
 * Decompiled with CFR 0.152.
 */
package org.web3d.x3d.jsail.Core;

import java.util.ArrayList;
import java.util.Arrays;
import org.web3d.x3d.jsail.ConfigurationProperties;
import org.web3d.x3d.jsail.Core.CommentsBlock;
import org.web3d.x3d.jsail.X3DConcreteElement;
import org.web3d.x3d.jsail.X3DConcreteNode;
import org.web3d.x3d.jsail.X3DConcreteStatement;
import org.web3d.x3d.jsail.fields.MFString;
import org.web3d.x3d.jsail.fields.SFInt32;
import org.web3d.x3d.jsail.fields.SFString;
import org.web3d.x3d.sai.InvalidFieldValueException;

public class component
extends X3DConcreteStatement {
    private ArrayList<String> commentsList;
    private int level;
    private String name;
    public static final String NAME_CORE = "Core";
    public static final String NAME_CADGEOMETRY = "CADGeometry";
    public static final String NAME_CUBEMAPTEXTURING = "CubeMapTexturing";
    public static final String NAME_DIS = "DIS";
    public static final String NAME_ENVIRONMENTALEFFECTS = "EnvironmentalEffects";
    public static final String NAME_ENVIRONMENTALSENSOR = "EnvironmentalSensor";
    public static final String NAME_EVENTUTILITIES = "EventUtilities";
    public static final String NAME_FOLLOWERS = "Followers";
    public static final String NAME_GEOMETRY2D = "Geometry2D";
    public static final String NAME_GEOMETRY3D = "Geometry3D";
    public static final String NAME_GEOSPATIAL = "Geospatial";
    public static final String NAME_GROUPING = "Grouping";
    public static final String NAME_HANIM = "HAnim";
    public static final String NAME_H_ANIM = "H-Anim";
    public static final String NAME_INTERPOLATION = "Interpolation";
    public static final String NAME_KEYDEVICESENSOR = "KeyDeviceSensor";
    public static final String NAME_LAYERING = "Layering";
    public static final String NAME_LAYOUT = "Layout";
    public static final String NAME_LIGHTING = "Lighting";
    public static final String NAME_NAVIGATION = "Navigation";
    public static final String NAME_NETWORKING = "Networking";
    public static final String NAME_NURBS = "NURBS";
    public static final String NAME_PARTICLESYSTEMS = "ParticleSystems";
    public static final String NAME_PICKING = "Picking";
    public static final String NAME_POINTINGDEVICESENSOR = "PointingDeviceSensor";
    public static final String NAME_RENDERING = "Rendering";
    public static final String NAME_RIGIDBODYPHYSICS = "RigidBodyPhysics";
    public static final String NAME_SCRIPTING = "Scripting";
    public static final String NAME_SHADERS = "Shaders";
    public static final String NAME_SHAPE = "Shape";
    public static final String NAME_SOUND = "Sound";
    public static final String NAME_TEXT = "Text";
    public static final String NAME_TEXTURING = "Texturing";
    public static final String NAME_TEXTURING3D = "Texturing3D";
    public static final String NAME_TIME = "Time";
    public static final String NAME_VOLUMERENDERING = "VolumeRendering";
    public static final String NAME = "component";
    public static final String COMPONENT = "Core";
    public static final int LEVEL = 1;
    public static final int LEVEL_DEFAULT_VALUE = 1;
    public static final String NAME_DEFAULT_VALUE = "";

    @Override
    public final String getElementName() {
        return NAME;
    }

    @Override
    public final String getComponent() {
        return "Core";
    }

    @Override
    public final int getComponentLevel() {
        return 1;
    }

    @Override
    public String getFieldType(String fieldName) {
        String result;
        switch (fieldName) {
            case "containerField": {
                result = "SFString";
                break;
            }
            case "level": {
                result = "SFInt32";
                break;
            }
            case "name": {
                result = "SFString";
                break;
            }
            default: {
                result = fieldName.trim().startsWith("set_") ? this.getFieldType(fieldName.trim().substring(4)) : (fieldName.trim().endsWith("_changed") ? this.getFieldType(fieldName.trim().substring(0, fieldName.length() - 8)) : "ERROR_UNKNOWN_FIELD_TYPE");
            }
        }
        return result;
    }

    @Override
    public String getAccessType(String fieldName) {
        String result;
        switch (fieldName) {
            case "level": {
                result = "inputOutput";
                break;
            }
            case "name": {
                result = "inputOutput";
                break;
            }
            default: {
                result = fieldName.trim().startsWith("set_") ? this.getAccessType(fieldName.trim().substring(4)) : (fieldName.trim().endsWith("_changed") ? this.getAccessType(fieldName.trim().substring(0, fieldName.length() - 8)) : "ERROR_UNKNOWN_FIELD_ACCESSTYPE");
            }
        }
        return result;
    }

    public component() {
        this.initialize();
    }

    @Override
    public final void initialize() {
        super.initialize();
        this.level = 1;
        this.name = NAME_DEFAULT_VALUE;
        this.commentsList = new ArrayList();
    }

    public int getLevel() {
        return this.level;
    }

    public component setLevel(int newValue) {
        if (newValue < 1) {
            throw new InvalidFieldValueException("component level newValue=" + newValue + " has component value less than restriction minInclusive=1");
        }
        if (newValue > 5) {
            throw new InvalidFieldValueException("component level newValue=" + SFInt32.toString(newValue) + " has component value greater than restriction maxInclusive=5");
        }
        this.level = newValue;
        return this;
    }

    public component setLevel(SFInt32 newValue) {
        this.setLevel(newValue.getPrimitiveValue());
        return this;
    }

    public String getName() {
        return this.name;
    }

    public final component setName(String newValue) {
        if (newValue == null) {
            newValue = new String();
        }
        if (!((newValue = MFString.cleanupUnescapedEnclosingQuotes(newValue)).isEmpty() || newValue.equals("Core") || newValue.equals(NAME_CADGEOMETRY) || newValue.equals(NAME_CUBEMAPTEXTURING) || newValue.equals(NAME_DIS) || newValue.equals(NAME_ENVIRONMENTALEFFECTS) || newValue.equals(NAME_ENVIRONMENTALSENSOR) || newValue.equals(NAME_EVENTUTILITIES) || newValue.equals(NAME_FOLLOWERS) || newValue.equals(NAME_GEOMETRY2D) || newValue.equals(NAME_GEOMETRY3D) || newValue.equals(NAME_GEOSPATIAL) || newValue.equals(NAME_GROUPING) || newValue.equals(NAME_HANIM) || newValue.equals(NAME_H_ANIM) || newValue.equals(NAME_INTERPOLATION) || newValue.equals(NAME_KEYDEVICESENSOR) || newValue.equals(NAME_LAYERING) || newValue.equals(NAME_LAYOUT) || newValue.equals(NAME_LIGHTING) || newValue.equals(NAME_NAVIGATION) || newValue.equals(NAME_NETWORKING) || newValue.equals(NAME_NURBS) || newValue.equals(NAME_PARTICLESYSTEMS) || newValue.equals(NAME_PICKING) || newValue.equals(NAME_POINTINGDEVICESENSOR) || newValue.equals(NAME_RENDERING) || newValue.equals(NAME_RIGIDBODYPHYSICS) || newValue.equals(NAME_SCRIPTING) || newValue.equals(NAME_SHADERS) || newValue.equals(NAME_SHAPE) || newValue.equals(NAME_SOUND) || newValue.equals(NAME_TEXT) || newValue.equals(NAME_TEXTURING) || newValue.equals(NAME_TEXTURING3D) || newValue.equals(NAME_TIME) || newValue.equals(NAME_VOLUMERENDERING))) {
            String warningMessage = "Warning: component name newValue=\"" + newValue + "\" has an unrecognized value not matching any of the required enumeration string tokens.";
            System.out.println(warningMessage);
            if (!newValue.isEmpty()) {
                throw new InvalidFieldValueException(warningMessage);
            }
        }
        if (newValue == null) {
            newValue = new String();
        }
        if (!SFString.isNMTOKEN(newValue)) {
            throw new InvalidFieldValueException("component name newValue='" + newValue + "' has illegal name value, cannot be empty and must be defined with valid NMTOKEN name string (with legal characters and no embedded whitespace).");
        }
        if (!newValue.equals(NAME_H_ANIM) && !SFString.meetsX3dInteroperabilityNamingConventions(newValue)) {
            System.out.println("component name newValue='" + newValue + "' has name value that does not meet X3D naming conventions.");
        }
        this.name = newValue;
        return this;
    }

    public component setName(SFString newValue) {
        this.setName(newValue.getPrimitiveValue());
        return this;
    }

    public component(String newName, int newLevel) {
        this.initialize();
        this.setName(newName);
        this.setLevel(newLevel);
    }

    @Override
    public component addComments(String newComment) {
        this.commentsList.add(newComment);
        return this;
    }

    @Override
    public component addComments(String[] newComments) {
        this.commentsList.addAll(Arrays.asList(newComments));
        return this;
    }

    @Override
    public component addComments(CommentsBlock newCommentsBlock) {
        this.commentsList.addAll(newCommentsBlock.toStringList());
        return this;
    }

    @Override
    public String toStringX3D(int indentLevel) {
        boolean hasAttributes = true;
        boolean hasChild = !this.commentsList.isEmpty();
        StringBuilder indent = new StringBuilder();
        int indentIncrement = ConfigurationProperties.getIndentIncrement();
        char indentCharacter = ConfigurationProperties.getIndentCharacter();
        for (int i = 0; i < indentLevel; ++i) {
            indent.append(indentCharacter);
        }
        StringBuilder stringX3D = new StringBuilder();
        stringX3D.append((CharSequence)indent).append("<component");
        if (hasAttributes) {
            if (!this.getName().equals(NAME_DEFAULT_VALUE)) {
                stringX3D.append(" name='").append(SFString.toString(this.getName())).append("'");
            }
            stringX3D.append(" level='").append(SFInt32.toString(this.getLevel())).append("'");
        }
        if (hasChild) {
            stringX3D.append(">").append("\n");
            if (!this.commentsList.isEmpty()) {
                CommentsBlock commentsBlock = new CommentsBlock(this.commentsList);
                stringX3D.append(commentsBlock.toStringX3D(indentLevel + indentIncrement));
            }
            stringX3D.append((CharSequence)indent).append("</component>").append("\n");
        } else {
            stringX3D.append("/>").append("\n");
        }
        return stringX3D.toString();
    }

    @Override
    public String toStringClassicVRML(int indentLevel) {
        StringBuilder stringClassicVRML = new StringBuilder();
        boolean hasAttributes = true;
        boolean hasChild = !this.commentsList.isEmpty();
        StringBuilder indent = new StringBuilder();
        char indentCharacter = ConfigurationProperties.getIndentCharacter();
        int indentIncrement = ConfigurationProperties.getIndentIncrement();
        for (int i = 0; i < indentLevel; ++i) {
            indent.append(indentCharacter);
        }
        stringClassicVRML.append("COMPONENT ").append(this.name).append(":").append(this.getLevel()).append("\n");
        return stringClassicVRML.toString();
    }

    @Override
    public String toStringVRML97(int indentLevel) {
        return this.toStringClassicVRML(indentLevel).replaceAll("COMPONENT ", "#COMPONENT ");
    }

    @Override
    public X3DConcreteElement findElementByNameValue(String nameValue) {
        return this.findElementByNameValue(nameValue, NAME_DEFAULT_VALUE);
    }

    @Override
    public X3DConcreteElement findElementByNameValue(String nameValue, String elementName) {
        if (nameValue == null || nameValue.isEmpty()) {
            String errorNotice = "findElementByNameValue(\"\", " + elementName + ") cannot use empty string to find a name attribute";
            this.validationResult.append(errorNotice).append("\n");
            throw new InvalidFieldValueException(errorNotice);
        }
        if (elementName == null) {
            elementName = NAME_DEFAULT_VALUE;
        }
        if (this.getName().equals(nameValue) && (elementName.isEmpty() || elementName.equals(this.getElementName()))) {
            return this;
        }
        return null;
    }

    public boolean hasElementByNameValue(String nameValue, String elementName) {
        return this.findElementByNameValue(nameValue, elementName) != null;
    }

    @Override
    public X3DConcreteNode findNodeByDEF(String DEFvalue) {
        if (DEFvalue == null || DEFvalue.isEmpty()) {
            String errorNotice = "findNodeByDEF(\"\") cannot use empty string to find a name";
            this.validationResult.append(errorNotice).append("\n");
            throw new InvalidFieldValueException(errorNotice);
        }
        return null;
    }

    public boolean hasNodeByDEF(String DEFvalue) {
        return this.findNodeByDEF(DEFvalue) != null;
    }

    @Override
    public String validate() {
        this.validationResult = new StringBuilder();
        this.setLevel(this.getLevel());
        if (this.getName().isEmpty()) {
            String errorNotice = "ERROR_VALUE_NOT_FOUND, component name field is required but no value found. ";
            this.validationResult.append(errorNotice).append("\n");
            throw new InvalidFieldValueException(errorNotice);
        }
        this.setName(this.getName());
        return this.validationResult.toString();
    }
}

