/*
 * Decompiled with CFR 0.152.
 */
package org.web3d.x3d.jsail.Core;

import java.util.ArrayList;
import java.util.Arrays;
import org.web3d.x3d.jsail.ConfigurationProperties;
import org.web3d.x3d.jsail.Core.CommentsBlock;
import org.web3d.x3d.jsail.X3DConcreteElement;
import org.web3d.x3d.jsail.X3DConcreteNode;
import org.web3d.x3d.jsail.X3DConcreteStatement;
import org.web3d.x3d.jsail.fields.MFString;
import org.web3d.x3d.jsail.fields.SFDouble;
import org.web3d.x3d.jsail.fields.SFString;
import org.web3d.x3d.sai.InvalidFieldValueException;

public class unit
extends X3DConcreteStatement {
    private ArrayList<String> commentsList;
    private String category;
    private double conversionFactor;
    private String name;
    public static final double CONVERSIONFACTOR_ANGLES_toRadiansFromDegrees = 0.0174532925167;
    public static final double CONVERSIONFACTOR_ANGLES_toRadiansFromFullCircle = 6.283185307179;
    public static final double CONVERSIONFACTOR_ANGLES_toRadiansFromGrads = 0.01570796326795;
    public static final double CONVERSIONFACTOR_LENGTH_toMetersFromPica = 0.0042175176;
    public static final double CONVERSIONFACTOR_LENGTH_toMetersFromInches = 0.0254;
    public static final double CONVERSIONFACTOR_LENGTH_toMetersFromFeet = 0.3048;
    public static final double CONVERSIONFACTOR_LENGTH_toMetersFromYards = 0.9144;
    public static final double CONVERSIONFACTOR_LENGTH_toMetersFromFathoms = 1.8288;
    public static final double CONVERSIONFACTOR_LENGTH_toMetersFromFurlongs = 201.1684;
    public static final double CONVERSIONFACTOR_LENGTH_toMetersFromMiles = 1609.344;
    public static final double CONVERSIONFACTOR_LENGTH_toMetersFromNauticalMiles = 1852.0;
    public static final double CONVERSIONFACTOR_LENGTH_toMetersFromMicrons = 1.0E-6;
    public static final double CONVERSIONFACTOR_LENGTH_toMetersFromMillimeters = 0.001;
    public static final double CONVERSIONFACTOR_LENGTH_toMetersFromCentimeters = 0.01;
    public static final double CONVERSIONFACTOR_LENGTH_toMetersFromKilometers = 1000.0;
    public static final double CONVERSIONFACTOR_FORCE_toNewtonsFromDynes = 1.0E-5;
    public static final double CONVERSIONFACTOR_FORCE_toNewtonsFromKilogramForce = 9.8068;
    public static final double CONVERSIONFACTOR_FORCE_toNewtonsFromPoundsForce = 4.4482;
    public static final double CONVERSIONFACTOR_FORCE_toNewtonsFromPoundal = 0.13826;
    public static final double CONVERSIONFACTOR_MASS_toKilogramsFromGrains = 6.479891E-5;
    public static final double CONVERSIONFACTOR_MASS_toKilogramsFromDrams = 0.001771845195312;
    public static final double CONVERSIONFACTOR_MASS_toKilogramsFromOunces = 0.028349523125;
    public static final double CONVERSIONFACTOR_MASS_toKilogramsFromTroyOunces = 0.0311034768;
    public static final double CONVERSIONFACTOR_MASS_toKilogramsFromPounds = 0.45359237;
    public static final double CONVERSIONFACTOR_MASS_toKilogramsFromStone = 6.35029318;
    public static final double CONVERSIONFACTOR_MASS_toKilogramsFromTons = 907.18474;
    public static final double CONVERSIONFACTOR_MASS_toKilogramsFrom = 1.0E-9;
    public static final double CONVERSIONFACTOR_MASS_toKilogramsFromMilligrams = 1.0E-6;
    public static final double CONVERSIONFACTOR_MASS_toKilogramsFromCentigrams = 1.0E-5;
    public static final double CONVERSIONFACTOR_MASS_toKilogramsFromCarats = 2.0E-4;
    public static final double CONVERSIONFACTOR_MASS_toKilogramsFromGrams = 0.001;
    public static final double CONVERSIONFACTOR_MASS_toKilogramsFromDekagrams = 0.01;
    public static final double CONVERSIONFACTOR_MASS_toKilogramsFromMetricTonnes = 1000.0;
    public static final String CATEGORY_ANGLE = "angle";
    public static final String CATEGORY_FORCE = "force";
    public static final String CATEGORY_LENGTH = "length";
    public static final String CATEGORY_MASS = "mass";
    public static final String NAME = "unit";
    public static final String COMPONENT = "Core";
    public static final int LEVEL = 1;
    public static final String CATEGORY_DEFAULT_VALUE = "";
    public static final double CONVERSIONFACTOR_DEFAULT_VALUE = 1.0;
    public static final String NAME_DEFAULT_VALUE = "";

    @Override
    public final String getElementName() {
        return NAME;
    }

    @Override
    public final String getComponent() {
        return COMPONENT;
    }

    @Override
    public final int getComponentLevel() {
        return 1;
    }

    @Override
    public String getFieldType(String fieldName) {
        String result;
        switch (fieldName) {
            case "containerField": {
                result = "SFString";
                break;
            }
            case "category": {
                result = "SFString";
                break;
            }
            case "conversionFactor": {
                result = "SFDouble";
                break;
            }
            case "name": {
                result = "SFString";
                break;
            }
            default: {
                result = fieldName.trim().startsWith("set_") ? this.getFieldType(fieldName.trim().substring(4)) : (fieldName.trim().endsWith("_changed") ? this.getFieldType(fieldName.trim().substring(0, fieldName.length() - 8)) : "ERROR_UNKNOWN_FIELD_TYPE");
            }
        }
        return result;
    }

    @Override
    public String getAccessType(String fieldName) {
        String result;
        switch (fieldName) {
            case "category": {
                result = "initializeOnly";
                break;
            }
            case "conversionFactor": {
                result = "inputOutput";
                break;
            }
            case "name": {
                result = "inputOutput";
                break;
            }
            default: {
                result = fieldName.trim().startsWith("set_") ? this.getAccessType(fieldName.trim().substring(4)) : (fieldName.trim().endsWith("_changed") ? this.getAccessType(fieldName.trim().substring(0, fieldName.length() - 8)) : "ERROR_UNKNOWN_FIELD_ACCESSTYPE");
            }
        }
        return result;
    }

    public unit() {
        this.initialize();
    }

    @Override
    public final void initialize() {
        super.initialize();
        this.category = "";
        this.conversionFactor = 1.0;
        this.name = "";
        this.commentsList = new ArrayList();
    }

    public String getCategory() {
        return this.category;
    }

    public unit setCategory(String newValue) {
        if (newValue == null) {
            newValue = new String();
        }
        if (!((newValue = MFString.cleanupUnescapedEnclosingQuotes(newValue)).isEmpty() || newValue.equals(CATEGORY_ANGLE) || newValue.equals(CATEGORY_FORCE) || newValue.equals(CATEGORY_LENGTH) || newValue.equals(CATEGORY_MASS))) {
            String warningMessage = "Warning: unit category newValue=\"" + newValue + "\" has an unrecognized value not matching any of the required enumeration string tokens.";
            System.out.println(warningMessage);
            if (!newValue.isEmpty()) {
                throw new InvalidFieldValueException(warningMessage);
            }
        }
        if (newValue == null) {
            newValue = new String();
        }
        this.category = newValue;
        return this;
    }

    public unit setCategory(SFString newValue) {
        this.setCategory(newValue.getPrimitiveValue());
        return this;
    }

    public double getConversionFactor() {
        return this.conversionFactor;
    }

    public unit setConversionFactor(double newValue) {
        if (newValue <= 0.0) {
            throw new InvalidFieldValueException("unit conversionFactor newValue=" + newValue + " has component value less than (or equal to) restriction minExclusive=0");
        }
        this.conversionFactor = newValue;
        return this;
    }

    public unit setConversionFactor(SFDouble newValue) {
        this.setConversionFactor(newValue.getPrimitiveValue());
        return this;
    }

    public String getName() {
        return this.name;
    }

    public final unit setName(String newValue) {
        if (newValue == null) {
            newValue = new String();
        }
        if (!SFString.isNMTOKEN(newValue)) {
            throw new InvalidFieldValueException("unit name newValue='" + newValue + "' has illegal name value, cannot be empty and must be defined with valid NMTOKEN name string (with legal characters and no embedded whitespace).");
        }
        if (!SFString.meetsX3dInteroperabilityNamingConventions(newValue)) {
            System.out.println("unit name newValue='" + newValue + "' has name value that does not meet X3D naming conventions.");
        }
        this.name = newValue;
        return this;
    }

    public unit setName(SFString newValue) {
        this.setName(newValue.getPrimitiveValue());
        return this;
    }

    public unit(String newName, String newCategory, float newConversionFactor) {
        this.initialize();
        this.setName(newName);
        this.setCategory(newCategory);
        this.setConversionFactor(newConversionFactor);
    }

    public unit(String newName, String newCategory, double newConversionFactor) {
        this.initialize();
        this.setName(newName);
        this.setCategory(newCategory);
        this.setConversionFactor(newConversionFactor);
    }

    @Override
    public unit addComments(String newComment) {
        this.commentsList.add(newComment);
        return this;
    }

    @Override
    public unit addComments(String[] newComments) {
        this.commentsList.addAll(Arrays.asList(newComments));
        return this;
    }

    @Override
    public unit addComments(CommentsBlock newCommentsBlock) {
        this.commentsList.addAll(newCommentsBlock.toStringList());
        return this;
    }

    @Override
    public String toStringX3D(int indentLevel) {
        boolean hasAttributes = true;
        boolean hasChild = !this.commentsList.isEmpty();
        StringBuilder indent = new StringBuilder();
        int indentIncrement = ConfigurationProperties.getIndentIncrement();
        char indentCharacter = ConfigurationProperties.getIndentCharacter();
        for (int i = 0; i < indentLevel; ++i) {
            indent.append(indentCharacter);
        }
        StringBuilder stringX3D = new StringBuilder();
        stringX3D.append((CharSequence)indent).append("<unit");
        if (hasAttributes) {
            if (!this.getName().equals("")) {
                stringX3D.append(" name='").append(SFString.toString(this.getName())).append("'");
            }
            if (!this.getCategory().equals("") || !ConfigurationProperties.getStripDefaultAttributes()) {
                stringX3D.append(" category='").append(new SFString(this.getCategory()).toStringX3D()).append("'");
            }
            stringX3D.append(" conversionFactor='").append(SFDouble.toString(this.getConversionFactor())).append("'");
        }
        if (hasChild) {
            stringX3D.append(">").append("\n");
            if (!this.commentsList.isEmpty()) {
                CommentsBlock commentsBlock = new CommentsBlock(this.commentsList);
                stringX3D.append(commentsBlock.toStringX3D(indentLevel + indentIncrement));
            }
            stringX3D.append((CharSequence)indent).append("</unit>").append("\n");
        } else {
            stringX3D.append("/>").append("\n");
        }
        return stringX3D.toString();
    }

    @Override
    public String toStringClassicVRML(int indentLevel) {
        StringBuilder stringClassicVRML = new StringBuilder();
        boolean hasAttributes = true;
        boolean hasChild = !this.commentsList.isEmpty();
        StringBuilder indent = new StringBuilder();
        char indentCharacter = ConfigurationProperties.getIndentCharacter();
        int indentIncrement = ConfigurationProperties.getIndentIncrement();
        for (int i = 0; i < indentLevel; ++i) {
            indent.append(indentCharacter);
        }
        stringClassicVRML.append("UNIT ").append(this.category).append(" ").append(this.name).append(" ").append(this.conversionFactor).append("\n");
        return stringClassicVRML.toString();
    }

    @Override
    public String toStringVRML97(int indentLevel) {
        return this.toStringClassicVRML(indentLevel);
    }

    @Override
    public X3DConcreteElement findElementByNameValue(String nameValue) {
        return this.findElementByNameValue(nameValue, "");
    }

    @Override
    public X3DConcreteElement findElementByNameValue(String nameValue, String elementName) {
        if (nameValue == null || nameValue.isEmpty()) {
            String errorNotice = "findElementByNameValue(\"\", " + elementName + ") cannot use empty string to find a name attribute";
            this.validationResult.append(errorNotice).append("\n");
            throw new InvalidFieldValueException(errorNotice);
        }
        if (elementName == null) {
            elementName = "";
        }
        if (this.getName().equals(nameValue) && (elementName.isEmpty() || elementName.equals(this.getElementName()))) {
            return this;
        }
        return null;
    }

    public boolean hasElementByNameValue(String nameValue, String elementName) {
        return this.findElementByNameValue(nameValue, elementName) != null;
    }

    @Override
    public X3DConcreteNode findNodeByDEF(String DEFvalue) {
        if (DEFvalue == null || DEFvalue.isEmpty()) {
            String errorNotice = "findNodeByDEF(\"\") cannot use empty string to find a name";
            this.validationResult.append(errorNotice).append("\n");
            throw new InvalidFieldValueException(errorNotice);
        }
        return null;
    }

    public boolean hasNodeByDEF(String DEFvalue) {
        return this.findNodeByDEF(DEFvalue) != null;
    }

    @Override
    public String validate() {
        this.validationResult = new StringBuilder();
        if (this.getCategory().isEmpty()) {
            String errorNotice = "ERROR_VALUE_NOT_FOUND, unit category field is required but no value found. ";
            this.validationResult.append(errorNotice).append("\n");
            throw new InvalidFieldValueException(errorNotice);
        }
        this.setCategory(this.getCategory());
        this.setConversionFactor(this.getConversionFactor());
        if (this.getName().isEmpty()) {
            String errorNotice = "ERROR_VALUE_NOT_FOUND, unit name field is required but no value found. ";
            this.validationResult.append(errorNotice).append("\n");
            throw new InvalidFieldValueException(errorNotice);
        }
        this.setName(this.getName());
        return this.validationResult.toString();
    }
}

