/*
 * Decompiled with CFR 0.152.
 */
package org.web3d.x3d.jsail.Geospatial;

import java.util.ArrayList;
import java.util.Arrays;
import org.web3d.x3d.jsail.ConfigurationProperties;
import org.web3d.x3d.jsail.Core.CommentsBlock;
import org.web3d.x3d.jsail.Core.IS;
import org.web3d.x3d.jsail.Core.ProtoInstance;
import org.web3d.x3d.jsail.Core.connect;
import org.web3d.x3d.jsail.X3DConcreteElement;
import org.web3d.x3d.jsail.X3DConcreteNode;
import org.web3d.x3d.jsail.fields.MFString;
import org.web3d.x3d.jsail.fields.SFBool;
import org.web3d.x3d.jsail.fields.SFString;
import org.web3d.x3d.jsail.fields.SFVec3d;
import org.web3d.x3d.jsail.fields.SFVec3f;
import org.web3d.x3d.sai.Core.X3DMetadataObject;
import org.web3d.x3d.sai.Geospatial.GeoOrigin;
import org.web3d.x3d.sai.InvalidFieldException;
import org.web3d.x3d.sai.InvalidFieldValueException;
import org.web3d.x3d.sai.InvalidProtoException;

public class GeoProximitySensor
extends X3DConcreteNode
implements org.web3d.x3d.sai.Geospatial.GeoProximitySensor {
    private ArrayList<String> commentsList;
    private double[] center;
    private float[] centerOfRotation;
    private boolean enabled;
    private double enterTime;
    private double exitTime;
    private double[] geoCenter;
    private double[] geoCoord;
    private GeoOrigin geoOrigin;
    private ProtoInstance geoOriginProtoInstance;
    private ArrayList<String> geoSystem = new ArrayList();
    private IS IS;
    private boolean isActive;
    private X3DMetadataObject metadata;
    private ProtoInstance metadataProtoInstance;
    private float[] orientation;
    private float[] position;
    private float[] size;
    public static final String NAME = "GeoProximitySensor";
    public static final String COMPONENT = "Geospatial";
    public static final int LEVEL = 2;
    public static final double[] CENTER_DEFAULT_VALUE = new double[]{0.0, 0.0, 0.0};
    public static final boolean ENABLED_DEFAULT_VALUE = true;
    public static final double[] GEOCENTER_DEFAULT_VALUE = new double[]{0.0, 0.0, 0.0};
    public static final GeoOrigin GEOORIGIN_DEFAULT_VALUE = null;
    public static final ArrayList<String> GEOSYSTEM_DEFAULT_VALUE = new ArrayList<String>(Arrays.asList("GD", "WE"));
    public static final IS IS_DEFAULT_VALUE = null;
    public static final X3DMetadataObject METADATA_DEFAULT_VALUE = null;
    public static final float[] SIZE_DEFAULT_VALUE = new float[]{0.0f, 0.0f, 0.0f};
    public static final String containerField_DEFAULT_VALUE = "children";
    public static final String fromField_CENTER = "center";
    public static final String toField_CENTER = "center";
    public static final String fromField_CENTEROFROTATION_CHANGED = "centerOfRotation_changed";
    public static final String fromField_ENABLED = "enabled";
    public static final String toField_ENABLED = "enabled";
    public static final String fromField_ENTERTIME = "enterTime";
    public static final String fromField_EXITTIME = "exitTime";
    public static final String fromField_GEOCENTER = "geoCenter";
    public static final String toField_GEOCENTER = "geoCenter";
    public static final String fromField_GEOCOORD_CHANGED = "geoCoord_changed";
    public static final String fromField_IS = "IS";
    public static final String fromField_ISACTIVE = "isActive";
    public static final String fromField_METADATA = "metadata";
    public static final String toField_METADATA = "metadata";
    public static final String fromField_ORIENTATION_CHANGED = "orientation_changed";
    public static final String fromField_POSITION_CHANGED = "position_changed";

    @Override
    public final String getElementName() {
        return NAME;
    }

    @Override
    public final String getComponent() {
        return COMPONENT;
    }

    @Override
    public final int getComponentLevel() {
        return 2;
    }

    @Override
    public String getFieldType(String fieldName) {
        String result;
        switch (fieldName) {
            case "containerField": {
                result = "SFString";
                break;
            }
            case "center": {
                result = "SFVec3d";
                break;
            }
            case "centerOfRotation": {
                result = "SFVec3f";
                break;
            }
            case "enabled": {
                result = "SFBool";
                break;
            }
            case "enterTime": {
                result = "SFTime";
                break;
            }
            case "exitTime": {
                result = "SFTime";
                break;
            }
            case "geoCenter": {
                result = "SFVec3d";
                break;
            }
            case "geoCoord": {
                result = "SFVec3d";
                break;
            }
            case "geoOrigin": {
                result = "SFNode";
                break;
            }
            case "geoSystem": {
                result = "MFString";
                break;
            }
            case "IS": {
                result = "SFNode";
                break;
            }
            case "isActive": {
                result = "SFBool";
                break;
            }
            case "metadata": {
                result = "SFNode";
                break;
            }
            case "orientation": {
                result = "SFRotation";
                break;
            }
            case "position": {
                result = "SFVec3f";
                break;
            }
            case "size": {
                result = "SFVec3f";
                break;
            }
            case "DEF": {
                result = "SFString";
                break;
            }
            case "USE": {
                result = "SFString";
                break;
            }
            case "class": {
                result = "SFString";
                break;
            }
            default: {
                result = fieldName.trim().startsWith("set_") ? this.getFieldType(fieldName.trim().substring(4)) : (fieldName.trim().endsWith("_changed") ? this.getFieldType(fieldName.trim().substring(0, fieldName.length() - 8)) : "ERROR_UNKNOWN_FIELD_TYPE");
            }
        }
        return result;
    }

    @Override
    public String getAccessType(String fieldName) {
        String result;
        switch (fieldName) {
            case "center": {
                result = "inputOutput";
                break;
            }
            case "centerOfRotation_changed": {
                result = "outputOnly";
                break;
            }
            case "enabled": {
                result = "inputOutput";
                break;
            }
            case "enterTime": {
                result = "outputOnly";
                break;
            }
            case "exitTime": {
                result = "outputOnly";
                break;
            }
            case "geoCenter": {
                result = "inputOutput";
                break;
            }
            case "geoCoord_changed": {
                result = "outputOnly";
                break;
            }
            case "geoOrigin": {
                result = "initializeOnly";
                break;
            }
            case "geoSystem": {
                result = "initializeOnly";
                break;
            }
            case "IS": {
                result = "inputOutput";
                break;
            }
            case "isActive": {
                result = "outputOnly";
                break;
            }
            case "metadata": {
                result = "inputOutput";
                break;
            }
            case "orientation_changed": {
                result = "outputOnly";
                break;
            }
            case "position_changed": {
                result = "outputOnly";
                break;
            }
            case "size": {
                result = "initializeOnly";
                break;
            }
            case "DEF": {
                result = "inputOutput";
                break;
            }
            case "USE": {
                result = "inputOutput";
                break;
            }
            case "class": {
                result = "inputOutput";
                break;
            }
            default: {
                result = fieldName.trim().startsWith("set_") ? this.getAccessType(fieldName.trim().substring(4)) : (fieldName.trim().endsWith("_changed") ? this.getAccessType(fieldName.trim().substring(0, fieldName.length() - 8)) : "ERROR_UNKNOWN_FIELD_ACCESSTYPE");
            }
        }
        return result;
    }

    @Override
    public final String getContainerFieldDefault() {
        return containerField_DEFAULT_VALUE;
    }

    public GeoProximitySensor() {
        this.initialize();
    }

    @Override
    public final void initialize() {
        super.initialize();
        this.setContainerFieldOverride("");
        this.containerField_ALTERNATE_VALUES = new String[]{containerField_DEFAULT_VALUE};
        this.center = CENTER_DEFAULT_VALUE;
        this.enabled = true;
        this.geoCenter = GEOCENTER_DEFAULT_VALUE;
        this.geoOrigin = null;
        this.geoOriginProtoInstance = null;
        this.geoSystem = new ArrayList<String>(GEOSYSTEM_DEFAULT_VALUE);
        this.IS = null;
        this.metadata = null;
        this.metadataProtoInstance = null;
        this.size = SIZE_DEFAULT_VALUE;
        this.commentsList = new ArrayList();
    }

    @Override
    public double[] getCenter() {
        return this.center;
    }

    @Override
    public GeoProximitySensor setCenter(double[] newValue) {
        if (newValue == null) {
            newValue = new double[]{};
        }
        if (newValue.length != 3) {
            throw new InvalidFieldValueException("GeoProximitySensor center newValue=" + SFVec3d.toString(newValue) + " has length=" + newValue.length + " instead of required length 3");
        }
        this.center = newValue;
        return this;
    }

    public GeoProximitySensor setCenter(SFVec3d newValue) {
        this.setCenter(newValue.getPrimitiveValue());
        return this;
    }

    public GeoProximitySensor setCenter(double x, double y, double z) {
        this.setCenter(new double[]{x, y, z});
        return this;
    }

    @Override
    public float[] getCenterOfRotation() {
        return this.centerOfRotation;
    }

    @Override
    public boolean getEnabled() {
        return this.enabled;
    }

    @Override
    public GeoProximitySensor setEnabled(boolean newValue) {
        this.enabled = newValue;
        return this;
    }

    public GeoProximitySensor setEnabled(SFBool newValue) {
        this.setEnabled(newValue.getPrimitiveValue());
        return this;
    }

    @Override
    public double getEnterTime() {
        return this.enterTime;
    }

    @Override
    public double getExitTime() {
        return this.exitTime;
    }

    @Override
    public double[] getGeoCenter() {
        return this.geoCenter;
    }

    @Override
    public GeoProximitySensor setGeoCenter(double[] newValue) {
        if (newValue == null) {
            newValue = new double[]{};
        }
        if (newValue.length != 3) {
            throw new InvalidFieldValueException("GeoProximitySensor geoCenter newValue=" + SFVec3d.toString(newValue) + " has length=" + newValue.length + " instead of required length 3");
        }
        this.geoCenter = newValue;
        return this;
    }

    public GeoProximitySensor setGeoCenter(SFVec3d newValue) {
        this.setGeoCenter(newValue.getPrimitiveValue());
        return this;
    }

    public GeoProximitySensor setGeoCenter(double x, double y, double z) {
        this.setGeoCenter(new double[]{x, y, z});
        return this;
    }

    @Override
    public double[] getGeoCoord() {
        return this.geoCoord;
    }

    @Override
    public GeoOrigin getGeoOrigin() {
        return this.geoOrigin;
    }

    @Override
    public GeoProximitySensor setGeoOrigin(GeoOrigin newValue) {
        this.geoOrigin = newValue;
        if (newValue != null) {
            ((X3DConcreteElement)((Object)this.geoOrigin)).setParent(this);
        }
        if (this.geoOriginProtoInstance != null) {
            this.geoOriginProtoInstance.setParent(null);
            this.geoOriginProtoInstance = null;
        }
        return this;
    }

    public GeoProximitySensor clearGeoOrigin() {
        ((X3DConcreteElement)((Object)this.geoOrigin)).clearParent();
        this.geoOrigin = null;
        return this;
    }

    public GeoProximitySensor setGeoOrigin(ProtoInstance newValue) {
        if (this.geoOriginProtoInstance != null) {
            this.geoOriginProtoInstance.setParent(null);
        }
        this.geoOriginProtoInstance = newValue;
        if (newValue != null) {
            this.geoOriginProtoInstance.setParent(this);
            this.geoOriginProtoInstance.setContainerField("geoOrigin");
        }
        if (this.geoOrigin != null) {
            ((X3DConcreteElement)((Object)this.geoOrigin)).setParent(null);
            this.geoOrigin = null;
        }
        return this;
    }

    private ProtoInstance getGeoOriginProtoInstance() {
        return this.geoOriginProtoInstance;
    }

    public boolean hasGeoOrigin() {
        return this.geoOrigin != null || this.geoOriginProtoInstance != null;
    }

    @Override
    public String[] getGeoSystem() {
        String[] valuesArray = new String[this.geoSystem.size()];
        int i = 0;
        for (String arrayElement : this.geoSystem) {
            valuesArray[i++] = arrayElement;
        }
        return valuesArray;
    }

    public ArrayList<String> getGeoSystemList() {
        return this.geoSystem;
    }

    public String getGeoSystemString() {
        StringBuilder result = new StringBuilder();
        for (String arrayElement : this.geoSystem) {
            result.append("\"");
            result.append(arrayElement);
            result.append("\"");
            result.append(" ");
        }
        return result.toString().trim();
    }

    @Override
    public GeoProximitySensor setGeoSystem(String[] newValue) {
        if (newValue == null) {
            this.clearGeoSystem();
            return this;
        }
        this.clearGeoSystem();
        for (int i = 0; i < newValue.length; ++i) {
            this.geoSystem.add(newValue[i]);
        }
        return this;
    }

    public GeoProximitySensor setGeoSystem(MFString newValue) {
        if (newValue == null) {
            this.clearGeoSystem();
            return this;
        }
        this.setGeoSystem(newValue.getPrimitiveValue());
        return this;
    }

    public GeoProximitySensor setGeoSystem(SFString newValue) {
        if (newValue == null) {
            this.clearGeoSystem();
            return this;
        }
        this.setGeoSystem(newValue.getValue());
        return this;
    }

    public GeoProximitySensor setGeoSystem(String newValue) {
        if (newValue == null) {
            this.clearGeoSystem();
            return this;
        }
        this.clearGeoSystem();
        this.geoSystem.add(newValue);
        return this;
    }

    public GeoProximitySensor setGeoSystem(ArrayList<String> newValue) {
        if (newValue == null) {
            this.clearGeoSystem();
            return this;
        }
        if (newValue.isEmpty()) {
            this.clearGeoSystem();
        } else {
            String[] newArray = new String[newValue.size()];
            for (int i = 0; i < newValue.size(); ++i) {
                newArray[i] = newValue.get(i);
            }
            this.setGeoSystem(newArray);
        }
        return this;
    }

    public GeoProximitySensor clearGeoSystem() {
        this.geoSystem.clear();
        return this;
    }

    public GeoProximitySensor addGeoSystem(String newValue) {
        if (newValue == null) {
            return this;
        }
        if (!(newValue = MFString.cleanupEnumerationValue(newValue)).isEmpty() && !this.geoSystem.contains(newValue)) {
            this.geoSystem.add(newValue);
        }
        return this;
    }

    public GeoProximitySensor addGeoSystem(SFString newValue) {
        if (newValue == null) {
            return this;
        }
        newValue.setValue(MFString.cleanupEnumerationValue(newValue.getValue()));
        if (!newValue.getValue().isEmpty() && !this.geoSystem.contains(newValue.getValue())) {
            this.geoSystem.add(newValue.getValue());
        }
        return this;
    }

    @Override
    public IS getIS() {
        return this.IS;
    }

    @Override
    public GeoProximitySensor setIS(IS newValue) {
        this.IS = newValue;
        if (newValue != null) {
            this.IS.setParent(this);
        }
        return this;
    }

    public GeoProximitySensor clearIS() {
        this.IS.clearParent();
        this.IS = null;
        return this;
    }

    public boolean hasIS() {
        return this.IS != null;
    }

    @Override
    public boolean getIsActive() {
        return this.isActive;
    }

    @Override
    public X3DMetadataObject getMetadata() {
        return this.metadata;
    }

    @Override
    public GeoProximitySensor setMetadata(X3DMetadataObject newValue) {
        this.metadata = newValue;
        if (newValue != null) {
            ((X3DConcreteElement)((Object)this.metadata)).setParent(this);
        }
        if (this.metadataProtoInstance != null) {
            this.metadataProtoInstance.setParent(null);
            this.metadataProtoInstance = null;
        }
        return this;
    }

    public GeoProximitySensor clearMetadata() {
        ((X3DConcreteElement)((Object)this.metadata)).clearParent();
        this.metadata = null;
        return this;
    }

    @Override
    public GeoProximitySensor setMetadata(ProtoInstance newValue) {
        if (this.metadataProtoInstance != null) {
            this.metadataProtoInstance.setParent(null);
        }
        this.metadataProtoInstance = newValue;
        if (newValue != null) {
            this.metadataProtoInstance.setParent(this);
            this.metadataProtoInstance.setContainerField("metadata");
        }
        if (this.metadata != null) {
            ((X3DConcreteElement)((Object)this.metadata)).setParent(null);
            this.metadata = null;
        }
        return this;
    }

    private ProtoInstance getMetadataProtoInstance() {
        return this.metadataProtoInstance;
    }

    public boolean hasMetadata() {
        return this.metadata != null || this.metadataProtoInstance != null;
    }

    @Override
    public float[] getOrientation() {
        return this.orientation;
    }

    @Override
    public float[] getPosition() {
        return this.position;
    }

    @Override
    public float[] getSize() {
        return this.size;
    }

    @Override
    public GeoProximitySensor setSize(float[] newValue) {
        if (newValue == null) {
            newValue = new float[]{};
        }
        if (newValue.length != 3) {
            throw new InvalidFieldValueException("GeoProximitySensor size newValue=" + SFVec3f.toString(newValue) + " has length=" + newValue.length + " instead of required length 3");
        }
        if (newValue[0] < 0.0f || newValue[1] < 0.0f || newValue[2] < 0.0f) {
            throw new InvalidFieldValueException("GeoProximitySensor size newValue=" + newValue + " has component value less than restriction minInclusive=0");
        }
        this.size = newValue;
        return this;
    }

    public GeoProximitySensor setSize(SFVec3f newValue) {
        this.setSize(newValue.getPrimitiveValue());
        return this;
    }

    public GeoProximitySensor setSize(float x, float y, float z) {
        this.setSize(new float[]{x, y, z});
        return this;
    }

    public GeoProximitySensor setSize(double x, double y, double z) {
        return this.setSize(new SFVec3f(x, y, z));
    }

    public GeoProximitySensor setSize(double[] newArray) {
        return this.setSize(new SFVec3f(newArray));
    }

    @Override
    public String getDEF() {
        return super.getDEF();
    }

    @Override
    public final GeoProximitySensor setDEF(String newValue) {
        if (newValue == null) {
            newValue = new String();
        }
        if (!newValue.isEmpty() && !SFString.isNMTOKEN(newValue)) {
            throw new InvalidFieldValueException("GeoProximitySensor DEF newValue='" + newValue + "' has illegal name value, cannot be empty and must be defined with valid NMTOKEN name string (with legal characters and no embedded whitespace).");
        }
        this.setConcreteUSE("");
        this.setConcreteDEF(newValue);
        return this;
    }

    public GeoProximitySensor setDEF(SFString newValue) {
        this.setDEF(newValue.getPrimitiveValue());
        return this;
    }

    @Override
    public String getUSE() {
        return super.getUSE();
    }

    @Override
    public final GeoProximitySensor setUSE(String newValue) {
        if (newValue == null) {
            newValue = new String();
        }
        if (!newValue.isEmpty() && !SFString.isNMTOKEN(newValue)) {
            throw new InvalidFieldValueException("GeoProximitySensor USE newValue='" + newValue + "' has illegal name value, cannot be empty and must be defined with valid NMTOKEN name string (with legal characters and no embedded whitespace).");
        }
        this.setConcreteDEF("");
        this.setConcreteUSE(newValue);
        return this;
    }

    public GeoProximitySensor setUSE(SFString newValue) {
        this.setUSE(newValue.getPrimitiveValue());
        return this;
    }

    @Override
    public String getCssClass() {
        return super.getCssClass();
    }

    @Override
    public final GeoProximitySensor setCssClass(String newValue) {
        if (newValue == null) {
            newValue = new String();
        }
        this.setConcreteCssClass(newValue);
        return this;
    }

    public GeoProximitySensor setCssClass(SFString newValue) {
        this.setCssClass(newValue.getPrimitiveValue());
        return this;
    }

    public GeoProximitySensor setUSE(GeoProximitySensor DEFnode) {
        if (DEFnode.getDEF().isEmpty()) {
            String errorNotice = "setUSE(DEFnode) invoked on GeoProximitySensor that has no DEF name defined, thus a copy cannot be referenced as a USE node";
            this.validationResult.append(errorNotice).append("\n");
            throw new InvalidFieldValueException(errorNotice);
        }
        this.setUSE(DEFnode.getDEF());
        return this;
    }

    public GeoProximitySensor(String DEFlabel) {
        this.initialize();
        this.setDEF(DEFlabel);
    }

    @Override
    public GeoProximitySensor addComments(String newComment) {
        if (this.isUSE()) {
            String errorNotice = "addComments(\"" + newComment + "\")\ncannot be applied to a USE node (USE='" + this.getUSE() + "') which only contains a reference to a DEF node";
            this.validationResult.append(errorNotice).append("\n");
            throw new InvalidFieldValueException(errorNotice);
        }
        this.commentsList.add(newComment);
        return this;
    }

    @Override
    public GeoProximitySensor addComments(String[] newComments) {
        if (this.isUSE()) {
            String errorNotice = "addComments(" + Arrays.toString(newComments) + ")\ncannot be applied to a USE node (USE='" + this.getUSE() + "') which only contains a reference to a DEF node";
            this.validationResult.append(errorNotice).append("\n");
            throw new InvalidFieldValueException(errorNotice);
        }
        this.commentsList.addAll(Arrays.asList(newComments));
        return this;
    }

    @Override
    public GeoProximitySensor addComments(CommentsBlock newCommentsBlock) {
        if (this.isUSE()) {
            String errorNotice = "addComments(CommentsBlock) cannot be applied to a USE node (USE='" + this.getUSE() + "') which only contains a reference to a DEF node";
            this.validationResult.append(errorNotice).append("\n");
            throw new InvalidFieldValueException(errorNotice);
        }
        this.commentsList.addAll(newCommentsBlock.toStringList());
        return this;
    }

    @Override
    public String toStringX3D(int indentLevel) {
        boolean hasChild;
        boolean hasAttributes = true;
        boolean bl = hasChild = this.IS != null || this.geoOrigin != null || this.geoOriginProtoInstance != null || this.IS != null || this.metadata != null || this.metadataProtoInstance != null || !this.commentsList.isEmpty();
        if (this.isUSE()) {
            hasChild = false;
        }
        StringBuilder indent = new StringBuilder();
        int indentIncrement = ConfigurationProperties.getIndentIncrement();
        char indentCharacter = ConfigurationProperties.getIndentCharacter();
        for (int i = 0; i < indentLevel; ++i) {
            indent.append(indentCharacter);
        }
        StringBuilder stringX3D = new StringBuilder();
        stringX3D.append((CharSequence)indent).append("<GeoProximitySensor");
        if (hasAttributes) {
            if (!this.getDEF().equals("") && !this.isUSE()) {
                stringX3D.append(" DEF='").append(SFString.toString(this.getDEF())).append("'");
            }
            if (!this.getUSE().equals("")) {
                stringX3D.append(" USE='").append(SFString.toString(this.getUSE())).append("'");
            }
            if (!this.getContainerFieldOverride().isEmpty() && !this.getContainerFieldOverride().equals(this.getContainerFieldDefault())) {
                stringX3D.append(" containerField='").append(this.getContainerFieldOverride()).append("'");
            }
            if (!(Arrays.equals(this.getCenter(), CENTER_DEFAULT_VALUE) && ConfigurationProperties.getStripDefaultAttributes() || this.isUSE())) {
                stringX3D.append(" center='").append(SFVec3d.toString(this.getCenter())).append("'");
            }
            if (!(this.getCssClass().equals("") && ConfigurationProperties.getStripDefaultAttributes() || this.isUSE())) {
                stringX3D.append(" class='").append(new SFString(this.getCssClass()).toStringX3D()).append("'");
            }
            if (!(this.getEnabled() && ConfigurationProperties.getStripDefaultAttributes() || this.isUSE())) {
                stringX3D.append(" enabled='").append(SFBool.toString(this.getEnabled())).append("'");
            }
            if (!(Arrays.equals(this.getGeoCenter(), GEOCENTER_DEFAULT_VALUE) && ConfigurationProperties.getStripDefaultAttributes() || this.isUSE())) {
                stringX3D.append(" geoCenter='").append(SFVec3d.toString(this.getGeoCenter())).append("'");
            }
            if (!(this.getGeoSystem().length <= 0 && ConfigurationProperties.getStripDefaultAttributes() || this.isUSE())) {
                stringX3D.append(" geoSystem='").append(new MFString(this.getGeoSystem()).toStringX3D()).append("'");
            }
            if (!(Arrays.equals(this.getSize(), SIZE_DEFAULT_VALUE) && ConfigurationProperties.getStripDefaultAttributes() || this.isUSE())) {
                stringX3D.append(" size='").append(SFVec3f.toString(this.getSize())).append("'");
            }
        }
        if (hasChild && !this.isUSE()) {
            stringX3D.append(">").append("\n");
            if (!this.commentsList.isEmpty()) {
                CommentsBlock commentsBlock = new CommentsBlock(this.commentsList);
                stringX3D.append(commentsBlock.toStringX3D(indentLevel + indentIncrement));
            }
            if (this.metadata != null) {
                stringX3D.append(((X3DConcreteElement)((Object)this.metadata)).toStringX3D(indentLevel + indentIncrement));
            } else if (this.metadataProtoInstance != null) {
                stringX3D.append(((X3DConcreteElement)this.metadataProtoInstance).toStringX3D(indentLevel + indentIncrement));
            }
            if (this.IS != null) {
                stringX3D.append(((X3DConcreteElement)this.IS).toStringX3D(indentLevel + indentIncrement));
            }
            if (this.geoOrigin != null) {
                stringX3D.append(((X3DConcreteElement)((Object)this.geoOrigin)).toStringX3D(indentLevel + indentIncrement));
            } else if (this.geoOriginProtoInstance != null) {
                stringX3D.append(((X3DConcreteElement)this.geoOriginProtoInstance).toStringX3D(indentLevel + indentIncrement));
            }
            stringX3D.append((CharSequence)indent).append("</GeoProximitySensor>").append("\n");
        } else {
            stringX3D.append("/>").append("\n");
        }
        return stringX3D.toString();
    }

    @Override
    public String toStringClassicVRML(int indentLevel) {
        boolean hasChild;
        StringBuilder stringClassicVRML = new StringBuilder();
        boolean hasAttributes = true;
        boolean bl = hasChild = this.IS != null || this.geoOrigin != null || this.geoOriginProtoInstance != null || this.IS != null || this.metadata != null || this.metadataProtoInstance != null || !this.commentsList.isEmpty();
        if (this.isUSE()) {
            hasAttributes = false;
            hasChild = false;
        }
        StringBuilder indent = new StringBuilder();
        char indentCharacter = ConfigurationProperties.getIndentCharacter();
        int indentIncrement = ConfigurationProperties.getIndentIncrement();
        for (int i = 0; i < indentLevel; ++i) {
            indent.append(indentCharacter);
        }
        if (!this.getDEF().equals("")) {
            stringClassicVRML.append("DEF ").append(SFString.toString(this.getDEF())).append(" ");
        }
        if (!this.getUSE().equals("")) {
            stringClassicVRML.append("USE ").append(SFString.toString(this.getUSE())).append("\n");
        } else {
            stringClassicVRML.append(NAME).append(" { ");
            if (hasAttributes || hasChild) {
                stringClassicVRML.append("\n").append((CharSequence)indent).append(indentCharacter);
            }
            if (hasAttributes) {
                boolean hasISconnect;
                boolean bl2 = hasISconnect = this.getIS() != null && !this.getIS().getConnectList().isEmpty();
                if (hasISconnect) {
                    for (connect element : this.getIS().getConnectList()) {
                        if (!element.getNodeField().equals("center")) continue;
                        stringClassicVRML.append(indentCharacter).append("center").append(" IS ").append(element.getProtoField()).append("\n").append((CharSequence)indent).append(indentCharacter);
                    }
                } else if (!Arrays.equals(this.getCenter(), CENTER_DEFAULT_VALUE) || !ConfigurationProperties.getStripDefaultAttributes()) {
                    stringClassicVRML.append("center ").append(SFVec3d.toString(this.getCenter())).append("\n").append((CharSequence)indent).append(indentCharacter);
                }
                if (hasISconnect) {
                    for (connect element : this.getIS().getConnectList()) {
                        if (!element.getNodeField().equals("class")) continue;
                        stringClassicVRML.append(indentCharacter).append("class").append(" IS ").append(element.getProtoField()).append("\n").append((CharSequence)indent).append(indentCharacter);
                    }
                } else if (!this.getCssClass().equals("") || !ConfigurationProperties.getStripDefaultAttributes()) {
                    stringClassicVRML.append("# class ").append("\"").append(SFString.toString(this.getCssClass())).append("\"").append("\n").append((CharSequence)indent).append(indentCharacter);
                }
                if (hasISconnect) {
                    for (connect element : this.getIS().getConnectList()) {
                        if (!element.getNodeField().equals("enabled")) continue;
                        stringClassicVRML.append(indentCharacter).append("enabled").append(" IS ").append(element.getProtoField()).append("\n").append((CharSequence)indent).append(indentCharacter);
                    }
                } else if (!this.getEnabled() || !ConfigurationProperties.getStripDefaultAttributes()) {
                    stringClassicVRML.append("enabled ").append(SFBool.toString(this.getEnabled())).append("\n").append((CharSequence)indent).append(indentCharacter);
                }
                if (hasISconnect) {
                    for (connect element : this.getIS().getConnectList()) {
                        if (!element.getNodeField().equals("geoCenter")) continue;
                        stringClassicVRML.append(indentCharacter).append("geoCenter").append(" IS ").append(element.getProtoField()).append("\n").append((CharSequence)indent).append(indentCharacter);
                    }
                } else if (!Arrays.equals(this.getGeoCenter(), GEOCENTER_DEFAULT_VALUE) || !ConfigurationProperties.getStripDefaultAttributes()) {
                    stringClassicVRML.append("geoCenter ").append(SFVec3d.toString(this.getGeoCenter())).append("\n").append((CharSequence)indent).append(indentCharacter);
                }
                if (hasISconnect) {
                    for (connect element : this.getIS().getConnectList()) {
                        if (!element.getNodeField().equals("geoSystem")) continue;
                        stringClassicVRML.append(indentCharacter).append("geoSystem").append(" IS ").append(element.getProtoField()).append("\n").append((CharSequence)indent).append(indentCharacter);
                    }
                } else if (this.getGeoSystem().length > 0 || !ConfigurationProperties.getStripDefaultAttributes()) {
                    stringClassicVRML.append("geoSystem ").append("[ ").append(MFString.toString(this.getGeoSystem())).append(" ]").append("\n").append((CharSequence)indent).append(indentCharacter);
                }
                if (hasISconnect) {
                    for (connect element : this.getIS().getConnectList()) {
                        if (!element.getNodeField().equals("size")) continue;
                        stringClassicVRML.append(indentCharacter).append("size").append(" IS ").append(element.getProtoField()).append("\n").append((CharSequence)indent).append(indentCharacter);
                    }
                } else if (!Arrays.equals(this.getSize(), SIZE_DEFAULT_VALUE) || !ConfigurationProperties.getStripDefaultAttributes()) {
                    stringClassicVRML.append("size ").append(SFVec3f.toString(this.getSize())).append("\n").append((CharSequence)indent).append(indentCharacter);
                }
            }
        }
        if (hasChild) {
            if (this.metadata != null) {
                stringClassicVRML.append(indentCharacter).append("metadata").append(" ");
                stringClassicVRML.append(((X3DConcreteElement)((Object)this.metadata)).toStringClassicVRML(indentLevel + indentIncrement));
                stringClassicVRML.append((CharSequence)indent);
            } else if (this.metadataProtoInstance != null) {
                stringClassicVRML.append(indentCharacter).append("metadata").append(" ");
                stringClassicVRML.append(((X3DConcreteElement)this.metadataProtoInstance).toStringClassicVRML(indentLevel + indentIncrement));
                stringClassicVRML.append((CharSequence)indent);
            }
            if (this.IS != null) {
                stringClassicVRML.append(((X3DConcreteElement)this.IS).toStringClassicVRML(indentLevel));
            }
            if (this.geoOrigin != null) {
                stringClassicVRML.append(indentCharacter).append("geoOrigin").append(" ");
                stringClassicVRML.append(((X3DConcreteElement)((Object)this.geoOrigin)).toStringClassicVRML(indentLevel + indentIncrement));
                stringClassicVRML.append((CharSequence)indent);
            } else if (this.geoOriginProtoInstance != null) {
                stringClassicVRML.append(indentCharacter).append("geoOrigin").append(" ");
                stringClassicVRML.append(((X3DConcreteElement)this.geoOriginProtoInstance).toStringClassicVRML(indentLevel + indentIncrement));
                stringClassicVRML.append((CharSequence)indent);
            }
            if (!this.commentsList.isEmpty()) {
                CommentsBlock commentsBlock = new CommentsBlock(this.commentsList);
                stringClassicVRML.append(commentsBlock.toStringClassicVRML(indentLevel));
                stringClassicVRML.append((CharSequence)indent);
            }
        }
        if (hasAttributes || hasChild) {
            stringClassicVRML.append("}").append("\n");
        }
        return stringClassicVRML.toString();
    }

    @Override
    public String toStringVRML97(int indentLevel) {
        return this.toStringClassicVRML(indentLevel);
    }

    @Override
    public X3DConcreteElement findElementByNameValue(String nameValue) {
        return this.findElementByNameValue(nameValue, "");
    }

    @Override
    public X3DConcreteElement findElementByNameValue(String nameValue, String elementName) {
        X3DConcreteElement referenceElement;
        if (nameValue == null || nameValue.isEmpty()) {
            String errorNotice = "findElementByNameValue(\"\", " + elementName + ") cannot use empty string to find a name attribute";
            this.validationResult.append(errorNotice).append("\n");
            throw new InvalidFieldValueException(errorNotice);
        }
        if (this.geoOrigin != null && (referenceElement = ((X3DConcreteElement)((Object)this.geoOrigin)).findElementByNameValue(nameValue, elementName)) != null) {
            return referenceElement;
        }
        if (this.geoOriginProtoInstance != null && (referenceElement = ((X3DConcreteElement)this.geoOriginProtoInstance).findElementByNameValue(nameValue, elementName)) != null) {
            return referenceElement;
        }
        if (this.IS != null && (referenceElement = ((X3DConcreteElement)this.IS).findElementByNameValue(nameValue, elementName)) != null) {
            return referenceElement;
        }
        if (this.metadata != null && (referenceElement = ((X3DConcreteElement)((Object)this.metadata)).findElementByNameValue(nameValue, elementName)) != null) {
            return referenceElement;
        }
        if (this.metadataProtoInstance != null && (referenceElement = ((X3DConcreteElement)this.metadataProtoInstance).findElementByNameValue(nameValue, elementName)) != null) {
            return referenceElement;
        }
        return null;
    }

    public boolean hasElementByNameValue(String nameValue, String elementName) {
        return this.findElementByNameValue(nameValue, elementName) != null;
    }

    @Override
    public X3DConcreteNode findNodeByDEF(String DEFvalue) {
        X3DConcreteNode referenceNode;
        if (DEFvalue == null || DEFvalue.isEmpty()) {
            String errorNotice = "findNodeByDEF(\"\") cannot use empty string to find a name";
            this.validationResult.append(errorNotice).append("\n");
            throw new InvalidFieldValueException(errorNotice);
        }
        if (this.getDEF().equals(DEFvalue)) {
            return this;
        }
        if (this.geoOrigin != null && (referenceNode = ((X3DConcreteElement)((Object)this.geoOrigin)).findNodeByDEF(DEFvalue)) != null) {
            return referenceNode;
        }
        if (this.geoOriginProtoInstance != null && (referenceNode = ((X3DConcreteElement)this.geoOriginProtoInstance).findNodeByDEF(DEFvalue)) != null) {
            return referenceNode;
        }
        if (this.IS != null && (referenceNode = ((X3DConcreteElement)this.IS).findNodeByDEF(DEFvalue)) != null) {
            return referenceNode;
        }
        if (this.metadata != null && (referenceNode = ((X3DConcreteElement)((Object)this.metadata)).findNodeByDEF(DEFvalue)) != null) {
            return referenceNode;
        }
        if (this.metadataProtoInstance != null && (referenceNode = ((X3DConcreteElement)this.metadataProtoInstance).findNodeByDEF(DEFvalue)) != null) {
            return referenceNode;
        }
        return null;
    }

    public boolean hasNodeByDEF(String DEFvalue) {
        return this.findNodeByDEF(DEFvalue) != null;
    }

    @Override
    public String validate() {
        this.validationResult = new StringBuilder();
        this.setCenter(this.getCenter());
        this.setEnabled(this.getEnabled());
        this.setGeoCenter(this.getGeoCenter());
        this.setGeoSystem(this.getGeoSystem());
        this.setSize(this.getSize());
        if (!this.isUSE()) {
            this.setDEF(this.getDEF());
        }
        if (this.isUSE()) {
            this.setUSE(this.getUSE());
        }
        this.setCssClass(this.getCssClass());
        if (this.geoOrigin != null) {
            this.setGeoOrigin(this.getGeoOrigin());
            ((X3DConcreteElement)((Object)this.geoOrigin)).validate();
            this.validationResult.append(((X3DConcreteElement)((Object)this.geoOrigin)).getValidationResult());
        }
        if (this.geoOriginProtoInstance != null) {
            this.setGeoOrigin(this.getGeoOriginProtoInstance());
            ((X3DConcreteElement)this.geoOriginProtoInstance).validate();
            this.validationResult.append(this.geoOriginProtoInstance.getValidationResult());
        }
        if (this.geoOrigin != null && this.geoOriginProtoInstance != null) {
            String errorNotice = "Internal X3DJSAIL error: incorrect handling of contained SFNode field, both geoOrigin and geoOriginProtoInstance are set simultaneously";
            this.validationResult.append(errorNotice);
            throw new InvalidProtoException(errorNotice);
        }
        if (this.isUSE() && this.hasGeoOrigin()) {
            String errorNotice = "GeoProximitySensor USE='" + this.getUSE() + "' is not allowed to have contained SFNode geoOrigin";
            this.validationResult.append(errorNotice);
            throw new InvalidFieldValueException(errorNotice);
        }
        if (this.isUSE() && !this.commentsList.isEmpty()) {
            String errorNotice = "GeoProximitySensor USE='" + this.getUSE() + "' is not allowed to have contained comments";
            this.validationResult.append(errorNotice);
            throw new InvalidFieldValueException(errorNotice);
        }
        if (this.IS != null) {
            this.setIS(this.getIS());
            ((X3DConcreteElement)this.IS).validate();
            this.validationResult.append(this.IS.getValidationResult());
        }
        if (this.isUSE() && this.hasIS()) {
            String errorNotice = "GeoProximitySensor USE='" + this.getUSE() + "' is not allowed to have contained SFNode IS";
            this.validationResult.append(errorNotice);
            throw new InvalidFieldValueException(errorNotice);
        }
        if (this.isUSE() && !this.commentsList.isEmpty()) {
            String errorNotice = "GeoProximitySensor USE='" + this.getUSE() + "' is not allowed to have contained comments";
            this.validationResult.append(errorNotice);
            throw new InvalidFieldValueException(errorNotice);
        }
        if (this.metadata != null) {
            this.setMetadata(this.getMetadata());
            ((X3DConcreteElement)((Object)this.metadata)).validate();
            this.validationResult.append(((X3DConcreteElement)((Object)this.metadata)).getValidationResult());
        }
        if (this.metadataProtoInstance != null) {
            this.setMetadata(this.getMetadataProtoInstance());
            ((X3DConcreteElement)this.metadataProtoInstance).validate();
            this.validationResult.append(this.metadataProtoInstance.getValidationResult());
        }
        if (this.metadata != null && this.metadataProtoInstance != null) {
            String errorNotice = "Internal X3DJSAIL error: incorrect handling of contained SFNode field, both metadata and metadataProtoInstance are set simultaneously";
            this.validationResult.append(errorNotice);
            throw new InvalidProtoException(errorNotice);
        }
        if (this.isUSE() && this.hasMetadata()) {
            String errorNotice = "GeoProximitySensor USE='" + this.getUSE() + "' is not allowed to have contained SFNode metadata";
            this.validationResult.append(errorNotice);
            throw new InvalidFieldValueException(errorNotice);
        }
        if (this.isUSE() && !this.commentsList.isEmpty()) {
            String errorNotice = "GeoProximitySensor USE='" + this.getUSE() + "' is not allowed to have contained comments";
            this.validationResult.append(errorNotice);
            throw new InvalidFieldValueException(errorNotice);
        }
        if (this.getIS() != null && this.getIS().getConnectList().isEmpty()) {
            String errorNotice = "IS statement present, but contains no connect statements";
            this.validationResult.append(errorNotice).append("\n");
            throw new InvalidProtoException(errorNotice);
        }
        if (!this.getContainerFieldOverride().isEmpty() && !Arrays.asList(this.containerField_ALTERNATE_VALUES).contains(this.getContainerFieldOverride())) {
            String errorNotice = "ERROR_ILLEGAL_VALUE: illegal value encountered, containerField='" + this.getContainerFieldOverride() + "' but allowed values are containerField_ALTERNATE_VALUES='" + new MFString(this.containerField_ALTERNATE_VALUES).toStringX3D() + "'.";
            this.validationResult.append(errorNotice).append("\n");
            throw new InvalidFieldException(errorNotice);
        }
        if (this.findAncestorX3D() != null) {
            String modelProfile = this.findAncestorX3D().getProfile();
            boolean hasSatisfactorySupport = this.findAncestorX3D().supportsX3dComponent(COMPONENT, 2);
            if (!hasSatisfactorySupport) {
                String errorNotice = "ERROR_ILLEGAL_VALUE insufficient X3D profile='" + modelProfile + "' for parent X3D model containing 'GeoProximitySensor' node, add head statement <component name='Geospatial' level='2'/>\nor Java source-code assignment:  findAncestorX3D().getHead().addComponent(\"Geospatial\").setLevel(2);";
                this.validationResult.append(errorNotice).append("\n");
                throw new InvalidFieldException(errorNotice);
            }
        }
        return this.validationResult.toString();
    }
}

