/*
 * Decompiled with CFR 0.152.
 */
package org.web3d.x3d.jsail.fields;

import java.util.Arrays;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.web3d.x3d.jsail.fields.SFBool;
import org.web3d.x3d.jsail.fields.X3DConcreteField;
import org.web3d.x3d.sai.InvalidFieldValueException;

public class MFBool
extends X3DConcreteField
implements org.web3d.x3d.sai.MFBool {
    public static final String NAME = "MFBool";
    public static final boolean[] DEFAULT_VALUE = new boolean[0];
    public static final String DEFAULT_VALUE_STRING = "";
    public static final int TUPLE_SIZE = 1;
    public static final String REGEX = "\\s*((true|false)\\s*,?\\s*)*";
    public static final Pattern PATTERN = Pattern.compile("\\s*((true|false)\\s*,?\\s*)*");
    private static boolean priorRegexStackOverflowFound = false;
    private boolean[] MFBool = Arrays.copyOf(DEFAULT_VALUE, DEFAULT_VALUE.length);

    public static final boolean isArray() {
        return true;
    }

    public MFBool() {
        this.initialize();
    }

    @Override
    public final void initialize() {
        this.MFBool = Arrays.copyOf(DEFAULT_VALUE, DEFAULT_VALUE.length);
    }

    public boolean equals(MFBool comparisonMFBool) {
        return this.getPrimitiveValue() == comparisonMFBool.getPrimitiveValue();
    }

    public final String validate() {
        MFBool tempHold = new MFBool(this.getPrimitiveValue());
        if (!this.equals(tempHold)) {
            return "MFBool validate() error: failed get/set round-trip test";
        }
        return DEFAULT_VALUE_STRING;
    }

    public final String validateRegex() {
        try {
            Matcher m = PATTERN.matcher(this.toString());
            if (!m.matches()) {
                String errorNotice = "*** Regular expression (regex) failure, new MFBool PATTERN mismatch (\"" + this.toString() + "\")";
                return errorNotice;
            }
        }
        catch (StackOverflowError soe) {
            String validationMessage = "java.lang.StackOverflow warning: regular expression (regex) unable to evaluate large corresponding String value for MFBool array";
            validationResult.append(validationMessage).append("\n");
            System.out.println("*** " + validationMessage);
            return validationMessage;
        }
        return DEFAULT_VALUE_STRING;
    }

    public final boolean matches() {
        try {
            Matcher m = PATTERN.matcher(this.toString());
            return m.matches();
        }
        catch (StackOverflowError soe) {
            String validationMessage = "java.lang.StackOverflow warning: regular expression (regex) unable to evaluate large corresponding String value for MFBool array";
            validationResult.append(validationMessage).append("\n");
            System.out.println("*** " + validationMessage);
            return false;
        }
    }

    public static final boolean matches(String value) {
        Matcher m = PATTERN.matcher(value);
        return m.matches();
    }

    public MFBool setValueByString(String newValue) throws InvalidFieldValueException {
        if (newValue == null) {
            newValue = new String();
        }
        if (!org.web3d.x3d.jsail.fields.MFBool.matches(newValue)) {
            String errorNotice = "*** Regular expression (regex) failure, new MFBool(" + newValue + ")";
            validationResult.append(errorNotice).append("\n");
        }
        if (newValue.trim().isEmpty()) {
            this.MFBool = Arrays.copyOf(DEFAULT_VALUE, DEFAULT_VALUE.length);
            return this;
        }
        String[] newValues = newValue.replace(",", " ").replaceAll("\\s+", " ").trim().split("\\s+");
        this.MFBool = new boolean[newValues.length];
        int i = 0;
        for (String value : newValues) {
            if (!value.equals("true") && !value.equals("false")) {
                String errorNotice = "illegal boolean value for MFBool() initialization, newValue[" + i + "]='" + value + "' but must be 'true' or 'false' (case sensitive)";
                validationResult.append(errorNotice).append("\n");
                throw new InvalidFieldValueException(errorNotice);
            }
            this.MFBool[i] = Boolean.parseBoolean(value);
            ++i;
        }
        return this;
    }

    public MFBool(MFBool newValue) {
        if (newValue == null) {
            this.MFBool = Arrays.copyOf(DEFAULT_VALUE, DEFAULT_VALUE.length);
            return;
        }
        this.MFBool = newValue.getPrimitiveValue();
    }

    public MFBool(boolean[] newValue) {
        if (newValue == null) {
            newValue = Arrays.copyOf(DEFAULT_VALUE, DEFAULT_VALUE.length);
        }
        this.MFBool = newValue;
    }

    public MFBool(boolean newValue) {
        this.MFBool = new boolean[1];
        this.MFBool[0] = newValue;
    }

    public MFBool(SFBool newValue) {
        this.setValue(newValue);
    }

    public static String toString(boolean[] value) {
        StringBuilder result = new StringBuilder();
        for (int i = 0; i < value.length; ++i) {
            result.append(value[i]).append(" ");
        }
        return result.toString().trim();
    }

    @Override
    public void getValue(boolean[] valueDestination) {
        valueDestination = this.MFBool;
    }

    public boolean[] getPrimitiveValue() {
        return this.MFBool;
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        for (int i = 0; i < this.MFBool.length; ++i) {
            result.append(String.valueOf(this.MFBool[i]));
            if (i >= this.MFBool.length - 1) continue;
            result.append(" ");
        }
        return result.toString();
    }

    @Override
    public boolean get1Value(int index) {
        if (index < 0) {
            String errorNotice = "Index value is negative, thus cannot get1Value at index=" + index + ".";
            validationResult.append(errorNotice).append("\n");
            throw new ArrayIndexOutOfBoundsException(errorNotice);
        }
        if (this.MFBool.length == 0) {
            String errorNotice = "Value array is empty, thus cannot get1Value at index=" + index + ".";
            validationResult.append(errorNotice).append("\n");
            throw new ArrayIndexOutOfBoundsException(errorNotice);
        }
        if (index >= this.MFBool.length / 1) {
            String errorNotice = "Provided array index=" + index + " must be less than MFBool array length=" + this.MFBool.length / 1;
            validationResult.append(errorNotice).append("\n");
            throw new ArrayIndexOutOfBoundsException(errorNotice);
        }
        return this.MFBool[index];
    }

    @Override
    public void setValue(int size, boolean[] newValue) {
        if (newValue == null) {
            throw new InvalidFieldValueException(" newValue is null and cannot be set");
        }
        if (size < 0) {
            throw new InvalidFieldValueException("requested setValue() array-copy size=" + size + " is negative");
        }
        if (size > newValue.length) {
            throw new InvalidFieldValueException("requested setValue() array-copy size=" + size + " is greater than newValue.length()=" + newValue.length);
        }
        this.MFBool = Arrays.copyOf(newValue, size);
    }

    public void setValue(boolean[] newValue) {
        if (newValue == null) {
            newValue = new boolean[]{};
        }
        this.MFBool = new boolean[newValue.length];
        this.MFBool = newValue;
    }

    public void setValue(boolean newValue) {
        this.MFBool = new boolean[1];
        this.MFBool[0] = newValue;
    }

    public MFBool setValue(SFBool newValue) {
        if (newValue == null) {
            this.MFBool = Arrays.copyOf(DEFAULT_VALUE, DEFAULT_VALUE.length);
            return this;
        }
        this.MFBool = new boolean[1];
        this.MFBool[0] = newValue.getValue();
        return this;
    }

    @Override
    public void set1Value(int index, boolean newValue) throws ArrayIndexOutOfBoundsException {
        if (index < 0) {
            String errorNotice = "Index value is negative, thus cannot set1Value at index=" + index + ".";
            validationResult.append(errorNotice).append("\n");
            throw new ArrayIndexOutOfBoundsException(errorNotice);
        }
        if (this.MFBool.length == 0) {
            String errorNotice = "Value array is empty, thus cannot set1Value at index=" + index + ".";
            validationResult.append(errorNotice).append("\n");
            throw new ArrayIndexOutOfBoundsException(errorNotice);
        }
        if (index >= this.MFBool.length / 1) {
            String errorNotice = "Provided array index=" + index + " must be less than MFBool array length=" + this.MFBool.length / 1;
            validationResult.append(errorNotice).append("\n");
            throw new ArrayIndexOutOfBoundsException(errorNotice);
        }
        this.MFBool[index] = newValue;
    }

    @Override
    public void append(boolean newValue) {
        this.MFBool = Arrays.copyOf(this.MFBool, this.MFBool.length + 1);
        this.MFBool[this.MFBool.length - 1] = newValue;
    }

    public void append(boolean[] newValue) {
        if (newValue.length % 1 != 0) {
            String errorNotice = "illegal number of values (" + newValue.length + ") in initialization array, must be multiple of 4 when declaring new MFVec4f(" + newValue + ")";
            validationResult.append(errorNotice).append("\n");
            throw new InvalidFieldValueException(errorNotice);
        }
        int originalLength = this.MFBool.length;
        this.MFBool = Arrays.copyOf(this.MFBool, this.MFBool.length + newValue.length);
        for (int i = 0; i < newValue.length; ++i) {
            this.MFBool[originalLength + i] = newValue[i];
        }
    }

    public MFBool append(SFBool newValue) {
        this.append(newValue.getPrimitiveValue());
        return this;
    }

    public MFBool append(MFBool newValue) {
        this.append(newValue.getPrimitiveValue());
        return this;
    }

    @Override
    public void insertValue(int index, boolean newValue) {
        if (index < 0) {
            String errorNotice = "Index value is negative, thus cannot insertValue at index=" + index + ".";
            validationResult.append(errorNotice).append("\n");
            throw new ArrayIndexOutOfBoundsException(errorNotice);
        }
        if (index >= this.MFBool.length) {
            String errorNotice = "Provided array index=" + index + " must be less than MFBool array length=" + this.MFBool.length;
            validationResult.append(errorNotice).append("\n");
            throw new ArrayIndexOutOfBoundsException(errorNotice);
        }
        int sliceLength = this.MFBool.length - index;
        this.MFBool = Arrays.copyOf(this.MFBool, this.MFBool.length + 1);
        System.arraycopy(this.MFBool, index, this.MFBool, index + 1, sliceLength);
        this.MFBool[index] = newValue;
    }

    @Override
    public int size() {
        return this.MFBool.length;
    }

    @Override
    public void clear() {
        this.MFBool = new boolean[0];
    }

    @Override
    public void remove(int index) {
        if (index < 0) {
            String errorNotice = "Index value is negative, thus cannot remove() value at index=" + index + ".";
            validationResult.append(errorNotice).append("\n");
            throw new ArrayIndexOutOfBoundsException(errorNotice);
        }
        if (this.MFBool.length == 0) {
            String errorNotice = "Value array is empty, thus cannot remove value at index=" + index + ".";
            validationResult.append(errorNotice).append("\n");
            throw new ArrayIndexOutOfBoundsException(errorNotice);
        }
        if (index >= this.MFBool.length) {
            String errorNotice = "Provided array index=" + index + " must be less than MFBool array length=" + this.MFBool.length;
            validationResult.append(errorNotice).append("\n");
            throw new ArrayIndexOutOfBoundsException(errorNotice);
        }
        int offsetLength = this.MFBool.length - (index + 1) * 1;
        System.arraycopy(this.MFBool, (index + 1) * 1, this.MFBool, index * 1, offsetLength);
        this.MFBool = Arrays.copyOfRange(this.MFBool, 0, this.MFBool.length - 1);
    }

    public MFBool negate() {
        for (int i = 0; i < this.MFBool.length; ++i) {
            this.MFBool[i] = !this.MFBool[i];
        }
        return this;
    }

    public MFBool setValue(MFBool newValue) {
        if (newValue == null) {
            this.MFBool = Arrays.copyOf(DEFAULT_VALUE, DEFAULT_VALUE.length);
            return this;
        }
        this.MFBool = newValue.getPrimitiveValue();
        return this;
    }

    public boolean isDefaultValue() {
        return Arrays.equals(this.MFBool, DEFAULT_VALUE);
    }

    static {
        try {
            Pattern.compile(REGEX);
            if (!new MFBool(DEFAULT_VALUE).matches()) {
                System.out.println("MFBool.initialize() problem: failed to match DEFAULT_VALUE=" + Arrays.toString(DEFAULT_VALUE));
            }
        }
        catch (PatternSyntaxException exception) {
            System.out.println("Exception in MFBool initialization testing, regex pattern compilation failure.");
            System.out.println("REGEX=\"\\s*((true|false)\\s*,?\\s*)*\"");
            System.out.println(exception.getDescription());
        }
    }
}

