/*
 * Decompiled with CFR 0.152.
 */
package org.web3d.x3d.jsail.fields;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.web3d.x3d.jsail.fields.X3DConcreteField;
import org.web3d.x3d.sai.InvalidFieldValueException;

public class SFInt32
extends X3DConcreteField
implements org.web3d.x3d.sai.SFInt32 {
    public static final String NAME = "SFInt32";
    public static final int DEFAULT_VALUE = 0;
    public static final String DEFAULT_VALUE_STRING = "0";
    public static final int TUPLE_SIZE = 1;
    public static final String REGEX = "(\\s)*[+-]?(0|[1-9][0-9]*)([Ee][+-]?[0-9]+)?(\\s)*";
    public static final Pattern PATTERN = Pattern.compile("(\\s)*[+-]?(0|[1-9][0-9]*)([Ee][+-]?[0-9]+)?(\\s)*");
    private static boolean priorRegexStackOverflowFound = false;
    private int SFInt32 = 0;

    public static final boolean isArray() {
        return false;
    }

    public SFInt32() {
        this.initialize();
    }

    @Override
    public final void initialize() {
        this.SFInt32 = 0;
    }

    public boolean equals(SFInt32 comparisonSFInt32) {
        return this.getPrimitiveValue() == comparisonSFInt32.getPrimitiveValue();
    }

    public final String validate() {
        SFInt32 tempHold = new SFInt32(this.getPrimitiveValue());
        if (!this.equals(tempHold)) {
            return "SFInt32 validate() error: failed get/set round-trip test";
        }
        return "";
    }

    public final String validateRegex() {
        try {
            Matcher m = PATTERN.matcher(this.toString());
            if (!m.matches()) {
                String errorNotice = "*** Regular expression (regex) failure, new SFInt32 PATTERN mismatch (\"" + this.toString() + "\")";
                return errorNotice;
            }
        }
        catch (StackOverflowError soe) {
            String validationMessage = "java.lang.StackOverflow warning: regular expression (regex) unable to evaluate large corresponding String value for SFInt32";
            validationResult.append(validationMessage).append("\n");
            System.out.println("*** " + validationMessage);
            return validationMessage;
        }
        return "";
    }

    public final boolean matches() {
        try {
            Matcher m = PATTERN.matcher(this.toString());
            return m.matches();
        }
        catch (StackOverflowError soe) {
            String validationMessage = "java.lang.StackOverflow warning: regular expression (regex) unable to evaluate large corresponding String value for SFInt32";
            validationResult.append(validationMessage).append("\n");
            System.out.println("*** " + validationMessage);
            return false;
        }
    }

    public static final boolean matches(String value) {
        Matcher m = PATTERN.matcher(value);
        return m.matches();
    }

    public SFInt32 setValueByString(String newValue) throws InvalidFieldValueException {
        if (newValue == null) {
            newValue = new String();
        }
        if (!org.web3d.x3d.jsail.fields.SFInt32.matches(newValue)) {
            String errorNotice = "*** Regular expression (regex) failure, new SFInt32(" + newValue + ")";
            validationResult.append(errorNotice).append("\n");
        }
        if (newValue.trim().isEmpty()) {
            this.SFInt32 = 0;
            return this;
        }
        try {
            this.SFInt32 = newValue.startsWith("0x") ? Integer.decode(newValue) : Integer.parseInt(newValue);
        }
        catch (NumberFormatException e) {
            String errorNotice = "new SFInt32(" + newValue + ") " + e.getMessage();
            validationResult.append(errorNotice).append("\n");
            throw new InvalidFieldValueException(errorNotice);
        }
        return this;
    }

    public SFInt32(SFInt32 newValue) {
        if (newValue == null) {
            this.SFInt32 = 0;
            return;
        }
        this.SFInt32 = newValue.getPrimitiveValue();
    }

    public SFInt32(int newValue) {
        this.SFInt32 = newValue;
    }

    public static String toString(int value) {
        return String.valueOf(value);
    }

    @Override
    public int getValue() {
        return this.SFInt32;
    }

    public int getPrimitiveValue() {
        return this.SFInt32;
    }

    public String toString() {
        return String.valueOf(this.SFInt32);
    }

    public String toStringHexadecimal() {
        return "0x" + Integer.toHexString(this.SFInt32);
    }

    @Override
    public void setValue(int newValue) {
        this.SFInt32 = newValue;
    }

    public SFInt32 setValue(SFInt32 newValue) {
        if (newValue == null) {
            this.SFInt32 = 0;
            return this;
        }
        this.SFInt32 = newValue.getPrimitiveValue();
        return this;
    }

    public boolean isDefaultValue() {
        return this.SFInt32 == 0;
    }

    static {
        try {
            Pattern.compile(REGEX);
            if (!new SFInt32(0).matches()) {
                System.out.println("SFInt32.initialize() problem: failed to match DEFAULT_VALUE=0");
            }
        }
        catch (PatternSyntaxException exception) {
            System.out.println("Exception in SFInt32 initialization testing, regex pattern compilation failure.");
            System.out.println("REGEX=\"(\\s)*[+-]?(0|[1-9][0-9]*)([Ee][+-]?[0-9]+)?(\\s)*\"");
            System.out.println(exception.getDescription());
        }
    }
}

