/*
 * Decompiled with CFR 0.152.
 */
package org.web3d.x3d.jsail.fields;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.web3d.x3d.jsail.fields.X3DConcreteField;
import org.web3d.x3d.sai.InvalidFieldValueException;

public class SFTime
extends X3DConcreteField
implements org.web3d.x3d.sai.SFTime {
    public static final String NAME = "SFTime";
    public static final double DEFAULT_VALUE = -1.0;
    public static final String DEFAULT_VALUE_STRING = "-1.0";
    public static final int TUPLE_SIZE = 1;
    public static final String REGEX = "(\\s)*([+-]?((0|[1-9][0-9]*)(\\.[0-9]*)?|\\.[0-9]+)([Ee][+-]?[0-9]+)?)(\\s)*";
    public static final Pattern PATTERN = Pattern.compile("(\\s)*([+-]?((0|[1-9][0-9]*)(\\.[0-9]*)?|\\.[0-9]+)([Ee][+-]?[0-9]+)?)(\\s)*");
    private static boolean priorRegexStackOverflowFound = false;
    private double SFTime = -1.0;

    public static final boolean isArray() {
        return false;
    }

    public SFTime() {
        this.initialize();
    }

    @Override
    public final void initialize() {
        this.SFTime = -1.0;
    }

    public boolean equals(SFTime comparisonSFTime) {
        return this.getPrimitiveValue() == comparisonSFTime.getPrimitiveValue();
    }

    public final String validate() {
        SFTime tempHold = new SFTime(this.getPrimitiveValue());
        if (!this.equals(tempHold)) {
            return "SFTime validate() error: failed get/set round-trip test";
        }
        return "";
    }

    public final String validateRegex() {
        try {
            Matcher m = PATTERN.matcher(this.toString());
            if (!m.matches()) {
                String errorNotice = "*** Regular expression (regex) failure, new SFTime PATTERN mismatch (\"" + this.toString() + "\")";
                return errorNotice;
            }
        }
        catch (StackOverflowError soe) {
            String validationMessage = "java.lang.StackOverflow warning: regular expression (regex) unable to evaluate large corresponding String value for SFTime";
            validationResult.append(validationMessage).append("\n");
            System.out.println("*** " + validationMessage);
            return validationMessage;
        }
        return "";
    }

    public final boolean matches() {
        try {
            Matcher m = PATTERN.matcher(this.toString());
            return m.matches();
        }
        catch (StackOverflowError soe) {
            String validationMessage = "java.lang.StackOverflow warning: regular expression (regex) unable to evaluate large corresponding String value for SFTime";
            validationResult.append(validationMessage).append("\n");
            System.out.println("*** " + validationMessage);
            return false;
        }
    }

    public static final boolean matches(String value) {
        Matcher m = PATTERN.matcher(value);
        return m.matches();
    }

    public SFTime setValueByString(String newValue) throws InvalidFieldValueException {
        if (newValue == null) {
            newValue = new String();
        }
        if (!org.web3d.x3d.jsail.fields.SFTime.matches(newValue)) {
            String errorNotice = "*** Regular expression (regex) failure, new SFTime(" + newValue + ")";
            validationResult.append(errorNotice).append("\n");
        }
        if (newValue.trim().isEmpty()) {
            this.SFTime = -1.0;
            return this;
        }
        try {
            this.SFTime = Double.parseDouble(newValue);
        }
        catch (NumberFormatException e) {
            String errorNotice = "new SFTime(" + newValue + ") " + e.getMessage();
            validationResult.append(errorNotice).append("\n");
            throw new InvalidFieldValueException(errorNotice);
        }
        return this;
    }

    public SFTime(SFTime newValue) {
        if (newValue == null) {
            this.SFTime = -1.0;
            return;
        }
        this.SFTime = newValue.getPrimitiveValue();
    }

    public SFTime(double newValue) {
        if (newValue < 0.0 && newValue != -1.0) {
            this.SFTime = -1.0;
            return;
        }
        this.SFTime = newValue;
    }

    public SFTime(float newValue) {
        this.SFTime = newValue;
        if (this.SFTime < 0.0 && this.SFTime != -1.0) {
            this.SFTime = -1.0;
        }
    }

    public SFTime(int newValue) {
        this.SFTime = newValue;
        if (this.SFTime < 0.0 && this.SFTime != -1.0) {
            this.SFTime = -1.0;
        }
    }

    public static String toString(double value) {
        return String.valueOf(value);
    }

    @Override
    public double getValue() {
        return this.SFTime;
    }

    public double getPrimitiveValue() {
        return this.SFTime;
    }

    public String toString() {
        return String.valueOf(this.SFTime);
    }

    @Override
    public void setValue(double newValue) {
        this.SFTime = newValue;
    }

    @Override
    public long getJavaValue() {
        return (long)this.SFTime;
    }

    @Override
    public void setValue(long newValue) {
        this.SFTime = newValue;
        if (this.SFTime < 0.0 && this.SFTime != -1.0) {
            this.SFTime = -1.0;
        }
    }

    public SFTime setValue(float newValue) {
        this.SFTime = newValue;
        return this;
    }

    public SFTime setValue(int newValue) {
        this.SFTime = newValue;
        return this;
    }

    public String stripTrailingZeroes() {
        return org.web3d.x3d.jsail.fields.SFTime.stripTrailingZeroes(this.getValue());
    }

    public static String stripTrailingZeroes(double value) {
        String stringValue = String.valueOf(value);
        if (stringValue.contains(".") && !stringValue.contains("E") && !stringValue.contains("e")) {
            return stringValue.replaceAll("[0]*$", "").replaceAll("\\.$", "");
        }
        return stringValue;
    }

    public SFTime setValue(SFTime newValue) {
        if (newValue == null) {
            this.SFTime = -1.0;
            return this;
        }
        this.SFTime = newValue.getPrimitiveValue();
        return this;
    }

    public boolean isDefaultValue() {
        return this.SFTime == -1.0;
    }

    static {
        try {
            Pattern.compile(REGEX);
            if (!new SFTime(-1.0).matches()) {
                System.out.println("SFTime.initialize() problem: failed to match DEFAULT_VALUE=-1.0");
            }
        }
        catch (PatternSyntaxException exception) {
            System.out.println("Exception in SFTime initialization testing, regex pattern compilation failure.");
            System.out.println("REGEX=\"(\\s)*([+-]?((0|[1-9][0-9]*)(\\.[0-9]*)?|\\.[0-9]+)([Ee][+-]?[0-9]+)?)(\\s)*\"");
            System.out.println(exception.getDescription());
        }
    }
}

