/*
 * Decompiled with CFR 0.152.
 */
package org.web3d.x3d.sai;

import java.applet.Applet;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Map;
import java.util.Properties;
import org.web3d.x3d.sai.BrowserFactoryImpl;
import org.web3d.x3d.sai.ConnectionException;
import org.web3d.x3d.sai.ExternalBrowser;
import org.web3d.x3d.sai.NoSuchBrowserException;
import org.web3d.x3d.sai.NotSupportedException;
import org.web3d.x3d.sai.X3DComponent;
import org.web3d.x3d.sai.X3DException;

public class BrowserFactory {
    private static final String PROPERTIES_FILE_NAME = "x3d.properties";
    private static final String FACTORY_CLASS = "x3d.sai.factory.class";
    private static final String XJ3D_PROPERTIES_FILE = "config/3.0/spec/x3d.properties";
    private static final String DEFAULT_FACTORY_CLASS = "org.web3d.x3d.sai.DefaultBrowserImpl";
    private static final String NULL_BROWSER_FACTORY_IMPL_ERR_MSG = "Provided factory is null";
    private static final String FACTORY_ALREADY_DEFINED_ERR_MSG = "Factory already defined";
    private static final String FACTORY_CLASS_NOT_FOUND_ERR_MSG = "Unable to find X3D player factory implementation\n";
    private static final String UNABLE_TO_INSTANTIATE_FACTORY_ERR_MSG = "Error instantiating the X3D player factory\n";
    private static final String CLASS_NOT_A_BROWSER_FACTORY_IMPL_ERR_MSG = "The nominated browser factory is not an instance of ";
    private static final String BROWSER_FACTORY_IMPL_INTERFACE_CLASSNAME = "org.web3d.x3d.sai.BrowserFactoryImpl";
    private static BrowserFactoryImpl factory = null;
    private static final Properties vrml_properties = new Properties();

    private BrowserFactory() {
    }

    public static synchronized void setBrowserFactoryImpl(BrowserFactoryImpl fac) throws IllegalArgumentException, X3DException, SecurityException {
        if (fac == null) {
            String errorNotice = NULL_BROWSER_FACTORY_IMPL_ERR_MSG;
            throw new IllegalArgumentException(errorNotice);
        }
        if (factory != null) {
            String errorNotice = FACTORY_ALREADY_DEFINED_ERR_MSG;
            throw new X3DException(errorNotice);
        }
        SecurityManager security = System.getSecurityManager();
        if (security != null) {
            security.checkSetFactory();
        }
        factory = fac;
    }

    public static X3DComponent createX3DComponent(Map<String, Object> params) throws NotSupportedException {
        X3DComponent comp = null;
        try {
            if (factory == null) {
                BrowserFactory.loadFactoryImpl();
            }
        }
        catch (NotSupportedException nse) {
            System.out.println("Tracing exception for debug:   Factory: " + factory);
            nse.printStackTrace(System.out);
            throw nse;
        }
        return comp;
    }

    public static ExternalBrowser getBrowser(Applet applet) throws NotSupportedException, NoSuchBrowserException, ConnectionException {
        if (factory == null) {
            BrowserFactory.loadFactoryImpl();
        }
        return null;
    }

    public static ExternalBrowser getBrowser(Applet applet, String frameName, int index) throws NotSupportedException, NoSuchBrowserException, ConnectionException {
        if (factory == null) {
            BrowserFactory.loadFactoryImpl();
        }
        return null;
    }

    public static ExternalBrowser getBrowser(InetAddress address, int port) throws NotSupportedException, NoSuchBrowserException, UnknownHostException, ConnectionException {
        if (factory == null) {
            BrowserFactory.loadFactoryImpl();
        }
        return null;
    }

    private static void loadFactoryImpl() {
        try {
            String factory_class_name = vrml_properties.getProperty(FACTORY_CLASS, DEFAULT_FACTORY_CLASS);
            Class<?> factory_class = Class.forName(factory_class_name);
            factory = (BrowserFactoryImpl)factory_class.newInstance();
        }
        catch (ClassNotFoundException cnfe) {
            System.out.println(FACTORY_CLASS_NOT_FOUND_ERR_MSG);
        }
        catch (InstantiationException ie) {
            System.out.println(UNABLE_TO_INSTANTIATE_FACTORY_ERR_MSG);
        }
        catch (IllegalAccessException iae) {
            System.out.println(iae);
        }
        catch (ClassCastException cce) {
            System.out.println("The nominated browser factory is not an instance of org.web3d.x3d.sai.BrowserFactoryImpl");
        }
    }

    static {
        String factory_class_name = AccessController.doPrivileged(new PrivilegedAction<String>(){

            @Override
            public String run() {
                return System.getProperty(BrowserFactory.FACTORY_CLASS);
            }
        });
        if (factory_class_name != null) {
            vrml_properties.put(FACTORY_CLASS, factory_class_name);
        } else {
            InputStream propertiesFileInputstream = null;
            try {
                propertiesFileInputstream = AccessController.doPrivileged(new PrivilegedAction<InputStream>(){

                    @Override
                    public InputStream run() {
                        return ClassLoader.getSystemResourceAsStream(BrowserFactory.PROPERTIES_FILE_NAME);
                    }
                });
                if (propertiesFileInputstream == null) {
                    propertiesFileInputstream = BrowserFactory.class.getClassLoader().getResourceAsStream(PROPERTIES_FILE_NAME);
                }
                if (propertiesFileInputstream == null) {
                    propertiesFileInputstream = AccessController.doPrivileged(new PrivilegedAction<InputStream>(){

                        @Override
                        public InputStream run() {
                            return ClassLoader.getSystemResourceAsStream(BrowserFactory.XJ3D_PROPERTIES_FILE);
                        }
                    });
                }
                if (propertiesFileInputstream == null) {
                    propertiesFileInputstream = BrowserFactory.class.getClassLoader().getResourceAsStream(XJ3D_PROPERTIES_FILE);
                }
                if (propertiesFileInputstream == null) {
                    vrml_properties.put(FACTORY_CLASS, DEFAULT_FACTORY_CLASS);
                } else {
                    vrml_properties.load(propertiesFileInputstream);
                }
            }
            catch (IOException ioe) {
                System.out.println(ioe);
            }
            finally {
                try {
                    propertiesFileInputstream.close();
                }
                catch (IOException iOException) {}
            }
        }
    }
}

