/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.geo.map;

import com.macrofocus.data.DataModel;
import com.macrofocus.geo.map.LayerModel;
import com.macrofocus.geo.map.Point;
import com.macrofocus.geo.map.SimplePoint;
import java.awt.geom.Rectangle2D;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

public class DataModelLayerModel
implements LayerModel<Point>,
Serializable {
    private final DataModel dataModel;
    private List<Point> points;
    private Rectangle2D bounds;

    public DataModelLayerModel(DataModel dataModel, int latitude, int longitude) {
        this.dataModel = dataModel;
        this.points = new ArrayList<Point>();
        for (int row = 0; row < dataModel.getRowCount(); ++row) {
            if (dataModel.isAvailable(row, latitude) && dataModel.isAvailable(row, longitude)) {
                double lat = ((Number)dataModel.getValueAt(row, latitude)).doubleValue();
                double lon = ((Number)dataModel.getValueAt(row, longitude)).doubleValue();
                SimplePoint point = new SimplePoint(lon * 100000.0, lat * 100000.0);
                this.addGeometry(point);
                continue;
            }
            this.addGeometry(null);
        }
    }

    private void addGeometry(Point polygon) {
        if (this.bounds == null) {
            Rectangle2D b = polygon.getBounds();
            this.bounds = new Rectangle2D.Double(b.getMinX(), b.getMinY(), b.getWidth(), b.getHeight());
        }
        if (polygon != null) {
            this.bounds.add(polygon.getBounds());
        }
        this.points.add(polygon);
    }

    @Override
    public String getName() {
        return "Points";
    }

    @Override
    public Rectangle2D getBounds() {
        return this.bounds;
    }

    @Override
    public Iterable<Point> getGeometries() {
        return this.points;
    }

    @Override
    public Point getGeometry(int index) {
        return this.points.get(index);
    }

    @Override
    public int getGeometryCount() {
        return this.points.size();
    }

    @Override
    public DataModel getDataModel() {
        return this.dataModel;
    }
}

