/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.geo.map;

import com.macrofocus.geo.map.LayerModel;
import com.macrofocus.geo.map.LayerView;
import com.macrofocus.geo.map.Point;
import com.macrofocus.geo.map.Polygon;
import com.macrofocus.util.file.filter.PostscriptFileFilter;
import com.macrofocus.util.swing.MFileChooser;
import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.geom.Rectangle2D;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import javax.swing.AbstractAction;
import javax.swing.filechooser.FileFilter;

public class PostscriptPrintAction
extends AbstractAction {
    private LayerView view;
    private File file;

    public PostscriptPrintAction(LayerView view) {
        this(view, null);
    }

    public PostscriptPrintAction(LayerView view, File file) {
        super("Export to Postscript...");
        this.view = view;
        this.file = file;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void actionPerformed(ActionEvent e) {
        if (this.file == null) {
            MFileChooser fileChooser = new MFileChooser(new File(System.getProperty("user.dir")));
            fileChooser.setFileSelectionMode(0);
            fileChooser.setAcceptAllFileFilterUsed(false);
            fileChooser.setControlButtonsAreShown(true);
            PostscriptFileFilter defaultFileFilter = new PostscriptFileFilter();
            fileChooser.addChoosableFileFilter((FileFilter)defaultFileFilter);
            int value = fileChooser.showSaveDialog(this.view);
            this.file = value == 0 ? fileChooser.getSelectedFile() : null;
        }
        if (this.file != null) {
            double addy;
            double addx;
            double conv;
            LayerModel layer = this.view.getLayerModel();
            Rectangle2D bounds = layer.getBounds();
            if (11.0 * bounds.getWidth() > 8.5 * bounds.getHeight()) {
                conv = 612.0 / bounds.getWidth();
                addx = 0.0;
                addy = 396.0 - 306.0 * bounds.getHeight() / bounds.getWidth();
            } else {
                conv = 792.0 / bounds.getHeight();
                addx = 306.0 - 396.0 * bounds.getWidth() / bounds.getHeight();
                addy = 0.0;
            }
            try {
                BufferedWriter outfile = new BufferedWriter(new FileWriter(this.file));
                outfile.write("0.001 setlinewidth\n");
                for (int i = 0; i < layer.getGeometryCount(); ++i) {
                    Polygon polygon = (Polygon)layer.getGeometry(i);
                    Color color = this.view.getPolygonRenderer().getColor(polygon, i, layer);
                    if (color == null) continue;
                    Point p0 = polygon.getPoint(0);
                    double xcoord = p0.getX();
                    double ycoord = p0.getY();
                    outfile.write("newpath\n");
                    outfile.write((xcoord - bounds.getMinX()) * conv + addx + " ");
                    outfile.write((ycoord - bounds.getMinY()) * conv + addy + " ");
                    outfile.write("moveto\n");
                    for (int j = 1; j < polygon.getPointCount(); ++j) {
                        Point point = polygon.getPoint(j);
                        xcoord = point.getX();
                        ycoord = point.getY();
                        outfile.write((xcoord - bounds.getMinX()) * conv + addx + " ");
                        outfile.write((ycoord - bounds.getMinY()) * conv + addy + " ");
                        outfile.write("lineto\n");
                    }
                    double r = (double)color.getRed() / 255.0;
                    double g = (double)color.getGreen() / 255.0;
                    double b = (double)color.getBlue() / 255.0;
                    outfile.write("closepath\n");
                    outfile.write(r + " " + g + " " + b + " ");
                    outfile.write("setrgbcolor\ngsave\nfill\ngrestore\n0 setgray stroke\n");
                }
                outfile.write("showpage\n");
                outfile.flush();
                outfile.close();
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
            finally {
                this.file = null;
            }
        }
    }
}

