/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.geo.map;

import com.macrofocus.geo.map.LayerModel;
import com.macrofocus.geo.map.LayerView;
import com.macrofocus.geo.map.Polygon;
import com.macrofocus.util.java2d.RenderingHintsModel;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Point2D;

public class SimpleLayerView
extends LayerView {
    private final LayerModel<? extends Polygon> layer;
    private final boolean maintainAspectRatio = true;
    private LayerView.PolygonRenderer polygonRenderer = new DefaultPolygonRenderer();
    private final RenderingHintsModel renderingHintsModel;

    public SimpleLayerView(LayerModel layer, RenderingHintsModel renderingHintsModel) {
        this.layer = layer;
        this.renderingHintsModel = renderingHintsModel;
    }

    @Override
    public LayerModel getLayerModel() {
        return this.layer;
    }

    @Override
    protected void paintComponent(Graphics graphics) {
        super.paintComponent(graphics);
        Graphics2D g2 = (Graphics2D)graphics;
        Dimension d = this.getSize();
        g2.setRenderingHints(this.renderingHintsModel.getRenderingHints());
        if (this.layer.getBounds() != null) {
            if (g2.getTransform() != null) {
                AffineTransform transform = g2.getTransform();
                transform.concatenate(this.worldToScreenTransform(this.layer, d));
                g2.setTransform(transform);
            } else {
                g2.setTransform(this.worldToScreenTransform(this.layer, d));
            }
            g2.setColor(Color.black);
            int row = 0;
            for (Polygon polygon : this.layer.getGeometries()) {
                this.polygonRenderer.paint(g2, polygon, row, this.layer);
                ++row;
            }
        } else {
            System.err.println("Empty layer " + this.layer.getGeometryCount());
        }
    }

    @Override
    public int getRow(int x, int y) {
        int r = -1;
        if (this.layer.getBounds() != null) {
            AffineTransform af = this.worldToScreenTransform(this.layer, this.getSize());
            Point2D.Double p = new Point2D.Double(x, y);
            try {
                Point2D point = af.inverseTransform(p, null);
                int row = 0;
                for (Polygon polygon : this.layer.getGeometries()) {
                    Shape shape = polygon.getShape();
                    if (shape.contains(point)) {
                        return row;
                    }
                    ++row;
                }
            }
            catch (NoninvertibleTransformException e) {
                e.printStackTrace();
            }
        }
        return r;
    }

    public AffineTransform worldToScreenTransform(LayerModel layer, Dimension screenSize) {
        double scale;
        double scaleY;
        double oscaleX = screenSize.getWidth() / layer.getBounds().getWidth();
        double oscaleY = screenSize.getHeight() / layer.getBounds().getHeight();
        double scaleX = scaleY = (scale = Math.min(oscaleX, oscaleY));
        double tx = -layer.getBounds().getMinX() * scaleX + layer.getBounds().getWidth() * ((oscaleX - scaleX) / 2.0);
        double ty = layer.getBounds().getMinY() * scaleY + screenSize.getHeight() - layer.getBounds().getHeight() * ((oscaleY - scaleY) / 2.0);
        AffineTransform at = new AffineTransform(scaleX, 0.0, 0.0, -scaleY, tx, ty);
        return at;
    }

    @Override
    public void setPolygonRenderer(LayerView.PolygonRenderer polygonRenderer) {
        this.polygonRenderer = polygonRenderer;
        this.repaint();
    }

    @Override
    public LayerView.PolygonRenderer getPolygonRenderer() {
        return this.polygonRenderer;
    }

    public class DefaultPolygonRenderer
    implements LayerView.PolygonRenderer {
        @Override
        public Color getColor(Polygon polygon, int row, LayerModel layerModel) {
            return Color.black;
        }

        @Override
        public void paint(Graphics2D g, Polygon polygon, int row, LayerModel layerModel) {
            Shape shape = polygon.getShape();
            g.setColor(this.getColor(polygon, row, layerModel));
            g.draw(shape);
        }
    }
}

