/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.geo.model;

import com.macrofocus.color.BtyColormapModel;
import com.macrofocus.color.ColormapModel;
import com.macrofocus.colormap.ColorMap;
import com.macrofocus.common.selection.MutableSelection;
import com.macrofocus.common.selection.MutableSingleSelection;
import com.macrofocus.common.selection.SimpleSelection;
import com.macrofocus.common.selection.SimpleSingleSelection;
import com.macrofocus.data.table.Column;
import com.macrofocus.data.table.Row;
import com.macrofocus.data.table.RowFactory;
import com.macrofocus.data.table.TableStatistics;
import com.macrofocus.filter.MutableFilter;
import com.macrofocus.filter.SimpleFilter;
import com.macrofocus.geo.model.GeoListener;
import com.macrofocus.geo.model.GeoModel;
import com.macrofocus.util.range.MBoundedRangeModel;
import com.macrofocus.util.range.SimpleBoundedRangeModel;
import java.awt.Image;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.table.TableModel;
import org.locationtech.jts.geom.CoordinateFilter;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.Geometry;

public class SimpleGeoModel
implements GeoModel {
    protected final TableModel tableModel;
    private final TableStatistics tableStatistics;
    private int geometryColumn = -1;
    protected Rectangle2D.Double bounds = null;
    private MutableSingleSelection<Row> probing;
    private MutableSelection<Row> selection;
    private MutableFilter<Row> filter;
    private MutableSingleSelection<Column> colorColumn;
    private MutableSingleSelection<Column> imageColumn;
    private MutableSingleSelection<Column> labelColumn;
    private Map<Column, MBoundedRangeModel> colorRangeModels;
    private Map<Column, ColorMap> columColormap;
    private final MutableSingleSelection<ColormapModel> colormap = new SimpleSingleSelection();
    protected final List<GeoListener> listeners;

    public SimpleGeoModel(TableModel tableModel) {
        this.tableModel = tableModel;
        this.tableStatistics = new TableStatistics(tableModel);
        for (int c = 0; c < tableModel.getColumnCount(); ++c) {
            if (!Geometry.class.isAssignableFrom(tableModel.getColumnClass(c))) continue;
            this.setGeometryColumn(c);
            break;
        }
        this.probing = new SimpleSingleSelection();
        this.selection = new SimpleSelection();
        this.filter = new SimpleFilter();
        this.colorColumn = new SimpleSingleSelection();
        this.imageColumn = new SimpleSingleSelection();
        this.labelColumn = new SimpleSingleSelection();
        this.columColormap = new HashMap<Column, ColorMap>();
        this.colorRangeModels = new HashMap<Column, MBoundedRangeModel>();
        this.colormap.setSelected((Object)new BtyColormapModel());
        this.listeners = new ArrayList<GeoListener>();
    }

    @Override
    public void setGeometryColumn(int geometryColumn) {
        if (this.geometryColumn != geometryColumn) {
            this.geometryColumn = geometryColumn;
            this.updateBounds();
        }
    }

    protected void updateBounds() {
        this.bounds = null;
        for (int r = 0; r < this.getRowCount(); ++r) {
            Geometry g = this.getGeometry(r);
            if (g == null) continue;
            try {
                Envelope e = g.getEnvelopeInternal();
                if (e.isNull()) continue;
                if (this.bounds != null) {
                    this.bounds.add(e.getMinX(), e.getMinY());
                    this.bounds.add(e.getMaxX(), e.getMaxY());
                    continue;
                }
                this.bounds = new Rectangle2D.Double(e.getMinX(), e.getMinY(), e.getWidth(), e.getHeight());
                continue;
            }
            catch (NullPointerException e) {
                System.err.println(g);
                e.printStackTrace();
            }
        }
    }

    @Override
    public Geometry getGeometry(int row) {
        return (Geometry)this.tableModel.getValueAt(row, this.geometryColumn);
    }

    @Override
    public Image getImage(int row) {
        return (Image)this.tableModel.getValueAt(row, ((Column)this.imageColumn.getSelected()).getColumn());
    }

    @Override
    public int getRowCount() {
        return this.tableModel.getRowCount();
    }

    @Override
    public int getColumnCount() {
        return this.tableModel.getColumnCount();
    }

    @Override
    public Rectangle2D.Double getBounds() {
        return this.bounds;
    }

    @Override
    public Row getRow(int row) {
        return RowFactory.createRow((TableModel)this.tableModel, (int)row);
    }

    @Override
    public Column findColumn(String name) {
        for (int c = 0; c < this.tableModel.getColumnCount(); ++c) {
            String n = this.tableModel.getColumnName(c);
            if (!n.equalsIgnoreCase(name)) continue;
            return this.getColumn(c);
        }
        return null;
    }

    @Override
    public Column getColumn(int column) {
        return new Column(this.tableModel, column);
    }

    @Override
    public TableModel getTableModel() {
        return this.tableModel;
    }

    @Override
    public MutableSingleSelection<Column> getColorColumn() {
        return this.colorColumn;
    }

    @Override
    public MutableSingleSelection<Column> getImageColumn() {
        return this.imageColumn;
    }

    @Override
    public MutableSingleSelection<Column> getLabelColumn() {
        return this.labelColumn;
    }

    @Override
    public ColorMap getColormap(Column column) {
        if (this.columColormap.containsKey(column)) {
            return this.columColormap.get(column);
        }
        return null;
    }

    @Override
    public void setColormap(Column column, ColorMap colormap) {
        this.columColormap.put(column, colormap);
    }

    @Override
    public MBoundedRangeModel getColorRangeModel(Column column) {
        if (this.colorRangeModels.containsKey(column)) {
            return this.colorRangeModels.get(column);
        }
        Number minNumber = this.tableStatistics.getValue(column, TableStatistics.MIN);
        Number maxNumber = this.tableStatistics.getValue(column, TableStatistics.MAX);
        if (minNumber != null && maxNumber != null) {
            double min = minNumber.doubleValue();
            double max = maxNumber.doubleValue();
            SimpleBoundedRangeModel rangeModel = new SimpleBoundedRangeModel(min, max - min, min, max);
            this.colorRangeModels.put(column, (MBoundedRangeModel)rangeModel);
            return rangeModel;
        }
        return null;
    }

    @Override
    public MutableSingleSelection<ColormapModel> getColormap() {
        return this.colormap;
    }

    @Override
    public MutableSingleSelection<Row> getProbing() {
        return this.probing;
    }

    @Override
    public MutableSelection<Row> getSelection() {
        return this.selection;
    }

    @Override
    public MutableFilter<Row> getFilter() {
        return this.filter;
    }

    @Override
    public void apply(int column, CoordinateFilter coordinateFilter) {
        for (int row = 0; row < this.getRowCount(); ++row) {
            Geometry geometry = (Geometry)this.tableModel.getValueAt(row, column);
            geometry.apply(coordinateFilter);
            geometry.geometryChanged();
        }
        this.updateBounds();
    }

    @Override
    public void apply(CoordinateFilter coordinateFilter) {
        for (int row = 0; row < this.getRowCount(); ++row) {
            Geometry geometry = (Geometry)this.tableModel.getValueAt(row, this.geometryColumn);
            System.err.println("Old: " + geometry);
            geometry.apply(coordinateFilter);
            System.err.println("New: " + geometry);
            geometry.geometryChanged();
        }
        this.updateBounds();
    }

    @Override
    public void addListener(GeoListener treeMapListener) {
        this.listeners.add(treeMapListener);
    }

    @Override
    public void removeListener(GeoListener treeMapListener) {
        this.listeners.remove(treeMapListener);
    }
}

