/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.application.document.swing;

import com.macrofocus.application.AbstractToggleUICommand;
import com.macrofocus.common.properties.MutableProperty;
import com.macrofocus.common.properties.PropertyEvent;
import com.macrofocus.common.properties.PropertyListener;
import com.macrofocus.common.properties.SimpleProperty;
import java.awt.GraphicsDevice;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import javax.swing.JFrame;

public class FullScreenCommand
extends AbstractToggleUICommand {
    private FullScreenWindowAdapter fullScreenWindowListener = null;

    public FullScreenCommand(final JFrame window) {
        super((MutableProperty)new SimpleProperty((Object)"Full Screen"), null);
        final boolean macOSFullscreenEnabled = FullScreenCommand.enableOSXFullscreen(window);
        this.enabledProperty().setValue((Object)window.getGraphicsConfiguration().getDevice().isFullScreenSupported());
        this.toggleProperty().setValue((Object)Boolean.FALSE);
        this.toggleProperty().addPropertyListener((PropertyListener)new PropertyListener<Boolean>(){

            public void propertyChanged(PropertyEvent<Boolean> event) {
                if (macOSFullscreenEnabled && FullScreenCommand.requestOSXFullscreen(window)) {
                    GraphicsDevice gd = window.getGraphicsConfiguration().getDevice();
                    if (((Boolean)FullScreenCommand.this.toggleProperty().getValue()).booleanValue()) {
                        window.getRootPane().setWindowDecorationStyle(0);
                        if (Toolkit.getDefaultToolkit().isFrameStateSupported(6)) {
                            window.setExtendedState(6);
                        } else {
                            window.setState(0);
                        }
                    } else {
                        window.getRootPane().setWindowDecorationStyle(1);
                        window.setState(0);
                    }
                } else {
                    GraphicsDevice gd = window.getGraphicsConfiguration().getDevice();
                    if (((Boolean)FullScreenCommand.this.toggleProperty().getValue()).booleanValue()) {
                        window.setState(0);
                        gd.setFullScreenWindow(window);
                        FullScreenCommand.this.fullScreenWindowListener = new FullScreenWindowAdapter();
                        window.addWindowListener(FullScreenCommand.this.fullScreenWindowListener);
                    } else {
                        window.setState(0);
                        gd.setFullScreenWindow(null);
                        window.removeWindowListener(FullScreenCommand.this.fullScreenWindowListener);
                        FullScreenCommand.this.fullScreenWindowListener = null;
                    }
                }
            }
        });
    }

    private static boolean enableOSXFullscreen(Window window) {
        try {
            Class<?> fullscreenClass = Class.forName("com.apple.eawt.FullScreenUtilities");
            Method setFullscreen = fullscreenClass.getMethod("setWindowCanFullScreen", Window.class, Boolean.TYPE);
            setFullscreen.invoke(null, window, true);
            return true;
        }
        catch (ClassNotFoundException | IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException ex) {
            return false;
        }
    }

    private static boolean requestOSXFullscreen(Window window) {
        try {
            Class<?> appClass = Class.forName("com.apple.eawt.Application");
            Class[] params = new Class[]{};
            Method getApplication = appClass.getMethod("getApplication", params);
            Object application = getApplication.invoke(appClass, new Object[0]);
            Method requestToggleFulLScreen = application.getClass().getMethod("requestToggleFullScreen", Window.class);
            requestToggleFulLScreen.invoke(application, window);
            return true;
        }
        catch (ClassNotFoundException | IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException ex) {
            return false;
        }
    }

    public class FullScreenWindowAdapter
    extends WindowAdapter {
        @Override
        public void windowIconified(WindowEvent we) {
            FullScreenCommand.this.toggleProperty().setValue((Object)Boolean.FALSE);
        }
    }
}

