/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.application.file;

import com.macrofocus.application.file.CPFileChooser;
import com.macrofocus.common.file.FileType;
import com.macrofocus.util.file.filter.AbstractFileFilter;
import com.macrofocus.util.swing.MFileChooser;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.filechooser.FileFilter;

public class SwingFileChooser
implements CPFileChooser<JFrame, File> {
    private final JFileChooser fileChooser;
    private Map<FileFilter, FileType> map = new HashMap<FileFilter, FileType>();
    private Map<FileType, FileFilter> reverseMap = new HashMap<FileType, FileFilter>();

    public SwingFileChooser() {
        this.fileChooser = new MFileChooser();
        this.fileChooser.setFileSelectionMode(0);
        this.fileChooser.setAcceptAllFileFilterUsed(false);
        this.fileChooser.setControlButtonsAreShown(true);
    }

    public void setTitle(String title) {
        this.fileChooser.setDialogTitle(title);
    }

    public File showOpenDialog(JFrame window) {
        int accept = this.fileChooser.showOpenDialog(window);
        if (accept == 0) {
            return this.fileChooser.getSelectedFile();
        }
        return null;
    }

    public File showSaveDialog(JFrame window) {
        int accept = this.fileChooser.showSaveDialog(window);
        if (accept == 0) {
            return this.fileChooser.getSelectedFile();
        }
        return null;
    }

    public void setFileTypes(FileType ... fileTypes) {
        this.fileChooser.resetChoosableFileFilters();
        this.map.clear();
        this.reverseMap.clear();
        AbstractFileFilter first = null;
        for (final FileType fileType : fileTypes) {
            String[] extensionFilters = new String[fileType.getExtensions().length];
            for (int i = 0; i < extensionFilters.length; ++i) {
                extensionFilters[i] = "*." + fileType.getExtensions()[i];
            }
            AbstractFileFilter filter = new AbstractFileFilter(){

                public String[] getExtensions() {
                    return fileType.getExtensions();
                }

                public String getDefaultExtension() {
                    return fileType.getExtensions()[0];
                }

                public String getName() {
                    return fileType.getDescription();
                }
            };
            if (first == null) {
                first = filter;
            }
            this.fileChooser.addChoosableFileFilter((FileFilter)filter);
            this.map.put((FileFilter)filter, fileType);
            this.reverseMap.put(fileType, (FileFilter)filter);
        }
        if (first != null) {
            this.fileChooser.setFileFilter((FileFilter)first);
        }
    }

    public void setCurrentDirectory(File currentDirectory) {
        this.fileChooser.setCurrentDirectory(currentDirectory);
    }

    public void setSelectedFile(File selectedFile) {
        this.fileChooser.setSelectedFile(selectedFile);
    }

    public void setSelectedFileType(FileType fileType) {
        this.fileChooser.setFileFilter(this.reverseMap.get(fileType));
    }

    public FileType getSelectedFileType() {
        return this.map.get(this.fileChooser.getFileFilter());
    }
}

