/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.application.window;

import com.macrofocus.application.status.CPStatusBar;
import com.macrofocus.application.window.CPWindow;
import com.macrofocus.helper.ComponentCleaner;
import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JMenuBar;
import javax.swing.JPanel;

public class SwingWindow
implements CPWindow<JFrame, JComponent> {
    private final JFrame window = new JFrame();
    private JPanel nativeComponent = new JPanel();
    private JComponent menuBar;
    private JComponent content;
    private CPStatusBar<JComponent> statusBar;

    public SwingWindow() {
        this.nativeComponent.setLayout(new BorderLayout());
        this.window.getContentPane().removeAll();
        this.window.getContentPane().add(this.nativeComponent);
        this.window.getContentPane().validate();
    }

    public void setMenuBar(JComponent menuBar) {
        if (this.menuBar != menuBar) {
            if (this.menuBar != null) {
                ComponentCleaner.cleanComponent((Component)this.menuBar);
            }
            this.menuBar = menuBar;
            if (this.menuBar != null) {
                this.window.setJMenuBar((JMenuBar)menuBar);
                this.window.validate();
            }
        }
    }

    public void setContent(JComponent content) {
        if (this.content != content) {
            if (this.content != null) {
                this.nativeComponent.remove(this.content);
                ComponentCleaner.cleanComponent((Component)this.content);
            }
            this.content = content;
            if (this.content != null) {
                this.nativeComponent.add((Component)this.content, "Center");
            }
            this.nativeComponent.validate();
        }
    }

    public void setStatusBar(CPStatusBar<JComponent> statusBar) {
        if (this.statusBar != statusBar) {
            if (this.statusBar != null) {
                if (this.statusBar.getNativeComponent() != null) {
                    this.nativeComponent.remove((Component)this.statusBar.getNativeComponent());
                    ComponentCleaner.cleanComponent((Component)((Component)this.statusBar.getNativeComponent()));
                }
                this.statusBar.dispose();
            }
            this.statusBar = statusBar;
            if (this.statusBar != null && this.statusBar.getNativeComponent() != null) {
                this.nativeComponent.add((Component)this.statusBar.getNativeComponent(), "South");
            }
            this.nativeComponent.validate();
        }
    }

    public void dispose() {
        ComponentCleaner.cleanComponent((Component)this.window);
        CPStatusBar<JComponent> statusBar = this.statusBar;
        this.setMenuBar(null);
        this.setStatusBar(null);
        this.setContent(null);
        if (statusBar != null) {
            statusBar.dispose();
        }
        this.window.dispose();
    }

    public void addStyleClass(String ... styleClasses) {
    }

    public void setStyleClass(String ... styleClasses) {
    }

    public void removeStyleClass(String ... styleClasses) {
    }

    public JFrame getNativeWindow() {
        return this.window;
    }

    public JComponent getNativeComponent() {
        return this.nativeComponent;
    }
}

