/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.docking.swing;

import de.javasoft.docking.JYDockingPort;
import de.javasoft.docking.controls.DockingEvent;
import de.javasoft.docking.controls.DockingManager;
import de.javasoft.docking.controls.IDockable;
import de.javasoft.docking.controls.IDockableAcceptor;
import de.javasoft.docking.controls.IDockingConstants;
import de.javasoft.docking.controls.IDockingEventListener;
import de.javasoft.docking.controls.IDockingPort;
import de.javasoft.docking.controls.Perspective;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JComponent;

public class DockableComponentWrapper
implements IDockable,
IDockingConstants {
    private JComponent component;
    private String id;
    protected ArrayList<JComponent> dragSources;
    protected ArrayList<IDockingEventListener> dockingListeners;
    private boolean dockingEnabled;
    private boolean active;
    private boolean activeStateLocked;
    private String tabText;
    private Icon dockbarIcon;
    private Icon tabIcon;
    private HashMap<String, Float> regionInset;
    private HashMap<String, Float> siblingSize;
    private HashMap<String, Boolean> territoryBlocked;
    private float dragThreshold;
    private float previewSize;
    private boolean mouseMotionListenersBlockedWhileDragging;
    private IDockableAcceptor dockableAcceptor;

    public DockableComponentWrapper(JComponent paramJComponent, String paramString1, String paramString2, boolean paramBoolean) {
        if (paramString1 == null) {
            throw new IllegalArgumentException("The 'id' parameter cannot be null.");
        }
        this.component = paramJComponent;
        this.id = paramString1;
        this.setTabText(paramString2);
        this.dragSources = new ArrayList(1);
        this.dockingListeners = new ArrayList(1);
        this.initDefaults();
        if (paramBoolean) {
            this.getDragSources().add(paramJComponent);
        }
    }

    private void initDefaults() {
        this.dockingEnabled = true;
        if (this.tabText == null) {
            this.tabText = "-------";
        }
        this.dragThreshold = 4.0f;
        this.previewSize = 0.3f;
        this.mouseMotionListenersBlockedWhileDragging = true;
        this.regionInset = new HashMap();
        this.regionInset.put("NORTH", Float.valueOf(0.25f));
        this.regionInset.put("SOUTH", Float.valueOf(0.25f));
        this.regionInset.put("EAST", Float.valueOf(0.25f));
        this.regionInset.put("WEST", Float.valueOf(0.25f));
        this.siblingSize = new HashMap();
        this.territoryBlocked = new HashMap();
        this.territoryBlocked.put("NORTH", Boolean.FALSE);
        this.territoryBlocked.put("SOUTH", Boolean.FALSE);
        this.territoryBlocked.put("EAST", Boolean.FALSE);
        this.territoryBlocked.put("WEST", Boolean.FALSE);
        this.territoryBlocked.put("CENTER", Boolean.FALSE);
        this.dockableAcceptor = new IDockableAcceptor(){

            public boolean acceptDockable(IDockable paramAnonymousIDockable, String paramAnonymousString) {
                IDockingPort localIDockingPort = DockableComponentWrapper.this.getDockingPort();
                return (!(localIDockingPort instanceof JYDockingPort) || !((JYDockingPort)localIDockingPort).isRegionBlocked(paramAnonymousString)) && !DockableComponentWrapper.this.isTerritoryBlocked(paramAnonymousString);
            }
        };
    }

    public JComponent getComponent() {
        return this.component;
    }

    public String getID() {
        return this.id;
    }

    public IDockingPort getDockingPort() {
        return DockingManager.getDockingPort((IDockable)this);
    }

    public List<JComponent> getDragSources() {
        return this.dragSources;
    }

    public boolean dock(IDockable paramIDockable, Perspective paramPerspective, String paramString, float paramFloat) {
        return false;
    }

    public void addDockingListener(IDockingEventListener paramIDockingEventListener) {
        this.dockingListeners.add(paramIDockingEventListener);
    }

    public void removeDockingListener(IDockingEventListener paramIDockingEventListener) {
        this.dockingListeners.remove(paramIDockingEventListener);
    }

    public List<IDockingEventListener> getDockingListeners() {
        return this.dockingListeners;
    }

    public void setDockingEnabled(boolean paramBoolean) {
        boolean bool = this.isDockingEnabled();
        this.dockingEnabled = paramBoolean;
        this.component.firePropertyChange("dockingEnabled", bool, paramBoolean);
    }

    public boolean isDockingEnabled() {
        return this.dockingEnabled;
    }

    public void setActive(boolean paramBoolean) {
        if (!this.isActiveStateLocked() && paramBoolean != this.isActive()) {
            boolean bool = this.isActive();
            this.active = paramBoolean;
            this.component.firePropertyChange("active", bool, paramBoolean);
            this.component.repaint();
        }
    }

    public boolean isActive() {
        return this.active;
    }

    public void setActiveStateLocked(boolean paramBoolean) {
        boolean bool = this.isActiveStateLocked();
        this.activeStateLocked = paramBoolean;
        this.component.firePropertyChange("activeStateLocked", bool, paramBoolean);
    }

    public boolean isActiveStateLocked() {
        return this.activeStateLocked;
    }

    public void setTabText(String paramString) {
        this.tabText = paramString;
    }

    public String getTabText() {
        return this.tabText;
    }

    public void setDockbarIcon(Icon paramIcon) {
        this.dockbarIcon = paramIcon;
    }

    public Icon getDockbarIcon() {
        return this.dockbarIcon;
    }

    public void setTabIcon(Icon paramIcon) {
        this.tabIcon = paramIcon;
    }

    public Icon getTabIcon() {
        return this.tabIcon;
    }

    public void setRegionInset(String paramString, float paramFloat) {
        this.regionInset.put(paramString, Float.valueOf(paramFloat));
    }

    public float getRegionInset(String paramString) {
        Float localFloat = this.regionInset.get(paramString);
        return localFloat == null ? 0.0f : localFloat.floatValue();
    }

    public void setSiblingSize(String paramString, float paramFloat) {
        this.siblingSize.put(paramString, Float.valueOf(paramFloat));
    }

    public float getSiblingSize(String paramString) {
        Float localFloat = this.siblingSize.get(paramString);
        return localFloat == null ? 0.0f : localFloat.floatValue();
    }

    public void setTerritoryBlocked(String paramString, boolean paramBoolean) {
        this.territoryBlocked.put(paramString, paramBoolean);
    }

    public boolean isTerritoryBlocked(String paramString) {
        Boolean localBoolean = this.territoryBlocked.get(paramString);
        return localBoolean != null && localBoolean != false;
    }

    public void setDragTheshold(float paramFloat) {
        float f = this.getDragThreshold();
        this.dragThreshold = paramFloat;
        this.component.firePropertyChange("dragThreshold", f, paramFloat);
    }

    public float getDragThreshold() {
        return this.dragThreshold;
    }

    public void setPreviewSize(float paramFloat) {
        float f = this.getPreviewSize();
        this.previewSize = paramFloat;
        this.component.firePropertyChange("previewSize", f, paramFloat);
    }

    public float getPreviewSize() {
        return this.previewSize;
    }

    public void setMouseMotionListenersBlockedWhileDragging(boolean paramBoolean) {
        boolean bool = this.isMouseMotionListenersBlockedWhileDragging();
        this.mouseMotionListenersBlockedWhileDragging = paramBoolean;
        this.component.firePropertyChange("mouseMotionListenersBlockedWhileDragging", bool, paramBoolean);
    }

    public boolean isMouseMotionListenersBlockedWhileDragging() {
        return this.mouseMotionListenersBlockedWhileDragging;
    }

    public void setDockableAcceptor(IDockableAcceptor paramIDockableAcceptor) {
        this.dockableAcceptor = paramIDockableAcceptor;
    }

    public IDockableAcceptor getDockableAcceptor() {
        return this.dockableAcceptor;
    }

    public void dockableRegistered(DockingEvent paramDockingEvent) {
    }

    public void dockableUnregistered(DockingEvent paramDockingEvent) {
    }

    public void dockingCanceled(DockingEvent paramDockingEvent) {
    }

    public void dockingCompleted(DockingEvent paramDockingEvent) {
    }

    public void dragStarted(DockingEvent paramDockingEvent) {
    }

    public void dropStarted(DockingEvent paramDockingEvent) {
    }

    public void undockingStarted(DockingEvent paramDockingEvent) {
    }

    public void undockingCompleted(DockingEvent paramDockingEvent) {
    }
}

