/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.docking.swing;

import com.macrofocus.docking.swing.DockableComponentWrapper;
import com.macrofocus.docking.swing.DockingButton;
import com.macrofocus.docking.swing.DockingViewContentPane;
import com.macrofocus.docking.swing.DockingViewTitleBar;
import com.macrofocus.docking.swing.plaf.DockingAddon;
import de.javasoft.docking.JYDockingPort;
import de.javasoft.docking.controls.DockingEvent;
import de.javasoft.docking.controls.DockingManager;
import de.javasoft.docking.controls.DockingStrategy;
import de.javasoft.docking.controls.IDockable;
import de.javasoft.docking.controls.IDockableAcceptor;
import de.javasoft.docking.controls.IDockingConstants;
import de.javasoft.docking.controls.IDockingEventListener;
import de.javasoft.docking.controls.IDockingPort;
import de.javasoft.docking.controls.IDockingStrategy;
import de.javasoft.docking.controls.Perspective;
import de.javasoft.docking.ui.DockingViewUI;
import de.javasoft.docking.ui.addons.JYDockingAddon;
import de.javasoft.syntheticaaddons.SyntheticaAddons;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.LayoutManager2;
import java.awt.Rectangle;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import java.io.Serializable;
import java.util.List;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jdesktop.swingx.plaf.ComponentAddon;
import org.jdesktop.swingx.plaf.LookAndFeelAddons;

public class DockingView
extends JComponent
implements IDockable,
IDockingConstants {
    private static final long serialVersionUID = 1910286791529421496L;
    public static final String uiClassID = "DockingViewUI";
    protected DockingViewTitleBar titlebar;
    protected JPanel contentPane;
    protected Container userContentPane;
    private DockableComponentWrapper delegate;
    static final IDockingStrategy VIEW_DOCKING_STRATEGY;
    private boolean paintContentPaneBackground;

    public DockingView(String paramString1, String paramString2, String paramString3) {
        this.delegate = new DockableComponentWrapper(this, paramString1, paramString3, false);
        this.contentPane = new DockingViewContentPane();
        this.add(this.contentPane);
        this.setTitlebar(new DockingViewTitleBar());
        this.paintContentPaneBackground = true;
        this.setContentPane(this.createContentPane());
        super.setLayout(this.createLayout());
        this.setTitle(paramString2 == null ? "" : paramString2);
        this.addHierarchyListener(new HierarchyListener(){

            @Override
            public void hierarchyChanged(HierarchyEvent paramAnonymousHierarchyEvent) {
                DockingView.this.clearButtonRollovers();
            }
        });
        this.updateUI();
    }

    @Override
    public String getUIClassID() {
        return uiClassID;
    }

    @Override
    public void updateUI() {
        this.setUI(LookAndFeelAddons.getUI((JComponent)this, DockingViewUI.class));
    }

    public DockingViewUI getUI() {
        return (DockingViewUI)this.ui;
    }

    @Override
    protected void addImpl(Component paramComponent, Object paramObject, int paramInt) {
        if (paramComponent instanceof DockingViewTitleBar) {
            ((DockingViewTitleBar)paramComponent).setView(this);
            super.addImpl(paramComponent, paramObject, paramInt);
        } else if (paramComponent == this.contentPane) {
            super.addImpl(paramComponent, paramObject, paramInt);
        } else {
            this.getContentPane().add(paramComponent, paramObject, paramInt);
        }
    }

    @Override
    public void remove(Component paramComponent) {
        if (paramComponent == this.userContentPane) {
            this.contentPane.remove(paramComponent);
        } else {
            this.getContentPane().remove(paramComponent);
        }
    }

    protected Container createContentPane() {
        return new JPanel();
    }

    protected LayoutManager createLayout() {
        return new ViewLayout();
    }

    public void setContentPane(Container paramContainer) throws IllegalArgumentException {
        if (this.userContentPane != null) {
            this.remove(this.userContentPane);
        }
        this.userContentPane = paramContainer;
        this.contentPane.add(this.userContentPane);
    }

    public Container getContentPane() {
        return this.userContentPane;
    }

    public void setTitle(String paramString) {
        if (this.titlebar != null) {
            this.titlebar.setTitleText(paramString);
        }
    }

    public String getTitle() {
        DockingViewTitleBar localDockingViewTitlebar = this.getTitlebar();
        return localDockingViewTitlebar == null ? null : localDockingViewTitlebar.getTitleText();
    }

    public void setDraggingEnabled(boolean paramBoolean) {
        if (paramBoolean) {
            this.getDragSources().add(this.getTitlebar());
        } else {
            this.getDragSources().remove(this.getTitlebar());
        }
    }

    public boolean isDraggingEnabled() {
        return this.getDragSources().contains(this.getTitlebar());
    }

    public void setTitlebar(DockingViewTitleBar paramDockingViewTitlebar) {
        if (paramDockingViewTitlebar != null && paramDockingViewTitlebar == this.userContentPane) {
            throw new IllegalArgumentException("Cannot use the same component as both content pane and titlebar.");
        }
        if (this.titlebar != null) {
            this.remove(this.titlebar);
            this.titlebar.setView(null);
            this.getDragSources().remove(this.titlebar);
            DockingManager.removeDragListeners((JComponent)this.titlebar);
        }
        this.titlebar = paramDockingViewTitlebar;
        if (paramDockingViewTitlebar != null) {
            this.add(paramDockingViewTitlebar);
            this.setDraggingEnabled(true);
        }
    }

    public DockingViewTitleBar getTitlebar() {
        return this.titlebar;
    }

    public void addAction(Action paramAction) {
        if (this.titlebar != null) {
            this.titlebar.addAction(paramAction);
        }
    }

    public void removeAction(Action paramAction) {
        if (this.titlebar != null) {
            this.titlebar.removeAction(paramAction);
        }
    }

    public void setIcon(Icon paramIcon) {
        if (this.titlebar != null) {
            this.titlebar.setTitleIcon(paramIcon);
        }
    }

    public Icon getIcon() {
        return this.titlebar == null ? null : this.titlebar.getTitleIcon();
    }

    @Override
    public void setLayout(LayoutManager paramLayoutManager) {
        this.getContentPane().setLayout(paramLayoutManager);
    }

    @Override
    protected String paramString() {
        return "id=" + this.getID() + "," + super.paramString();
    }

    private static IDockingStrategy createDockingStrategy() {
        return new DockingStrategy(){

            protected IDockingPort createDockingPortImpl(IDockingPort paramAnonymousIDockingPort) {
                return new JYDockingPort();
            }
        };
    }

    private void clearButtonRollovers() {
        if (this.titlebar == null) {
            return;
        }
        Component[] arrayOfComponent = this.titlebar.getComponents();
        for (int i = 0; i < arrayOfComponent.length; ++i) {
            DockingButton localObject;
            DockingButton dockingButton = localObject = arrayOfComponent[i] instanceof DockingButton ? (DockingButton)arrayOfComponent[i] : null;
            if (localObject == null) continue;
            localObject.getModel().setRollover(false);
        }
    }

    public boolean dock(IDockable paramIDockable, String paramString, float paramFloat) {
        return this.delegate.dock(paramIDockable, DockingManager.getPerspectiveManager().getCurrentPerspective(), paramString, paramFloat);
    }

    public JComponent getComponent() {
        return this.delegate.getComponent();
    }

    public String getID() {
        return this.delegate.getID();
    }

    public IDockingPort getDockingPort() {
        return this.delegate.getDockingPort();
    }

    public List<JComponent> getDragSources() {
        return this.delegate.getDragSources();
    }

    public boolean dock(IDockable paramIDockable, Perspective paramPerspective, String paramString, float paramFloat) {
        return this.delegate.dock(paramIDockable, paramPerspective, paramString, paramFloat);
    }

    public void addDockingListener(IDockingEventListener paramIDockingEventListener) {
        this.delegate.addDockingListener(paramIDockingEventListener);
    }

    public void removeDockingListener(IDockingEventListener paramIDockingEventListener) {
        this.delegate.removeDockingListener(paramIDockingEventListener);
    }

    public List<IDockingEventListener> getDockingListeners() {
        return this.delegate.getDockingListeners();
    }

    public void setDockingEnabled(boolean paramBoolean) {
        this.delegate.setDockingEnabled(paramBoolean);
    }

    public boolean isDockingEnabled() {
        return this.delegate.isDockingEnabled();
    }

    public void setActive(boolean paramBoolean) {
        this.delegate.setActive(paramBoolean);
    }

    public boolean isActive() {
        return this.delegate.isActive();
    }

    public void setActiveStateLocked(boolean paramBoolean) {
        this.delegate.setActiveStateLocked(paramBoolean);
    }

    public boolean isActiveStateLocked() {
        return this.delegate.isActiveStateLocked();
    }

    public void setTabText(String paramString) {
        String str = this.getTabText();
        this.delegate.setTabText(paramString);
        this.firePropertyChange("tabText", str, paramString);
    }

    public String getTabText() {
        return this.delegate.getTabText();
    }

    public void setDockbarIcon(Icon paramIcon) {
        Icon localIcon = this.getDockbarIcon();
        this.delegate.setDockbarIcon(paramIcon);
        this.firePropertyChange("dockbarIcon", localIcon, paramIcon);
    }

    public Icon getDockbarIcon() {
        Icon localIcon = this.delegate.getDockbarIcon();
        return localIcon == null ? this.getIcon() : localIcon;
    }

    public void setTabIcon(Icon paramIcon) {
        Icon localIcon = this.getTabIcon();
        this.delegate.setTabIcon(paramIcon);
        this.firePropertyChange("tabIcon", localIcon, paramIcon);
    }

    public Icon getTabIcon() {
        Icon localIcon = this.delegate.getTabIcon();
        return localIcon == null ? this.getIcon() : localIcon;
    }

    public void setRegionInset(String paramString, float paramFloat) {
        this.delegate.setRegionInset(paramString, paramFloat);
    }

    public float getRegionInset(String paramString) {
        return this.delegate.getRegionInset(paramString);
    }

    public void setSiblingSize(String paramString, float paramFloat) {
        this.delegate.setSiblingSize(paramString, paramFloat);
    }

    public float getSiblingSize(String paramString) {
        return this.delegate.getSiblingSize(paramString);
    }

    public void setTerritoryBlocked(String paramString, boolean paramBoolean) {
        this.delegate.setTerritoryBlocked(paramString, paramBoolean);
    }

    public boolean isTerritoryBlocked(String paramString) {
        return this.delegate.isTerritoryBlocked(paramString);
    }

    public void setDockableAcceptor(IDockableAcceptor paramIDockableAcceptor) {
        IDockableAcceptor localIDockableAcceptor = this.getDockableAcceptor();
        this.delegate.setDockableAcceptor(paramIDockableAcceptor);
        this.firePropertyChange("dockableAcceptor", localIDockableAcceptor, paramIDockableAcceptor);
    }

    public IDockableAcceptor getDockableAcceptor() {
        return this.delegate.getDockableAcceptor();
    }

    public void setDragTheshold(float paramFloat) {
        this.delegate.setDragTheshold(paramFloat);
    }

    public float getDragThreshold() {
        return this.delegate.getDragThreshold();
    }

    public void setPreviewSize(float paramFloat) {
        this.delegate.setPreviewSize(paramFloat);
    }

    public float getPreviewSize() {
        return this.delegate.getPreviewSize();
    }

    public void setMouseMotionListenersBlockedWhileDragging(boolean paramBoolean) {
        this.delegate.setMouseMotionListenersBlockedWhileDragging(paramBoolean);
    }

    public boolean isMouseMotionListenersBlockedWhileDragging() {
        return this.delegate.isMouseMotionListenersBlockedWhileDragging();
    }

    public void setPaintContentPaneBackground(boolean paramBoolean) {
        this.paintContentPaneBackground = paramBoolean;
    }

    public boolean getPaintContentPaneBackground() {
        return this.paintContentPaneBackground;
    }

    public void dockableRegistered(DockingEvent paramDockingEvent) {
        this.delegate.dockableRegistered(paramDockingEvent);
    }

    public void dockableUnregistered(DockingEvent paramDockingEvent) {
        this.delegate.dockableUnregistered(paramDockingEvent);
    }

    public void dockingCanceled(DockingEvent paramDockingEvent) {
        this.delegate.dockingCanceled(paramDockingEvent);
    }

    public void dockingCompleted(DockingEvent paramDockingEvent) {
        this.delegate.dockingCompleted(paramDockingEvent);
        if (this.titlebar != null) {
            this.titlebar.revalidate();
        }
    }

    public void dragStarted(DockingEvent paramDockingEvent) {
        this.delegate.dragStarted(paramDockingEvent);
    }

    public void dropStarted(DockingEvent paramDockingEvent) {
        this.delegate.dropStarted(paramDockingEvent);
    }

    public void undockingStarted(DockingEvent paramDockingEvent) {
        this.delegate.undockingStarted(paramDockingEvent);
    }

    public void undockingCompleted(DockingEvent paramDockingEvent) {
        this.delegate.undockingCompleted(paramDockingEvent);
        this.clearButtonRollovers();
    }

    static {
        SyntheticaAddons.contribute((ComponentAddon)new JYDockingAddon());
        LookAndFeelAddons.contribute((ComponentAddon)new DockingAddon());
        VIEW_DOCKING_STRATEGY = DockingView.createDockingStrategy();
    }

    protected class ViewLayout
    implements LayoutManager2,
    Serializable {
        private static final long serialVersionUID = -785289772450064051L;

        protected ViewLayout() {
        }

        @Override
        public Dimension preferredLayoutSize(Container paramContainer) {
            Insets localInsets = DockingView.this.getInsets();
            Dimension localDimension1 = DockingView.this.contentPane != null ? DockingView.this.contentPane.getPreferredSize() : paramContainer.getSize();
            Dimension localDimension2 = DockingView.this.titlebar != null && DockingView.this.titlebar.isVisible() ? DockingView.this.titlebar.getPreferredSize() : new Dimension(0, 0);
            return new Dimension(Math.max(localDimension1.width, localDimension2.width) + localInsets.left + localInsets.right, localDimension1.height + localDimension2.height + localInsets.top + localInsets.bottom);
        }

        @Override
        public Dimension minimumLayoutSize(Container paramContainer) {
            Insets localInsets = DockingView.this.getInsets();
            Dimension localDimension1 = DockingView.this.contentPane != null ? DockingView.this.contentPane.getMinimumSize() : paramContainer.getSize();
            Dimension localDimension2 = DockingView.this.titlebar != null && DockingView.this.titlebar.isVisible() ? DockingView.this.titlebar.getMinimumSize() : new Dimension(0, 0);
            Dimension localDimension3 = new Dimension(Math.max(localDimension1.width, localDimension2.width) + localInsets.left + localInsets.right, localDimension1.height + localDimension2.height + localInsets.top + localInsets.bottom);
            return localDimension3;
        }

        @Override
        public Dimension maximumLayoutSize(Container paramContainer) {
            Insets localInsets = DockingView.this.getInsets();
            Dimension localDimension2 = DockingView.this.titlebar != null && DockingView.this.titlebar.isVisible() ? DockingView.this.titlebar.getMaximumSize() : new Dimension(0, 0);
            Dimension localDimension1 = DockingView.this.contentPane != null ? DockingView.this.contentPane.getMaximumSize() : new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE - localInsets.top - localInsets.bottom - localDimension2.height - 1);
            return new Dimension(Math.min(localDimension1.width, localDimension2.width) + localInsets.left + localInsets.right, localDimension1.height + localDimension2.height + localInsets.top + localInsets.bottom);
        }

        @Override
        public void layoutContainer(Container paramContainer) {
            Rectangle localRectangle = paramContainer.getBounds();
            Insets localInsets = DockingView.this.getInsets();
            int i = localInsets.left;
            int j = localInsets.top;
            int k = localRectangle.width - localInsets.right - localInsets.left;
            int m = localRectangle.height - localInsets.top - localInsets.bottom;
            if (DockingView.this.titlebar != null && DockingView.this.titlebar.isVisible()) {
                Dimension localDimension = DockingView.this.titlebar.getPreferredSize();
                DockingView.this.titlebar.setBounds(0, 0, k, localDimension.height);
                m -= (j += localDimension.height);
            }
            if (DockingView.this.contentPane != null) {
                DockingView.this.contentPane.setBounds(i, j, k, m);
            }
        }

        @Override
        public void addLayoutComponent(String paramString, Component paramComponent) {
        }

        @Override
        public void removeLayoutComponent(Component paramComponent) {
        }

        @Override
        public void addLayoutComponent(Component paramComponent, Object paramObject) {
        }

        @Override
        public float getLayoutAlignmentX(Container paramContainer) {
            return 0.0f;
        }

        @Override
        public float getLayoutAlignmentY(Container paramContainer) {
            return 0.0f;
        }

        @Override
        public void invalidateLayout(Container paramContainer) {
        }
    }
}

