/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.docking.swing;

import com.macrofocus.docking.Dockable;
import com.macrofocus.docking.DockingBar;
import com.macrofocus.docking.swing.DockingView;
import com.macrofocus.docking.swing.DockingViewTitleBar;
import com.macrofocus.docking.swing.IconDockable;
import com.macrofocus.docking.swing.plaf.DockingAddon;
import com.macrofocus.helper.Disposable;
import com.macrofocus.helper.WeakActionListeners;
import de.javasoft.docking.ui.addons.JYDockingAddon;
import java.awt.BorderLayout;
import java.awt.Container;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.plaf.metal.MetalButtonUI;
import org.jdesktop.swingx.plaf.ComponentAddon;
import org.jdesktop.swingx.plaf.LookAndFeelAddons;

public class SwingDockable
implements Dockable<JComponent>,
IconDockable<JComponent>,
Disposable {
    private JPanel titledPanel;
    private final DockingView view;
    private JComponent component;
    private final String description;
    private final String shortTitle;
    private final String title;
    private final String iconUrl;
    private final Icon icon;
    private final JButton detachButton;
    private final JButton hideButton;
    private DockingBar dockingBar;
    private final WeakActionListeners actionListeners = new WeakActionListeners();

    public SwingDockable(JComponent component, String title, Icon icon) {
        this(component, title, title, null, icon);
    }

    public SwingDockable(JComponent component, String shortTitle, String title, String description, Icon icon) {
        this.component = component;
        this.shortTitle = shortTitle;
        this.title = title;
        this.description = description;
        this.icon = icon;
        this.iconUrl = null;
        this.titledPanel = new JPanel();
        this.titledPanel.setLayout(new BorderLayout());
        this.view = new DockingView("DecoratedDockable", "DecoratedDockable", "DecoratedDockable");
        this.view.setTitle(title);
        this.view.setIcon(icon);
        this.view.setContentPane(component);
        this.titledPanel.add(this.view);
        ImageIcon floatingIcon = new ImageIcon(this.getClass().getResource("floating.png"));
        this.detachButton = new TitleButton(floatingIcon);
        this.detachButton.setToolTipText("Float");
        this.detachButton.setVisible(false);
        this.detachButton.addActionListener(this.actionListeners.create(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SwingDockable.this.dockingBar.setFloating(SwingDockable.this.getSelf(), true);
            }
        }, (Object)this.detachButton));
        this.view.getTitlebar().add(this.detachButton);
        this.hideButton = new TitleButton(new ImageIcon(this.getClass().getResource("hideToolWindow.png")));
        this.hideButton.setToolTipText("Hide");
        this.hideButton.setVisible(false);
        this.hideButton.addActionListener(this.actionListeners.create(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SwingDockable.this.dockingBar.setActive(SwingDockable.this.getSelf(), false);
            }
        }, (Object)this.hideButton));
        this.view.getTitlebar().add(this.hideButton);
    }

    public JComponent getContainer() {
        return this.component;
    }

    public JComponent detachContainer() {
        this.view.setContentPane(new Container());
        return this.component;
    }

    public void attachContainer() {
        this.view.setContentPane(this.component);
    }

    private Dockable getSelf() {
        return this;
    }

    public JComponent getComponent() {
        return this.titledPanel;
    }

    public String getShortTitle() {
        return this.shortTitle;
    }

    public String getTitle() {
        return this.title;
    }

    public String getDescription() {
        return this.description;
    }

    public String getIconURL() {
        return this.iconUrl;
    }

    @Override
    public Icon getIcon() {
        return this.icon;
    }

    public DockingBar getDockingBar() {
        return this.dockingBar;
    }

    public void setDockingBar(DockingBar dockingBar) {
        this.dockingBar = dockingBar;
        this.detachButton.setVisible(dockingBar != null);
        this.hideButton.setVisible(dockingBar != null);
    }

    public DockingViewTitleBar getTitledBar() {
        return this.view.getTitlebar();
    }

    public void dispose() {
        this.dockingBar = null;
        this.titledPanel = null;
        this.component = null;
    }

    static {
        try {
            LookAndFeelAddons.contribute((ComponentAddon)new JYDockingAddon());
            LookAndFeelAddons.contribute((ComponentAddon)new DockingAddon());
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    private static final class TitleButtonUI
    extends MetalButtonUI {
        private TitleButtonUI() {
        }

        @Override
        protected void paintIcon(Graphics g1, JComponent jcomponent, Rectangle rectangle) {
            TitleButton mytitlebutton = (TitleButton)jcomponent;
            if (mytitlebutton.getModel().isArmed() && mytitlebutton.getModel().isPressed()) {
                rectangle = new Rectangle(rectangle.x - 1, rectangle.y, rectangle.width, rectangle.height);
            }
            super.paintIcon(g1, jcomponent, rectangle);
        }
    }

    public static final class TitleButton
    extends JButton {
        @Override
        public final void updateUI() {
            this.setUI(new TitleButtonUI());
            this.setOpaque(false);
            this.setRolloverEnabled(true);
            this.setContentAreaFilled(false);
            this.setMargin(new Insets(0, 0, 0, 0));
            this.setDefaultCapable(false);
            this.setFocusable(false);
        }

        public TitleButton(Icon icon) {
            super(icon);
            this.setBorder(BorderFactory.createEmptyBorder());
        }

        public TitleButton() {
            this.setBorder(BorderFactory.createEmptyBorder());
        }
    }
}

