/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.docking.swing.plaf.basic;

import com.macrofocus.docking.swing.plaf.DockingButtonUI;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.MouseMotionListener;
import javax.swing.AbstractButton;
import javax.swing.ButtonModel;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.LookAndFeel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicButtonListener;
import javax.swing.plaf.basic.BasicGraphicsUtils;
import javax.swing.plaf.basic.BasicHTML;
import javax.swing.text.View;
import sun.swing.SwingUtilities2;

public class BasicDockingButtonUI
extends DockingButtonUI {
    private static final DockingButtonUI buttonUI = new BasicDockingButtonUI();
    protected int defaultTextIconGap;
    private int shiftOffset = 0;
    protected int defaultTextShiftOffset;
    private static final String propertyPrefix = "Button.";
    private static Rectangle viewRect = new Rectangle();
    private static Rectangle textRect = new Rectangle();
    private static Rectangle iconRect = new Rectangle();

    public static ComponentUI createUI(JComponent c) {
        return buttonUI;
    }

    protected String getPropertyPrefix() {
        return propertyPrefix;
    }

    @Override
    public void installUI(JComponent c) {
        this.installDefaults((AbstractButton)c);
        this.installListeners((AbstractButton)c);
        this.installKeyboardActions((AbstractButton)c);
        BasicHTML.updateRenderer(c, ((AbstractButton)c).getText());
    }

    protected void installDefaults(AbstractButton b) {
        String pp = this.getPropertyPrefix();
        this.defaultTextShiftOffset = UIManager.getInt(pp + "textShiftOffset");
        LookAndFeel.installColorsAndFont(b, pp + "background", pp + "foreground", pp + "font");
    }

    protected void installListeners(AbstractButton b) {
        BasicButtonListener listener = this.createButtonListener(b);
        if (listener != null) {
            b.addMouseListener(listener);
            b.addMouseMotionListener(listener);
            b.addFocusListener(listener);
            b.addPropertyChangeListener(listener);
            b.addChangeListener(listener);
        }
    }

    protected void installKeyboardActions(AbstractButton b) {
        BasicButtonListener listener = this.getButtonListener(b);
        if (listener != null) {
            listener.installKeyboardActions(b);
        }
    }

    @Override
    public void uninstallUI(JComponent c) {
        this.uninstallKeyboardActions((AbstractButton)c);
        this.uninstallListeners((AbstractButton)c);
        this.uninstallDefaults((AbstractButton)c);
        BasicHTML.updateRenderer(c, "");
    }

    protected void uninstallKeyboardActions(AbstractButton b) {
        BasicButtonListener listener = this.getButtonListener(b);
        if (listener != null) {
            listener.uninstallKeyboardActions(b);
        }
    }

    protected void uninstallListeners(AbstractButton b) {
        BasicButtonListener listener = this.getButtonListener(b);
        if (listener != null) {
            b.removeMouseListener(listener);
            b.removeMouseMotionListener(listener);
            b.removeFocusListener(listener);
            b.removeChangeListener(listener);
            b.removePropertyChangeListener(listener);
        }
    }

    protected void uninstallDefaults(AbstractButton b) {
        LookAndFeel.uninstallBorder(b);
    }

    protected BasicButtonListener createButtonListener(AbstractButton b) {
        return new BasicButtonListener(b);
    }

    public int getDefaultTextIconGap(AbstractButton b) {
        return this.defaultTextIconGap;
    }

    @Override
    public void paint(Graphics g, JComponent c) {
        AbstractButton b = (AbstractButton)c;
        ButtonModel model = b.getModel();
        String text = this.layout(b, SwingUtilities2.getFontMetrics((JComponent)b, g), b.getWidth(), b.getHeight());
        this.clearTextShiftOffset();
        if (model.isArmed() && model.isPressed()) {
            this.paintButtonPressed(g, b);
        }
        if (b.getIcon() != null) {
            this.paintIcon(g, c, iconRect);
        }
        if (text != null && !text.equals("")) {
            View v = (View)c.getClientProperty("html");
            if (v != null) {
                v.paint(g, textRect);
            } else {
                this.paintText(g, b, textRect, text);
            }
        }
        if (b.isFocusPainted() && b.hasFocus()) {
            this.paintFocus(g, b, viewRect, textRect, iconRect);
        }
    }

    protected void paintIcon(Graphics g, JComponent c, Rectangle iconRect) {
        AbstractButton b = (AbstractButton)c;
        ButtonModel model = b.getModel();
        Icon icon = b.getIcon();
        Icon tmpIcon = null;
        if (icon == null) {
            return;
        }
        Icon selectedIcon = null;
        if (model.isSelected() && (selectedIcon = b.getSelectedIcon()) != null) {
            icon = selectedIcon;
        }
        if (!model.isEnabled()) {
            if (model.isSelected() && (tmpIcon = b.getDisabledSelectedIcon()) == null) {
                tmpIcon = selectedIcon;
            }
            if (tmpIcon == null) {
                tmpIcon = b.getDisabledIcon();
            }
        } else if (model.isPressed() && model.isArmed()) {
            tmpIcon = b.getPressedIcon();
            if (tmpIcon != null) {
                this.clearTextShiftOffset();
            }
        } else if (b.isRolloverEnabled() && model.isRollover()) {
            if (model.isSelected() && (tmpIcon = b.getRolloverSelectedIcon()) == null) {
                tmpIcon = selectedIcon;
            }
            if (tmpIcon == null) {
                tmpIcon = b.getRolloverIcon();
            }
        }
        if (tmpIcon != null) {
            icon = tmpIcon;
        }
        if (model.isPressed() && model.isArmed()) {
            icon.paintIcon(c, g, iconRect.x + this.getTextShiftOffset(), iconRect.y + this.getTextShiftOffset());
        } else {
            icon.paintIcon(c, g, iconRect.x, iconRect.y);
        }
    }

    protected void paintText(Graphics g, JComponent c, Rectangle textRect, String text) {
        AbstractButton b = (AbstractButton)c;
        ButtonModel model = b.getModel();
        FontMetrics fm = SwingUtilities2.getFontMetrics(c, g);
        int mnemonicIndex = b.getDisplayedMnemonicIndex();
        if (model.isEnabled()) {
            g.setColor(b.getForeground());
            SwingUtilities2.drawStringUnderlineCharAt(c, g, text, mnemonicIndex, textRect.x + this.getTextShiftOffset(), textRect.y + fm.getAscent() + this.getTextShiftOffset());
        } else {
            g.setColor(b.getBackground().brighter());
            SwingUtilities2.drawStringUnderlineCharAt(c, g, text, mnemonicIndex, textRect.x, textRect.y + fm.getAscent());
            g.setColor(b.getBackground().darker());
            SwingUtilities2.drawStringUnderlineCharAt(c, g, text, mnemonicIndex, textRect.x - 1, textRect.y + fm.getAscent() - 1);
        }
    }

    protected void paintText(Graphics g, AbstractButton b, Rectangle textRect, String text) {
        this.paintText(g, (JComponent)b, textRect, text);
    }

    protected void paintFocus(Graphics g, AbstractButton b, Rectangle viewRect, Rectangle textRect, Rectangle iconRect) {
    }

    protected void paintButtonPressed(Graphics g, AbstractButton b) {
    }

    protected void clearTextShiftOffset() {
        this.shiftOffset = 0;
    }

    protected void setTextShiftOffset() {
        this.shiftOffset = this.defaultTextShiftOffset;
    }

    protected int getTextShiftOffset() {
        return this.shiftOffset;
    }

    @Override
    public Dimension getMinimumSize(JComponent c) {
        Dimension d = this.getPreferredSize(c);
        View v = (View)c.getClientProperty("html");
        if (v != null) {
            d.width = (int)((float)d.width - (v.getPreferredSpan(0) - v.getMinimumSpan(0)));
        }
        return d;
    }

    @Override
    public Dimension getPreferredSize(JComponent c) {
        AbstractButton b = (AbstractButton)c;
        return BasicGraphicsUtils.getPreferredButtonSize(b, b.getIconTextGap());
    }

    @Override
    public Dimension getMaximumSize(JComponent c) {
        Dimension d = this.getPreferredSize(c);
        View v = (View)c.getClientProperty("html");
        if (v != null) {
            d.width = (int)((float)d.width + (v.getMaximumSpan(0) - v.getPreferredSpan(0)));
        }
        return d;
    }

    @Override
    public int getBaseline(JComponent c, int width, int height) {
        super.getBaseline(c, width, height);
        AbstractButton b = (AbstractButton)c;
        String text = b.getText();
        if (text == null || "".equals(text)) {
            return -1;
        }
        FontMetrics fm = b.getFontMetrics(b.getFont());
        this.layout(b, fm, width, height);
        return BasicDockingButtonUI.getBaseline(b, BasicDockingButtonUI.textRect.y, fm.getAscent(), BasicDockingButtonUI.textRect.width, BasicDockingButtonUI.textRect.height);
    }

    static int getBaseline(JComponent c, int y, int ascent, int w, int h) {
        View view = (View)c.getClientProperty("html");
        if (view != null) {
            int baseline = BasicHTML.getHTMLBaseline(view, w, h);
            if (baseline < 0) {
                return baseline;
            }
            return y + baseline;
        }
        return y + ascent;
    }

    private String layout(AbstractButton b, FontMetrics fm, int width, int height) {
        Insets i = b.getInsets();
        BasicDockingButtonUI.viewRect.x = i.left;
        BasicDockingButtonUI.viewRect.y = i.top;
        BasicDockingButtonUI.viewRect.width = width - (i.right + BasicDockingButtonUI.viewRect.x);
        BasicDockingButtonUI.viewRect.height = height - (i.bottom + BasicDockingButtonUI.viewRect.y);
        BasicDockingButtonUI.textRect.height = 0;
        BasicDockingButtonUI.textRect.width = 0;
        BasicDockingButtonUI.textRect.y = 0;
        BasicDockingButtonUI.textRect.x = 0;
        BasicDockingButtonUI.iconRect.height = 0;
        BasicDockingButtonUI.iconRect.width = 0;
        BasicDockingButtonUI.iconRect.y = 0;
        BasicDockingButtonUI.iconRect.x = 0;
        return SwingUtilities.layoutCompoundLabel(b, fm, b.getText(), b.getIcon(), b.getVerticalAlignment(), b.getHorizontalAlignment(), b.getVerticalTextPosition(), b.getHorizontalTextPosition(), viewRect, iconRect, textRect, b.getText() == null ? 0 : b.getIconTextGap());
    }

    private BasicButtonListener getButtonListener(AbstractButton b) {
        MouseMotionListener[] listeners = b.getMouseMotionListeners();
        if (listeners != null) {
            for (int counter = 0; counter < listeners.length; ++counter) {
                if (!(listeners[counter] instanceof BasicButtonListener)) continue;
                return (BasicButtonListener)listeners[counter];
            }
        }
        return null;
    }
}

