/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.docking.swing.splitter;

import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;

public class TwoComponentsSplitter
extends JPanel {
    private int myDividerWidth;
    private boolean myVerticalSplit;
    private boolean myHonorMinimumSize = false;
    private final Divider myDivider;
    private JComponent myFirstComponent;
    private JComponent myLastComponent;
    private int myFirstSize = 10;
    private boolean myShowDividerControls;

    public TwoComponentsSplitter() {
        this(false);
    }

    public TwoComponentsSplitter(boolean vertical) {
        this.myVerticalSplit = vertical;
        this.myShowDividerControls = false;
        this.myDivider = new Divider(true);
        this.myDividerWidth = 7;
        this.setOpaque(false);
        super.add(this.myDivider);
    }

    public void setShowDividerControls(boolean showDividerControls) {
        this.myShowDividerControls = showDividerControls;
        this.setOrientation(this.myVerticalSplit);
    }

    public boolean isHonorMinimumSize() {
        return this.myHonorMinimumSize;
    }

    public void setHonorComponentsMinimumSize(boolean honorMinimumSize) {
        this.myHonorMinimumSize = honorMinimumSize;
    }

    @Override
    public boolean isVisible() {
        return super.isVisible() && (this.firstVisible() || this.lastVisible());
    }

    private boolean lastVisible() {
        return this.myLastComponent != null && this.myLastComponent.isVisible();
    }

    private boolean firstVisible() {
        return this.myFirstComponent != null && this.myFirstComponent.isVisible();
    }

    private int visibleDividersCount() {
        int count = 0;
        if (this.firstDividerVisible()) {
            ++count;
        }
        return count;
    }

    private boolean firstDividerVisible() {
        return this.firstVisible() && this.lastVisible();
    }

    @Override
    public Dimension getMinimumSize() {
        if (this.isHonorMinimumSize()) {
            Dimension lastSize;
            int dividerWidth = this.getDividerWidth();
            Dimension firstSize = this.myFirstComponent == null ? new Dimension(0, 0) : this.myFirstComponent.getMinimumSize();
            Dimension dimension = lastSize = this.myLastComponent == null ? new Dimension(0, 0) : this.myLastComponent.getMinimumSize();
            if (this.getOrientation()) {
                int width = Math.max(firstSize.width, lastSize.width);
                int height = this.visibleDividersCount() * dividerWidth;
                height += firstSize.height;
                return new Dimension(width, height += lastSize.height);
            }
            int heigth = Math.max(firstSize.height, lastSize.height);
            int width = this.visibleDividersCount() * dividerWidth;
            width += firstSize.width;
            return new Dimension(width += lastSize.width, heigth);
        }
        return super.getMinimumSize();
    }

    @Override
    public void doLayout() {
        int space;
        int lastComponentSize;
        int firstCompontSize;
        int width = this.getWidth();
        int height = this.getHeight();
        Rectangle firstRect = new Rectangle();
        Rectangle firstDividerRect = new Rectangle();
        Rectangle lastRect = new Rectangle();
        int componentSize = this.getOrientation() ? height : width;
        int dividerWidth = this.getDividerWidth();
        int dividersCount = this.visibleDividersCount();
        if (componentSize <= dividersCount * dividerWidth) {
            firstCompontSize = 0;
            lastComponentSize = 0;
            dividerWidth = componentSize;
        } else {
            if (this.firstDividerVisible()) {
                firstCompontSize = this.getFirstSize();
                lastComponentSize = componentSize - dividersCount * dividerWidth - firstCompontSize;
            } else if (this.myFirstComponent.isVisible()) {
                firstCompontSize = componentSize;
                lastComponentSize = 0;
            } else {
                firstCompontSize = 0;
                lastComponentSize = componentSize;
            }
            int sizeLack = firstCompontSize - (componentSize - dividersCount * dividerWidth);
            if (sizeLack > 0) {
                firstCompontSize -= sizeLack;
            }
        }
        if (this.getOrientation()) {
            space = firstCompontSize;
            firstRect.setBounds(0, 0, width, firstCompontSize);
            if (this.firstDividerVisible()) {
                firstDividerRect.setBounds(0, space, width, dividerWidth);
                space += dividerWidth;
            }
            lastRect.setBounds(0, space, width, lastComponentSize);
        } else {
            space = firstCompontSize;
            firstRect.setBounds(0, 0, firstCompontSize, height);
            if (this.firstDividerVisible()) {
                firstDividerRect.setBounds(space, 0, dividerWidth, height);
                space += dividerWidth;
            }
            lastRect.setBounds(space, 0, lastComponentSize, height);
        }
        this.myDivider.setVisible(this.firstDividerVisible());
        this.myDivider.setBounds(firstDividerRect);
        this.myDivider.doLayout();
        if (this.myFirstComponent != null) {
            this.myFirstComponent.setBounds(firstRect);
            this.myFirstComponent.revalidate();
        }
        if (this.myLastComponent != null) {
            this.myLastComponent.setBounds(lastRect);
            this.myLastComponent.revalidate();
        }
    }

    public int getDividerWidth() {
        return this.myDividerWidth;
    }

    public void setDividerWidth(int width) {
        if (width <= 0) {
            throw new IllegalArgumentException("Wrong divider width: " + width);
        }
        if (this.myDividerWidth != width) {
            this.myDividerWidth = width;
            this.doLayout();
            this.repaint();
        }
    }

    public boolean getOrientation() {
        return this.myVerticalSplit;
    }

    public void setOrientation(boolean verticalSplit) {
        this.myVerticalSplit = verticalSplit;
        this.myDivider.setOrientation(verticalSplit);
        this.doLayout();
        this.repaint();
    }

    public JComponent getFirstComponent() {
        return this.myFirstComponent;
    }

    public void setFirstComponent(JComponent component) {
        if (this.myFirstComponent != component) {
            if (this.myFirstComponent != null) {
                this.remove(this.myFirstComponent);
            }
            this.myFirstComponent = component;
            if (this.myFirstComponent != null) {
                super.add(this.myFirstComponent);
                this.myFirstComponent.invalidate();
            }
        }
    }

    public JComponent getLastComponent() {
        return this.myLastComponent;
    }

    public void setLastComponent(JComponent component) {
        if (this.myLastComponent != component) {
            if (this.myLastComponent != null) {
                this.remove(this.myLastComponent);
            }
            this.myLastComponent = component;
            if (this.myLastComponent != null) {
                super.add(this.myLastComponent);
                this.myLastComponent.invalidate();
            }
        }
    }

    public void setFirstSize(int size) {
        if (this.myFirstSize != size) {
            this.myFirstSize = size;
            this.doLayout();
            this.repaint();
        }
    }

    public int getFirstSize() {
        return this.firstVisible() ? this.myFirstSize : 0;
    }

    @Override
    public void setBounds(int x, int y, int width, int height) {
        int firstSize = this.myFirstSize;
        if (this.getWidth() > 0 && this.getHeight() > 0) {
            firstSize = this.myVerticalSplit ? firstSize * height / this.getHeight() : firstSize * width / this.getWidth();
        }
        super.setBounds(x, y, width, height);
        this.setFirstSize(firstSize);
    }

    protected class Divider
    extends JPanel {
        protected boolean myDragging;
        protected Point myPoint;
        private boolean myIsFirst;

        private void setOrientation(boolean isVerticalSplit) {
            this.removeAll();
            if (!TwoComponentsSplitter.this.myShowDividerControls) {
                return;
            }
            int xMask = isVerticalSplit ? 1 : 0;
            int yMask = isVerticalSplit ? 0 : 1;
            ImageIcon glueIcon = new ImageIcon(this.getClass().getResource(isVerticalSplit ? "splitGlueV.png" : "splitGlueH.png"));
            int glueFill = isVerticalSplit ? 3 : 2;
            this.add((Component)new JLabel(glueIcon), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, isVerticalSplit ? 13 : 11, glueFill, new Insets(0, 0, 0, 0), 0, 0));
            JLabel splitDownlabel = new JLabel(new ImageIcon(this.getClass().getResource(isVerticalSplit ? "splitDown.png" : "splitRight.png")));
            splitDownlabel.setCursor(Cursor.getPredefinedCursor(12));
            splitDownlabel.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    int income;
                    int n = income = TwoComponentsSplitter.this.myVerticalSplit ? TwoComponentsSplitter.this.myLastComponent.getHeight() : TwoComponentsSplitter.this.myLastComponent.getWidth();
                    if (Divider.this.myIsFirst) {
                        TwoComponentsSplitter.this.setFirstSize(TwoComponentsSplitter.this.myFirstSize + income);
                    }
                }
            });
            this.add((Component)splitDownlabel, new GridBagConstraints(isVerticalSplit ? 1 : 0, isVerticalSplit ? 0 : 5, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
            this.add((Component)new JLabel(glueIcon), new GridBagConstraints(2 * xMask, 2 * yMask, 1, 1, 0.0, 0.0, 10, glueFill, new Insets(0, 0, 0, 0), 0, 0));
            JLabel splitCenterlabel = new JLabel(new ImageIcon(this.getClass().getResource(isVerticalSplit ? "splitCenterV.png" : "splitCenterH.png")));
            splitCenterlabel.setCursor(Cursor.getPredefinedCursor(12));
            splitCenterlabel.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    Divider.this.center();
                }
            });
            this.add((Component)splitCenterlabel, new GridBagConstraints(3 * xMask, 3 * yMask, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
            this.add((Component)new JLabel(glueIcon), new GridBagConstraints(4 * xMask, 4 * yMask, 1, 1, 0.0, 0.0, 10, glueFill, new Insets(0, 0, 0, 0), 0, 0));
            JLabel splitUpLabel = new JLabel(new ImageIcon(this.getClass().getResource(isVerticalSplit ? "splitUp.png" : "splitLeft.png")));
            splitUpLabel.setCursor(Cursor.getPredefinedCursor(12));
            splitUpLabel.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    if (Divider.this.myIsFirst) {
                        TwoComponentsSplitter.this.setFirstSize(Divider.this.getMinSize(TwoComponentsSplitter.this.myFirstComponent));
                    }
                }
            });
            this.add((Component)splitUpLabel, new GridBagConstraints(isVerticalSplit ? 5 : 0, isVerticalSplit ? 0 : 1, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
            this.add((Component)new JLabel(glueIcon), new GridBagConstraints(6 * xMask, 6 * yMask, 1, 1, 0.0, 0.0, isVerticalSplit ? 17 : 15, glueFill, new Insets(0, 0, 0, 0), 0, 0));
        }

        private void center() {
            int total = TwoComponentsSplitter.this.myFirstSize + (TwoComponentsSplitter.this.myVerticalSplit ? TwoComponentsSplitter.this.myLastComponent.getHeight() : TwoComponentsSplitter.this.myLastComponent.getWidth());
            if (this.myIsFirst) {
                TwoComponentsSplitter.this.setFirstSize(total / 2);
            }
        }

        @Override
        protected void processMouseMotionEvent(MouseEvent e) {
            super.processMouseMotionEvent(e);
            if (506 == e.getID()) {
                this.myDragging = true;
                this.setCursor(TwoComponentsSplitter.this.getOrientation() ? Cursor.getPredefinedCursor(9) : Cursor.getPredefinedCursor(11));
                this.myPoint = SwingUtilities.convertPoint(this, e.getPoint(), TwoComponentsSplitter.this);
                if (TwoComponentsSplitter.this.getOrientation()) {
                    if (this.getHeight() > 0 && this.myIsFirst) {
                        TwoComponentsSplitter.this.setFirstSize(Math.max(this.getMinSize(TwoComponentsSplitter.this.myFirstComponent), this.myPoint.y));
                    }
                } else if (this.getWidth() > 0 && this.myIsFirst) {
                    TwoComponentsSplitter.this.setFirstSize(Math.max(this.getMinSize(TwoComponentsSplitter.this.myFirstComponent), this.myPoint.x));
                }
                this.doLayout();
            }
        }

        private int getMinSize(JComponent component) {
            if (TwoComponentsSplitter.this.isHonorMinimumSize() && component != null && TwoComponentsSplitter.this.myFirstComponent != null && TwoComponentsSplitter.this.myFirstComponent.isVisible() && TwoComponentsSplitter.this.myLastComponent != null && TwoComponentsSplitter.this.myLastComponent.isVisible()) {
                if (TwoComponentsSplitter.this.getOrientation()) {
                    return component.getMinimumSize().height;
                }
                return component.getMinimumSize().width;
            }
            return 0;
        }

        @Override
        protected void processMouseEvent(MouseEvent e) {
            super.processMouseEvent(e);
            switch (e.getID()) {
                default: {
                    break;
                }
                case 504: {
                    this.setCursor(TwoComponentsSplitter.this.getOrientation() ? Cursor.getPredefinedCursor(9) : Cursor.getPredefinedCursor(11));
                    break;
                }
                case 505: {
                    if (this.myDragging) break;
                    this.setCursor(Cursor.getPredefinedCursor(0));
                    break;
                }
                case 501: {
                    this.setCursor(TwoComponentsSplitter.this.getOrientation() ? Cursor.getPredefinedCursor(9) : Cursor.getPredefinedCursor(11));
                    break;
                }
                case 502: {
                    this.myDragging = false;
                    this.myPoint = null;
                    break;
                }
                case 500: {
                    if (e.getClickCount() != 2) break;
                    this.center();
                }
            }
        }

        public Divider(boolean isFirst) {
            super(new GridBagLayout());
            this.setFocusable(false);
            this.enableEvents(48L);
            this.myIsFirst = isFirst;
            this.setOrientation(TwoComponentsSplitter.this.myVerticalSplit);
            this.setOpaque(false);
        }
    }
}

